/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.semver.checker.util;

import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.ConstantDeclarationNode;
import io.ballerina.compiler.syntax.tree.EnumDeclarationNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.semver.checker.util.PackageUtils;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;

public final class SyntaxTreeUtils {
    private SyntaxTreeUtils() {
    }

    public static String getNodeKindName(SyntaxKind nodeKind) {
        return nodeKind.name().toLowerCase(Locale.ROOT).toLowerCase(Locale.ENGLISH).replace("_", " ");
    }

    public static Optional<String> getServiceIdentifier(ServiceDeclarationNode serviceNode) {
        if (serviceNode.absoluteResourcePath() != null && !serviceNode.absoluteResourcePath().isEmpty()) {
            return Optional.of(serviceNode.absoluteResourcePath().stream().map(Node::toSourceCode).collect(Collectors.joining("_")));
        }
        return Optional.empty();
    }

    public static String getModuleVarIdentifier(ModuleVariableDeclarationNode moduleVarNode) {
        return moduleVarNode.typedBindingPattern().bindingPattern().toSourceCode().trim();
    }

    public static String getConstIdentifier(ConstantDeclarationNode constNode) {
        return constNode.variableName().text().trim();
    }

    public static String getFunctionIdentifier(FunctionDefinitionNode functionNode) {
        String functionName = functionNode.functionName().toSourceCode().trim();
        if (functionNode.relativeResourcePath() == null || functionNode.relativeResourcePath().isEmpty()) {
            return functionName;
        }
        String resourcePaths = functionNode.relativeResourcePath().stream().filter(node -> node.kind() == SyntaxKind.IDENTIFIER_TOKEN).map(node -> PackageUtils.capitalize(node.toSourceCode().trim())).collect(Collectors.joining());
        return functionName + resourcePaths;
    }

    public static String getClassIdentifier(ClassDefinitionNode classNode) {
        return classNode.className().text().trim();
    }

    public static String getTypeDefIdentifier(TypeDefinitionNode typeDefNode) {
        return typeDefNode.typeName().text().trim();
    }

    public static String getEnumIdentifier(EnumDeclarationNode enumNode) {
        return enumNode.identifier().text().trim();
    }

    public static Optional<Token> lookupQualifier(NodeList<Token> qualifierList, SyntaxKind qualifierType) {
        return qualifierList.stream().filter(token -> token.kind() == qualifierType).findAny();
    }
}

