/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bindgen.utils;

import io.ballerina.projects.JvmTarget;
import io.ballerina.projects.PackageManifest;
import io.ballerina.projects.TomlDocument;
import io.ballerina.projects.internal.ManifestBuilder;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.ballerinalang.bindgen.exceptions.BindgenException;
import org.ballerinalang.bindgen.utils.BindgenEnv;
import org.ballerinalang.maven.Dependency;
import org.ballerinalang.maven.MavenResolver;
import org.ballerinalang.maven.exceptions.MavenResolverException;
import org.wso2.ballerinalang.compiler.util.ProjectDirs;

public class BindgenMvnResolver {
    private final PrintStream outStream;
    private final BindgenEnv env;

    public BindgenMvnResolver(PrintStream outStream, BindgenEnv env) {
        this.outStream = outStream;
        this.env = env;
    }

    public void mavenResolver(String groupId, String artifactId, String version, Path projectRoot, boolean resolve, JvmTarget parentJvmTarget) throws BindgenException {
        Path mvnRepository = projectRoot == null ? (this.env.getOutputPath() != null ? Path.of(this.env.getOutputPath(), "target", "platform-libs") : Path.of(System.getProperty("user.dir"), "target", "platform-libs")) : Path.of(projectRoot.toString(), "target", "platform-libs");
        Dependency dependency = BindgenMvnResolver.resolveDependency(groupId, artifactId, version, mvnRepository.toString());
        this.handleDependency(groupId, artifactId, version, mvnRepository.toString(), projectRoot, null, parentJvmTarget);
        if (resolve) {
            this.dependencyTraversal(dependency, mvnRepository.toString(), projectRoot, parentJvmTarget);
            if (projectRoot != null) {
                this.outStream.println("\nUpdated the `Ballerina.toml` file with the new platform libraries.");
            }
        }
    }

    private void dependencyTraversal(Dependency dependency, String mvnRepository, Path projectRoot, JvmTarget parentJvmTarget) throws BindgenException {
        if (dependency.getDepedencies() == null) {
            return;
        }
        String parent = dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion();
        for (Dependency transitive : dependency.getDepedencies()) {
            this.handleDependency(transitive.getGroupId(), transitive.getArtifactId(), transitive.getVersion(), mvnRepository, projectRoot, parent, parentJvmTarget);
            this.dependencyTraversal(transitive, mvnRepository, projectRoot, parentJvmTarget);
        }
    }

    private static Dependency resolveDependency(String groupId, String artifactId, String version, String mvnRepository) throws BindgenException {
        MavenResolver resolver = new MavenResolver(mvnRepository);
        try {
            return resolver.resolve(groupId, artifactId, version, true);
        }
        catch (MavenResolverException e) {
            throw new BindgenException("error: unable to resolve the maven dependency: " + e.getMessage());
        }
    }

    private void handleDependency(String groupId, String artifactId, String version, String mvnRepository, Path projectRoot, String parent, JvmTarget parentJvmTarget) throws BindgenException {
        File tomlFile;
        Path mvnPath = Path.of(mvnRepository, BindgenMvnResolver.getPathFromGroupId(groupId), artifactId, version);
        this.env.addClasspath(mvnPath.toString());
        if (projectRoot != null && (tomlFile = new File(Path.of(projectRoot.toString(), "Ballerina.toml").toString())).exists() && !tomlFile.isDirectory()) {
            this.populateBallerinaToml(groupId, artifactId, version, tomlFile, projectRoot, parent, parentJvmTarget);
        }
    }

    private void populateBallerinaToml(String groupId, String artifactId, String version, File tomlFile, Path projectRoot, String parent, JvmTarget parentJvmTarget) throws BindgenException {
        try (FileWriterWithEncoding fileWriter = ((FileWriterWithEncoding.Builder)((FileWriterWithEncoding.Builder)FileWriterWithEncoding.builder().setFile(tomlFile)).setCharset(StandardCharsets.UTF_8)).setAppend(true).get();){
            TomlDocument tomlDocument = this.env.getTomlDocument();
            if (tomlDocument == null) {
                return;
            }
            PackageManifest packageManifest = ManifestBuilder.from((TomlDocument)tomlDocument, null, null, (Path)projectRoot).packageManifest();
            if (packageManifest == null) {
                return;
            }
            for (JvmTarget jvmTarget : JvmTarget.values()) {
                PackageManifest.Platform platform = packageManifest.platform(jvmTarget.code());
                if (platform == null || platform.dependencies() == null) continue;
                for (Map library : platform.dependencies()) {
                    if (library.get("path") != null || library.get("groupId") == null || !library.get("groupId").equals(groupId) || library.get("artifactId") == null || !library.get("artifactId").equals(artifactId) || library.get("version") == null || !library.get("version").equals(version)) continue;
                    return;
                }
            }
            this.writeDependencyToBallerinaToml(groupId, artifactId, version, projectRoot, parent, parentJvmTarget, fileWriter);
        }
        catch (IOException e) {
            throw new BindgenException("error: unable to update the Ballerina.toml file: " + e.getMessage(), e);
        }
    }

    private void writeDependencyToBallerinaToml(String groupId, String artifactId, String version, Path projectRoot, String parent, JvmTarget parentJvmTarget, FileWriterWithEncoding fileWriter) throws IOException {
        fileWriter.write("\n");
        if (parent != null) {
            fileWriter.write("# transitive dependency of " + parent + "\n");
        }
        fileWriter.write("[[platform." + parentJvmTarget.code() + ".dependency]]\n");
        String moduleName = BindgenMvnResolver.getModuleName(projectRoot, this.env.getOutputPath());
        if (moduleName != null) {
            fileWriter.write("modules = [\"" + moduleName + "\"]\n");
        }
        fileWriter.write("groupId = \"" + groupId + "\"\n");
        fileWriter.write("artifactId = \"" + artifactId + "\"\n");
        fileWriter.write("version = \"" + version + "\"\n");
    }

    private static String getPathFromGroupId(String groupId) {
        String[] paths = groupId.split("\\.");
        if (paths.length == 0) {
            return groupId;
        }
        File combined = new File(paths[0]);
        for (int i = 1; i < paths.length; ++i) {
            combined = new File(combined, paths[i]);
        }
        return combined.getPath();
    }

    private static String getModuleName(Path projectRoot, String outputPath) {
        String splitRegex;
        String[] splittedPath;
        String moduleName;
        if (outputPath == null) {
            outputPath = Path.of(System.getProperty("user.dir"), new String[0]).toString();
        }
        if (ProjectDirs.isModuleExist((Path)projectRoot, (String)(moduleName = (splittedPath = outputPath.split(splitRegex = Pattern.quote(System.getProperty("file.separator"))))[splittedPath.length - 1]))) {
            return moduleName;
        }
        return null;
    }
}

