/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bindgen.utils;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.AssignmentStatementNode;
import io.ballerina.compiler.syntax.tree.BasicLiteralNode;
import io.ballerina.compiler.syntax.tree.BinaryExpressionNode;
import io.ballerina.compiler.syntax.tree.BindingPatternNode;
import io.ballerina.compiler.syntax.tree.BlockStatementNode;
import io.ballerina.compiler.syntax.tree.BracedExpressionNode;
import io.ballerina.compiler.syntax.tree.CaptureBindingPatternNode;
import io.ballerina.compiler.syntax.tree.CheckExpressionNode;
import io.ballerina.compiler.syntax.tree.ConditionalExpressionNode;
import io.ballerina.compiler.syntax.tree.ElseBlockNode;
import io.ballerina.compiler.syntax.tree.ErrorConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionStatementNode;
import io.ballerina.compiler.syntax.tree.ExternalFunctionBodyNode;
import io.ballerina.compiler.syntax.tree.ForEachStatementNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyBlockNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyNode;
import io.ballerina.compiler.syntax.tree.FunctionCallExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.IfElseStatementNode;
import io.ballerina.compiler.syntax.tree.ImplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ImportOrgNameNode;
import io.ballerina.compiler.syntax.tree.ImportPrefixNode;
import io.ballerina.compiler.syntax.tree.ListConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.LiteralValueToken;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MarkdownDocumentationLineNode;
import io.ballerina.compiler.syntax.tree.MarkdownDocumentationNode;
import io.ballerina.compiler.syntax.tree.MarkdownParameterDocumentationLineNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.MethodCallExpressionNode;
import io.ballerina.compiler.syntax.tree.Minutiae;
import io.ballerina.compiler.syntax.tree.MinutiaeList;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ParenthesizedArgList;
import io.ballerina.compiler.syntax.tree.PositionalArgumentNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.ReturnStatementNode;
import io.ballerina.compiler.syntax.tree.ReturnTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeCastExpressionNode;
import io.ballerina.compiler.syntax.tree.TypeCastParamNode;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.TypeReferenceNode;
import io.ballerina.compiler.syntax.tree.TypedBindingPatternNode;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ballerinalang.bindgen.exceptions.BindgenException;
import org.ballerinalang.bindgen.model.BFunction;
import org.ballerinalang.bindgen.model.JConstructor;
import org.ballerinalang.bindgen.model.JField;
import org.ballerinalang.bindgen.model.JMethod;
import org.ballerinalang.bindgen.model.JParameter;
import org.ballerinalang.bindgen.utils.BindgenEnv;

final class BindgenNodeFactory {
    private static final Token OPEN_PAREN_TOKEN = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_PAREN_TOKEN);
    private static final Token CLOSED_PAREN_TOKEN = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_PAREN_TOKEN);
    private static final Token SEMICOLON_TOKEN = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN);
    private static final Token COLON_TOKEN = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN);
    private static final MinutiaeList EMPTY_WHITE_SPACE = NodeFactory.createEmptyMinutiaeList();
    private static final MinutiaeList SINGLE_SPACE_WHITE_SPACE = NodeFactory.createMinutiaeList((Minutiae[])new Minutiae[]{NodeFactory.createWhitespaceMinutiae((String)" ")});
    private static final ExpressionNode NIL_TOKEN_EXPRESSION = NodeFactory.createNilLiteralNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_PAREN_TOKEN), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_PAREN_TOKEN));
    private static final ExpressionNode ARRAY_TOKEN_EXPRESSION = NodeFactory.createNilLiteralNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACKET_TOKEN), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACKET_TOKEN));

    private BindgenNodeFactory() {
    }

    static ImportDeclarationNode createImportDeclarationNode(String orgNameValue, String prefixValue, List<String> moduleNames) {
        Token importKeyword = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.IMPORT_KEYWORD, (MinutiaeList)BindgenNodeFactory.emptyML(), (MinutiaeList)BindgenNodeFactory.singleWSML());
        ImportOrgNameNode orgName = null;
        if (orgNameValue != null) {
            orgName = BindgenNodeFactory.createImportOrgNameNode(orgNameValue);
        }
        SeparatedNodeList moduleName = AbstractNodeFactory.createSeparatedNodeList(BindgenNodeFactory.getTokenList(moduleNames));
        ImportPrefixNode prefix = null;
        if (prefixValue != null) {
            prefix = BindgenNodeFactory.createImportPrefixNode(prefixValue);
        }
        Token semicolon = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN);
        return NodeFactory.createImportDeclarationNode((Token)importKeyword, (ImportOrgNameNode)orgName, (SeparatedNodeList)moduleName, (ImportPrefixNode)prefix, (Token)semicolon);
    }

    private static ImportOrgNameNode createImportOrgNameNode(String orgNameValue) {
        IdentifierToken orgName = AbstractNodeFactory.createIdentifierToken((String)orgNameValue);
        Token slashToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SLASH_TOKEN);
        return NodeFactory.createImportOrgNameNode((Token)orgName, (Token)slashToken);
    }

    private static ImportPrefixNode createImportPrefixNode(String prefixValue) {
        Token asKeyword = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.AS_KEYWORD, (MinutiaeList)BindgenNodeFactory.singleWSML(), (MinutiaeList)BindgenNodeFactory.singleWSML());
        IdentifierToken prefix = AbstractNodeFactory.createIdentifierToken((String)prefixValue);
        return NodeFactory.createImportPrefixNode((Token)asKeyword, (Token)prefix);
    }

    static TypeReferenceNode createTypeReferenceNode(String type) {
        Token asteriskToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ASTERISK_TOKEN);
        SimpleNameReferenceNode typeName = BindgenNodeFactory.createSimpleNameReferenceNode(type);
        Token semicolonToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN, (MinutiaeList)BindgenNodeFactory.emptyML(), (MinutiaeList)BindgenNodeFactory.singleNLML());
        return NodeFactory.createTypeReferenceNode((Token)asteriskToken, (Node)typeName, (Token)semicolonToken);
    }

    static FunctionDefinitionNode createFunctionDefinitionNode(BFunction bFunction, boolean isExternal) throws BindgenException {
        ExternalFunctionBodyNode functionBody;
        IdentifierToken functionName;
        NodeList qualifierList;
        MetadataNode metadata = null;
        if (!isExternal) {
            metadata = BindgenNodeFactory.createMetadataNode((Node)BindgenNodeFactory.createMarkdownDocumentationNode(BindgenNodeFactory.getFunctionMarkdownDocumentation(bFunction)), (NodeList<AnnotationNode>)AbstractNodeFactory.createNodeList((Node[])new AnnotationNode[0]));
        }
        if (bFunction.getEnv().hasPublicFlag() && !isExternal) {
            Token accessModifier = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.PUBLIC_KEYWORD, (MinutiaeList)BindgenNodeFactory.emptyML(), (MinutiaeList)BindgenNodeFactory.singleWSML());
            qualifierList = AbstractNodeFactory.createNodeList((Node[])new Token[]{accessModifier});
        } else {
            qualifierList = AbstractNodeFactory.createNodeList((Node[])new Token[0]);
        }
        Token functionKeyword = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.FUNCTION_KEYWORD, (MinutiaeList)BindgenNodeFactory.emptyML(), (MinutiaeList)BindgenNodeFactory.singleWSML());
        NodeList relativeResourcePath = AbstractNodeFactory.createNodeList((Node[])new Node[0]);
        FunctionSignatureNode functionSignature = BindgenNodeFactory.createFunctionSignatureNode(bFunction, isExternal);
        if (isExternal) {
            functionName = AbstractNodeFactory.createIdentifierToken((String)bFunction.getExternalFunctionName());
            functionBody = BindgenNodeFactory.createExternalFunctionBodyNode(bFunction);
        } else {
            functionName = AbstractNodeFactory.createIdentifierToken((String)bFunction.getFunctionName());
            functionBody = BindgenNodeFactory.createFunctionBodyBlockNode(bFunction);
        }
        return NodeFactory.createFunctionDefinitionNode(null, (MetadataNode)metadata, (NodeList)qualifierList, (Token)functionKeyword, (IdentifierToken)functionName, (NodeList)relativeResourcePath, (FunctionSignatureNode)functionSignature, (FunctionBodyNode)functionBody);
    }

    private static NodeList<Node> getFunctionMarkdownDocumentation(BFunction bFunction) {
        LinkedList<Node> documentationLines = new LinkedList<Node>();
        documentationLines.addAll(BindgenNodeFactory.getFunctionMarkdownDocumentationLine(bFunction));
        documentationLines.addAll(BindgenNodeFactory.getFunctionMarkdownParameterDocumentationLine(bFunction));
        return AbstractNodeFactory.createNodeList(documentationLines);
    }

    private static List<Node> getFunctionMarkdownDocumentationLine(BFunction bFunction) {
        String documentationValue;
        LinkedList<Node> documentationLines = new LinkedList<Node>();
        String className = bFunction.getDeclaringClass().getName();
        if (bFunction.getKind() == BFunction.BFunctionKind.CONSTRUCTOR) {
            documentationValue = "The constructor function to generate an object of `" + className + "`.";
        } else if (bFunction.getKind() == BFunction.BFunctionKind.METHOD) {
            JMethod jMethod = (JMethod)bFunction;
            documentationValue = "The function that maps to the `" + jMethod.getJavaMethodName() + "` method of `" + className + "`.";
        } else if (bFunction.getKind() == BFunction.BFunctionKind.FIELD_GET) {
            JField jField = (JField)bFunction;
            documentationValue = "The function that retrieves the value of the public field `" + jField.getFieldName() + "`.";
        } else if (bFunction.getKind() == BFunction.BFunctionKind.FIELD_SET) {
            JField jField = (JField)bFunction;
            documentationValue = "The function to set the value of the public field `" + jField.getFieldName() + "`.";
        } else {
            return documentationLines;
        }
        documentationLines.add((Node)BindgenNodeFactory.createMarkdownDocumentationLineNode(documentationValue));
        if (!bFunction.getParameters().isEmpty() || bFunction.getReturnType() != null || bFunction.getErrorType() != null) {
            documentationLines.add((Node)BindgenNodeFactory.createMarkdownDocumentationLineNode(""));
        }
        return documentationLines;
    }

    private static List<Node> getFunctionMarkdownParameterDocumentationLine(BFunction bFunction) {
        String returnDescription;
        LinkedList<Node> parameterDocumentationLines = new LinkedList<Node>();
        if (!bFunction.getParameters().isEmpty()) {
            for (JParameter jParameter : bFunction.getParameters()) {
                String paramDescription = BindgenNodeFactory.documentationParamDescription(bFunction.getKind(), jParameter);
                if (paramDescription == null) continue;
                parameterDocumentationLines.add((Node)BindgenNodeFactory.createMarkdownParameterDocumentationLineNode(jParameter.getFieldName(), paramDescription));
            }
        }
        if ((returnDescription = BindgenNodeFactory.documentationReturnDescription(bFunction)) != null) {
            parameterDocumentationLines.add((Node)BindgenNodeFactory.createMarkdownParameterDocumentationLineNode("return", returnDescription));
        }
        return parameterDocumentationLines;
    }

    private static String documentationParamDescription(BFunction.BFunctionKind functionKind, JParameter jParameter) {
        String paramDescription = null;
        if (functionKind == BFunction.BFunctionKind.CONSTRUCTOR) {
            paramDescription = "The `" + jParameter.getShortTypeName() + "` value required to map with the Java constructor parameter.";
        } else if (functionKind == BFunction.BFunctionKind.METHOD) {
            paramDescription = "The `" + jParameter.getShortTypeName() + "` value required to map with the Java method parameter.";
        } else if (functionKind == BFunction.BFunctionKind.FIELD_SET) {
            paramDescription = "The `" + jParameter.getShortTypeName() + "` value that is to be set for the field.";
        }
        return paramDescription;
    }

    private static String documentationReturnDescription(BFunction bFunction) {
        String paramDescription = null;
        if (bFunction.getReturnType() == null && bFunction.getErrorType() == null) {
            return null;
        }
        if (bFunction.getKind() == BFunction.BFunctionKind.CONSTRUCTOR) {
            paramDescription = bFunction.getErrorType() != null ? "The new `" + bFunction.getReturnType() + "` class or `" + bFunction.getErrorType() + "` error generated." : "The new `" + bFunction.getReturnType() + "` class generated.";
        } else if (bFunction.getKind() == BFunction.BFunctionKind.METHOD) {
            paramDescription = bFunction.getReturnType() != null && bFunction.getErrorType() != null ? "The `" + bFunction.getReturnType() + "` or the `" + bFunction.getErrorType() + "` value returning from the Java mapping." : (bFunction.getReturnType() != null ? "The `" + bFunction.getReturnType() + "` value returning from the Java mapping." : "The `" + bFunction.getErrorType() + "` value returning from the Java mapping.");
        } else if (bFunction.getKind() == BFunction.BFunctionKind.FIELD_GET) {
            paramDescription = "The `" + bFunction.getReturnType() + "` value of the field.";
        }
        return paramDescription;
    }

    private static FunctionSignatureNode createFunctionSignatureNode(BFunction bFunction, boolean isExternal) throws BindgenException {
        Token openParenToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_PAREN_TOKEN);
        Token closeParenToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_PAREN_TOKEN);
        LinkedList<Object> parameterNodes = new LinkedList<Object>();
        if (isExternal && !bFunction.isStatic()) {
            parameterNodes.add(BindgenNodeFactory.createRequiredParameterNode("handle", "receiver"));
            if (!bFunction.getParameters().isEmpty()) {
                parameterNodes.add(AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
            }
        }
        for (JParameter jParameter : bFunction.getParameters()) {
            if (jParameter.isArray().booleanValue() && BindgenNodeFactory.isMultiDimensionalArray(jParameter.getParameterClass().getName())) {
                throw new BindgenException("multidimensional arrays are currently unsupported");
            }
            if (isExternal) {
                parameterNodes.add(BindgenNodeFactory.createRequiredParameterNode(jParameter.getExternalType() + " ", jParameter.getFieldName()));
            } else {
                parameterNodes.add(BindgenNodeFactory.createRequiredParameterNode(jParameter.getShortTypeName() + " ", jParameter.getFieldName()));
            }
            parameterNodes.add(AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
        }
        if (parameterNodes.size() > 1) {
            parameterNodes.remove(parameterNodes.size() - 1);
        }
        SeparatedNodeList parameters = AbstractNodeFactory.createSeparatedNodeList(parameterNodes);
        ReturnTypeDescriptorNode returnTypeDescriptor = isExternal ? BindgenNodeFactory.getExternalFunctionSignatureReturnType(bFunction) : BindgenNodeFactory.getFunctionSignatureReturnType(bFunction);
        return NodeFactory.createFunctionSignatureNode((Token)openParenToken, (SeparatedNodeList)parameters, (Token)closeParenToken, (ReturnTypeDescriptorNode)returnTypeDescriptor);
    }

    private static ReturnTypeDescriptorNode getFunctionSignatureReturnType(BFunction bFunction) throws BindgenException {
        String returnType = null;
        if (bFunction.getKind() == BFunction.BFunctionKind.METHOD) {
            returnType = ((JMethod)bFunction).getFunctionReturnType();
        } else if (bFunction.getKind() == BFunction.BFunctionKind.CONSTRUCTOR) {
            returnType = ((JConstructor)bFunction).getFunctionReturnType();
        } else if (bFunction.getKind() == BFunction.BFunctionKind.FIELD_GET) {
            returnType = ((JField)bFunction).getFunctionReturnType();
        }
        if (returnType == null || returnType.isEmpty()) {
            return null;
        }
        if (BindgenNodeFactory.isMultiDimensionalArray(returnType)) {
            throw new BindgenException("multidimensional arrays are currently unsupported");
        }
        return BindgenNodeFactory.createReturnTypeDescriptorNode((TypeDescriptorNode)BindgenNodeFactory.createSimpleNameReferenceNode(returnType));
    }

    private static ReturnTypeDescriptorNode getExternalFunctionSignatureReturnType(BFunction bFunction) {
        if (bFunction.getKind() == BFunction.BFunctionKind.FIELD_SET) {
            return null;
        }
        if (bFunction.getExternalReturnType() != null && !bFunction.getThrowables().isEmpty()) {
            return BindgenNodeFactory.createReturnTypeDescriptorNode((TypeDescriptorNode)BindgenNodeFactory.createSimpleNameReferenceNode(bFunction.getExternalReturnType() + "|error"));
        }
        if (bFunction.getExternalReturnType() != null) {
            return BindgenNodeFactory.createReturnTypeDescriptorNode((TypeDescriptorNode)BindgenNodeFactory.createSimpleNameReferenceNode(bFunction.getExternalReturnType()));
        }
        if (!bFunction.getThrowables().isEmpty()) {
            return BindgenNodeFactory.createReturnTypeDescriptorNode((TypeDescriptorNode)BindgenNodeFactory.createSimpleNameReferenceNode("error?"));
        }
        return null;
    }

    private static boolean isMultiDimensionalArray(String className) {
        return className.codePoints().filter(ch -> ch == 91).count() > 1L;
    }

    private static ExternalFunctionBodyNode createExternalFunctionBodyNode(BFunction bFunction) {
        LinkedHashMap<String, List<String>> fields = new LinkedHashMap<String, List<String>>();
        if (bFunction.getKind() == BFunction.BFunctionKind.METHOD) {
            JMethod jMethod = (JMethod)bFunction;
            fields.put("name", Collections.singletonList(jMethod.getJavaMethodName()));
            fields.put("'class", Collections.singletonList(jMethod.getDeclaringClass().getName()));
            fields.put("paramTypes", BindgenNodeFactory.getParameterList(jMethod.getParameters()));
        } else if (bFunction.getKind() == BFunction.BFunctionKind.CONSTRUCTOR) {
            JConstructor jConstructor = (JConstructor)bFunction;
            fields.put("'class", Collections.singletonList(jConstructor.getDeclaringClass().getName()));
            fields.put("paramTypes", BindgenNodeFactory.getParameterList(jConstructor.getParameters()));
        } else if (bFunction.getKind() == BFunction.BFunctionKind.FIELD_GET || bFunction.getKind() == BFunction.BFunctionKind.FIELD_SET) {
            JField jField = (JField)bFunction;
            fields.put("name", Collections.singletonList(jField.getFieldName()));
            fields.put("'class", Collections.singletonList(jField.getDeclaringClass().getName()));
        }
        Token equalsToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN);
        NodeList annotations = AbstractNodeFactory.createNodeList((Node[])new AnnotationNode[]{BindgenNodeFactory.createAnnotationNode(bFunction.getKind().value(), fields)});
        Token externalToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EXTERNAL_KEYWORD);
        Token semiColonToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN);
        return NodeFactory.createExternalFunctionBodyNode((Token)equalsToken, (NodeList)annotations, (Token)externalToken, (Token)semiColonToken);
    }

    private static FunctionBodyBlockNode createFunctionBodyBlockNode(BFunction bFunction) {
        List<StatementNode> statementNodes;
        Token openBraceToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN);
        if (bFunction.getKind() == BFunction.BFunctionKind.METHOD) {
            JMethod jMethod = (JMethod)bFunction;
            statementNodes = BindgenNodeFactory.getMethodFunctionStatements(jMethod);
        } else if (bFunction.getKind() == BFunction.BFunctionKind.CONSTRUCTOR) {
            JConstructor jConstructor = (JConstructor)bFunction;
            statementNodes = BindgenNodeFactory.getConstructorFunctionStatements(jConstructor);
        } else {
            JField jField = (JField)bFunction;
            statementNodes = BindgenNodeFactory.getFieldFunctionStatements(jField);
        }
        NodeList statements = AbstractNodeFactory.createNodeList(statementNodes);
        Token closeBraceToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN, (MinutiaeList)BindgenNodeFactory.emptyML(), (MinutiaeList)BindgenNodeFactory.doubleNLML());
        return NodeFactory.createFunctionBodyBlockNode((Token)openBraceToken, null, (NodeList)statements, (Token)closeBraceToken, null);
    }

    private static List<StatementNode> getConstructorFunctionStatements(JConstructor jConstructor) {
        LinkedList<StatementNode> statementNodes = new LinkedList<StatementNode>();
        if (jConstructor.isHandleException()) {
            statementNodes.addAll(BindgenNodeFactory.getConstructorWithException(jConstructor));
        } else {
            statementNodes.addAll(BindgenNodeFactory.getConstructorWithoutException(jConstructor));
        }
        return statementNodes;
    }

    private static List<StatementNode> getConstructorWithoutException(JConstructor jConstructor) {
        LinkedList<StatementNode> statementNodes = new LinkedList<StatementNode>();
        statementNodes.add(BindgenNodeFactory.getExternalFunctionCallStatement("handle", jConstructor));
        statementNodes.add((StatementNode)BindgenNodeFactory.createVariableDeclarationNode(BindgenNodeFactory.createTypedBindingPatternNode(jConstructor.getReturnType(), "newObj"), (ExpressionNode)BindgenNodeFactory.createImplicitNewExpressionNode(Collections.singletonList("externalObj"))));
        statementNodes.add((StatementNode)BindgenNodeFactory.createReturnStatementNode((ExpressionNode)BindgenNodeFactory.createSimpleNameReferenceNode("newObj")));
        return statementNodes;
    }

    private static List<StatementNode> getConstructorWithException(JConstructor jConstructor) {
        LinkedList<StatementNode> statementNodes = new LinkedList<StatementNode>();
        statementNodes.add(BindgenNodeFactory.getExternalFunctionCallStatement("handle|error", jConstructor));
        statementNodes.add((StatementNode)BindgenNodeFactory.createIfElseStatementNode((ExpressionNode)BindgenNodeFactory.createBracedExpressionNode((ExpressionNode)BindgenNodeFactory.createSimpleNameReferenceNode("externalObj is error")), BindgenNodeFactory.getCheckExceptionBlock(jConstructor.getExceptionName(), jConstructor.getExceptionConstName()), (Node)BindgenNodeFactory.createElseBlockNode((StatementNode)BindgenNodeFactory.createBlockStatementNode((NodeList<StatementNode>)AbstractNodeFactory.createNodeList((Node[])new StatementNode[]{BindgenNodeFactory.createVariableDeclarationNode(BindgenNodeFactory.createTypedBindingPatternNode(jConstructor.getReturnType(), "newObj"), (ExpressionNode)BindgenNodeFactory.createImplicitNewExpressionNode(Collections.singletonList("externalObj"))), BindgenNodeFactory.createReturnStatementNode((ExpressionNode)BindgenNodeFactory.createSimpleNameReferenceNode("newObj"))})))));
        return statementNodes;
    }

    private static List<StatementNode> getFieldFunctionStatements(JField jField) {
        LinkedList<StatementNode> statementNodes = new LinkedList<StatementNode>();
        if (jField.getKind() == BFunction.BFunctionKind.FIELD_GET) {
            if (!jField.isArray()) {
                if (jField.isString()) {
                    statementNodes.addAll(BindgenNodeFactory.getFieldGetStringStatement(jField));
                } else if (jField.isObject()) {
                    statementNodes.addAll(BindgenNodeFactory.getFieldGetObjectStatements(jField));
                } else {
                    statementNodes.addAll(BindgenNodeFactory.getFieldGetPrimitiveStatement(jField));
                }
            } else if (jField.isStringArray()) {
                statementNodes.addAll(BindgenNodeFactory.getFieldGetStringArrayStatements(jField));
            } else if (jField.isObjectArray()) {
                statementNodes.addAll(BindgenNodeFactory.getFieldGetObjectArrayStatements(jField));
            } else {
                statementNodes.addAll(BindgenNodeFactory.getFieldGetPrimitiveArrayStatements(jField));
            }
        } else {
            statementNodes.addAll(BindgenNodeFactory.getFieldSetStatements(jField));
        }
        return statementNodes;
    }

    private static List<StatementNode> getFieldGetPrimitiveArrayStatements(JField jField) {
        LinkedList<StatementNode> statementNodes = new LinkedList<StatementNode>();
        statementNodes.add(BindgenNodeFactory.getExternalFunctionCallStatement("handle", jField));
        statementNodes.add((StatementNode)BindgenNodeFactory.createReturnStatementNode((ExpressionNode)BindgenNodeFactory.createTypeCastExpressionNode(jField.getReturnType(), (ExpressionNode)BindgenNodeFactory.createCheckExpressionNode((ExpressionNode)BindgenNodeFactory.createFunctionCallExpressionNode("jarrays:fromHandle", new LinkedList<String>(Arrays.asList("externalObj", "\"" + jField.getFieldType() + "\"")))))));
        return statementNodes;
    }

    private static List<StatementNode> getFieldGetObjectArrayStatements(JField jField) {
        LinkedList<StatementNode> statementNodes = new LinkedList<StatementNode>();
        statementNodes.add(BindgenNodeFactory.getExternalFunctionCallStatement("handle", jField));
        statementNodes.add((StatementNode)BindgenNodeFactory.createVariableDeclarationNode(BindgenNodeFactory.createTypedBindingPatternNode(jField.getReturnShortName(), "newObj"), (ExpressionNode)BindgenNodeFactory.createListConstructorExpressionNode(new LinkedList<String>())));
        statementNodes.add((StatementNode)BindgenNodeFactory.createVariableDeclarationNode(BindgenNodeFactory.createTypedBindingPatternNode("handle[]", "anyObj"), (ExpressionNode)BindgenNodeFactory.createTypeCastExpressionNode("handle[]", (ExpressionNode)BindgenNodeFactory.createCheckExpressionNode((ExpressionNode)BindgenNodeFactory.createFunctionCallExpressionNode("jarrays:fromHandle", new LinkedList<String>(Arrays.asList("externalObj", "\"handle\"")))))));
        statementNodes.add((StatementNode)BindgenNodeFactory.createVariableDeclarationNode(BindgenNodeFactory.createTypedBindingPatternNode("int", "count"), (ExpressionNode)BindgenNodeFactory.createMethodCallExpressionNode((ExpressionNode)BindgenNodeFactory.createSimpleNameReferenceNode("anyObj"), "length", new LinkedList<String>())));
        statementNodes.add((StatementNode)BindgenNodeFactory.getObjectArrayPopulation(jField.getEnv(), jField.getReturnShortName()));
        statementNodes.add((StatementNode)BindgenNodeFactory.createReturnStatementNode((ExpressionNode)BindgenNodeFactory.createSimpleNameReferenceNode("newObj")));
        return statementNodes;
    }

    private static List<StatementNode> getFieldGetStringArrayStatements(JField jField) {
        return List.of(BindgenNodeFactory.getExternalFunctionCallStatement("handle", jField), BindgenNodeFactory.createReturnIfHandleIsNullStatement(jField.getEnv(), "externalObj"), BindgenNodeFactory.createReturnStatementNode((ExpressionNode)BindgenNodeFactory.createTypeCastExpressionNode("string[]", (ExpressionNode)BindgenNodeFactory.createCheckExpressionNode((ExpressionNode)BindgenNodeFactory.createFunctionCallExpressionNode("jarrays:fromHandle", new LinkedList<String>(Arrays.asList("externalObj", "\"string\"")))))));
    }

    private static List<StatementNode> getFieldGetPrimitiveStatement(JField jField) {
        LinkedList<StatementNode> statementNodes = new LinkedList<StatementNode>();
        statementNodes.add((StatementNode)BindgenNodeFactory.createReturnStatementNode((ExpressionNode)BindgenNodeFactory.createFunctionCallExpressionNode(jField.getExternalFunctionName(), BindgenNodeFactory.getParameterArgumentList(jField))));
        return statementNodes;
    }

    private static List<StatementNode> getFieldGetObjectStatements(JField jField) {
        LinkedList<StatementNode> statementNodes = new LinkedList<StatementNode>();
        statementNodes.add(BindgenNodeFactory.getExternalFunctionCallStatement("handle", jField));
        statementNodes.add((StatementNode)BindgenNodeFactory.createVariableDeclarationNode(BindgenNodeFactory.createTypedBindingPatternNode(jField.getReturnShortName(), "newObj"), (ExpressionNode)BindgenNodeFactory.createImplicitNewExpressionNode(Collections.singletonList("externalObj"))));
        statementNodes.add((StatementNode)BindgenNodeFactory.createReturnStatementNode((ExpressionNode)BindgenNodeFactory.createSimpleNameReferenceNode("newObj")));
        return statementNodes;
    }

    private static List<StatementNode> getFieldGetStringStatement(JField jField) {
        LinkedList<StatementNode> statementNodes = new LinkedList<StatementNode>();
        FunctionCallExpressionNode innerFunctionCall = BindgenNodeFactory.createFunctionCallExpressionNode(jField.getExternalFunctionName(), BindgenNodeFactory.getParameterArgumentList(jField));
        statementNodes.add((StatementNode)BindgenNodeFactory.createStringReturnStatement(jField.getEnv(), Collections.singletonList(innerFunctionCall.toSourceCode())));
        return statementNodes;
    }

    private static List<StatementNode> getFieldSetStatements(JField jField) {
        LinkedList<StatementNode> statementNodes = new LinkedList<StatementNode>();
        statementNodes.add((StatementNode)BindgenNodeFactory.createExpressionStatementNode((ExpressionNode)BindgenNodeFactory.createFunctionCallExpressionNode(jField.getExternalFunctionName(), BindgenNodeFactory.getParameterArgumentList(jField))));
        return statementNodes;
    }

    private static List<StatementNode> getMethodFunctionStatements(JMethod jMethod) {
        LinkedList<StatementNode> statementNodes = new LinkedList<StatementNode>();
        if (!jMethod.getHasReturn()) {
            if (!jMethod.isHandleException()) {
                statementNodes.add((StatementNode)BindgenNodeFactory.getNoReturnNoExceptionStatement(jMethod));
            } else {
                statementNodes.addAll(BindgenNodeFactory.getOnlyExceptionReturnStatement(jMethod));
            }
        } else if (!jMethod.isHandleException()) {
            if (!jMethod.isArrayReturn()) {
                if (jMethod.isStringReturn()) {
                    statementNodes.add((StatementNode)BindgenNodeFactory.getStringReturnStatement(jMethod));
                } else if (jMethod.isObjectReturn()) {
                    statementNodes.addAll(BindgenNodeFactory.getObjectReturnStatements(jMethod));
                } else {
                    statementNodes.add((StatementNode)BindgenNodeFactory.getPrimitiveReturnStatement(jMethod));
                }
            } else if (jMethod.isStringArrayReturn()) {
                statementNodes.addAll(BindgenNodeFactory.getStringArrayReturnStatements(jMethod));
            } else if (jMethod.isObjectReturn()) {
                statementNodes.addAll(BindgenNodeFactory.getObjectArrayReturnStatements(jMethod));
            } else {
                statementNodes.addAll(BindgenNodeFactory.getPrimitiveArrayReturnStatements(jMethod));
            }
        } else if (!jMethod.isArrayReturn()) {
            if (jMethod.isStringReturn()) {
                statementNodes.addAll(BindgenNodeFactory.getStringReturnWithException(jMethod));
            } else if (jMethod.isObjectReturn()) {
                statementNodes.addAll(BindgenNodeFactory.getObjectReturnWithException(jMethod));
            } else {
                statementNodes.addAll(BindgenNodeFactory.getPrimitiveReturnWithException(jMethod));
            }
        } else if (jMethod.isStringArrayReturn()) {
            statementNodes.addAll(BindgenNodeFactory.getStringArrayWithException(jMethod));
        } else if (jMethod.isObjectReturn()) {
            statementNodes.addAll(BindgenNodeFactory.getObjectArrayWithException(jMethod));
        } else {
            statementNodes.addAll(BindgenNodeFactory.getPrimitiveArrayWithException(jMethod));
        }
        return statementNodes;
    }

    private static ReturnStatementNode getPrimitiveReturnStatement(JMethod jMethod) {
        FunctionCallExpressionNode functionCallExpression = BindgenNodeFactory.createFunctionCallExpressionNode(jMethod.getExternalFunctionName(), BindgenNodeFactory.getParameterArgumentList(jMethod));
        return BindgenNodeFactory.createReturnStatementNode((ExpressionNode)functionCallExpression);
    }

    private static ReturnStatementNode getStringReturnStatement(JMethod jMethod) {
        FunctionCallExpressionNode innerFunctionCall = BindgenNodeFactory.createFunctionCallExpressionNode(jMethod.getExternalFunctionName(), BindgenNodeFactory.getParameterArgumentList(jMethod));
        PositionalArgumentNode positionalArgNode = BindgenNodeFactory.createPositionalArgumentNode(innerFunctionCall.toSourceCode());
        return BindgenNodeFactory.createStringReturnStatement(jMethod.getEnv(), Collections.singletonList(positionalArgNode.toSourceCode()));
    }

    private static ExpressionStatementNode getNoReturnNoExceptionStatement(JMethod jMethod) {
        FunctionCallExpressionNode functionCallExpression = BindgenNodeFactory.createFunctionCallExpressionNode(jMethod.getExternalFunctionName(), BindgenNodeFactory.getParameterArgumentList(jMethod));
        return BindgenNodeFactory.createExpressionStatementNode((ExpressionNode)functionCallExpression);
    }

    private static List<StatementNode> getPrimitiveArrayWithException(JMethod jMethod) {
        LinkedList<StatementNode> statementNodes = new LinkedList<StatementNode>();
        statementNodes.add(BindgenNodeFactory.getExternalFunctionCallStatement("handle|error", jMethod));
        statementNodes.add((StatementNode)BindgenNodeFactory.createIfElseStatementNode((ExpressionNode)BindgenNodeFactory.createBracedExpressionNode((ExpressionNode)BindgenNodeFactory.createSimpleNameReferenceNode("externalObj is error")), BindgenNodeFactory.getCheckExceptionBlock(jMethod.getExceptionName(), jMethod.getExceptionConstName()), (Node)BindgenNodeFactory.createElseBlockNode((StatementNode)BindgenNodeFactory.createBlockStatementNode((NodeList<StatementNode>)AbstractNodeFactory.createNodeList((Node[])new StatementNode[]{BindgenNodeFactory.createReturnStatementNode((ExpressionNode)BindgenNodeFactory.createTypeCastExpressionNode(jMethod.getReturnType(), (ExpressionNode)BindgenNodeFactory.createCheckExpressionNode((ExpressionNode)BindgenNodeFactory.createFunctionCallExpressionNode("jarrays:fromHandle", new LinkedList<String>(Arrays.asList("externalObj", "\"" + jMethod.getReturnTypeJava() + "\""))))))})))));
        return statementNodes;
    }

    private static List<StatementNode> getObjectArrayWithException(JMethod jMethod) {
        LinkedList<StatementNode> statementNodes = new LinkedList<StatementNode>();
        statementNodes.add(BindgenNodeFactory.getExternalFunctionCallStatement("handle|error", jMethod));
        statementNodes.add((StatementNode)BindgenNodeFactory.createIfElseStatementNode((ExpressionNode)BindgenNodeFactory.createBracedExpressionNode((ExpressionNode)BindgenNodeFactory.createSimpleNameReferenceNode("externalObj is error")), BindgenNodeFactory.getCheckExceptionBlock(jMethod.getExceptionName(), jMethod.getExceptionConstName()), (Node)BindgenNodeFactory.createElseBlockNode((StatementNode)BindgenNodeFactory.createBlockStatementNode((NodeList<StatementNode>)AbstractNodeFactory.createNodeList((Node[])new StatementNode[]{BindgenNodeFactory.createVariableDeclarationNode(BindgenNodeFactory.createTypedBindingPatternNode(jMethod.getReturnType(), "newObj"), (ExpressionNode)BindgenNodeFactory.createListConstructorExpressionNode(new LinkedList<String>())), BindgenNodeFactory.createVariableDeclarationNode(BindgenNodeFactory.createTypedBindingPatternNode("handle[]", "anyObj"), (ExpressionNode)BindgenNodeFactory.createTypeCastExpressionNode("handle[]", (ExpressionNode)BindgenNodeFactory.createCheckExpressionNode((ExpressionNode)BindgenNodeFactory.createFunctionCallExpressionNode("jarrays:fromHandle", new LinkedList<String>(Arrays.asList("externalObj", "\"handle\"")))))), BindgenNodeFactory.createVariableDeclarationNode(BindgenNodeFactory.createTypedBindingPatternNode("int", "count"), (ExpressionNode)BindgenNodeFactory.createMethodCallExpressionNode((ExpressionNode)BindgenNodeFactory.createSimpleNameReferenceNode("anyObj"), "length", new LinkedList<String>())), BindgenNodeFactory.getObjectArrayPopulation(jMethod.getEnv(), jMethod.getReturnComponentType())})))));
        statementNodes.add((StatementNode)BindgenNodeFactory.createReturnStatementNode((ExpressionNode)BindgenNodeFactory.createSimpleNameReferenceNode("newObj")));
        return statementNodes;
    }

    private static List<StatementNode> getStringArrayWithException(JMethod jMethod) {
        return List.of(BindgenNodeFactory.getExternalFunctionCallStatement("handle|error", jMethod), BindgenNodeFactory.createReturnIfHandleIsNullStatement(jMethod.getEnv(), "externalObj"), BindgenNodeFactory.createIfElseStatementNode((ExpressionNode)BindgenNodeFactory.createBracedExpressionNode((ExpressionNode)BindgenNodeFactory.createSimpleNameReferenceNode("externalObj is error")), BindgenNodeFactory.getCheckExceptionBlock(jMethod.getExceptionName(), jMethod.getExceptionConstName()), (Node)BindgenNodeFactory.createElseBlockNode((StatementNode)BindgenNodeFactory.createBlockStatementNode((NodeList<StatementNode>)AbstractNodeFactory.createNodeList((Node[])new StatementNode[]{BindgenNodeFactory.createReturnStatementNode((ExpressionNode)BindgenNodeFactory.createTypeCastExpressionNode("string[]", (ExpressionNode)BindgenNodeFactory.createCheckExpressionNode((ExpressionNode)BindgenNodeFactory.createFunctionCallExpressionNode("jarrays:fromHandle", new LinkedList<String>(Arrays.asList("externalObj", "\"string\""))))))})))));
    }

    private static List<StatementNode> getPrimitiveReturnWithException(JMethod jMethod) {
        LinkedList<StatementNode> statementNodes = new LinkedList<StatementNode>();
        statementNodes.add(BindgenNodeFactory.getExternalFunctionCallStatement(jMethod.getReturnType() + "|error", jMethod));
        statementNodes.add((StatementNode)BindgenNodeFactory.createIfElseStatementNode((ExpressionNode)BindgenNodeFactory.createBracedExpressionNode((ExpressionNode)BindgenNodeFactory.createSimpleNameReferenceNode("externalObj is error")), BindgenNodeFactory.getCheckExceptionBlock(jMethod.getExceptionName(), jMethod.getExceptionConstName()), (Node)BindgenNodeFactory.createElseBlockNode((StatementNode)BindgenNodeFactory.createBlockStatementNode((NodeList<StatementNode>)AbstractNodeFactory.createNodeList((Node[])new StatementNode[]{BindgenNodeFactory.createReturnStatementNode((ExpressionNode)BindgenNodeFactory.createSimpleNameReferenceNode("externalObj"))})))));
        return statementNodes;
    }

    private static List<StatementNode> getObjectReturnWithException(JMethod jMethod) {
        LinkedList<StatementNode> statementNodes = new LinkedList<StatementNode>();
        statementNodes.add(BindgenNodeFactory.getExternalFunctionCallStatement("handle|error", jMethod));
        statementNodes.add((StatementNode)BindgenNodeFactory.createIfElseStatementNode((ExpressionNode)BindgenNodeFactory.createBracedExpressionNode((ExpressionNode)BindgenNodeFactory.createSimpleNameReferenceNode("externalObj is error")), BindgenNodeFactory.getCheckExceptionBlock(jMethod.getExceptionName(), jMethod.getExceptionConstName()), (Node)BindgenNodeFactory.createElseBlockNode((StatementNode)BindgenNodeFactory.createBlockStatementNode((NodeList<StatementNode>)AbstractNodeFactory.createNodeList((Node[])new StatementNode[]{BindgenNodeFactory.createVariableDeclarationNode(BindgenNodeFactory.createTypedBindingPatternNode(jMethod.getReturnType(), "newObj"), (ExpressionNode)BindgenNodeFactory.createImplicitNewExpressionNode(Collections.singletonList("externalObj"))), BindgenNodeFactory.createReturnStatementNode((ExpressionNode)BindgenNodeFactory.createSimpleNameReferenceNode("newObj"))})))));
        return statementNodes;
    }

    private static List<StatementNode> getStringReturnWithException(JMethod jMethod) {
        LinkedList<StatementNode> statementNodes = new LinkedList<StatementNode>();
        statementNodes.add(BindgenNodeFactory.getExternalFunctionCallStatement("handle|error", jMethod));
        statementNodes.add((StatementNode)BindgenNodeFactory.createIfElseStatementNode((ExpressionNode)BindgenNodeFactory.createBracedExpressionNode((ExpressionNode)BindgenNodeFactory.createSimpleNameReferenceNode("externalObj is error")), BindgenNodeFactory.getCheckExceptionBlock(jMethod.getExceptionName(), jMethod.getExceptionConstName()), (Node)BindgenNodeFactory.createElseBlockNode((StatementNode)BindgenNodeFactory.createBlockStatementNode((NodeList<StatementNode>)AbstractNodeFactory.createNodeList((Node[])new StatementNode[]{BindgenNodeFactory.createStringReturnStatement(jMethod.getEnv(), Collections.singletonList("externalObj"))})))));
        return statementNodes;
    }

    private static List<StatementNode> getObjectReturnStatements(JMethod jMethod) {
        LinkedList<StatementNode> statementNodes = new LinkedList<StatementNode>();
        statementNodes.add(BindgenNodeFactory.getExternalFunctionCallStatement("handle", jMethod));
        String returnType = jMethod.getReturnType().replace("?", "");
        statementNodes.add((StatementNode)BindgenNodeFactory.createVariableDeclarationNode(BindgenNodeFactory.createTypedBindingPatternNode(returnType, "newObj"), (ExpressionNode)BindgenNodeFactory.createImplicitNewExpressionNode(Collections.singletonList("externalObj"))));
        if (jMethod.getEnv().isOptionalTypes() || jMethod.getEnv().isOptionalReturnTypes()) {
            ConditionalExpressionNode returnExpr = BindgenNodeFactory.createConditionalExpressionNode((ExpressionNode)BindgenNodeFactory.createFunctionCallExpressionNode("java:isNull", Collections.singletonList("newObj.jObj")), NIL_TOKEN_EXPRESSION, (ExpressionNode)BindgenNodeFactory.createSimpleNameReferenceNode("newObj"));
            statementNodes.add((StatementNode)BindgenNodeFactory.createReturnStatementNode((ExpressionNode)returnExpr));
        } else {
            statementNodes.add((StatementNode)BindgenNodeFactory.createReturnStatementNode((ExpressionNode)BindgenNodeFactory.createSimpleNameReferenceNode("newObj")));
        }
        return statementNodes;
    }

    private static List<StatementNode> getObjectArrayReturnStatements(JMethod jMethod) {
        LinkedList<StatementNode> statementNodes = new LinkedList<StatementNode>();
        statementNodes.add(BindgenNodeFactory.getExternalFunctionCallStatement("handle", jMethod));
        statementNodes.add((StatementNode)BindgenNodeFactory.createVariableDeclarationNode(BindgenNodeFactory.createTypedBindingPatternNode(jMethod.getReturnType(), "newObj"), (ExpressionNode)BindgenNodeFactory.createListConstructorExpressionNode(new LinkedList<String>())));
        statementNodes.add((StatementNode)BindgenNodeFactory.createVariableDeclarationNode(BindgenNodeFactory.createTypedBindingPatternNode("handle[]", "anyObj"), (ExpressionNode)BindgenNodeFactory.createTypeCastExpressionNode("handle[]", (ExpressionNode)BindgenNodeFactory.createCheckExpressionNode((ExpressionNode)BindgenNodeFactory.createFunctionCallExpressionNode("jarrays:fromHandle", new LinkedList<String>(Arrays.asList("externalObj", "\"handle\"")))))));
        statementNodes.add((StatementNode)BindgenNodeFactory.createVariableDeclarationNode(BindgenNodeFactory.createTypedBindingPatternNode("int", "count"), (ExpressionNode)BindgenNodeFactory.createMethodCallExpressionNode((ExpressionNode)BindgenNodeFactory.createSimpleNameReferenceNode("anyObj"), "length", new LinkedList<String>())));
        statementNodes.add((StatementNode)BindgenNodeFactory.getObjectArrayPopulation(jMethod.getEnv(), jMethod.getReturnComponentType()));
        statementNodes.add((StatementNode)BindgenNodeFactory.createReturnStatementNode((ExpressionNode)BindgenNodeFactory.createSimpleNameReferenceNode("newObj")));
        return statementNodes;
    }

    private static NameReferenceNode createNameReferenceNode(String namespace, String name) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("name must not be null, blank, or empty");
        }
        if (namespace == null) {
            return NodeFactory.createSimpleNameReferenceNode((Token)NodeFactory.createIdentifierToken((String)name));
        }
        if (namespace.isBlank()) {
            throw new IllegalArgumentException("namespace must not be blank or empty");
        }
        return NodeFactory.createQualifiedNameReferenceNode((Token)NodeFactory.createIdentifierToken((String)namespace), (Node)COLON_TOKEN, (IdentifierToken)NodeFactory.createIdentifierToken((String)name));
    }

    private static NameReferenceNode createNameReferenceNode(String name) {
        return BindgenNodeFactory.createNameReferenceNode(null, name);
    }

    private static StatementNode createReturnIfHandleIsNullStatement(BindgenEnv env, String handleName) {
        FunctionCallExpressionNode checkIsNullExpression = NodeFactory.createFunctionCallExpressionNode((NameReferenceNode)BindgenNodeFactory.createNameReferenceNode("java", "isNull"), (Token)OPEN_PAREN_TOKEN, (SeparatedNodeList)NodeFactory.createSeparatedNodeList((Node[])new Node[]{NodeFactory.createPositionalArgumentNode((ExpressionNode)BindgenNodeFactory.createNameReferenceNode(handleName))}), (Token)CLOSED_PAREN_TOKEN);
        ReturnStatementNode returnStatement = env.isOptionalTypes() || env.isOptionalReturnTypes() ? NodeFactory.createReturnStatementNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RETURN_KEYWORD, (MinutiaeList)EMPTY_WHITE_SPACE, (MinutiaeList)SINGLE_SPACE_WHITE_SPACE), (ExpressionNode)NIL_TOKEN_EXPRESSION, (Token)SEMICOLON_TOKEN) : NodeFactory.createReturnStatementNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RETURN_KEYWORD, (MinutiaeList)EMPTY_WHITE_SPACE, (MinutiaeList)SINGLE_SPACE_WHITE_SPACE), (ExpressionNode)ARRAY_TOKEN_EXPRESSION, (Token)SEMICOLON_TOKEN);
        return NodeFactory.createIfElseStatementNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.IF_KEYWORD, (MinutiaeList)EMPTY_WHITE_SPACE, (MinutiaeList)SINGLE_SPACE_WHITE_SPACE), (ExpressionNode)checkIsNullExpression, (BlockStatementNode)BindgenNodeFactory.createBlockStatementNode((NodeList<StatementNode>)NodeFactory.createNodeList((Node[])new StatementNode[]{returnStatement})), null);
    }

    private static List<StatementNode> getStringArrayReturnStatements(JMethod jMethod) {
        return List.of(BindgenNodeFactory.getExternalFunctionCallStatement("handle", jMethod), BindgenNodeFactory.createReturnIfHandleIsNullStatement(jMethod.getEnv(), "externalObj"), BindgenNodeFactory.createReturnStatementNode((ExpressionNode)BindgenNodeFactory.createTypeCastExpressionNode("string[]", (ExpressionNode)BindgenNodeFactory.createCheckExpressionNode((ExpressionNode)BindgenNodeFactory.createFunctionCallExpressionNode("jarrays:fromHandle", new LinkedList<String>(Arrays.asList("externalObj", "\"string\"")))))));
    }

    private static ReturnStatementNode createStringReturnStatement(BindgenEnv env, List<String> argNodes) {
        FunctionCallExpressionNode funcCallExprNode = BindgenNodeFactory.createFunctionCallExpressionNode("java:toString", argNodes);
        if (env.isOptionalTypes() || env.isOptionalReturnTypes()) {
            return BindgenNodeFactory.createReturnStatementNode((ExpressionNode)funcCallExprNode);
        }
        BinaryExpressionNode conditionalExprNode = BindgenNodeFactory.createElvisExpressionNode((Node)funcCallExprNode, (Node)BindgenNodeFactory.createBasicLiteralNode(""));
        return BindgenNodeFactory.createReturnStatementNode((ExpressionNode)conditionalExprNode);
    }

    private static List<StatementNode> getPrimitiveArrayReturnStatements(JMethod jMethod) {
        LinkedList<StatementNode> statementNodes = new LinkedList<StatementNode>();
        statementNodes.add(BindgenNodeFactory.getExternalFunctionCallStatement("handle", jMethod));
        statementNodes.add((StatementNode)BindgenNodeFactory.createReturnStatementNode((ExpressionNode)BindgenNodeFactory.createTypeCastExpressionNode(jMethod.getReturnType(), (ExpressionNode)BindgenNodeFactory.createCheckExpressionNode((ExpressionNode)BindgenNodeFactory.createFunctionCallExpressionNode("jarrays:fromHandle", new LinkedList<String>(Arrays.asList("externalObj", "\"" + jMethod.getReturnTypeJava() + "\"")))))));
        return statementNodes;
    }

    private static List<StatementNode> getOnlyExceptionReturnStatement(JMethod jMethod) {
        LinkedList<StatementNode> statementNodes = new LinkedList<StatementNode>();
        statementNodes.add(BindgenNodeFactory.getExternalFunctionCallStatement("error|()", jMethod));
        statementNodes.add((StatementNode)BindgenNodeFactory.createIfElseStatementNode((ExpressionNode)BindgenNodeFactory.createBracedExpressionNode((ExpressionNode)BindgenNodeFactory.createSimpleNameReferenceNode("externalObj is error")), BindgenNodeFactory.getCheckExceptionBlock(jMethod.getExceptionName(), jMethod.getExceptionConstName()), null));
        return statementNodes;
    }

    private static ForEachStatementNode getObjectArrayPopulation(BindgenEnv env, String elementType) {
        AssignmentStatementNode assignmentStatementNode = BindgenNodeFactory.createAssignmentStatementNode((Node)BindgenNodeFactory.createSimpleNameReferenceNode("newObj[i]"), (ExpressionNode)BindgenNodeFactory.createSimpleNameReferenceNode("element"));
        if (env.isOptionalTypes() || env.isOptionalReturnTypes()) {
            assignmentStatementNode = BindgenNodeFactory.createIfElseStatementNode((ExpressionNode)BindgenNodeFactory.createBracedExpressionNode((ExpressionNode)BindgenNodeFactory.createSimpleNameReferenceNode(String.format("newObj is %s", elementType.replace("?", "?[]")))), BindgenNodeFactory.createBlockStatementNode((NodeList<StatementNode>)AbstractNodeFactory.createNodeList((Node[])new StatementNode[]{assignmentStatementNode})), null);
            BindgenNodeFactory.createAssignmentStatementNode((Node)BindgenNodeFactory.createSimpleNameReferenceNode("newObj[i]"), (ExpressionNode)BindgenNodeFactory.createSimpleNameReferenceNode("element"));
        }
        return BindgenNodeFactory.createForEachStatementNode(BindgenNodeFactory.createTypedBindingPatternNode("int", "i"), (Node)BindgenNodeFactory.createBinaryExpressionNode("0", AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ELLIPSIS_TOKEN), "count - 1"), BindgenNodeFactory.createBlockStatementNode((NodeList<StatementNode>)AbstractNodeFactory.createNodeList((Node[])new StatementNode[]{BindgenNodeFactory.createVariableDeclarationNode(BindgenNodeFactory.createTypedBindingPatternNode(elementType, "element"), (ExpressionNode)BindgenNodeFactory.createImplicitNewExpressionNode(Collections.singletonList("anyObj[i]"))), assignmentStatementNode})));
    }

    private static BlockStatementNode getCheckExceptionBlock(String exceptionName, String exceptionConstName) {
        return BindgenNodeFactory.createBlockStatementNode((NodeList<StatementNode>)AbstractNodeFactory.createNodeList((Node[])new StatementNode[]{BindgenNodeFactory.createVariableDeclarationNode(BindgenNodeFactory.createTypedBindingPatternNode(exceptionName, "e"), (ExpressionNode)BindgenNodeFactory.createErrorConstructorExpressionNode((TypeDescriptorNode)BindgenNodeFactory.createSimpleNameReferenceNode(exceptionName), new LinkedList<String>(Arrays.asList(exceptionConstName, "externalObj", "message = externalObj.message()")))), BindgenNodeFactory.createReturnStatementNode((ExpressionNode)BindgenNodeFactory.createSimpleNameReferenceNode("e"))}));
    }

    private static StatementNode getExternalFunctionCallStatement(String returnType, BFunction bFunction) {
        FunctionCallExpressionNode innerFunctionCall = BindgenNodeFactory.createFunctionCallExpressionNode(bFunction.getExternalFunctionName(), BindgenNodeFactory.getParameterArgumentList(bFunction));
        return BindgenNodeFactory.createVariableDeclarationNode(BindgenNodeFactory.createTypedBindingPatternNode(returnType, "externalObj"), (ExpressionNode)innerFunctionCall);
    }

    private static List<String> getParameterArgumentList(BFunction bFunction) {
        LinkedList<String> argValues = new LinkedList<String>();
        if (!bFunction.isStatic()) {
            argValues.add("self.jObj");
        }
        for (JParameter jParameter : bFunction.getParameters()) {
            if (jParameter.getIsString().booleanValue() && jParameter.isOptional().booleanValue()) {
                argValues.add(String.format("%s is () ? java:createNull() : java:fromString(%s)", jParameter.getFieldName(), jParameter.getFieldName()));
                continue;
            }
            if (jParameter.getIsString().booleanValue()) {
                argValues.add(String.format("java:fromString(%s)", jParameter.getFieldName()));
                continue;
            }
            if (jParameter.isArray().booleanValue() && jParameter.isOptional().booleanValue()) {
                argValues.add(String.format("check jarrays:toHandle(%s ?: [], \"%s\")", jParameter.getFieldName(), jParameter.getComponentType()));
                continue;
            }
            if (jParameter.isArray().booleanValue()) {
                argValues.add(String.format("check jarrays:toHandle(%s, \"%s\")", jParameter.getFieldName(), jParameter.getComponentType()));
                continue;
            }
            if (jParameter.getIsObj().booleanValue()) {
                if (jParameter.isOptional().booleanValue()) {
                    argValues.add(String.format("%s is () ? java:createNull() : %s.jObj", jParameter.getFieldName(), jParameter.getFieldName()));
                    continue;
                }
                argValues.add(jParameter.getFieldName() + ".jObj");
                continue;
            }
            argValues.add(jParameter.getFieldName());
        }
        return argValues;
    }

    private static MarkdownParameterDocumentationLineNode createMarkdownParameterDocumentationLineNode(String paramName, String content) {
        Token hashToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.HASH_TOKEN, (MinutiaeList)BindgenNodeFactory.emptyML(), (MinutiaeList)BindgenNodeFactory.emptyML());
        Token plusToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.PLUS_TOKEN);
        LiteralValueToken parameterName = AbstractNodeFactory.createLiteralValueToken((SyntaxKind)SyntaxKind.PARAMETER_NAME, (String)paramName, (MinutiaeList)BindgenNodeFactory.singleWSML(), (MinutiaeList)BindgenNodeFactory.singleWSML());
        LiteralValueToken documentElements = AbstractNodeFactory.createLiteralValueToken((SyntaxKind)SyntaxKind.DOCUMENTATION_DESCRIPTION, (String)content, (MinutiaeList)BindgenNodeFactory.emptyML(), (MinutiaeList)BindgenNodeFactory.singleNLML());
        Token minusToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.MINUS_TOKEN);
        return NodeFactory.createMarkdownParameterDocumentationLineNode(null, (Token)hashToken, (Token)plusToken, (Token)parameterName, (Token)minusToken, (NodeList)AbstractNodeFactory.createNodeList((Node[])new Node[]{documentElements}));
    }

    private static MarkdownDocumentationLineNode createMarkdownDocumentationLineNode(String content) {
        Token hashToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.HASH_TOKEN, (MinutiaeList)BindgenNodeFactory.emptyML(), (MinutiaeList)BindgenNodeFactory.singleWSML());
        LiteralValueToken documentElements = AbstractNodeFactory.createLiteralValueToken((SyntaxKind)SyntaxKind.DOCUMENTATION_DESCRIPTION, (String)content, (MinutiaeList)BindgenNodeFactory.emptyML(), (MinutiaeList)BindgenNodeFactory.singleNLML());
        return NodeFactory.createMarkdownDocumentationLineNode(null, (Token)hashToken, (NodeList)AbstractNodeFactory.createNodeList((Node[])new Node[]{documentElements}));
    }

    private static MarkdownDocumentationNode createMarkdownDocumentationNode(NodeList<Node> documentationString) {
        return NodeFactory.createMarkdownDocumentationNode(documentationString);
    }

    private static MetadataNode createMetadataNode(Node documentationString, NodeList<AnnotationNode> annotations) {
        return NodeFactory.createMetadataNode((Node)documentationString, annotations);
    }

    private static ErrorConstructorExpressionNode createErrorConstructorExpressionNode(TypeDescriptorNode typeReference, List<String> argList) {
        Token errorKeyword = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ERROR_KEYWORD, (MinutiaeList)BindgenNodeFactory.emptyML(), (MinutiaeList)BindgenNodeFactory.singleWSML());
        Token openParenToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_PAREN_TOKEN);
        LinkedList<Object> argumentNodes = new LinkedList<Object>();
        for (String arg : argList) {
            argumentNodes.add(BindgenNodeFactory.createPositionalArgumentNode(arg));
            argumentNodes.add(AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
        }
        if (argumentNodes.size() > 1) {
            argumentNodes.remove(argumentNodes.size() - 1);
        }
        SeparatedNodeList arguments = AbstractNodeFactory.createSeparatedNodeList(argumentNodes);
        Token closeParenToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_PAREN_TOKEN);
        return NodeFactory.createErrorConstructorExpressionNode((Token)errorKeyword, (TypeDescriptorNode)typeReference, (Token)openParenToken, (SeparatedNodeList)arguments, (Token)closeParenToken);
    }

    private static AssignmentStatementNode createAssignmentStatementNode(Node varRef, ExpressionNode expression) {
        Token equalsToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN, (MinutiaeList)BindgenNodeFactory.singleWSML(), (MinutiaeList)BindgenNodeFactory.singleWSML());
        Token semicolonToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN);
        return NodeFactory.createAssignmentStatementNode((Node)varRef, (Token)equalsToken, (ExpressionNode)expression, (Token)semicolonToken);
    }

    private static BinaryExpressionNode createBinaryExpressionNode(String lhs, Token operator, String rhs) {
        SimpleNameReferenceNode lhsExpr = BindgenNodeFactory.createSimpleNameReferenceNode(lhs);
        SimpleNameReferenceNode rhsExpr = BindgenNodeFactory.createSimpleNameReferenceNode(rhs);
        return NodeFactory.createBinaryExpressionNode(null, (Node)lhsExpr, (Token)operator, (Node)rhsExpr);
    }

    private static ForEachStatementNode createForEachStatementNode(TypedBindingPatternNode typedBindingPattern, Node actionOrExpressionNode, BlockStatementNode blockStatement) {
        Token forEachKeyword = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.FOREACH_KEYWORD, (MinutiaeList)BindgenNodeFactory.emptyML(), (MinutiaeList)BindgenNodeFactory.singleWSML());
        Token inKeyword = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.IN_KEYWORD, (MinutiaeList)BindgenNodeFactory.singleWSML(), (MinutiaeList)BindgenNodeFactory.singleWSML());
        return NodeFactory.createForEachStatementNode((Token)forEachKeyword, (TypedBindingPatternNode)typedBindingPattern, (Token)inKeyword, (Node)actionOrExpressionNode, (BlockStatementNode)blockStatement, null);
    }

    private static MethodCallExpressionNode createMethodCallExpressionNode(ExpressionNode expression, String methodNameValue, List<String> argList) {
        Token dotToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.DOT_TOKEN);
        SimpleNameReferenceNode methodName = BindgenNodeFactory.createSimpleNameReferenceNode(methodNameValue);
        Token openParenToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_PAREN_TOKEN);
        LinkedList<PositionalArgumentNode> argListNode = new LinkedList<PositionalArgumentNode>();
        for (String arg : argList) {
            argListNode.add(BindgenNodeFactory.createPositionalArgumentNode(arg));
            argListNode.add(BindgenNodeFactory.createPositionalArgumentNode(","));
        }
        if (argListNode.size() > 1) {
            argListNode.remove(argListNode.size() - 1);
        }
        SeparatedNodeList arguments = AbstractNodeFactory.createSeparatedNodeList(argListNode);
        Token closeParenToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_PAREN_TOKEN);
        return NodeFactory.createMethodCallExpressionNode((ExpressionNode)expression, (Token)dotToken, (NameReferenceNode)methodName, (Token)openParenToken, (SeparatedNodeList)arguments, (Token)closeParenToken);
    }

    private static ReturnStatementNode createReturnStatementNode(ExpressionNode expression) {
        Token returnKeyword = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RETURN_KEYWORD, (MinutiaeList)BindgenNodeFactory.emptyML(), (MinutiaeList)BindgenNodeFactory.singleWSML());
        Token semicolonToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN);
        return NodeFactory.createReturnStatementNode((Token)returnKeyword, (ExpressionNode)expression, (Token)semicolonToken);
    }

    private static VariableDeclarationNode createVariableDeclarationNode(TypedBindingPatternNode typedBindingPattern, ExpressionNode initializer) {
        NodeList annotations = AbstractNodeFactory.createNodeList((Node[])new AnnotationNode[0]);
        Token equalsToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN);
        Token semicolonToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN);
        return NodeFactory.createVariableDeclarationNode((NodeList)annotations, null, (TypedBindingPatternNode)typedBindingPattern, (Token)equalsToken, (ExpressionNode)initializer, (Token)semicolonToken);
    }

    private static TypeCastExpressionNode createTypeCastExpressionNode(String type, ExpressionNode expression) {
        Token ltToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.LT_TOKEN);
        TypeCastParamNode typeCastParam = BindgenNodeFactory.createTypeCastParamNode(type);
        Token gtToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.GT_TOKEN);
        return NodeFactory.createTypeCastExpressionNode((Token)ltToken, (TypeCastParamNode)typeCastParam, (Token)gtToken, (ExpressionNode)expression);
    }

    private static TypeCastParamNode createTypeCastParamNode(String type) {
        NodeList annotationNodes = AbstractNodeFactory.createNodeList((Node[])new AnnotationNode[0]);
        SimpleNameReferenceNode typeNode = BindgenNodeFactory.createSimpleNameReferenceNode(type);
        return NodeFactory.createTypeCastParamNode((NodeList)annotationNodes, (Node)typeNode);
    }

    private static ImplicitNewExpressionNode createImplicitNewExpressionNode(List<String> argList) {
        Token newToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.NEW_KEYWORD);
        ParenthesizedArgList parenthesizedArgList = BindgenNodeFactory.createParenthesizedArgList(argList);
        return NodeFactory.createImplicitNewExpressionNode((Token)newToken, (ParenthesizedArgList)parenthesizedArgList);
    }

    private static CheckExpressionNode createCheckExpressionNode(ExpressionNode expressionNode) {
        Token checkKeyword = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CHECK_KEYWORD, (MinutiaeList)BindgenNodeFactory.emptyML(), (MinutiaeList)BindgenNodeFactory.singleWSML());
        return NodeFactory.createCheckExpressionNode(null, (Token)checkKeyword, (ExpressionNode)expressionNode);
    }

    private static ElseBlockNode createElseBlockNode(StatementNode elseBody) {
        Token elseKeyword = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ELSE_KEYWORD, (MinutiaeList)BindgenNodeFactory.emptyML(), (MinutiaeList)BindgenNodeFactory.singleWSML());
        return NodeFactory.createElseBlockNode((Token)elseKeyword, (StatementNode)elseBody);
    }

    private static IfElseStatementNode createIfElseStatementNode(ExpressionNode condition, BlockStatementNode ifBody, Node elseBody) {
        Token ifKeyword = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.IF_KEYWORD, (MinutiaeList)BindgenNodeFactory.emptyML(), (MinutiaeList)BindgenNodeFactory.singleWSML());
        return NodeFactory.createIfElseStatementNode((Token)ifKeyword, (ExpressionNode)condition, (BlockStatementNode)ifBody, (Node)elseBody);
    }

    private static BlockStatementNode createBlockStatementNode(NodeList<StatementNode> statementNodes) {
        Token openBraceToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN);
        Token closeBraceToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN);
        return NodeFactory.createBlockStatementNode((Token)openBraceToken, statementNodes, (Token)closeBraceToken);
    }

    private static BracedExpressionNode createBracedExpressionNode(ExpressionNode expressionNode) {
        Token openParenToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_PAREN_TOKEN);
        Token closeParenToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_PAREN_TOKEN);
        return NodeFactory.createBracedExpressionNode(null, (Token)openParenToken, (ExpressionNode)expressionNode, (Token)closeParenToken);
    }

    private static ParenthesizedArgList createParenthesizedArgList(List<String> argList) {
        Token openParenToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_PAREN_TOKEN);
        LinkedList<Object> argumentNodeList = new LinkedList<Object>();
        for (String arg : argList) {
            argumentNodeList.add(BindgenNodeFactory.createPositionalArgumentNode(arg));
            argumentNodeList.add(AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
        }
        if (argumentNodeList.size() > 1) {
            argumentNodeList.remove(argumentNodeList.size() - 1);
        }
        SeparatedNodeList arguments = AbstractNodeFactory.createSeparatedNodeList(argumentNodeList);
        Token closeParenToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_PAREN_TOKEN);
        return NodeFactory.createParenthesizedArgList((Token)openParenToken, (SeparatedNodeList)arguments, (Token)closeParenToken);
    }

    private static ConditionalExpressionNode createConditionalExpressionNode(ExpressionNode lhsExpr, ExpressionNode middleExpr, ExpressionNode endExpr) {
        Token questionMark = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.QUESTION_MARK_TOKEN);
        Token colon = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN);
        return NodeFactory.createConditionalExpressionNode((ExpressionNode)lhsExpr, (Token)questionMark, (ExpressionNode)middleExpr, (Token)colon, (ExpressionNode)endExpr);
    }

    private static BinaryExpressionNode createElvisExpressionNode(Node lhs, Node rhs) {
        Token elvisToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ELVIS_TOKEN);
        return NodeFactory.createBinaryExpressionNode((SyntaxKind)SyntaxKind.BINARY_EXPRESSION, (Node)lhs, (Token)elvisToken, (Node)rhs);
    }

    private static FunctionCallExpressionNode createFunctionCallExpressionNode(String functionNameValue, List<String> argValues) {
        Token openParenToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_PAREN_TOKEN);
        SimpleNameReferenceNode functionName = BindgenNodeFactory.createSimpleNameReferenceNode(functionNameValue);
        LinkedList<Object> argList = new LinkedList<Object>();
        for (String arg : argValues) {
            argList.add(BindgenNodeFactory.createPositionalArgumentNode(arg));
            argList.add(AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
        }
        if (argList.size() > 1) {
            argList.remove(argList.size() - 1);
        }
        SeparatedNodeList argumentNodeList = AbstractNodeFactory.createSeparatedNodeList(argList);
        Token closeParenToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_PAREN_TOKEN);
        return NodeFactory.createFunctionCallExpressionNode((NameReferenceNode)functionName, (Token)openParenToken, (SeparatedNodeList)argumentNodeList, (Token)closeParenToken);
    }

    private static PositionalArgumentNode createPositionalArgumentNode(String name) {
        SimpleNameReferenceNode expression = BindgenNodeFactory.createSimpleNameReferenceNode(name);
        return NodeFactory.createPositionalArgumentNode((ExpressionNode)expression);
    }

    private static SimpleNameReferenceNode createSimpleNameReferenceNode(String name) {
        IdentifierToken nameReference = AbstractNodeFactory.createIdentifierToken((String)name);
        return NodeFactory.createSimpleNameReferenceNode((Token)nameReference);
    }

    private static TypedBindingPatternNode createTypedBindingPatternNode(String type, String variableName) {
        SimpleNameReferenceNode typeDescriptor = BindgenNodeFactory.createSimpleNameReferenceNode(type);
        CaptureBindingPatternNode bindingPattern = BindgenNodeFactory.createCaptureBindingPatternNode(variableName);
        return NodeFactory.createTypedBindingPatternNode((TypeDescriptorNode)typeDescriptor, (BindingPatternNode)bindingPattern);
    }

    private static CaptureBindingPatternNode createCaptureBindingPatternNode(String identifier) {
        IdentifierToken variableName = AbstractNodeFactory.createIdentifierToken((String)identifier, (MinutiaeList)BindgenNodeFactory.singleWSML(), (MinutiaeList)BindgenNodeFactory.singleWSML());
        return NodeFactory.createCaptureBindingPatternNode((Token)variableName);
    }

    private static AnnotationNode createAnnotationNode(String annotation, Map<String, List<String>> fields) {
        Token atToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.AT_TOKEN);
        SimpleNameReferenceNode nameReference = BindgenNodeFactory.createSimpleNameReferenceNode(annotation);
        MappingConstructorExpressionNode mappingConstructor = BindgenNodeFactory.createMappingConstructorExpressionNode(fields);
        return NodeFactory.createAnnotationNode((Token)atToken, (Node)nameReference, (MappingConstructorExpressionNode)mappingConstructor);
    }

    private static MappingConstructorExpressionNode createMappingConstructorExpressionNode(Map<String, List<String>> fields) {
        Token openBraceToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN, (MinutiaeList)BindgenNodeFactory.emptyML(), (MinutiaeList)BindgenNodeFactory.singleNLML());
        Token closeBraceToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN);
        LinkedList<Object> mappingFields = new LinkedList<Object>();
        for (Map.Entry<String, List<String>> entry : fields.entrySet()) {
            List<String> fieldValues = entry.getValue();
            mappingFields.add(BindgenNodeFactory.createSpecificFieldNode(entry.getKey(), fieldValues));
            mappingFields.add(AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
        }
        if (mappingFields.size() > 1) {
            mappingFields.remove(mappingFields.size() - 1);
        }
        SeparatedNodeList fieldsNodeList = AbstractNodeFactory.createSeparatedNodeList(mappingFields);
        return NodeFactory.createMappingConstructorExpressionNode((Token)openBraceToken, (SeparatedNodeList)fieldsNodeList, (Token)closeBraceToken);
    }

    private static SpecificFieldNode createSpecificFieldNode(String name, List<String> value) {
        IdentifierToken fieldName = AbstractNodeFactory.createIdentifierToken((String)name);
        Token colonToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN);
        ListConstructorExpressionNode expressionNode = null;
        if (value.size() > 1 || name.equals("paramTypes")) {
            expressionNode = BindgenNodeFactory.createListConstructorExpressionNode(value);
        } else if (!value.isEmpty()) {
            expressionNode = BindgenNodeFactory.createBasicLiteralNode(value.get(0));
        }
        return NodeFactory.createSpecificFieldNode(null, (Node)fieldName, (Token)colonToken, (ExpressionNode)expressionNode);
    }

    private static ListConstructorExpressionNode createListConstructorExpressionNode(List<String> list) {
        Token openBracketToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACKET_TOKEN);
        Token closeBracketToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACKET_TOKEN);
        LinkedList<Object> listElements = new LinkedList<Object>();
        for (String element : list) {
            listElements.add(BindgenNodeFactory.createBasicLiteralNode(element));
            listElements.add(AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
        }
        if (listElements.size() > 1) {
            listElements.remove(listElements.size() - 1);
        }
        SeparatedNodeList expressions = AbstractNodeFactory.createSeparatedNodeList(listElements);
        return NodeFactory.createListConstructorExpressionNode((Token)openBracketToken, (SeparatedNodeList)expressions, (Token)closeBracketToken);
    }

    private static ExpressionStatementNode createExpressionStatementNode(ExpressionNode expression) {
        Token semicolonToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN);
        return NodeFactory.createExpressionStatementNode(null, (ExpressionNode)expression, (Token)semicolonToken);
    }

    private static BasicLiteralNode createBasicLiteralNode(String value) {
        LiteralValueToken valueToken = AbstractNodeFactory.createLiteralValueToken((SyntaxKind)SyntaxKind.STRING_LITERAL_TOKEN, (String)("\"" + value + "\""), (MinutiaeList)BindgenNodeFactory.emptyML(), (MinutiaeList)BindgenNodeFactory.emptyML());
        return NodeFactory.createBasicLiteralNode((SyntaxKind)SyntaxKind.STRING_LITERAL, (Token)valueToken);
    }

    private static RequiredParameterNode createRequiredParameterNode(String type, String param) {
        NodeList annotations = AbstractNodeFactory.createNodeList((Node[])new AnnotationNode[0]);
        SimpleNameReferenceNode typeName = BindgenNodeFactory.createSimpleNameReferenceNode(type);
        IdentifierToken paramName = AbstractNodeFactory.createIdentifierToken((String)param, (MinutiaeList)BindgenNodeFactory.singleWSML(), (MinutiaeList)BindgenNodeFactory.emptyML());
        return NodeFactory.createRequiredParameterNode((NodeList)annotations, (Node)typeName, (Token)paramName);
    }

    private static ReturnTypeDescriptorNode createReturnTypeDescriptorNode(TypeDescriptorNode returnTypeDescriptorNode) {
        Token returnsKeyword = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RETURNS_KEYWORD, (MinutiaeList)BindgenNodeFactory.emptyML(), (MinutiaeList)BindgenNodeFactory.singleWSML());
        NodeList annotations = AbstractNodeFactory.createNodeList((Node[])new AnnotationNode[0]);
        return NodeFactory.createReturnTypeDescriptorNode((Token)returnsKeyword, (NodeList)annotations, (Node)returnTypeDescriptorNode);
    }

    private static MinutiaeList singleWSML() {
        return BindgenNodeFactory.emptyML().add(AbstractNodeFactory.createWhitespaceMinutiae((String)" "));
    }

    private static MinutiaeList singleNLML() {
        String newLine = System.getProperty("line.separator");
        return BindgenNodeFactory.emptyML().add(AbstractNodeFactory.createEndOfLineMinutiae((String)newLine));
    }

    private static MinutiaeList doubleNLML() {
        String newLine = System.getProperty("line.separator") + System.getProperty("line.separator");
        return BindgenNodeFactory.emptyML().add(AbstractNodeFactory.createEndOfLineMinutiae((String)newLine));
    }

    private static MinutiaeList emptyML() {
        return AbstractNodeFactory.createEmptyMinutiaeList();
    }

    private static Collection<Node> getTokenList(List<String> stringList) {
        LinkedList<Node> tokenList = new LinkedList<Node>();
        for (String value : stringList) {
            tokenList.add((Node)AbstractNodeFactory.createIdentifierToken((String)value));
        }
        return tokenList;
    }

    private static List<String> getParameterList(List<JParameter> jParameterList) {
        ArrayList<String> paramList = new ArrayList<String>();
        for (JParameter jparameter : jParameterList) {
            paramList.add(jparameter.getType());
        }
        return paramList;
    }
}

