/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api;

import io.ballerina.runtime.api.Runtime;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.flags.SymbolFlags;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.MethodType;
import io.ballerina.runtime.api.types.ObjectType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.ResourceMethodType;
import io.ballerina.runtime.api.types.ServiceType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.http.api.BallerinaConnectorException;
import io.ballerina.stdlib.http.api.CorsHeaders;
import io.ballerina.stdlib.http.api.HTTPInterceptorServicesRegistry;
import io.ballerina.stdlib.http.api.HttpConstants;
import io.ballerina.stdlib.http.api.HttpErrorType;
import io.ballerina.stdlib.http.api.HttpIntrospectionResource;
import io.ballerina.stdlib.http.api.HttpResource;
import io.ballerina.stdlib.http.api.HttpSwaggerUiResource;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.api.Resource;
import io.ballerina.stdlib.http.api.ResourceDataElement;
import io.ballerina.stdlib.http.api.ResourceElementFactory;
import io.ballerina.stdlib.http.api.Service;
import io.ballerina.stdlib.http.api.ValueCreatorUtils;
import io.ballerina.stdlib.http.api.nativeimpl.ModuleUtils;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import io.ballerina.stdlib.http.uri.DispatcherUtil;
import io.ballerina.stdlib.http.uri.URITemplate;
import io.ballerina.stdlib.http.uri.URITemplateException;
import io.ballerina.stdlib.http.uri.parser.Literal;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpService
implements Service {
    private static final Logger log = LoggerFactory.getLogger(HttpService.class);
    private static final BString CORS_FIELD = StringUtils.fromString((String)"cors");
    private static final BString HOST_FIELD = StringUtils.fromString((String)"host");
    private static final BString OPENAPI_DEF_FIELD = StringUtils.fromString((String)"openApiDefinition");
    private static final BString MEDIA_TYPE_SUBTYPE_PREFIX = StringUtils.fromString((String)"mediaTypeSubtypePrefix");
    private static final BString TREAT_NILABLE_AS_OPTIONAL = StringUtils.fromString((String)"treatNilableAsOptional");
    private static final BString DATA_VALIDATION = StringUtils.fromString((String)"validation");
    private static final BString LAX_DATA_BINDING = StringUtils.fromString((String)"laxDataBinding");
    private BObject balService;
    private List<HttpResource> resources;
    private List<String> allAllowedMethods;
    private String basePath;
    private CorsHeaders corsHeaders;
    private URITemplate<Resource, HttpCarbonMessage> uriTemplate;
    private boolean keepAlive = true;
    private BMap<BString, Object> compression;
    private String hostName;
    private String chunkingConfig;
    private String mediaTypeSubtypePrefix;
    private List<String> oasResourceLinks = new ArrayList<String>();
    private boolean treatNilableAsOptional = true;
    private List<HTTPInterceptorServicesRegistry> interceptorServicesRegistries;
    private BArray balInterceptorServicesArray;
    private byte[] introspectionPayload = new byte[0];
    private Boolean constraintValidation = true;
    private Boolean laxDataBinding = false;

    protected HttpService(BObject service, String basePath) {
        this.balService = service;
        this.basePath = basePath;
    }

    protected HttpService(BObject service) {
        this.balService = service;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    protected void setCompressionConfig(BMap<BString, Object> compression) {
        this.compression = compression;
    }

    @Override
    public BMap<BString, Object> getCompressionConfig() {
        return this.compression;
    }

    public void setChunkingConfig(String chunkingConfig) {
        this.chunkingConfig = chunkingConfig;
    }

    @Override
    public String getChunkingConfig() {
        return this.chunkingConfig;
    }

    public String getName() {
        return HttpUtil.getServiceName(this.balService);
    }

    public String getPackage() {
        return TypeUtils.getType((Object)this.balService).getPackage().getName();
    }

    public BObject getBalService() {
        return this.balService;
    }

    public List<HttpResource> getResources() {
        return this.resources;
    }

    public void setResources(List<HttpResource> resources) {
        this.resources = resources;
    }

    @Override
    public List<String> getAllAllowedMethods() {
        return this.allAllowedMethods;
    }

    public void setAllAllowedMethods(List<String> allAllowMethods) {
        this.allAllowedMethods = allAllowMethods;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setMediaTypeSubtypePrefix(String mediaTypeSubtypePrefix) {
        this.mediaTypeSubtypePrefix = mediaTypeSubtypePrefix;
    }

    @Override
    public String getMediaTypeSubtypePrefix() {
        return this.mediaTypeSubtypePrefix;
    }

    public void setTreatNilableAsOptional(boolean treatNilableAsOptional) {
        this.treatNilableAsOptional = treatNilableAsOptional;
    }

    public boolean isTreatNilableAsOptional() {
        return this.treatNilableAsOptional;
    }

    @Override
    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        String serviceName;
        this.basePath = basePath == null || basePath.trim().isEmpty() ? "/".concat((serviceName = this.getName()).startsWith("$") ? "" : serviceName) : HttpUtil.sanitizeBasePath(basePath);
    }

    public CorsHeaders getCorsHeaders() {
        return this.corsHeaders;
    }

    public void setCorsHeaders(CorsHeaders corsHeaders) {
        this.corsHeaders = corsHeaders;
        if (this.corsHeaders == null || !this.corsHeaders.isAvailable()) {
            return;
        }
        if (this.corsHeaders.getAllowOrigins() == null) {
            this.corsHeaders.setAllowOrigins(Stream.of("*").collect(Collectors.toList()));
        }
        if (this.corsHeaders.getAllowMethods() == null) {
            this.corsHeaders.setAllowMethods(Stream.of("*").collect(Collectors.toList()));
        }
    }

    public void setIntrospectionPayload(byte[] introspectionPayload) {
        if (this.introspectionPayload.length == 0) {
            this.introspectionPayload = (byte[])introspectionPayload.clone();
        }
    }

    public byte[] getIntrospectionPayload() {
        return (byte[])this.introspectionPayload.clone();
    }

    @Override
    public URITemplate<Resource, HttpCarbonMessage> getUriTemplate() throws URITemplateException {
        if (this.uriTemplate == null) {
            this.uriTemplate = new URITemplate<Resource, HttpCarbonMessage>(new Literal<Resource, HttpCarbonMessage>(new ResourceDataElement(), "/"));
        }
        return this.uriTemplate;
    }

    public static HttpService buildHttpService(BObject service, String basePath) {
        HttpService httpService = new HttpService(service, basePath);
        BMap serviceConfig = HttpService.getHttpServiceConfigAnnotation(service);
        httpService.populateIntrospectionPayload();
        httpService.populateServiceConfig(serviceConfig);
        return httpService;
    }

    protected void populateServiceConfig(BMap serviceConfig) {
        if (HttpUtil.checkConfigAnnotationAvailability(serviceConfig)) {
            this.setCompressionConfig((BMap<BString, Object>)((BMap)serviceConfig.get((Object)HttpConstants.ANN_CONFIG_ATTR_COMPRESSION)));
            this.setChunkingConfig(serviceConfig.get((Object)HttpConstants.ANN_CONFIG_ATTR_CHUNKING).toString());
            this.setCorsHeaders(CorsHeaders.buildCorsHeaders(serviceConfig.getMapValue(CORS_FIELD)));
            this.setHostName(serviceConfig.getStringValue(HOST_FIELD).getValue().trim());
            this.setIntrospectionPayload(serviceConfig.getArrayValue(OPENAPI_DEF_FIELD).getByteArray());
            if (serviceConfig.containsKey((Object)MEDIA_TYPE_SUBTYPE_PREFIX)) {
                this.setMediaTypeSubtypePrefix(serviceConfig.getStringValue(MEDIA_TYPE_SUBTYPE_PREFIX).getValue().trim());
            }
            this.setTreatNilableAsOptional(serviceConfig.getBooleanValue(TREAT_NILABLE_AS_OPTIONAL));
            this.setConstraintValidation(serviceConfig.getBooleanValue(DATA_VALIDATION));
            this.setLaxDataBinding(serviceConfig.getBooleanValue(LAX_DATA_BINDING));
        } else {
            this.setHostName("b7a.default");
        }
        HttpService.processResources(this);
        this.setAllAllowedMethods(DispatcherUtil.getAllResourceMethods(this));
    }

    protected static void processResources(HttpService httpService) {
        ArrayList<HttpResource> httpResources = new ArrayList<HttpResource>();
        for (ResourceMethodType resource : httpService.getResourceMethods()) {
            if (!SymbolFlags.isFlagOn((long)resource.getFlags(), (long)131072L)) continue;
            HttpService.updateResourceTree(httpService, httpResources, HttpResource.buildHttpResource((MethodType)resource, httpService));
        }
        byte[] introspectionPayload = httpService.getIntrospectionPayload();
        if (introspectionPayload.length > 0) {
            HttpService.updateResourceTree(httpService, httpResources, new HttpIntrospectionResource(httpService, introspectionPayload));
            HttpService.updateResourceTree(httpService, httpResources, new HttpSwaggerUiResource(httpService, introspectionPayload));
        } else {
            log.debug("OpenAPI definition is not available");
        }
        HttpService.processLinks(httpService, httpResources);
        httpService.setResources(httpResources);
    }

    protected ResourceMethodType[] getResourceMethods() {
        return ((ServiceType)TypeUtils.getType((Object)this.balService)).getResourceMethods();
    }

    private static void processLinks(HttpService httpService, List<HttpResource> httpResources) {
        for (HttpResource targetResource : httpResources) {
            for (HttpResource.LinkedResourceInfo link : targetResource.getLinkedResources()) {
                HttpResource linkedResource = null;
                for (HttpResource resource : httpResources) {
                    linkedResource = HttpService.getLinkedResource(link, linkedResource, resource);
                }
                if (Objects.nonNull(linkedResource)) {
                    HttpService.setLinkToResource(httpService, targetResource, link, linkedResource);
                    continue;
                }
                String msg = "cannot find" + (String)(link.getMethod() != null ? " " + link.getMethod() : "") + " resource with resource link name: '" + link.getName() + "'";
                throw HttpUtil.createHttpError("resource link generation failed: " + msg, HttpErrorType.GENERIC_LISTENER_ERROR);
            }
        }
    }

    private static HttpResource getLinkedResource(HttpResource.LinkedResourceInfo link, HttpResource linkedResource, HttpResource resource) {
        if (Objects.nonNull(resource.getResourceLinkName()) && resource.getResourceLinkName().equalsIgnoreCase(link.getName())) {
            if (Objects.nonNull(link.getMethod())) {
                if (Objects.isNull(resource.getMethods())) {
                    if (Objects.isNull(linkedResource)) {
                        linkedResource = resource;
                    }
                } else if (resource.getMethods().contains(link.getMethod())) {
                    linkedResource = resource;
                }
            } else if (Objects.isNull(linkedResource)) {
                linkedResource = resource;
            } else {
                throw HttpUtil.createHttpError("resource link generation failed: cannot resolve resource link name: '" + link.getName() + "' since multiple occurrences found", HttpErrorType.GENERIC_LISTENER_ERROR);
            }
        }
        return linkedResource;
    }

    private static void validateResourceName(HttpResource targetResource, List<HttpResource> resources) {
        if (Objects.isNull(targetResource.getResourceLinkName())) {
            return;
        }
        for (HttpResource resource : resources) {
            if (Objects.isNull(resource.getResourceLinkName()) || !targetResource.getResourceLinkName().equalsIgnoreCase(resource.getResourceLinkName()) || targetResource.getResourcePathSignature().equals(resource.getResourcePathSignature())) continue;
            throw HttpUtil.createHttpError("resource link generation failed: cannot duplicate resource link name: '" + targetResource.getResourceLinkName() + "' unless they have the same path", HttpErrorType.GENERIC_LISTENER_ERROR);
        }
    }

    private static void setLinkToResource(HttpService httpService, HttpResource targetResource, HttpResource.LinkedResourceInfo link, HttpResource linkedResource) {
        BMap<BString, Object> linkMap = ValueCreatorUtils.createHTTPRecordValue("Link");
        BString relation = StringUtils.fromString((String)link.getRelationship());
        if (targetResource.hasLinkedRelation(relation)) {
            throw HttpUtil.createHttpError("resource link generation failed: cannot duplicate resource link relation: '" + relation.getValue() + "'", HttpErrorType.GENERIC_LISTENER_ERROR);
        }
        targetResource.addLinkedRelation(relation);
        BString href = StringUtils.fromString((String)linkedResource.getAbsoluteResourcePath());
        linkMap.put((Object)HttpConstants.LINK_HREF, (Object)href);
        BArray methods = HttpService.getMethodsBArray(linkedResource.getMethods());
        linkMap.put((Object)HttpConstants.LINK_METHODS, (Object)methods);
        Set<String> returnMediaTypes = linkedResource.getLinkReturnMediaTypes();
        BArray types = ValueCreator.createArrayValue((ArrayType)TypeCreator.createArrayType((Type)PredefinedTypes.TYPE_STRING));
        for (String returnMediaType : returnMediaTypes) {
            String specificReturnMediaType;
            if (!Objects.nonNull(returnMediaType)) continue;
            if (Objects.nonNull(httpService.getMediaTypeSubtypePrefix()) && Objects.nonNull(specificReturnMediaType = HttpUtil.getMediaTypeWithPrefix(httpService.getMediaTypeSubtypePrefix(), returnMediaType))) {
                returnMediaType = specificReturnMediaType;
            }
            types.append((Object)StringUtils.fromString((String)returnMediaType));
        }
        if (!types.isEmpty()) {
            linkMap.put((Object)HttpConstants.LINK_TYPES, (Object)types);
        }
        targetResource.addLink(relation, linkMap);
    }

    private static BArray getMethodsBArray(List<String> methods) {
        if (Objects.isNull(methods)) {
            methods = Arrays.asList("GET", "POST", "PUT", "PATCH", "DELETE", "OPTIONS", "HEAD");
        }
        List methodsAsBString = methods.stream().map(StringUtils::fromString).collect(Collectors.toList());
        return ValueCreator.createArrayValue((BString[])((BString[])methodsAsBString.toArray(BString[]::new)));
    }

    private static void updateResourceTree(HttpService httpService, List<HttpResource> httpResources, HttpResource httpResource) {
        try {
            httpService.getUriTemplate().parse(httpResource.getPath(), httpResource, new ResourceElementFactory());
        }
        catch (URITemplateException | UnsupportedEncodingException e) {
            throw new BallerinaConnectorException(e.getMessage());
        }
        httpResource.setTreatNilableAsOptional(httpService.isTreatNilableAsOptional());
        HttpService.validateResourceName(httpResource, httpResources);
        httpResources.add(httpResource);
    }

    public static BMap getHttpServiceConfigAnnotation(BObject service) {
        return HttpService.getServiceConfigAnnotation(service, ModuleUtils.getHttpPackageIdentifier(), "ServiceConfig");
    }

    protected static BMap getServiceConfigAnnotation(BObject service, String packagePath, String annotationName) {
        String key = packagePath.replaceAll("(?<!(http:|https:))//", "/");
        return (BMap)((ObjectType)TypeUtils.getReferredType((Type)TypeUtils.getType((Object)service))).getAnnotation(StringUtils.fromString((String)(key + ":" + annotationName)));
    }

    private static Optional<String> getOpenApiDocFileName(BObject service) {
        BMap openApiDocMap = (BMap)((ObjectType)TypeUtils.getReferredType((Type)TypeUtils.getType((Object)service))).getAnnotation(StringUtils.fromString((String)"ballerina/lang.annotations:0:IntrospectionDocConfig"));
        if (Objects.isNull(openApiDocMap)) {
            return Optional.empty();
        }
        BString name = openApiDocMap.getStringValue(StringUtils.fromString((String)"name"));
        return Objects.isNull(name) ? Optional.empty() : Optional.of(name.getValue());
    }

    protected void populateIntrospectionPayload() {
        Optional<String> openApiFileNameOpt = HttpService.getOpenApiDocFileName(this.balService);
        if (openApiFileNameOpt.isEmpty()) {
            return;
        }
        String openApiFileName = openApiFileNameOpt.get();
        String openApiDocPath = String.format("resources/openapi_%s.json", openApiFileName.startsWith("-") ? "0" + openApiFileName.substring(1) : openApiFileName);
        try (InputStream is = HttpService.class.getClassLoader().getResourceAsStream(openApiDocPath);){
            if (Objects.isNull(is)) {
                log.debug("OpenAPI definition is not available in the resources");
                return;
            }
            this.setIntrospectionPayload(is.readAllBytes());
        }
        catch (IOException e) {
            log.debug("Error while loading OpenAPI definition from resources", (Throwable)e);
        }
    }

    @Override
    public String getOasResourceLink() {
        if (this.oasResourceLinks.isEmpty()) {
            return null;
        }
        return String.join((CharSequence)", ", this.oasResourceLinks);
    }

    protected void addOasResourceLink(String oasResourcePath) {
        this.oasResourceLinks.add(oasResourcePath);
    }

    public void setInterceptorServicesRegistries(List<HTTPInterceptorServicesRegistry> interceptorServicesRegistries) {
        this.interceptorServicesRegistries = interceptorServicesRegistries;
    }

    public List<HTTPInterceptorServicesRegistry> getInterceptorServicesRegistries() {
        return this.interceptorServicesRegistries;
    }

    public void setBalInterceptorServicesArray(BArray interceptorServicesArray) {
        this.balInterceptorServicesArray = interceptorServicesArray;
    }

    public BArray getBalInterceptorServicesArray() {
        return this.balInterceptorServicesArray;
    }

    public static void populateInterceptorServicesRegistries(List<HTTPInterceptorServicesRegistry> listenerLevelInterceptors, BArray interceptorsArrayFromListener, HttpService service, Runtime runtime) {
        BArray interceptorsArrayFromService;
        ArrayList<HTTPInterceptorServicesRegistry> interceptorServicesRegistries = new ArrayList<HTTPInterceptorServicesRegistry>();
        for (HTTPInterceptorServicesRegistry servicesRegistry : listenerLevelInterceptors) {
            interceptorServicesRegistries.add(servicesRegistry);
        }
        ServiceType balServiceType = (ServiceType)service.getBalService().getOriginalType();
        boolean includesInterceptableService = balServiceType.getTypeIdSet().getIds().stream().anyMatch(typeId -> typeId.getName().equals("InterceptableService"));
        if (includesInterceptableService) {
            Object[] createdInterceptors = new Object[1];
            try {
                Object response = runtime.callMethod(service.getBalService(), "createInterceptors", null, new Object[0]);
                if (response instanceof BError) {
                    log.error("Error occurred while creating interceptors", response);
                } else {
                    createdInterceptors[0] = response;
                }
            }
            catch (BError bError) {
                bError.printStackTrace();
                System.exit(1);
            }
            if (Objects.isNull(createdInterceptors[0]) || createdInterceptors[0] instanceof BArray && ((BArray)createdInterceptors[0]).size() == 0) {
                service.setInterceptorServicesRegistries(interceptorServicesRegistries);
                service.setBalInterceptorServicesArray(interceptorsArrayFromListener);
                return;
            }
            interceptorsArrayFromService = createdInterceptors[0] instanceof BArray ? (BArray)createdInterceptors[0] : ValueCreator.createArrayValue((Object[])createdInterceptors, (ArrayType)TypeCreator.createArrayType((Type)((BObject)createdInterceptors[0]).getOriginalType()));
        } else {
            service.setInterceptorServicesRegistries(interceptorServicesRegistries);
            service.setBalInterceptorServicesArray(interceptorsArrayFromListener);
            return;
        }
        Object[] interceptors = interceptorsArrayFromService.getValues();
        ArrayList<Object> interceptorServices = new ArrayList<Object>();
        for (Object interceptor : interceptors) {
            if (Objects.isNull(interceptor)) break;
            interceptorServices.add(interceptor);
        }
        for (int i = 0; i < interceptorServices.size(); ++i) {
            BObject interceptorService = (BObject)interceptorServices.get(i);
            HTTPInterceptorServicesRegistry servicesRegistry = new HTTPInterceptorServicesRegistry();
            servicesRegistry.setServicesType(HttpUtil.getInterceptorServiceType(interceptorService));
            servicesRegistry.registerInterceptorService(interceptorService, service.getBasePath(), false);
            servicesRegistry.setRuntime(runtime);
            interceptorServicesRegistries.add(servicesRegistry);
        }
        service.setInterceptorServicesRegistries(interceptorServicesRegistries);
        HttpService.populateBalInterceptorServicesArray(service, interceptorsArrayFromListener, interceptorsArrayFromService);
    }

    private static void populateBalInterceptorServicesArray(HttpService service, BArray fromListener, BArray fromService) {
        if (Objects.isNull(fromListener)) {
            service.setBalInterceptorServicesArray(fromService);
        } else {
            BArray interceptorsArray = ValueCreator.createArrayValue((ArrayType)((ArrayType)fromListener.getType()));
            for (Object interceptor : fromListener.getValues()) {
                if (Objects.isNull(interceptor)) break;
                interceptorsArray.append(interceptor);
            }
            for (Object interceptor : fromService.getValues()) {
                if (Objects.isNull(interceptor)) break;
                interceptorsArray.append(interceptor);
            }
            service.setBalInterceptorServicesArray(interceptorsArray);
        }
    }

    public boolean hasInterceptors() {
        return Objects.nonNull(this.getInterceptorServicesRegistries()) && !this.getInterceptorServicesRegistries().isEmpty();
    }

    public boolean getConstraintValidation() {
        return this.constraintValidation;
    }

    protected void setConstraintValidation(boolean constraintValidation) {
        this.constraintValidation = constraintValidation;
    }

    public boolean getLaxDataBinding() {
        return this.laxDataBinding;
    }

    protected void setLaxDataBinding(boolean laxDataBinding) {
        this.laxDataBinding = laxDataBinding;
    }
}

