/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api;

import io.ballerina.runtime.api.types.AnnotatableType;
import io.ballerina.runtime.api.types.ReferenceType;
import io.ballerina.runtime.api.types.ResourceMethodType;
import io.ballerina.runtime.api.types.ServiceType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.stdlib.http.api.HttpConstants;
import io.ballerina.stdlib.http.api.HttpService;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.api.nativeimpl.ModuleUtils;
import java.util.Objects;

public class HttpServiceFromContract
extends HttpService {
    private final ReferenceType serviceContractType;

    protected HttpServiceFromContract(BObject service, String basePath, ReferenceType httpServiceContractType) {
        super(service, basePath);
        this.serviceContractType = httpServiceContractType;
    }

    public static HttpService buildHttpService(BObject service, String basePath, ReferenceType serviceContractType) {
        HttpServiceFromContract httpService = new HttpServiceFromContract(service, basePath, serviceContractType);
        httpService.populateIntrospectionPayload();
        BMap serviceConfig = HttpServiceFromContract.getHttpServiceConfigAnnotation(serviceContractType);
        ((HttpService)httpService).populateServiceConfig(serviceConfig);
        return httpService;
    }

    @Override
    protected void populateServiceConfig(BMap serviceConfig) {
        Object basePathFromAnnotation;
        if (HttpUtil.checkConfigAnnotationAvailability(serviceConfig) && Objects.nonNull(basePathFromAnnotation = serviceConfig.get((Object)HttpConstants.ANN_CONFIG_BASE_PATH))) {
            this.setBasePath(basePathFromAnnotation.toString());
        }
        super.populateServiceConfig(serviceConfig);
    }

    public static BMap getHttpServiceConfigAnnotation(ReferenceType serviceContractType) {
        String packagePath = ModuleUtils.getHttpPackageIdentifier();
        String annotationName = "ServiceConfig";
        String key = packagePath.replaceAll("(?<!(http:|https:))//", "/");
        if (!(serviceContractType instanceof AnnotatableType)) {
            return null;
        }
        AnnotatableType annotatableServiceContractType = (AnnotatableType)serviceContractType;
        return (BMap)annotatableServiceContractType.getAnnotation(StringUtils.fromString((String)(key + ":" + annotationName)));
    }

    @Override
    protected ResourceMethodType[] getResourceMethods() {
        return ((ServiceType)TypeUtils.getReferredType((Type)this.serviceContractType)).getResourceMethods();
    }
}

