/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api.client.actions;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.api.client.actions.AbstractHTTPAction;
import io.ballerina.stdlib.http.api.nativeimpl.ExternUtils;
import io.ballerina.stdlib.http.transport.contract.HttpClientConnector;
import io.ballerina.stdlib.http.transport.contract.HttpClientConnectorListener;
import io.ballerina.stdlib.http.transport.message.ResponseHandle;
import java.util.concurrent.CompletableFuture;

public class HasPromise
extends AbstractHTTPAction {
    public static boolean hasPromise(Environment env, BObject clientObj, BObject handleObj) {
        ResponseHandle responseHandle = (ResponseHandle)handleObj.getNativeData("transport_handle");
        if (responseHandle == null) {
            throw HttpUtil.createHttpError("invalid http handle");
        }
        HttpClientConnector clientConnector = (HttpClientConnector)clientObj.getNativeData("Client");
        return (Boolean)env.yieldAndRun(() -> {
            CompletableFuture<Object> balFuture = new CompletableFuture<Object>();
            clientConnector.hasPushPromise(responseHandle).setPromiseAvailabilityListener(new PromiseAvailabilityCheckListener(balFuture));
            return ExternUtils.getResult(balFuture);
        });
    }

    private HasPromise() {
    }

    private static class PromiseAvailabilityCheckListener
    implements HttpClientConnectorListener {
        private final CompletableFuture<Object> balFuture;

        PromiseAvailabilityCheckListener(CompletableFuture<Object> balFuture) {
            this.balFuture = balFuture;
        }

        @Override
        public void onPushPromiseAvailability(boolean isPromiseAvailable) {
            this.balFuture.complete(isPromiseAvailable);
        }
    }
}

