/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api.service.signature.converter;

import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.http.api.HttpErrorType;
import io.ballerina.stdlib.http.api.HttpUtil;
import java.nio.charset.StandardCharsets;

public class StringToByteArrayConverter {
    public static Object convert(ArrayType type, BString dataSource, boolean readonly) {
        Type elementType = type.getElementType();
        if (elementType.getTag() == 2) {
            byte[] values = dataSource.getValue().getBytes(StandardCharsets.UTF_8);
            return readonly ? ValueCreator.createReadonlyArrayValue((byte[])values) : ValueCreator.createArrayValue((byte[])values);
        }
        String message = "incompatible array element type found: '" + elementType.toString() + "'";
        throw HttpUtil.createHttpStatusCodeError(HttpErrorType.INTERNAL_PAYLOAD_BINDING_LISTENER_ERROR, message);
    }

    private StringToByteArrayConverter() {
    }
}

