/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.contractimpl;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpClientUpgradeHandler;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.ReferenceCountUtil;
import java.util.List;

public class DefaultHttpClientUpgradeHandler
extends HttpClientUpgradeHandler {
    private boolean continueResponse;

    public DefaultHttpClientUpgradeHandler(HttpClientUpgradeHandler.SourceCodec sourceCodec, HttpClientUpgradeHandler.UpgradeCodec upgradeCodec, int maxContentLength) {
        super(sourceCodec, upgradeCodec, maxContentLength);
    }

    protected void decode(ChannelHandlerContext ctx, HttpObject msg, List<Object> out) throws Exception {
        if (this.continueResponse && msg instanceof LastHttpContent) {
            ReferenceCountUtil.release((Object)msg);
            return;
        }
        if (msg instanceof HttpResponse && HttpResponseStatus.CONTINUE.equals((Object)((HttpResponse)msg).status())) {
            this.continueResponse = true;
            ctx.fireChannelRead((Object)msg);
            return;
        }
        this.continueResponse = false;
        super.decode(ctx, msg, out);
    }
}

