/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.contractimpl.listener.http2;

import io.ballerina.stdlib.http.transport.contract.ServerConnectorFuture;
import io.ballerina.stdlib.http.transport.contractimpl.common.Util;
import io.ballerina.stdlib.http.transport.contractimpl.listener.HttpServerChannelInitializer;
import io.ballerina.stdlib.http.transport.contractimpl.listener.http2.Http2SourceConnectionHandlerBuilder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.group.ChannelGroup;
import io.netty.handler.codec.http2.Http2CodecUtil;

public class Http2WithPriorKnowledgeHandler
extends ChannelInboundHandlerAdapter {
    private String interfaceId;
    private String serverName;
    private ServerConnectorFuture serverConnectorFuture;
    private HttpServerChannelInitializer serverChannelInitializer;
    private ChannelGroup allChannels;
    private ChannelGroup listenerChannels;
    private long maxHeaderListSize;
    private int initialWindowSize;

    public Http2WithPriorKnowledgeHandler(String interfaceId, String serverName, ServerConnectorFuture serverConnectorFuture, HttpServerChannelInitializer serverChannelInitializer, ChannelGroup allChannels, ChannelGroup listenerChannels, long maxHeaderListSize, int initialWindowSize) {
        this.interfaceId = interfaceId;
        this.serverName = serverName;
        this.serverConnectorFuture = serverConnectorFuture;
        this.serverChannelInitializer = serverChannelInitializer;
        this.allChannels = allChannels;
        this.listenerChannels = listenerChannels;
        this.maxHeaderListSize = maxHeaderListSize;
        this.initialWindowSize = initialWindowSize;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof ByteBuf) {
            ByteBuf inputData = (ByteBuf)msg;
            ByteBuf clientPrefaceString = Http2CodecUtil.connectionPrefaceBuf();
            int bytesRead = Math.min(inputData.readableBytes(), clientPrefaceString.readableBytes());
            ChannelPipeline pipeline = ctx.pipeline();
            if (ByteBufUtil.equals((ByteBuf)inputData, (int)inputData.readerIndex(), (ByteBuf)clientPrefaceString, (int)clientPrefaceString.readerIndex(), (int)bytesRead)) {
                Util.safelyRemoveHandlers(pipeline, "ServerCodec");
                pipeline.addBefore("Http2UpgradeHandler", "Http2SourceConnectionHandler", (ChannelHandler)new Http2SourceConnectionHandlerBuilder(this.interfaceId, this.serverConnectorFuture, this.serverName, this.serverChannelInitializer, this.allChannels, this.listenerChannels, this.maxHeaderListSize, this.initialWindowSize).build());
                Util.safelyRemoveHandlers(pipeline, "Http2UpgradeHandler", "compressor", "http-trace-logger");
            }
            pipeline.remove((ChannelHandler)this);
            ctx.fireChannelRead(msg);
        }
    }
}

