/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.contractimpl.sender.channel;

import io.ballerina.stdlib.http.transport.contract.config.SenderConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootstrapConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(BootstrapConfiguration.class);
    private final boolean tcpNoDelay;
    private final boolean keepAlive;
    private final boolean socketReuse;
    private final int connectTimeOut;
    private final int receiveBufferSize;
    private final int sendBufferSize;

    public BootstrapConfiguration(SenderConfiguration senderConfiguration) {
        this.connectTimeOut = senderConfiguration.getConnectTimeOut();
        this.receiveBufferSize = senderConfiguration.getReceiveBufferSize();
        this.sendBufferSize = senderConfiguration.getSendBufferSize();
        this.tcpNoDelay = senderConfiguration.isTcpNoDelay();
        this.socketReuse = senderConfiguration.isSocketReuse();
        this.keepAlive = senderConfiguration.isSocketKeepAlive();
        String logValue = "{}:{}";
        LOG.debug(logValue, (Object)"client.bootstrap.nodelay", (Object)this.tcpNoDelay);
        LOG.debug(logValue, (Object)"client.bootstrap.connect.timeout", (Object)this.connectTimeOut);
        LOG.debug(logValue, (Object)"client.bootstrap.recievebuffersize", (Object)this.receiveBufferSize);
        LOG.debug(logValue, (Object)"client.bootstrap.sendbuffersize", (Object)this.sendBufferSize);
        LOG.debug(logValue, (Object)"client.bootstrap.keepalive", (Object)this.keepAlive);
        LOG.debug(logValue, (Object)"client.bootstrap.socket.reuse", (Object)this.socketReuse);
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public int getConnectTimeOut() {
        return this.connectTimeOut;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public boolean isSocketReuse() {
        return this.socketReuse;
    }
}

