/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.message;

import io.ballerina.stdlib.http.transport.contract.HttpResponseFuture;
import io.ballerina.stdlib.http.transport.contract.ServerConnectorFuture;
import io.ballerina.stdlib.http.transport.contract.exceptions.ServerConnectorException;
import io.ballerina.stdlib.http.transport.contractimpl.DefaultHttpResponseFuture;
import io.ballerina.stdlib.http.transport.contractimpl.HttpWsServerConnectorFuture;
import io.ballerina.stdlib.http.transport.contractimpl.common.states.Http2MessageStateContext;
import io.ballerina.stdlib.http.transport.contractimpl.listener.states.ListenerReqRespStateManager;
import io.ballerina.stdlib.http.transport.message.BlockingEntityCollector;
import io.ballerina.stdlib.http.transport.message.DefaultFullHttpMessageFuture;
import io.ballerina.stdlib.http.transport.message.DefaultObservable;
import io.ballerina.stdlib.http.transport.message.EntityCollector;
import io.ballerina.stdlib.http.transport.message.FullHttpMessageFuture;
import io.ballerina.stdlib.http.transport.message.Http2PushPromise;
import io.ballerina.stdlib.http.transport.message.HttpPipeliningFuture;
import io.ballerina.stdlib.http.transport.message.Listener;
import io.ballerina.stdlib.http.transport.message.MessageFuture;
import io.ballerina.stdlib.http.transport.message.Observable;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class HttpCarbonMessage {
    protected HttpMessage httpMessage;
    private EntityCollector blockingEntityCollector;
    private final Map<String, Object> properties = new HashMap<String, Object>(64);
    private MessageFuture messageFuture;
    private final ServerConnectorFuture httpOutboundRespFuture = new HttpWsServerConnectorFuture();
    private final DefaultHttpResponseFuture httpOutboundRespStatusFuture = new DefaultHttpResponseFuture();
    private final Observable contentObservable = new DefaultObservable();
    private final HttpHeaders httpTrailerHeaders = new DefaultLastHttpContent().trailingHeaders();
    private IOException ioException;
    public ListenerReqRespStateManager listenerReqRespStateManager;
    private Http2MessageStateContext http2MessageStateContext;
    private FullHttpMessageFuture fullHttpMessageFuture;
    private long sequenceId;
    private ChannelHandlerContext sourceContext;
    private ChannelHandlerContext targetContext;
    private HttpPipeliningFuture pipeliningFuture;
    private boolean keepAlive;
    private boolean pipeliningEnabled;
    private boolean passthrough = false;
    private boolean lastHttpContentArrived = false;
    private String httpVersion;
    private String httpMethod;
    private String requestUrl;
    private Integer httpStatusCode;
    private Integer contentSize = 0;
    private boolean contentReleased = false;
    private final ReentrantLock messageLock = new ReentrantLock();

    public HttpCarbonMessage(HttpMessage httpMessage, Listener contentListener) {
        this.httpMessage = httpMessage;
        this.setBlockingEntityCollector(new BlockingEntityCollector(300000));
        this.contentObservable.setListener(contentListener);
    }

    public HttpCarbonMessage(HttpMessage httpMessage, int maxWaitTime, Listener contentListener) {
        this.httpMessage = httpMessage;
        this.setBlockingEntityCollector(new BlockingEntityCollector(maxWaitTime));
        this.contentObservable.setListener(contentListener);
    }

    public HttpCarbonMessage(HttpMessage httpMessage) {
        this.httpMessage = httpMessage;
        this.setBlockingEntityCollector(new BlockingEntityCollector(300000));
    }

    public void addHttpContent(HttpContent httpContent) {
        this.messageLock.lock();
        try {
            this.contentObservable.notifyAddListener(httpContent);
            if (this.messageFuture != null) {
                if (this.ioException != null) {
                    this.blockingEntityCollector.addHttpContent((HttpContent)new DefaultLastHttpContent());
                    this.messageFuture.notifyMessageListener(this.blockingEntityCollector.getHttpContent());
                    this.removeMessageFuture();
                    throw new RuntimeException(this.getIoException());
                }
                this.blockingEntityCollector.addHttpContent(httpContent);
                if (this.messageFuture.isMessageListenerSet()) {
                    this.messageFuture.notifyMessageListener(this.blockingEntityCollector.getHttpContent());
                    this.contentObservable.notifyGetListener(httpContent);
                }
                if (httpContent instanceof LastHttpContent) {
                    this.removeMessageFuture();
                }
            } else {
                if (this.ioException != null) {
                    this.blockingEntityCollector.addHttpContent((HttpContent)new DefaultLastHttpContent());
                    throw new RuntimeException(this.getIoException());
                }
                this.blockingEntityCollector.addHttpContent(httpContent);
            }
        }
        finally {
            this.messageLock.unlock();
        }
    }

    public HttpContent getHttpContent() {
        HttpContent httpContent = this.blockingEntityCollector.getHttpContent();
        this.contentObservable.notifyGetListener(httpContent);
        if (httpContent != null) {
            this.contentSize = this.contentSize + httpContent.content().readableBytes();
        }
        return httpContent;
    }

    public MessageFuture getHttpContentAsync() {
        this.messageLock.lock();
        try {
            MessageFuture messageFuture = this.messageFuture = new MessageFuture(this);
            return messageFuture;
        }
        finally {
            this.messageLock.unlock();
        }
    }

    @Deprecated
    public ByteBuf getMessageBody() {
        return this.blockingEntityCollector.getMessageBody();
    }

    public boolean isEmpty() {
        return this.blockingEntityCollector.isEmpty();
    }

    public long countMessageLengthTill(long maxLength) throws IllegalStateException {
        return this.blockingEntityCollector.countMessageLengthTill(maxLength);
    }

    @Deprecated
    public long getFullMessageLength() {
        return this.blockingEntityCollector.getFullMessageLength();
    }

    @Deprecated
    public void addMessageBody(ByteBuffer msgBody) {
        this.blockingEntityCollector.addMessageBody(msgBody);
    }

    public void completeMessage() {
        this.blockingEntityCollector.completeMessage();
    }

    public HttpHeaders getHeaders() {
        return this.httpMessage.headers();
    }

    public String getHeader(String key) {
        return this.httpMessage.headers().get(key);
    }

    public void setHeader(String key, String value) {
        this.httpMessage.headers().set(key, (Object)value);
    }

    public void setHeader(String key, Object value) {
        this.httpMessage.headers().set(key, value);
    }

    public void setHeaders(HttpHeaders httpHeaders) {
        this.httpMessage.headers().setAll(httpHeaders);
    }

    public void addHeader(String key, String value) {
        this.httpMessage.headers().add(key, (Object)value);
    }

    public void addHeader(String key, Object value) {
        this.httpMessage.headers().add(key, value);
    }

    public void addHeaders(HttpHeaders httpHeaders) {
        this.httpMessage.headers().add(httpHeaders);
    }

    public void removeHeader(String key) {
        this.httpMessage.headers().remove(key);
    }

    public HttpHeaders getTrailerHeaders() {
        return this.httpTrailerHeaders;
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public void removeMessageFuture() {
        this.messageLock.lock();
        try {
            this.messageFuture = null;
            this.passthrough = false;
        }
        finally {
            this.messageLock.unlock();
        }
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public void removeProperty(String key) {
        this.properties.remove(key);
    }

    public String getHttpVersion() {
        return this.httpVersion;
    }

    public void setHttpVersion(String httpVersion) {
        this.httpVersion = httpVersion;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public String getRequestUrl() {
        return this.requestUrl;
    }

    public void setRequestUrl(String requestUrl) {
        this.requestUrl = requestUrl;
    }

    public Integer getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public void setHttpStatusCode(Integer httpStatusCode) {
        this.httpStatusCode = httpStatusCode;
    }

    public String getReasonPhrase() {
        if (this.httpMessage instanceof DefaultHttpResponse) {
            return ((DefaultHttpResponse)this.httpMessage).status().reasonPhrase();
        }
        return "Unknown Status";
    }

    private void setBlockingEntityCollector(BlockingEntityCollector blockingEntityCollector) {
        this.blockingEntityCollector = blockingEntityCollector;
    }

    public ServerConnectorFuture getHttpResponseFuture() {
        return this.httpOutboundRespFuture;
    }

    public HttpResponseFuture getHttpOutboundRespStatusFuture() {
        return this.httpOutboundRespStatusFuture;
    }

    public HttpResponseFuture respond(HttpCarbonMessage httpCarbonMessage) throws ServerConnectorException {
        this.httpOutboundRespFuture.notifyHttpListener(httpCarbonMessage);
        return this.httpOutboundRespStatusFuture;
    }

    public HttpResponseFuture pushResponse(HttpCarbonMessage httpCarbonMessage, Http2PushPromise pushPromise) throws ServerConnectorException {
        this.httpOutboundRespFuture.notifyHttpListener(httpCarbonMessage, pushPromise);
        return this.httpOutboundRespStatusFuture;
    }

    public HttpResponseFuture pushPromise(Http2PushPromise pushPromise) throws ServerConnectorException {
        this.httpOutboundRespFuture.notifyHttpListener(pushPromise);
        return this.httpOutboundRespStatusFuture;
    }

    public HttpCarbonMessage cloneCarbonMessageWithOutData() {
        HttpCarbonMessage newCarbonMessage = this.getNewHttpCarbonMessage();
        Map<String, Object> propertiesMap = this.getProperties();
        propertiesMap.forEach(newCarbonMessage::setProperty);
        newCarbonMessage.setHttpStatusCode(this.getHttpStatusCode());
        newCarbonMessage.setHttpMethod(this.getHttpMethod());
        newCarbonMessage.setRequestUrl(this.getRequestUrl());
        newCarbonMessage.setHttpVersion(this.getHttpVersion());
        return newCarbonMessage;
    }

    private HttpCarbonMessage getNewHttpCarbonMessage() {
        DefaultHttpHeaders httpHeaders;
        DefaultFullHttpResponse newHttpMessage;
        if (this.httpMessage instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)this.httpMessage;
            newHttpMessage = new DefaultHttpRequest(this.httpMessage.protocolVersion(), ((HttpRequest)this.httpMessage).method(), httpRequest.uri());
            httpHeaders = new DefaultHttpHeaders();
            List headerList = this.httpMessage.headers().entries();
            for (Map.Entry entry : headerList) {
                httpHeaders.add((String)entry.getKey(), entry.getValue());
            }
        } else {
            HttpResponse httpResponse = (HttpResponse)this.httpMessage;
            newHttpMessage = new DefaultFullHttpResponse(this.httpMessage.protocolVersion(), httpResponse.status());
            httpHeaders = new DefaultHttpHeaders();
            List headerList = this.httpMessage.headers().entries();
            for (Map.Entry entry : headerList) {
                httpHeaders.add((String)entry.getKey(), entry.getValue());
            }
        }
        HttpCarbonMessage httpCarbonMessage = new HttpCarbonMessage((HttpMessage)newHttpMessage);
        httpCarbonMessage.getHeaders().set((HttpHeaders)httpHeaders);
        return httpCarbonMessage;
    }

    public void waitAndReleaseAllEntities() {
        this.blockingEntityCollector.waitAndReleaseAllEntities();
        this.setContentReleased(true);
    }

    public EntityCollector getBlockingEntityCollector() {
        return this.blockingEntityCollector;
    }

    public HttpRequest getNettyHttpRequest() {
        return (HttpRequest)this.httpMessage;
    }

    public HttpResponse getNettyHttpResponse() {
        return (HttpResponse)this.httpMessage;
    }

    public IOException getIoException() {
        return this.ioException;
    }

    public void setIoException(IOException ioException) {
        this.ioException = ioException;
    }

    public Http2MessageStateContext getHttp2MessageStateContext() {
        return this.http2MessageStateContext;
    }

    public void setHttp2MessageStateContext(Http2MessageStateContext http2MessageStateContext) {
        this.http2MessageStateContext = http2MessageStateContext;
    }

    public long getSequenceId() {
        return this.sequenceId;
    }

    public void setSequenceId(long sequenceId) {
        this.sequenceId = sequenceId;
    }

    public ChannelHandlerContext getSourceContext() {
        return this.sourceContext;
    }

    public void setSourceContext(ChannelHandlerContext sourceContext) {
        this.sourceContext = sourceContext;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public boolean isPipeliningEnabled() {
        return this.pipeliningEnabled;
    }

    public Integer getContentSize() {
        return this.contentSize;
    }

    public void setContentReleased(boolean contentReleased) {
        this.contentReleased = contentReleased;
    }

    public boolean isContentReleased() {
        return this.contentReleased;
    }

    public boolean is100ContinueExpected() {
        return HttpUtil.is100ContinueExpected((HttpMessage)this.httpMessage);
    }

    public void setPipeliningEnabled(boolean pipeliningEnabled) {
        this.pipeliningEnabled = pipeliningEnabled;
    }

    public HttpPipeliningFuture getPipeliningFuture() {
        return this.pipeliningFuture;
    }

    public void setPipeliningFuture(HttpPipeliningFuture pipeliningFuture) {
        this.pipeliningFuture = pipeliningFuture;
    }

    public void removeInboundContentListener() {
        this.contentObservable.notifyReadInterest();
        String httpVersion = this.getHttpVersion();
        if ("1.1".equalsIgnoreCase(httpVersion)) {
            this.contentObservable.removeListener();
        }
    }

    public boolean isPassthrough() {
        return this.passthrough;
    }

    public void setPassthrough(boolean passthrough) {
        this.passthrough = passthrough;
    }

    public void setTargetContext(ChannelHandlerContext targetContext) {
        this.targetContext = targetContext;
    }

    public ChannelHandlerContext getTargetContext() {
        return this.targetContext;
    }

    public FullHttpMessageFuture getFullHttpCarbonMessage() {
        this.messageLock.lock();
        try {
            this.removeInboundContentListener();
            FullHttpMessageFuture fullHttpMessageFuture = this.fullHttpMessageFuture = new DefaultFullHttpMessageFuture(this);
            return fullHttpMessageFuture;
        }
        finally {
            this.messageLock.unlock();
        }
    }

    public void setLastHttpContentArrived() {
        this.messageLock.lock();
        try {
            this.lastHttpContentArrived = true;
            if (this.fullHttpMessageFuture != null) {
                this.fullHttpMessageFuture.notifySuccess();
            }
        }
        finally {
            this.messageLock.unlock();
        }
    }

    public boolean isLastHttpContentArrived() {
        return this.lastHttpContentArrived;
    }

    public void notifyContentFailure(Exception exception) {
        this.messageLock.lock();
        try {
            if (this.fullHttpMessageFuture != null) {
                this.fullHttpMessageFuture.notifyFailure(exception);
            }
        }
        finally {
            this.messageLock.unlock();
        }
    }

    public boolean isAccessedInNonInterceptorService() {
        return this.getProperty("INTERCEPTOR_SERVICE") == null;
    }

    public boolean isInterceptorError() {
        return this.getProperty("INTERCEPTOR_SERVICE_ERROR") != null;
    }

    public boolean isInterceptorInternalError() {
        return this.getProperty("INTERNAL_ERROR") != null && this.getProperty("INTERCEPTOR_SERVICE_ERROR") != null;
    }

    public String getRequestInterceptorServiceState() {
        if (this.isInterceptorError()) {
            return "RequestErrorInterceptor";
        }
        return "RequestInterceptor";
    }

    public String getResponseInterceptorServiceState() {
        if (this.isInterceptorError()) {
            return "ResponseErrorInterceptor";
        }
        return "ResponseInterceptor";
    }

    public Listener getListener() {
        return this.contentObservable.getListener();
    }
}

