/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.oauth2;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BDecimal;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.crypto.nativeimpl.Decode;
import io.ballerina.stdlib.oauth2.ModuleUtils;
import io.ballerina.stdlib.oauth2.OAuth2Constants;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class OAuth2Client {
    private OAuth2Client() {
    }

    public static Object doHttpRequest(Environment env, BString url, BMap<BString, Object> clientConfig, BMap<BString, BString> headers, BString payload) {
        HttpRequest request;
        URI uri;
        int requestTimeout;
        int connectionTimeout;
        BString customPayload = OAuth2Client.getBStringValueIfPresent(clientConfig, OAuth2Constants.CUSTOM_PAYLOAD);
        Object textPayload = payload.getValue();
        if (customPayload != null) {
            textPayload = (String)textPayload + "&" + String.valueOf(customPayload);
        }
        ArrayList<String> headersList = new ArrayList<String>();
        for (Object entry : headers.entrySet()) {
            headersList.add(((BString)entry.getKey()).getValue());
            headersList.add(((BString)entry.getValue()).getValue());
        }
        BMap<BString, ?> customHeaders = OAuth2Client.getBMapValueIfPresent(clientConfig, OAuth2Constants.CUSTOM_HEADERS);
        if (customHeaders != null) {
            for (Map.Entry entry : customHeaders.entrySet()) {
                headersList.add(((BString)entry.getKey()).getValue());
                headersList.add(((BString)entry.getValue()).getValue());
            }
        }
        String httpVersion = OAuth2Client.getBStringValueIfPresent(clientConfig, OAuth2Constants.HTTP_VERSION).getValue();
        BMap<BString, ?> secureSocket = OAuth2Client.getBMapValueIfPresent(clientConfig, OAuth2Constants.SECURE_SOCKET);
        try {
            connectionTimeout = OAuth2Client.getConnectionTimeoutInMillis(clientConfig);
            requestTimeout = OAuth2Client.getRequestTimeoutInMillis(clientConfig);
        }
        catch (BError e) {
            return e;
        }
        try {
            uri = OAuth2Client.buildUri(url.getValue(), secureSocket);
        }
        catch (IllegalArgumentException e) {
            return OAuth2Client.createError("Failed to create URI for the provided value \"" + String.valueOf(url) + "\".");
        }
        if (headersList.isEmpty()) {
            request = OAuth2Client.buildHttpRequest(uri, (String)textPayload, requestTimeout);
        } else {
            String[] flatHeaders = (String[])headersList.toArray(String[]::new);
            request = OAuth2Client.buildHttpRequest(uri, flatHeaders, (String)textPayload, requestTimeout);
        }
        if (secureSocket != null) {
            try {
                SSLContext sslContext = OAuth2Client.getSslContext(secureSocket);
                HttpClient client = OAuth2Client.buildHttpClient(httpVersion, sslContext, connectionTimeout);
                return OAuth2Client.callEndpoint(env, client, request);
            }
            catch (Exception e) {
                return OAuth2Client.createError("Failed to init SSL context. " + e.getMessage());
            }
        }
        HttpClient client = OAuth2Client.buildHttpClient(httpVersion, connectionTimeout);
        return OAuth2Client.callEndpoint(env, client, request);
    }

    private static URI buildUri(String url, BMap<BString, ?> secureSocket) throws IllegalArgumentException {
        String[] urlParts = ((String)url).split("://", 2);
        if (urlParts.length == 1) {
            String[] stringArray;
            if (secureSocket != null) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "https";
                stringArray = stringArray2;
                stringArray2[1] = urlParts[0];
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = "http";
                stringArray = stringArray3;
                stringArray3[1] = urlParts[0];
            }
            urlParts = stringArray;
        } else if (urlParts[0].equals("http") && secureSocket != null) {
            System.err.println("warning: [ballerina/oauth2] HTTPS is recommended but using HTTP");
        }
        urlParts[1] = urlParts[1].replaceAll("//", "/");
        url = urlParts[0] + "://" + urlParts[1];
        return URI.create((String)url);
    }

    private static SSLContext getSslContext(BMap<BString, ?> secureSocket) throws Exception {
        boolean disable = secureSocket.getBooleanValue(OAuth2Constants.DISABLE);
        if (disable) {
            return OAuth2Client.initSslContext();
        }
        BMap<BString, ?> key = OAuth2Client.getBMapValueIfPresent(secureSocket, OAuth2Constants.KEY);
        Object cert = secureSocket.get((Object)OAuth2Constants.CERT);
        if (cert == null) {
            throw new Exception("Need to configure 'crypto:TrustStore' or 'cert' with client SSL certificates file.");
        }
        if (cert instanceof BString) {
            if (key != null) {
                KeyManagerFactory kmf;
                if (key.containsKey((Object)OAuth2Constants.CERT_FILE)) {
                    BString certFile = (BString)key.get((Object)OAuth2Constants.CERT_FILE);
                    BString keyFile = (BString)key.get((Object)OAuth2Constants.KEY_FILE);
                    BString keyPassword = OAuth2Client.getBStringValueIfPresent(key, OAuth2Constants.KEY_PASSWORD);
                    kmf = OAuth2Client.getKeyManagerFactory(certFile, keyFile, keyPassword);
                } else {
                    kmf = OAuth2Client.getKeyManagerFactory(key);
                }
                TrustManagerFactory tmf = OAuth2Client.getTrustManagerFactory((BString)cert);
                return OAuth2Client.buildSslContext(kmf.getKeyManagers(), tmf.getTrustManagers());
            }
            TrustManagerFactory tmf = OAuth2Client.getTrustManagerFactory((BString)cert);
            return OAuth2Client.buildSslContext(null, tmf.getTrustManagers());
        }
        if (cert instanceof BMap) {
            BMap trustStore = (BMap)cert;
            if (key != null) {
                KeyManagerFactory kmf;
                if (key.containsKey((Object)OAuth2Constants.CERT_FILE)) {
                    BString certFile = (BString)key.get((Object)OAuth2Constants.CERT_FILE);
                    BString keyFile = (BString)key.get((Object)OAuth2Constants.KEY_FILE);
                    BString keyPassword = OAuth2Client.getBStringValueIfPresent(key, OAuth2Constants.KEY_PASSWORD);
                    kmf = OAuth2Client.getKeyManagerFactory(certFile, keyFile, keyPassword);
                } else {
                    kmf = OAuth2Client.getKeyManagerFactory(key);
                }
                TrustManagerFactory tmf = OAuth2Client.getTrustManagerFactory((BMap<BString, BString>)trustStore);
                return OAuth2Client.buildSslContext(kmf.getKeyManagers(), tmf.getTrustManagers());
            }
            TrustManagerFactory tmf = OAuth2Client.getTrustManagerFactory((BMap<BString, BString>)trustStore);
            return OAuth2Client.buildSslContext(null, tmf.getTrustManagers());
        }
        return null;
    }

    private static HttpClient.Version getHttpVersion(String httpVersion) {
        if ("HTTP_2".equals(httpVersion)) {
            return HttpClient.Version.HTTP_2;
        }
        return HttpClient.Version.HTTP_1_1;
    }

    private static SSLContext initSslContext() throws Exception {
        TrustManager[] trustManagers = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        return OAuth2Client.buildSslContext(null, trustManagers);
    }

    private static TrustManagerFactory getTrustManagerFactory(BString cert) throws Exception {
        Object publicKeyMap = Decode.decodeRsaPublicKeyFromCertFile((BString)cert);
        if (publicKeyMap instanceof BMap) {
            X509Certificate x509Certificate = (X509Certificate)((BMap)publicKeyMap).getNativeData("NATIVE_DATA_PUBLIC_KEY_CERTIFICATE");
            KeyStore ts = KeyStore.getInstance("PKCS12");
            ts.load(null, "".toCharArray());
            ts.setCertificateEntry(UUID.randomUUID().toString(), x509Certificate);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(ts);
            return tmf;
        }
        throw new Exception("Failed to get the public key from Crypto API. " + ((BError)((Object)publicKeyMap)).getErrorMessage().getValue());
    }

    private static TrustManagerFactory getTrustManagerFactory(BMap<BString, BString> trustStore) throws Exception {
        BString trustStorePath = trustStore.getStringValue(OAuth2Constants.PATH);
        BString trustStorePassword = trustStore.getStringValue(OAuth2Constants.PASSWORD);
        KeyStore ts = OAuth2Client.getKeyStore(trustStorePath, trustStorePassword);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        tmf.init(ts);
        return tmf;
    }

    private static KeyManagerFactory getKeyManagerFactory(BMap<BString, BString> keyStore) throws Exception {
        BString keyStorePath = keyStore.getStringValue(OAuth2Constants.PATH);
        BString keyStorePassword = keyStore.getStringValue(OAuth2Constants.PASSWORD);
        KeyStore ks = OAuth2Client.getKeyStore(keyStorePath, keyStorePassword);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(ks, keyStorePassword.getValue().toCharArray());
        return kmf;
    }

    private static KeyManagerFactory getKeyManagerFactory(BString certFile, BString keyFile, BString keyPassword) throws Exception {
        Object publicKey = Decode.decodeRsaPublicKeyFromCertFile((BString)certFile);
        if (publicKey instanceof BMap) {
            X509Certificate publicCert = (X509Certificate)((BMap)publicKey).getNativeData("NATIVE_DATA_PUBLIC_KEY_CERTIFICATE");
            Object privateKeyMap = Decode.decodeRsaPrivateKeyFromKeyFile((BString)keyFile, (Object)keyPassword);
            if (privateKeyMap instanceof BMap) {
                PrivateKey privateKey = (PrivateKey)((BMap)privateKeyMap).getNativeData("NATIVE_DATA_PRIVATE_KEY");
                KeyStore ks = KeyStore.getInstance("PKCS12");
                ks.load(null, "".toCharArray());
                ks.setKeyEntry(UUID.randomUUID().toString(), privateKey, "".toCharArray(), new X509Certificate[]{publicCert});
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmf.init(ks, "".toCharArray());
                return kmf;
            }
            throw new Exception("Failed to get the private key from Crypto API. " + ((BError)((Object)privateKeyMap)).getErrorMessage().getValue());
        }
        throw new Exception("Failed to get the public key from Crypto API. " + ((BError)((Object)publicKey)).getErrorMessage().getValue());
    }

    private static KeyStore getKeyStore(BString path, BString password) throws Exception {
        try (FileInputStream is = new FileInputStream(path.getValue());){
            char[] passphrase = password.getValue().toCharArray();
            KeyStore ks = KeyStore.getInstance("PKCS12");
            ks.load(is, passphrase);
            KeyStore keyStore = ks;
            return keyStore;
        }
    }

    private static SSLContext buildSslContext(KeyManager[] keyManagers, TrustManager[] trustManagers) throws Exception {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManagers, trustManagers, new SecureRandom());
        return sslContext;
    }

    private static HttpClient buildHttpClient(String httpVersion, int connectionTimeout) {
        return HttpClient.newBuilder().version(OAuth2Client.getHttpVersion(httpVersion)).connectTimeout(Duration.ofMillis(connectionTimeout)).build();
    }

    private static HttpClient buildHttpClient(String httpVersion, SSLContext sslContext, int connectionTimeout) {
        return HttpClient.newBuilder().version(OAuth2Client.getHttpVersion(httpVersion)).sslContext(sslContext).connectTimeout(Duration.ofMillis(connectionTimeout)).build();
    }

    private static HttpRequest buildHttpRequest(URI uri, String payload, int requestTimeout) {
        return HttpRequest.newBuilder().uri(uri).setHeader("Content-Type", "application/x-www-form-urlencoded").POST(HttpRequest.BodyPublishers.ofString(payload)).timeout(Duration.ofMillis(requestTimeout)).build();
    }

    private static HttpRequest buildHttpRequest(URI uri, String[] headers, String payload, int requestTimeout) {
        return HttpRequest.newBuilder().uri(uri).headers(headers).setHeader("Content-Type", "application/x-www-form-urlencoded").POST(HttpRequest.BodyPublishers.ofString(payload)).timeout(Duration.ofMillis(requestTimeout)).build();
    }

    private static Object callEndpoint(Environment env, HttpClient client, HttpRequest request) {
        return env.yieldAndRun(() -> {
            try {
                HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                if (response.statusCode() >= 200 && response.statusCode() < 300) {
                    return StringUtils.fromString((String)response.body());
                }
                return OAuth2Client.createError("Failed to get a success response from the endpoint. Response code: '" + response.statusCode() + "'. Response body: '" + response.body() + "'");
            }
            catch (IOException | InterruptedException e) {
                return OAuth2Client.createError("Failed to send the request to the endpoint. " + e.getMessage());
            }
        });
    }

    private static BMap<BString, ?> getBMapValueIfPresent(BMap<BString, ?> config, BString key) {
        return config.containsKey((Object)key) ? config.getMapValue(key) : null;
    }

    private static BString getBStringValueIfPresent(BMap<BString, ?> config, BString key) {
        return config.containsKey((Object)key) ? config.getStringValue(key) : null;
    }

    private static BError createError(String errMsg) {
        return ErrorCreator.createError((Module)ModuleUtils.getModule(), (String)"Error", (BString)StringUtils.fromString((String)errMsg), null, null);
    }

    private static int getConnectionTimeoutInMillis(BMap<BString, ?> clientConfig) throws BError {
        double connectTimeoutInSeconds;
        double d = connectTimeoutInSeconds = clientConfig.containsKey((Object)OAuth2Constants.CONNECTION_TIMEOUT) ? ((BDecimal)clientConfig.get((Object)OAuth2Constants.CONNECTION_TIMEOUT)).floatValue() : ModuleUtils.getOauth2ConnectionTimeout();
        if (connectTimeoutInSeconds <= 0.0) {
            throw OAuth2Client.createError("OAuth2 connection timeout must be greater than zero");
        }
        return (int)(connectTimeoutInSeconds * 1000.0);
    }

    private static int getRequestTimeoutInMillis(BMap<BString, ?> clientConfig) throws BError {
        double requestTimeoutInSeconds;
        double d = requestTimeoutInSeconds = clientConfig.containsKey((Object)OAuth2Constants.REQUEST_TIMEOUT) ? ((BDecimal)clientConfig.get((Object)OAuth2Constants.REQUEST_TIMEOUT)).floatValue() : ModuleUtils.getOauth2RequestTimeout();
        if (requestTimeoutInSeconds <= 0.0) {
            throw OAuth2Client.createError("OAuth2 request timeout must be greater than zero");
        }
        return (int)(requestTimeoutInSeconds * 1000.0);
    }
}

