/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.error;

import io.ballerina.identifier.Utils;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.constants.RuntimeConstants;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.MethodType;
import io.ballerina.runtime.api.types.ObjectType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.semtype.BasicTypeBitSet;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BFuture;
import io.ballerina.runtime.api.values.BLink;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.runtime.internal.scheduling.Strand;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class StackTrace {
    private static final Module MODULE = new Module("ballerina", "lang.error", "1");
    private static final ObjectType CALLSTACK_TYPE = StackTrace.createCallStackType();

    private StackTrace() {
    }

    public static BObject stackTrace(BError value) {
        CallStack callStack = new CallStack(CALLSTACK_TYPE);
        callStack.callStack = StackTrace.getCallStackArray(value.getStackTrace());
        callStack.callStack.freezeDirect();
        return callStack;
    }

    private static ObjectType createCallStackType() {
        RecordType callStackElementType = TypeCreator.createRecordType((String)"CallStackElement", (Module)MODULE, (long)0L, Map.of("callableName", TypeCreator.createField((Type)PredefinedTypes.TYPE_STRING, (String)"callableName", (long)0L), "moduleName", TypeCreator.createField((Type)PredefinedTypes.TYPE_STRING, (String)"moduleName", (long)4096L), "fileName", TypeCreator.createField((Type)PredefinedTypes.TYPE_STRING, (String)"fileName", (long)0L), "lineNumber", TypeCreator.createField((Type)PredefinedTypes.TYPE_INT, (String)"lineNumber", (long)0L)), (Type)PredefinedTypes.TYPE_NEVER, (boolean)false, (int)0);
        ObjectType callStackObjType = TypeCreator.createObjectType((String)"CallStack", (Module)MODULE, (long)0L);
        callStackObjType.setMethods(new MethodType[0]);
        callStackObjType.setFields(Collections.singletonMap("callStack", TypeCreator.createField((Type)TypeCreator.createArrayType((Type)callStackElementType), (String)"callStack", (long)1L)));
        return callStackObjType;
    }

    private static BArray getCallStackArray(StackTraceElement[] stackTrace) {
        Type recordType = ValueCreator.createRecordValue((Module)RuntimeConstants.BALLERINA_LANG_ERROR_PKG_ID, (String)"CallStackElement").getType();
        Object[] array = new Object[stackTrace.length];
        for (int i = 0; i < stackTrace.length; ++i) {
            array[i] = StackTrace.getStackFrame(stackTrace[i]);
        }
        return ValueCreator.createArrayValue((Object[])array, (ArrayType)TypeCreator.createArrayType((Type)recordType));
    }

    static BMap<BString, Object> getStackFrame(StackTraceElement stackTraceElement) {
        String fileName;
        Object[] values = new Object[4];
        values[0] = stackTraceElement.getMethodName();
        values[2] = stackTraceElement.getFileName();
        values[3] = stackTraceElement.getLineNumber();
        String moduleName = Utils.decodeIdentifier((String)stackTraceElement.getClassName()).replace("$$$", ".");
        if (!moduleName.equals(fileName = stackTraceElement.getFileName().replace(".bal", ""))) {
            int index = moduleName.lastIndexOf("." + fileName);
            values[1] = index != -1 ? moduleName.substring(0, index) : moduleName;
        }
        return ValueCreator.createRecordValue((BMap)ValueCreator.createRecordValue((Module)RuntimeConstants.BALLERINA_LANG_ERROR_PKG_ID, (String)"CallStackElement"), (Object[])values);
    }

    public static class CallStack
    implements BObject {
        private static final BasicTypeBitSet BASIC_TYPE = Builder.getObjectType();
        BArray callStack;
        private final ObjectType type;
        private final BTypedesc typedesc;

        public CallStack(ObjectType type) {
            this.type = type;
            this.typedesc = ValueCreator.createTypedescValue((Type)type);
        }

        @Deprecated
        public Object call(Strand strand, String funcName, Object ... args) {
            throw ErrorCreator.createError((BString)StringUtils.fromString((String)("No such field or method: " + funcName)));
        }

        @Deprecated
        public BFuture start(Strand strand, String funcName, Object ... args) {
            throw ErrorCreator.createError((BString)StringUtils.fromString((String)("No such field or method: " + funcName)));
        }

        public String stringValue(BLink parent) {
            return "object " + this.type.toString();
        }

        public String expressionStringValue(BLink parent) {
            return null;
        }

        public ObjectType getType() {
            return (ObjectType)TypeUtils.getImpliedType((Type)this.type);
        }

        public BasicTypeBitSet getBasicType() {
            return BASIC_TYPE;
        }

        public Type getOriginalType() {
            return this.type;
        }

        public Object get(BString fieldName) {
            if (fieldName.getValue().equals("callStack")) {
                return this.callStack;
            }
            throw ErrorCreator.createError((BString)StringUtils.fromString((String)"No such field or method: callStack"));
        }

        public long getIntValue(BString fieldName) {
            return 0L;
        }

        public double getFloatValue(BString fieldName) {
            return 0.0;
        }

        public BString getStringValue(BString fieldName) {
            return null;
        }

        public boolean getBooleanValue(BString fieldName) {
            return false;
        }

        public BMap<BString, Object> getMapValue(BString fieldName) {
            return null;
        }

        public BObject getObjectValue(BString fieldName) {
            return null;
        }

        public BArray getArrayValue(BString fieldName) {
            return null;
        }

        public void addNativeData(String key, Object data) {
        }

        public Object getNativeData(String key) {
            return null;
        }

        public HashMap<String, Object> getNativeData() {
            return null;
        }

        public void set(BString fieldName, Object value) {
            throw ErrorCreator.createError((BString)StringUtils.fromString((String)"No such field or method: callStack"));
        }

        public Object copy(Map<Object, Object> refs) {
            return null;
        }

        public Object frozenCopy(Map<Object, Object> refs) {
            return null;
        }

        public BTypedesc getTypedesc() {
            return this.typedesc;
        }
    }
}

