/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.crypto.nativeimpl;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.crypto.Constants;
import io.ballerina.stdlib.crypto.CryptoUtils;
import io.ballerina.stdlib.crypto.nativeimpl.ModuleUtils;
import io.ballerina.stdlib.time.util.TimeValueHandler;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.Base64;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.PKCSException;
import org.bouncycastle.pkcs.jcajce.JcePKCSPBEInputDecryptorProviderBuilder;

public class Decode {
    private Decode() {
    }

    public static Object decodeRsaPrivateKeyFromKeyStore(BMap<BString, BString> keyStoreRecord, BString keyAlias, BString keyPassword) {
        Object decodedPrivateKey = Decode.getPrivateKey(keyStoreRecord, keyAlias, keyPassword);
        if (decodedPrivateKey instanceof PrivateKey) {
            PrivateKey privateKey = (PrivateKey)decodedPrivateKey;
            return Decode.buildRsPrivateKeyRecord(privateKey);
        }
        return decodedPrivateKey;
    }

    public static Object decodeEcPrivateKeyFromKeyStore(BMap<BString, BString> keyStoreRecord, BString keyAlias, BString keyPassword) {
        Object decodedPrivateKey = Decode.getPrivateKey(keyStoreRecord, keyAlias, keyPassword);
        if (decodedPrivateKey instanceof PrivateKey) {
            PrivateKey privateKey = (PrivateKey)decodedPrivateKey;
            return Decode.buildEcPrivateKeyRecord(privateKey);
        }
        return decodedPrivateKey;
    }

    public static Object decodeMlDsa65PrivateKeyFromKeyStore(BMap<BString, BString> keyStoreRecord, BString keyAlias, BString keyPassword) {
        CryptoUtils.addBCProvider();
        Object decodedPrivateKey = Decode.getPrivateKey(keyStoreRecord, keyAlias, keyPassword);
        if (decodedPrivateKey instanceof PrivateKey) {
            PrivateKey privateKey = (PrivateKey)decodedPrivateKey;
            return Decode.buildMlDsa65PrivateKeyRecord(privateKey);
        }
        return decodedPrivateKey;
    }

    public static Object decodeMlKem768PrivateKeyFromKeyStore(BMap<BString, BString> keyStoreRecord, BString keyAlias, BString keyPassword) {
        CryptoUtils.addBCProvider();
        Object decodedPrivateKey = Decode.getPrivateKey(keyStoreRecord, keyAlias, keyPassword);
        if (decodedPrivateKey instanceof PrivateKey) {
            PrivateKey privateKey = (PrivateKey)decodedPrivateKey;
            return Decode.buildMlKem768PrivateKeyRecord(privateKey);
        }
        return decodedPrivateKey;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object getPrivateKey(BMap<BString, BString> keyStoreRecord, BString keyAlias, BString keyPassword) {
        File keyStoreFile = new File(((BString)keyStoreRecord.get((Object)Constants.KEY_STORE_RECORD_PATH_FIELD)).toString());
        try {
            FileInputStream fileInputStream = new FileInputStream(keyStoreFile);
            try {
                KeyStore keyStore = KeyStore.getInstance("PKCS12");
                try {
                    keyStore.load(fileInputStream, ((BString)keyStoreRecord.get((Object)Constants.KEY_STORE_RECORD_PASSWORD_FIELD)).toString().toCharArray());
                }
                catch (NoSuchAlgorithmException e) {
                    BError bError = CryptoUtils.createError("Keystore integrity check algorithm is not found: " + e.getMessage());
                    fileInputStream.close();
                    return bError;
                }
                PrivateKey privateKey = (PrivateKey)keyStore.getKey(keyAlias.getValue(), keyPassword.getValue().toCharArray());
                if (privateKey == null) {
                    BError bError = CryptoUtils.createError("Key cannot be recovered by using given key alias: " + String.valueOf(keyAlias));
                    return bError;
                }
                PrivateKey privateKey2 = privateKey;
                return privateKey2;
            }
            finally {
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
        catch (FileNotFoundException e) {
            return CryptoUtils.createError("PKCS12 KeyStore not found at: " + String.valueOf(keyStoreFile.getAbsoluteFile()));
        }
        catch (IOException | KeyStoreException | CertificateException e) {
            return CryptoUtils.createError("Unable to open KeyStore: " + e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            return CryptoUtils.createError("Algorithm for key recovery is not found: " + e.getMessage());
        }
        catch (UnrecoverableKeyException e) {
            return CryptoUtils.createError("Key cannot be recovered: " + e.getMessage());
        }
    }

    public static Object decodeRsaPrivateKeyFromKeyFile(BString keyFilePath, Object keyPassword) {
        Object decodedPrivateKey = Decode.getPrivateKey(keyFilePath, keyPassword);
        if (decodedPrivateKey instanceof PrivateKey) {
            PrivateKey privateKey = (PrivateKey)decodedPrivateKey;
            return Decode.buildRsPrivateKeyRecord(privateKey);
        }
        return decodedPrivateKey;
    }

    /*
     * Exception decompiling
     */
    public static Object decodeRsaPrivateKeyFromContent(BArray content, Object keyPassword) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Object decodeEcPrivateKeyFromKeyFile(BString keyFilePath, Object keyPassword) {
        Object decodedPrivateKey = Decode.getPrivateKey(keyFilePath, keyPassword);
        if (decodedPrivateKey instanceof PrivateKey) {
            PrivateKey privateKey = (PrivateKey)decodedPrivateKey;
            return Decode.buildEcPrivateKeyRecord(privateKey);
        }
        return decodedPrivateKey;
    }

    public static Object decodeMlDsa65PrivateKeyFromKeyFile(BString keyFilePath, Object keyPassword) {
        Object decodedPrivateKey = Decode.getPrivateKey(keyFilePath, keyPassword);
        if (decodedPrivateKey instanceof PrivateKey) {
            PrivateKey privateKey = (PrivateKey)decodedPrivateKey;
            return Decode.buildMlDsa65PrivateKeyRecord(privateKey);
        }
        return decodedPrivateKey;
    }

    public static Object decodeMlKem768PrivateKeyFromKeyFile(BString keyFilePath, Object keyPassword) {
        CryptoUtils.addBCProvider();
        Object decodedPrivateKey = Decode.getPrivateKey(keyFilePath, keyPassword);
        if (decodedPrivateKey instanceof PrivateKey) {
            PrivateKey privateKey = (PrivateKey)decodedPrivateKey;
            return Decode.buildMlKem768PrivateKeyRecord(privateKey);
        }
        return decodedPrivateKey;
    }

    private static Object getPrivateKey(BString keyFilePath, Object keyPassword) {
        Object object;
        CryptoUtils.addBCProvider();
        File privateKeyFile = new File(keyFilePath.getValue());
        PEMParser pemParser = new PEMParser((Reader)new FileReader(privateKeyFile, StandardCharsets.UTF_8));
        try {
            Object obj = pemParser.readObject();
            object = Decode.getPrivateKeyInfo(keyPassword, obj);
        }
        catch (Throwable throwable) {
            try {
                try {
                    pemParser.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                return CryptoUtils.createError("Key file not found at: " + String.valueOf(privateKeyFile.getAbsoluteFile()));
            }
            catch (IOException | PKCSException e) {
                return CryptoUtils.createError("Unable to do private key operations: " + e.getMessage());
            }
        }
        pemParser.close();
        return object;
    }

    private static Object getPrivateKeyInfo(Object keyPassword, Object keyContent) throws IOException, PKCSException {
        PrivateKeyInfo privateKeyInfo;
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
        if (keyContent instanceof PEMEncryptedKeyPair) {
            PEMEncryptedKeyPair keyPair = (PEMEncryptedKeyPair)keyContent;
            if (keyPassword == null) {
                return CryptoUtils.createError("Failed to read the encrypted private key without a password.");
            }
            char[] pwd = ((BString)keyPassword).getValue().toCharArray();
            PEMDecryptorProvider decryptorProvider = new JcePEMDecryptorProviderBuilder().setProvider("BC").build(pwd);
            PEMKeyPair pemKeyPair = keyPair.decryptKeyPair(decryptorProvider);
            privateKeyInfo = pemKeyPair.getPrivateKeyInfo();
        } else if (keyContent instanceof PKCS8EncryptedPrivateKeyInfo) {
            PKCS8EncryptedPrivateKeyInfo pkcs8EncryptedPrivateKeyInfo = (PKCS8EncryptedPrivateKeyInfo)keyContent;
            if (keyPassword == null) {
                return CryptoUtils.createError("Failed to read the encrypted private key without a password.");
            }
            char[] pwd = ((BString)keyPassword).getValue().toCharArray();
            InputDecryptorProvider decryptorProvider = new JcePKCSPBEInputDecryptorProviderBuilder().setProvider("BC").build(pwd);
            privateKeyInfo = pkcs8EncryptedPrivateKeyInfo.decryptPrivateKeyInfo(decryptorProvider);
        } else if (keyContent instanceof PEMKeyPair) {
            PEMKeyPair pemKeyPair = (PEMKeyPair)keyContent;
            privateKeyInfo = pemKeyPair.getPrivateKeyInfo();
        } else if (keyContent instanceof PrivateKeyInfo) {
            PrivateKeyInfo keyInfo;
            privateKeyInfo = keyInfo = (PrivateKeyInfo)keyContent;
        } else {
            return CryptoUtils.createError("Failed to parse private key information from the given input");
        }
        return converter.getPrivateKey(privateKeyInfo);
    }

    private static Object buildRsPrivateKeyRecord(PrivateKey privateKey) {
        if (privateKey.getAlgorithm().equals("RSA")) {
            return Decode.getPrivateKeyRecord(privateKey);
        }
        return CryptoUtils.createError("Not a valid RSA key");
    }

    private static Object getPrivateKeyRecord(PrivateKey privateKey) {
        BMap privateKeyRecord = ValueCreator.createRecordValue((Module)ModuleUtils.getModule(), (String)"PrivateKey");
        privateKeyRecord.addNativeData("NATIVE_DATA_PRIVATE_KEY", (Object)privateKey);
        privateKeyRecord.put((Object)StringUtils.fromString((String)"algorithm"), (Object)StringUtils.fromString((String)privateKey.getAlgorithm()));
        return privateKeyRecord;
    }

    private static Object buildEcPrivateKeyRecord(PrivateKey privateKey) {
        if (privateKey.getAlgorithm().startsWith("EC")) {
            return Decode.getPrivateKeyRecord(privateKey);
        }
        return CryptoUtils.createError("Not a valid EC key");
    }

    private static Object buildMlDsa65PrivateKeyRecord(PrivateKey privateKey) {
        if (privateKey.getAlgorithm().equals("ML-DSA-65")) {
            return Decode.getPrivateKeyRecord(privateKey);
        }
        return CryptoUtils.createError("Not a valid ML-DSA-65 key");
    }

    private static Object buildMlKem768PrivateKeyRecord(PrivateKey privateKey) {
        if (privateKey.getAlgorithm().equals("ML-KEM-768")) {
            return Decode.getPrivateKeyRecord(privateKey);
        }
        return CryptoUtils.createError("Not a valid ML-KEM-768 key");
    }

    public static Object decodeRsaPublicKeyFromTrustStore(BMap<BString, BString> trustStoreRecord, BString keyAlias) {
        Object certificate = Decode.getPublicKey(trustStoreRecord, keyAlias);
        if (certificate instanceof Certificate) {
            Certificate publicKey = (Certificate)certificate;
            return Decode.buildRsaPublicKeyRecord(publicKey);
        }
        return certificate;
    }

    public static Object decodeEcPublicKeyFromTrustStore(BMap<BString, BString> trustStoreRecord, BString keyAlias) {
        Object certificate = Decode.getPublicKey(trustStoreRecord, keyAlias);
        if (certificate instanceof Certificate) {
            Certificate publicKey = (Certificate)certificate;
            return Decode.buildEcPublicKeyRecord(publicKey);
        }
        return certificate;
    }

    public static Object decodeMlDsa65PublicKeyFromTrustStore(BMap<BString, BString> trustStoreRecord, BString keyAlias) {
        CryptoUtils.addBCProvider();
        Object certificate = Decode.getPublicKey(trustStoreRecord, keyAlias);
        if (certificate instanceof Certificate) {
            Certificate publicKey = (Certificate)certificate;
            return Decode.buildMlDsa65PublicKeyRecord(publicKey);
        }
        return certificate;
    }

    public static Object decodeMlKem768PublicKeyFromTrustStore(BMap<BString, BString> trustStoreRecord, BString keyAlias) {
        CryptoUtils.addBCProvider();
        Object certificate = Decode.getPublicKey(trustStoreRecord, keyAlias);
        if (certificate instanceof Certificate) {
            Certificate publicKey = (Certificate)certificate;
            return Decode.buildMlKem768PublicKeyRecord(publicKey);
        }
        return certificate;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object getPublicKey(BMap<BString, BString> trustStoreRecord, BString keyAlias) {
        File keyStoreFile = new File(((BString)trustStoreRecord.get((Object)Constants.KEY_STORE_RECORD_PATH_FIELD)).toString());
        try {
            FileInputStream fileInputStream = new FileInputStream(keyStoreFile);
            try {
                KeyStore keyStore = KeyStore.getInstance("PKCS12");
                try {
                    keyStore.load(fileInputStream, ((BString)trustStoreRecord.get((Object)Constants.KEY_STORE_RECORD_PASSWORD_FIELD)).toString().toCharArray());
                }
                catch (NoSuchAlgorithmException e) {
                    BError bError = CryptoUtils.createError("Keystore integrity check algorithm is not found: " + e.getMessage());
                    fileInputStream.close();
                    return bError;
                }
                Certificate certificate = keyStore.getCertificate(keyAlias.getValue());
                if (certificate == null) {
                    BError bError = CryptoUtils.createError("Certificate cannot be recovered by using given key alias: " + String.valueOf(keyAlias));
                    return bError;
                }
                Certificate certificate2 = certificate;
                return certificate2;
            }
            finally {
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
        catch (FileNotFoundException e) {
            return CryptoUtils.createError("PKCS12 KeyStore not found at: " + String.valueOf(keyStoreFile.getAbsoluteFile()));
        }
        catch (IOException | KeyStoreException | CertificateException e) {
            return CryptoUtils.createError("Unable to open KeyStore: " + e.getMessage());
        }
    }

    public static Object decodeRsaPublicKeyFromCertFile(BString certFilePath) {
        Object object;
        File certFile = new File(certFilePath.getValue());
        FileInputStream fileInputStream = new FileInputStream(certFile);
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            X509Certificate certificate = (X509Certificate)certificateFactory.generateCertificate(fileInputStream);
            object = Decode.buildRsaPublicKeyRecord(certificate);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                return CryptoUtils.createError("Certificate file not found at: " + certFile.getAbsolutePath());
            }
            catch (IOException | CertificateException e) {
                return CryptoUtils.createError("Unable to do public key operations: " + e.getMessage());
            }
        }
        fileInputStream.close();
        return object;
    }

    public static Object decodeRsaPublicKeyFromContent(BArray content) {
        Object object;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(content.getBytes());
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            X509Certificate certificate = (X509Certificate)certificateFactory.generateCertificate(inputStream);
            object = Decode.buildRsaPublicKeyRecord(certificate);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | CertificateException e) {
                return CryptoUtils.createError("Unable to do public key operations: " + e.getMessage());
            }
        }
        ((InputStream)inputStream).close();
        return object;
    }

    public static Object decodeEcPublicKeyFromCertFile(BString certFilePath) {
        Object object;
        File certFile = new File(certFilePath.getValue());
        FileInputStream fileInputStream = new FileInputStream(certFile);
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            X509Certificate certificate = (X509Certificate)certificateFactory.generateCertificate(fileInputStream);
            object = Decode.buildEcPublicKeyRecord(certificate);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                return CryptoUtils.createError("Certificate file not found at: " + certFile.getAbsolutePath());
            }
            catch (IOException | CertificateException e) {
                return CryptoUtils.createError("Unable to do public key operations: " + e.getMessage());
            }
        }
        fileInputStream.close();
        return object;
    }

    public static Object decodeMlDsa65PublicKeyFromCertFile(BString certFilePath) {
        Object object;
        CryptoUtils.addBCProvider();
        File certFile = new File(certFilePath.getValue());
        FileInputStream fileInputStream = new FileInputStream(certFile);
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            X509Certificate certificate = (X509Certificate)certificateFactory.generateCertificate(fileInputStream);
            object = Decode.buildMlDsa65PublicKeyRecord(certificate);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                return CryptoUtils.createError("Certificate file not found at: " + certFile.getAbsolutePath());
            }
            catch (IOException | CertificateException e) {
                return CryptoUtils.createError("Unable to do public key operations: " + e.getMessage());
            }
        }
        fileInputStream.close();
        return object;
    }

    public static Object decodeMlKem768PublicKeyFromCertFile(BString certFilePath) {
        Object object;
        CryptoUtils.addBCProvider();
        File certFile = new File(certFilePath.getValue());
        FileInputStream fileInputStream = new FileInputStream(certFile);
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            X509Certificate certificate = (X509Certificate)certificateFactory.generateCertificate(fileInputStream);
            object = Decode.buildMlKem768PublicKeyRecord(certificate);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                return CryptoUtils.createError("Certificate file not found at: " + certFile.getAbsolutePath());
            }
            catch (IOException | CertificateException e) {
                return CryptoUtils.createError("Unable to do public key operations: " + e.getMessage());
            }
        }
        fileInputStream.close();
        return object;
    }

    private static Object buildRsaPublicKeyRecord(Certificate certificate) {
        BMap<BString, Object> certificateBMap = Decode.enrichPublicKeyInfo(certificate);
        PublicKey publicKey = certificate.getPublicKey();
        if (publicKey.getAlgorithm().equals("RSA")) {
            return Decode.getPublicKeyRecord(certificate, certificateBMap, publicKey);
        }
        return CryptoUtils.createError("Not a valid RSA public key");
    }

    private static Object buildEcPublicKeyRecord(Certificate certificate) {
        BMap<BString, Object> certificateBMap = Decode.enrichPublicKeyInfo(certificate);
        PublicKey publicKey = certificate.getPublicKey();
        if (publicKey.getAlgorithm().equals("EC")) {
            return Decode.getPublicKeyRecord(certificate, certificateBMap, publicKey);
        }
        return CryptoUtils.createError("Not a valid EC public key");
    }

    private static Object buildMlDsa65PublicKeyRecord(Certificate certificate) {
        BMap<BString, Object> certificateBMap = Decode.enrichPublicKeyInfo(certificate);
        PublicKey publicKey = certificate.getPublicKey();
        if (publicKey.getAlgorithm().equals("ML-DSA-65")) {
            return Decode.getPublicKeyRecord(certificate, certificateBMap, publicKey);
        }
        return CryptoUtils.createError("Not a valid ML-DSA-65 public key");
    }

    private static Object buildMlKem768PublicKeyRecord(Certificate certificate) {
        BMap<BString, Object> certificateBMap = Decode.enrichPublicKeyInfo(certificate);
        PublicKey publicKey = certificate.getPublicKey();
        if (publicKey.getAlgorithm().equals("ML-KEM-768")) {
            return Decode.getPublicKeyRecord(certificate, certificateBMap, publicKey);
        }
        return CryptoUtils.createError("Not a valid ML-KEM-768 public key");
    }

    private static Object getPublicKeyRecord(Certificate certificate, BMap<BString, Object> certificateBMap, PublicKey publicKey) {
        BMap publicKeyMap = ValueCreator.createRecordValue((Module)ModuleUtils.getModule(), (String)"PublicKey");
        publicKeyMap.addNativeData("NATIVE_DATA_PUBLIC_KEY", (Object)publicKey);
        publicKeyMap.addNativeData("NATIVE_DATA_PUBLIC_KEY_CERTIFICATE", (Object)certificate);
        publicKeyMap.put((Object)StringUtils.fromString((String)"algorithm"), (Object)StringUtils.fromString((String)publicKey.getAlgorithm()));
        if (certificateBMap.size() > 0) {
            publicKeyMap.put((Object)StringUtils.fromString((String)"certificate"), certificateBMap);
        }
        return publicKeyMap;
    }

    private static BMap<BString, Object> enrichPublicKeyInfo(Certificate certificate) {
        BMap certificateBMap = ValueCreator.createRecordValue((Module)ModuleUtils.getModule(), (String)"Certificate");
        if (certificate instanceof X509Certificate) {
            X509Certificate x509Certificate = (X509Certificate)certificate;
            certificateBMap.put((Object)StringUtils.fromString((String)"issuer"), (Object)StringUtils.fromString((String)x509Certificate.getIssuerX500Principal().getName()));
            certificateBMap.put((Object)StringUtils.fromString((String)"subject"), (Object)StringUtils.fromString((String)x509Certificate.getSubjectX500Principal().getName()));
            certificateBMap.put((Object)StringUtils.fromString((String)"version0"), (Object)x509Certificate.getVersion());
            certificateBMap.put((Object)StringUtils.fromString((String)"serial"), (Object)x509Certificate.getSerialNumber().longValue());
            certificateBMap.put((Object)StringUtils.fromString((String)"notBefore"), (Object)TimeValueHandler.createUtcFromMilliSeconds((long)x509Certificate.getNotBefore().getTime()));
            certificateBMap.put((Object)StringUtils.fromString((String)"notAfter"), (Object)TimeValueHandler.createUtcFromMilliSeconds((long)x509Certificate.getNotAfter().getTime()));
            certificateBMap.put((Object)StringUtils.fromString((String)"signature"), (Object)ValueCreator.createArrayValue((byte[])x509Certificate.getSignature()));
            certificateBMap.put((Object)StringUtils.fromString((String)"signingAlgorithm"), (Object)StringUtils.fromString((String)x509Certificate.getSigAlgName()));
        }
        return certificateBMap;
    }

    public static Object buildRsaPublicKey(BString modulus, BString exponent) {
        try {
            byte[] decodedModulus = Base64.getUrlDecoder().decode(modulus.getValue());
            byte[] decodedExponent = Base64.getUrlDecoder().decode(exponent.getValue());
            RSAPublicKeySpec spec = new RSAPublicKeySpec(new BigInteger(1, decodedModulus), new BigInteger(1, decodedExponent));
            RSAPublicKey publicKey = (RSAPublicKey)KeyFactory.getInstance("RSA").generatePublic(spec);
            BMap publicKeyMap = ValueCreator.createRecordValue((Module)ModuleUtils.getModule(), (String)"PublicKey");
            publicKeyMap.addNativeData("NATIVE_DATA_PUBLIC_KEY", (Object)publicKey);
            publicKeyMap.put((Object)StringUtils.fromString((String)"algorithm"), (Object)StringUtils.fromString((String)publicKey.getAlgorithm()));
            return publicKeyMap;
        }
        catch (InvalidKeySpecException e) {
            return CryptoUtils.createError("Invalid modulus or exponent: " + e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            return CryptoUtils.createError("Algorithm of the key factory is not found: " + e.getMessage());
        }
    }
}

