/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.persist.compiler.codeaction;

import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.projects.plugins.codeaction.CodeAction;
import io.ballerina.projects.plugins.codeaction.CodeActionArgument;
import io.ballerina.projects.plugins.codeaction.CodeActionContext;
import io.ballerina.projects.plugins.codeaction.CodeActionExecutionContext;
import io.ballerina.projects.plugins.codeaction.CodeActionInfo;
import io.ballerina.projects.plugins.codeaction.DocumentEdit;
import io.ballerina.stdlib.persist.compiler.BalException;
import io.ballerina.stdlib.persist.compiler.utils.Utils;
import io.ballerina.stdlib.persist.compiler.utils.ValidatorsByDatastore;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocumentChange;
import io.ballerina.tools.text.TextEdit;
import io.ballerina.tools.text.TextRange;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public abstract class AbstractChangeToSupportedType
implements CodeAction {
    private static final String TYPE_CHANGE_TEXT_RANGE = "type.change.text.range";

    public List<String> supportedDiagnosticCodes() {
        return this.getSupportedDiagnosticCodes();
    }

    public Optional<CodeActionInfo> codeActionInfo(CodeActionContext codeActionContext) {
        String type;
        try {
            String arrayType;
            type = this.getType();
            String datastore = Utils.getDatastore(codeActionContext);
            if (type.endsWith("[]") ? !ValidatorsByDatastore.isValidArrayType(arrayType = type.substring(0, type.length() - 2), datastore) : !ValidatorsByDatastore.isValidSimpleType(type, datastore)) {
                return Optional.empty();
            }
        }
        catch (BalException e) {
            throw new RuntimeException(e);
        }
        type = this.getType();
        String title = MessageFormat.format("Change to ''{0}'' type", type);
        CodeActionArgument syntaxLocationArg = CodeActionArgument.from((String)TYPE_CHANGE_TEXT_RANGE, (Object)codeActionContext.diagnostic().location().textRange());
        return Optional.of(CodeActionInfo.from((String)title, List.of(syntaxLocationArg)));
    }

    public List<DocumentEdit> execute(CodeActionExecutionContext context) {
        TextRange textRange = Utils.getTextRangeArgument(context, TYPE_CHANGE_TEXT_RANGE);
        if (textRange == null) {
            return Collections.emptyList();
        }
        SyntaxTree syntaxTree = context.currentDocument().syntaxTree();
        ArrayList<TextEdit> textEdits = new ArrayList<TextEdit>();
        textEdits.add(TextEdit.from((TextRange)textRange, (String)this.getType()));
        TextDocumentChange change = TextDocumentChange.from((TextEdit[])textEdits.toArray(new TextEdit[0]));
        TextDocument modifiedTextDocument = syntaxTree.textDocument().apply(change);
        return Collections.singletonList(new DocumentEdit(context.fileUri(), SyntaxTree.from((TextDocument)modifiedTextDocument)));
    }

    public String name() {
        return this.getName();
    }

    protected abstract String getName();

    protected abstract List<String> getSupportedDiagnosticCodes();

    protected abstract String getType();
}

