/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.persist.compiler.codeaction;

import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.projects.plugins.codeaction.CodeAction;
import io.ballerina.projects.plugins.codeaction.CodeActionArgument;
import io.ballerina.projects.plugins.codeaction.CodeActionContext;
import io.ballerina.projects.plugins.codeaction.CodeActionExecutionContext;
import io.ballerina.projects.plugins.codeaction.CodeActionInfo;
import io.ballerina.projects.plugins.codeaction.DocumentEdit;
import io.ballerina.stdlib.persist.compiler.utils.Utils;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocumentChange;
import io.ballerina.tools.text.TextEdit;
import io.ballerina.tools.text.TextRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public abstract class AbstractRemoveUnsupportedSyntax
implements CodeAction {
    private static final String REMOVE_TEXT_RANGE = "remove.text.range";

    public List<String> supportedDiagnosticCodes() {
        return this.getSupportedDiagnosticCodes();
    }

    public Optional<CodeActionInfo> codeActionInfo(CodeActionContext codeActionContext) {
        Diagnostic diagnostic = codeActionContext.diagnostic();
        CodeActionArgument syntaxLocationArg = CodeActionArgument.from((String)REMOVE_TEXT_RANGE, (Object)this.getNodeLocation(diagnostic));
        return Optional.of(CodeActionInfo.from((String)this.getTitle(diagnostic), List.of(syntaxLocationArg)));
    }

    public List<DocumentEdit> execute(CodeActionExecutionContext context) {
        TextRange textRange = Utils.getTextRangeArgument(context, REMOVE_TEXT_RANGE);
        if (textRange == null) {
            return Collections.emptyList();
        }
        SyntaxTree syntaxTree = context.currentDocument().syntaxTree();
        ArrayList<TextEdit> textEdits = new ArrayList<TextEdit>();
        textEdits.add(TextEdit.from((TextRange)textRange, (String)""));
        TextDocumentChange change = TextDocumentChange.from((TextEdit[])textEdits.toArray(new TextEdit[0]));
        TextDocument modifiedTextDocument = syntaxTree.textDocument().apply(change);
        return Collections.singletonList(new DocumentEdit(context.fileUri(), SyntaxTree.from((TextDocument)modifiedTextDocument)));
    }

    public String name() {
        return this.getName();
    }

    protected abstract String getName();

    protected abstract List<String> getSupportedDiagnosticCodes();

    protected abstract String getTitle(Diagnostic var1);

    protected abstract TextRange getNodeLocation(Diagnostic var1);
}

