/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.ftp.plugin;

import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.projects.plugins.codeaction.CodeAction;
import io.ballerina.projects.plugins.codeaction.CodeActionArgument;
import io.ballerina.projects.plugins.codeaction.CodeActionContext;
import io.ballerina.projects.plugins.codeaction.CodeActionExecutionContext;
import io.ballerina.projects.plugins.codeaction.CodeActionInfo;
import io.ballerina.projects.plugins.codeaction.DocumentEdit;
import io.ballerina.stdlib.ftp.plugin.PluginConstants;
import io.ballerina.stdlib.ftp.plugin.PluginUtils;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.text.LineRange;
import io.ballerina.tools.text.TextDocumentChange;
import io.ballerina.tools.text.TextEdit;
import io.ballerina.tools.text.TextRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class FtpCodeTemplateWithoutCaller
implements CodeAction {
    private static final String REMOTE_FUNCTION_TEXT = PluginConstants.LS + "\tremote function onFileChange(ftp:WatchEvent & readonly event) returns ftp:Error? {" + PluginConstants.LS + PluginConstants.LS + "\t}" + PluginConstants.LS;

    public List<String> supportedDiagnosticCodes() {
        return List.of(PluginConstants.CompilationErrors.TEMPLATE_CODE_GENERATION_HINT.getErrorCode());
    }

    public Optional<CodeActionInfo> codeActionInfo(CodeActionContext codeActionContext) {
        Diagnostic diagnostic = codeActionContext.diagnostic();
        if (diagnostic.location() == null) {
            return Optional.empty();
        }
        CodeActionArgument locationArg = CodeActionArgument.from((String)"node.location", (Object)diagnostic.location().lineRange());
        return Optional.of(CodeActionInfo.from((String)"Insert service template without caller", List.of(locationArg)));
    }

    public List<DocumentEdit> execute(CodeActionExecutionContext codeActionExecutionContext) {
        TextRange resourceTextRange;
        LineRange lineRange = null;
        for (CodeActionArgument argument : codeActionExecutionContext.arguments()) {
            if (!"node.location".equals(argument.key())) continue;
            lineRange = (LineRange)argument.valueAs(LineRange.class);
        }
        if (lineRange == null) {
            return Collections.emptyList();
        }
        SyntaxTree syntaxTree = codeActionExecutionContext.currentDocument().syntaxTree();
        NonTerminalNode node = PluginUtils.findNode(syntaxTree, lineRange);
        if (!(node instanceof ServiceDeclarationNode)) {
            return Collections.emptyList();
        }
        ServiceDeclarationNode serviceDeclarationNode = (ServiceDeclarationNode)node;
        ArrayList<TextEdit> textEdits = new ArrayList<TextEdit>();
        if (serviceDeclarationNode.members().isEmpty()) {
            resourceTextRange = TextRange.from((int)serviceDeclarationNode.openBraceToken().textRange().endOffset(), (int)(serviceDeclarationNode.closeBraceToken().textRange().startOffset() - serviceDeclarationNode.openBraceToken().textRange().endOffset()));
        } else {
            Node lastMember = serviceDeclarationNode.members().get(serviceDeclarationNode.members().size() - 1);
            resourceTextRange = TextRange.from((int)lastMember.textRange().endOffset(), (int)(serviceDeclarationNode.closeBraceToken().textRange().startOffset() - lastMember.textRange().endOffset()));
        }
        textEdits.add(TextEdit.from((TextRange)resourceTextRange, (String)REMOTE_FUNCTION_TEXT));
        TextDocumentChange change = TextDocumentChange.from((TextEdit[])textEdits.toArray(new TextEdit[0]));
        return Collections.singletonList(new DocumentEdit(codeActionExecutionContext.fileUri(), SyntaxTree.from((SyntaxTree)syntaxTree, (TextDocumentChange)change)));
    }

    public String name() {
        return "ADD_REMOTE_FUNCTION_CODE_SNIPPET_WITHOUT_CALLER";
    }
}

