/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.ftp.plugin;

import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.ftp.plugin.PluginConstants;
import io.ballerina.stdlib.ftp.plugin.PluginUtils;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import java.util.Objects;
import java.util.Optional;

public class FtpContentFunctionValidator {
    private final SyntaxNodeAnalysisContext syntaxNodeAnalysisContext;
    private final FunctionDefinitionNode contentFunctionDefinitionNode;
    private final String contentMethodName;

    public FtpContentFunctionValidator(SyntaxNodeAnalysisContext syntaxNodeAnalysisContext, FunctionDefinitionNode contentFunctionDefinitionNode, String contentMethodName) {
        this.syntaxNodeAnalysisContext = syntaxNodeAnalysisContext;
        this.contentFunctionDefinitionNode = contentFunctionDefinitionNode;
        this.contentMethodName = contentMethodName;
    }

    public void validate() {
        if (Objects.isNull(this.contentFunctionDefinitionNode)) {
            return;
        }
        if (!PluginUtils.isRemoteFunction(this.syntaxNodeAnalysisContext, this.contentFunctionDefinitionNode)) {
            this.reportErrorDiagnostic(PluginConstants.CompilationErrors.CONTENT_METHOD_MUST_BE_REMOTE, (Location)this.contentFunctionDefinitionNode.location(), this.contentMethodName);
        }
        SeparatedNodeList parameters = this.contentFunctionDefinitionNode.functionSignature().parameters();
        this.validateContentFunctionParameters((SeparatedNodeList<ParameterNode>)parameters, this.contentFunctionDefinitionNode);
        this.validateReturnTypeErrorOrNil(this.contentFunctionDefinitionNode);
    }

    private void validateContentFunctionParameters(SeparatedNodeList<ParameterNode> parameters, FunctionDefinitionNode functionDefinitionNode) {
        if (parameters.isEmpty()) {
            String expectedType = this.getExpectedContentType();
            this.reportErrorDiagnostic(PluginConstants.CompilationErrors.INVALID_CONTENT_PARAMETER_TYPE, (Location)functionDefinitionNode.location(), this.contentMethodName, expectedType, "none");
            return;
        }
        if (parameters.size() > 3) {
            this.reportErrorDiagnostic(PluginConstants.CompilationErrors.TOO_MANY_PARAMETERS, (Location)functionDefinitionNode.location(), this.contentMethodName);
            return;
        }
        ParameterNode firstParameter = (ParameterNode)parameters.get(0);
        if (!this.validateContentParameter(firstParameter)) {
            String expectedType = this.getExpectedContentType();
            String actualType = this.getActualParameterType(firstParameter);
            this.reportErrorDiagnostic(PluginConstants.CompilationErrors.INVALID_CONTENT_PARAMETER_TYPE, (Location)firstParameter.location(), this.contentMethodName, expectedType, actualType);
        }
        if (parameters.size() >= 2) {
            ParameterNode secondParameter = (ParameterNode)parameters.get(1);
            boolean isFileInfo = PluginUtils.validateFileInfoParameter(secondParameter, this.syntaxNodeAnalysisContext);
            boolean isCaller = PluginUtils.validateCallerParameter(secondParameter, this.syntaxNodeAnalysisContext);
            if (!isFileInfo && !isCaller) {
                this.reportErrorDiagnostic(PluginConstants.CompilationErrors.INVALID_FILEINFO_PARAMETER, (Location)secondParameter.location(), this.contentMethodName);
            }
            if (parameters.size() == 3) {
                ParameterNode thirdParameter = (ParameterNode)parameters.get(2);
                if (isFileInfo) {
                    if (!PluginUtils.validateCallerParameter(thirdParameter, this.syntaxNodeAnalysisContext)) {
                        this.reportErrorDiagnostic(PluginConstants.CompilationErrors.INVALID_CALLER_PARAMETER, (Location)thirdParameter.location());
                    }
                } else {
                    this.reportErrorDiagnostic(PluginConstants.CompilationErrors.TOO_MANY_PARAMETERS, (Location)thirdParameter.location(), this.contentMethodName);
                }
            }
        }
    }

    private boolean validateContentParameter(ParameterNode parameterNode) {
        Optional<TypeSymbol> typeSymbolOpt = PluginUtils.getParameterTypeSymbol(parameterNode, this.syntaxNodeAnalysisContext);
        if (typeSymbolOpt.isEmpty()) {
            return false;
        }
        TypeSymbol typeSymbol = typeSymbolOpt.get();
        TypeDescKind typeKind = typeSymbol.typeKind();
        switch (this.contentMethodName) {
            case "onFile": {
                return this.validateOnFileContentType(typeKind, typeSymbol);
            }
            case "onFileText": {
                return typeKind == TypeDescKind.STRING;
            }
            case "onFileJson": {
                return typeKind == TypeDescKind.JSON || typeKind == TypeDescKind.RECORD || this.isRecordTypeReference(typeSymbol);
            }
            case "onFileXml": {
                return typeKind == TypeDescKind.XML || typeKind == TypeDescKind.RECORD || this.isRecordTypeReference(typeSymbol);
            }
            case "onFileCsv": {
                return this.validateOnFileCsvContentType(typeKind, typeSymbol);
            }
        }
        return false;
    }

    private boolean validateOnFileContentType(TypeDescKind typeKind, TypeSymbol typeSymbol) {
        if (typeKind == TypeDescKind.ARRAY) {
            return this.isByteArray(typeSymbol);
        }
        if (typeKind == TypeDescKind.STREAM) {
            return this.isByteStream(typeSymbol);
        }
        return false;
    }

    private boolean validateOnFileCsvContentType(TypeDescKind typeKind, TypeSymbol typeSymbol) {
        if (typeKind == TypeDescKind.ARRAY) {
            return this.isStringArrayArray(typeSymbol) || this.isRecordArray(typeSymbol);
        }
        if (typeKind == TypeDescKind.STREAM) {
            return this.isByteStream(typeSymbol);
        }
        return false;
    }

    private boolean isByteArray(TypeSymbol typeSymbol) {
        return typeSymbol.signature().equals("byte[]");
    }

    private boolean isByteStream(TypeSymbol typeSymbol) {
        return typeSymbol.signature().contains("stream<byte[]");
    }

    private boolean isStringArrayArray(TypeSymbol typeSymbol) {
        return typeSymbol.signature().equals("string[][]");
    }

    private boolean isRecordArray(TypeSymbol typeSymbol) {
        String signature = typeSymbol.signature();
        return signature.contains("record") && signature.endsWith("[]");
    }

    private boolean isRecordTypeReference(TypeSymbol typeSymbol) {
        if (typeSymbol.typeKind() == TypeDescKind.TYPE_REFERENCE) {
            TypeSymbol referredType = ((TypeReferenceTypeSymbol)typeSymbol).typeDescriptor();
            return referredType != null && referredType.typeKind() == TypeDescKind.RECORD;
        }
        return false;
    }

    private void validateReturnTypeErrorOrNil(FunctionDefinitionNode functionDefinitionNode) {
        PluginUtils.validateReturnTypeErrorOrNil(functionDefinitionNode, this.syntaxNodeAnalysisContext);
    }

    private String getExpectedContentType() {
        return switch (this.contentMethodName) {
            case "onFile" -> "byte[] or stream<byte[], error?>";
            case "onFileText" -> "string";
            case "onFileJson" -> "json or record type";
            case "onFileXml" -> "xml or record type";
            case "onFileCsv" -> "string[][], record{}[], or stream<byte[], error?>";
            default -> "unknown";
        };
    }

    private String getActualParameterType(ParameterNode parameterNode) {
        return PluginUtils.getParameterTypeSignature(parameterNode, this.syntaxNodeAnalysisContext);
    }

    public void reportErrorDiagnostic(PluginConstants.CompilationErrors error, Location location) {
        this.syntaxNodeAnalysisContext.reportDiagnostic(PluginUtils.getDiagnostic(error, DiagnosticSeverity.ERROR, location));
    }

    public void reportErrorDiagnostic(PluginConstants.CompilationErrors error, Location location, Object ... args) {
        this.syntaxNodeAnalysisContext.reportDiagnostic(PluginUtils.getDiagnostic(error, DiagnosticSeverity.ERROR, location, args));
    }
}

