/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.ftp.plugin;

import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.ftp.plugin.PluginConstants;
import io.ballerina.stdlib.ftp.plugin.PluginUtils;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import java.util.Objects;

public class FtpFileDeletedValidator {
    private final SyntaxNodeAnalysisContext syntaxNodeAnalysisContext;
    private final FunctionDefinitionNode onFileDeletedFunctionDefinitionNode;

    public FtpFileDeletedValidator(SyntaxNodeAnalysisContext syntaxNodeAnalysisContext, FunctionDefinitionNode onFileDeletedFunctionDefinitionNode) {
        this.syntaxNodeAnalysisContext = syntaxNodeAnalysisContext;
        this.onFileDeletedFunctionDefinitionNode = onFileDeletedFunctionDefinitionNode;
    }

    public void validate() {
        if (Objects.isNull(this.onFileDeletedFunctionDefinitionNode)) {
            return;
        }
        if (!PluginUtils.isRemoteFunction(this.syntaxNodeAnalysisContext, this.onFileDeletedFunctionDefinitionNode)) {
            this.reportErrorDiagnostic(PluginConstants.CompilationErrors.ON_FILE_DELETED_MUST_BE_REMOTE, (Location)this.onFileDeletedFunctionDefinitionNode.location());
        }
        SeparatedNodeList parameters = this.onFileDeletedFunctionDefinitionNode.functionSignature().parameters();
        this.validateOnFileDeletedParameters((SeparatedNodeList<ParameterNode>)parameters, this.onFileDeletedFunctionDefinitionNode);
        this.validateReturnTypeErrorOrNil(this.onFileDeletedFunctionDefinitionNode);
    }

    private void validateOnFileDeletedParameters(SeparatedNodeList<ParameterNode> parameters, FunctionDefinitionNode functionDefinitionNode) {
        ParameterNode secondParameter;
        if (parameters.isEmpty()) {
            this.reportErrorDiagnostic(PluginConstants.CompilationErrors.INVALID_ON_FILE_DELETED_PARAMETER, (Location)functionDefinitionNode.location());
            return;
        }
        if (parameters.size() > 2) {
            this.reportErrorDiagnostic(PluginConstants.CompilationErrors.TOO_MANY_PARAMETERS_ON_FILE_DELETED, (Location)functionDefinitionNode.location());
            return;
        }
        ParameterNode firstParameter = (ParameterNode)parameters.get(0);
        if (!this.validateStringArrayParameter(firstParameter)) {
            this.reportErrorDiagnostic(PluginConstants.CompilationErrors.INVALID_ON_FILE_DELETED_PARAMETER, (Location)firstParameter.location());
        }
        if (parameters.size() == 2 && !PluginUtils.validateCallerParameter(secondParameter = (ParameterNode)parameters.get(1), this.syntaxNodeAnalysisContext)) {
            this.reportErrorDiagnostic(PluginConstants.CompilationErrors.INVALID_ON_FILE_DELETED_CALLER_PARAMETER, (Location)secondParameter.location());
        }
    }

    private boolean validateStringArrayParameter(ParameterNode parameterNode) {
        return PluginUtils.getParameterTypeSymbol(parameterNode, this.syntaxNodeAnalysisContext).map(typeSymbol -> typeSymbol.typeKind() == TypeDescKind.ARRAY && typeSymbol.signature().equals("string[]")).orElse(false);
    }

    private void validateReturnTypeErrorOrNil(FunctionDefinitionNode functionDefinitionNode) {
        PluginUtils.validateReturnTypeErrorOrNil(functionDefinitionNode, this.syntaxNodeAnalysisContext);
    }

    public void reportErrorDiagnostic(PluginConstants.CompilationErrors error, Location location) {
        this.syntaxNodeAnalysisContext.reportDiagnostic(PluginUtils.getDiagnostic(error, DiagnosticSeverity.ERROR, location));
    }
}

