/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.ftp.plugin;

import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.ftp.plugin.FtpContentFunctionValidator;
import io.ballerina.stdlib.ftp.plugin.FtpFileDeletedValidator;
import io.ballerina.stdlib.ftp.plugin.FtpFunctionValidator;
import io.ballerina.stdlib.ftp.plugin.PluginConstants;
import io.ballerina.stdlib.ftp.plugin.PluginUtils;
import io.ballerina.tools.diagnostics.DiagnosticFactory;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class FtpServiceValidator {
    public void validate(SyntaxNodeAnalysisContext context) {
        ServiceDeclarationNode serviceDeclarationNode = (ServiceDeclarationNode)context.node();
        NodeList memberNodes = serviceDeclarationNode.members();
        boolean hasRemoteFunction = serviceDeclarationNode.members().stream().anyMatch(child -> child.kind() == SyntaxKind.OBJECT_METHOD_DEFINITION && PluginUtils.isRemoteFunction(context, (FunctionDefinitionNode)child));
        if (serviceDeclarationNode.members().isEmpty() || !hasRemoteFunction) {
            DiagnosticInfo diagnosticInfo = new DiagnosticInfo(PluginConstants.CompilationErrors.TEMPLATE_CODE_GENERATION_HINT.getErrorCode(), PluginConstants.CompilationErrors.TEMPLATE_CODE_GENERATION_HINT.getError(), DiagnosticSeverity.INTERNAL);
            context.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)serviceDeclarationNode.location(), (Object[])new Object[0]));
        }
        FunctionDefinitionNode onFileChange = null;
        FunctionDefinitionNode onFileDeleted = null;
        ArrayList<FunctionDefinitionNode> contentMethods = new ArrayList<FunctionDefinitionNode>();
        ArrayList<String> contentMethodNames = new ArrayList<String>();
        for (Node node : memberNodes) {
            if (node.kind() == SyntaxKind.OBJECT_METHOD_DEFINITION) {
                FunctionDefinitionNode functionDefinitionNode = (FunctionDefinitionNode)node;
                MethodSymbol methodSymbol = PluginUtils.getMethodSymbol(context, functionDefinitionNode);
                Optional functionName = methodSymbol.getName();
                if (!functionName.isPresent()) continue;
                String funcName = (String)functionName.get();
                if (funcName.equals("onFileChange")) {
                    onFileChange = functionDefinitionNode;
                    continue;
                }
                if (funcName.equals("onFileDeleted")) {
                    onFileDeleted = functionDefinitionNode;
                    continue;
                }
                if (this.isContentMethod(funcName)) {
                    contentMethods.add(functionDefinitionNode);
                    contentMethodNames.add(funcName);
                    continue;
                }
                if (!PluginUtils.isRemoteFunction(context, functionDefinitionNode)) continue;
                context.reportDiagnostic(PluginUtils.getDiagnostic(PluginConstants.CompilationErrors.INVALID_REMOTE_FUNCTION, DiagnosticSeverity.ERROR, (Location)functionDefinitionNode.location()));
                continue;
            }
            if (node.kind() != SyntaxKind.RESOURCE_ACCESSOR_DEFINITION) continue;
            context.reportDiagnostic(PluginUtils.getDiagnostic(PluginConstants.CompilationErrors.RESOURCE_FUNCTION_NOT_ALLOWED, DiagnosticSeverity.ERROR, (Location)node.location()));
        }
        this.validateMethodExclusivity(context, serviceDeclarationNode, onFileChange, onFileDeleted, contentMethods, contentMethodNames);
        if (onFileChange != null && contentMethods.isEmpty() && onFileDeleted == null) {
            new FtpFunctionValidator(context, onFileChange).validate();
        } else if (!(onFileChange != null || contentMethods.isEmpty() && onFileDeleted == null)) {
            for (int i = 0; i < contentMethods.size(); ++i) {
                new FtpContentFunctionValidator(context, (FunctionDefinitionNode)contentMethods.get(i), (String)contentMethodNames.get(i)).validate();
            }
            if (onFileDeleted != null) {
                new FtpFileDeletedValidator(context, onFileDeleted).validate();
            }
        } else if (onFileChange == null && contentMethods.isEmpty() && onFileDeleted == null) {
            context.reportDiagnostic(PluginUtils.getDiagnostic(PluginConstants.CompilationErrors.NO_ON_FILE_CHANGE, DiagnosticSeverity.ERROR, (Location)serviceDeclarationNode.location()));
        }
    }

    private boolean isContentMethod(String methodName) {
        return methodName.equals("onFile") || methodName.equals("onFileText") || methodName.equals("onFileJson") || methodName.equals("onFileXml") || methodName.equals("onFileCsv");
    }

    private void validateMethodExclusivity(SyntaxNodeAnalysisContext context, ServiceDeclarationNode serviceDeclarationNode, FunctionDefinitionNode onFileChange, FunctionDefinitionNode onFileDeleted, List<FunctionDefinitionNode> contentMethods, List<String> contentMethodNames) {
        long onFileCount;
        if (!(onFileChange == null || contentMethods.isEmpty() && onFileDeleted == null)) {
            context.reportDiagnostic(PluginUtils.getDiagnostic(PluginConstants.CompilationErrors.MULTIPLE_CONTENT_METHODS, DiagnosticSeverity.ERROR, (Location)serviceDeclarationNode.location()));
            return;
        }
        if (!contentMethods.isEmpty() && (onFileCount = contentMethodNames.stream().filter(name -> name.equals("onFile")).count()) > 1L) {
            context.reportDiagnostic(PluginUtils.getDiagnostic(PluginConstants.CompilationErrors.MULTIPLE_GENERIC_CONTENT_METHODS, DiagnosticSeverity.ERROR, (Location)serviceDeclarationNode.location()));
        }
    }
}

