/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.ftp.plugin;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.ftp.plugin.PluginConstants;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticFactory;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.LineRange;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextRange;
import java.util.List;
import java.util.Optional;

public final class PluginUtils {
    private PluginUtils() {
    }

    public static Diagnostic getDiagnostic(PluginConstants.CompilationErrors error, DiagnosticSeverity severity, Location location) {
        String errorMessage = error.getError();
        String diagnosticCode = error.getErrorCode();
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(diagnosticCode, errorMessage, severity);
        return DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)location, (Object[])new Object[0]);
    }

    public static Diagnostic getDiagnostic(PluginConstants.CompilationErrors error, DiagnosticSeverity severity, Location location, Object ... args) {
        String errorTemplate = error.getError();
        String errorMessage = String.format(errorTemplate, args);
        String diagnosticCode = error.getErrorCode();
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(diagnosticCode, errorMessage, severity);
        return DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)location, (Object[])new Object[0]);
    }

    public static boolean validateModuleId(ModuleSymbol moduleSymbol) {
        if (moduleSymbol != null) {
            String moduleName = moduleSymbol.id().moduleName();
            String orgName = moduleSymbol.id().orgName();
            return moduleName.equals("ftp") && orgName.equals("ballerina");
        }
        return false;
    }

    public static boolean isRemoteFunction(SyntaxNodeAnalysisContext context, FunctionDefinitionNode functionDefinitionNode) {
        MethodSymbol methodSymbol = PluginUtils.getMethodSymbol(context, functionDefinitionNode);
        return methodSymbol.qualifiers().contains(Qualifier.REMOTE);
    }

    public static MethodSymbol getMethodSymbol(SyntaxNodeAnalysisContext context, FunctionDefinitionNode functionDefinitionNode) {
        MethodSymbol methodSymbol = null;
        SemanticModel semanticModel = context.semanticModel();
        Optional symbol = semanticModel.symbol((Node)functionDefinitionNode);
        if (symbol.isPresent()) {
            methodSymbol = (MethodSymbol)symbol.get();
        }
        return methodSymbol;
    }

    public static NonTerminalNode findNode(SyntaxTree syntaxTree, LineRange lineRange) {
        if (lineRange == null) {
            return null;
        }
        TextDocument textDocument = syntaxTree.textDocument();
        int start = textDocument.textPositionFrom(lineRange.startLine());
        int end = textDocument.textPositionFrom(lineRange.endLine());
        return ((ModulePartNode)syntaxTree.rootNode()).findNode(TextRange.from((int)start, (int)(end - start)), true);
    }

    public static boolean validateFileInfoParameter(ParameterNode parameterNode, SyntaxNodeAnalysisContext context) {
        return PluginUtils.validateQualifiedFtpParameter(parameterNode, context, "FileInfo");
    }

    public static boolean validateCallerParameter(ParameterNode parameterNode, SyntaxNodeAnalysisContext context) {
        return PluginUtils.validateQualifiedFtpParameter(parameterNode, context, "Caller");
    }

    private static boolean validateQualifiedFtpParameter(ParameterNode parameterNode, SyntaxNodeAnalysisContext context, String expectedTypeName) {
        if (!(parameterNode instanceof RequiredParameterNode)) {
            return false;
        }
        RequiredParameterNode requiredParameterNode = (RequiredParameterNode)parameterNode;
        if (requiredParameterNode.typeName().kind() != SyntaxKind.QUALIFIED_NAME_REFERENCE) {
            return false;
        }
        Optional<TypeSymbol> typeSymbol = PluginUtils.getParameterTypeSymbol(parameterNode, context);
        if (typeSymbol.isEmpty()) {
            return false;
        }
        Optional moduleSymbol = typeSymbol.get().getModule();
        if (moduleSymbol.isEmpty() || !PluginUtils.validateModuleId((ModuleSymbol)moduleSymbol.get())) {
            return false;
        }
        return typeSymbol.get().getName().map(expectedTypeName::equals).orElse(false);
    }

    public static Optional<TypeSymbol> getParameterTypeSymbol(ParameterNode parameterNode, SyntaxNodeAnalysisContext context) {
        Object t;
        if (!(parameterNode instanceof RequiredParameterNode)) {
            return Optional.empty();
        }
        RequiredParameterNode requiredParameterNode = (RequiredParameterNode)parameterNode;
        SemanticModel semanticModel = context.semanticModel();
        Optional symbol = semanticModel.symbol((Node)requiredParameterNode);
        if (symbol.isEmpty() || !((t = symbol.get()) instanceof ParameterSymbol)) {
            return Optional.empty();
        }
        ParameterSymbol parameterSymbol = (ParameterSymbol)t;
        return Optional.ofNullable(parameterSymbol.typeDescriptor());
    }

    public static String getParameterTypeSignature(ParameterNode parameterNode, SyntaxNodeAnalysisContext context) {
        return PluginUtils.getParameterTypeSymbol(parameterNode, context).map(TypeSymbol::signature).orElse("unknown");
    }

    public static void validateReturnTypeErrorOrNil(FunctionDefinitionNode functionDefinitionNode, SyntaxNodeAnalysisContext context) {
        MethodSymbol methodSymbol = PluginUtils.getMethodSymbol(context, functionDefinitionNode);
        if (methodSymbol == null) {
            return;
        }
        Optional returnTypeDesc = methodSymbol.typeDescriptor().returnTypeDescriptor();
        if (returnTypeDesc.isEmpty()) {
            return;
        }
        TypeDescKind returnTypeKind = ((TypeSymbol)returnTypeDesc.get()).typeKind();
        if (returnTypeKind == TypeDescKind.NIL) {
            return;
        }
        if (returnTypeKind == TypeDescKind.UNION) {
            List returnTypeMembers = ((UnionTypeSymbol)returnTypeDesc.get()).memberTypeDescriptors();
            for (TypeSymbol returnType : returnTypeMembers) {
                if (returnType.typeKind() == TypeDescKind.NIL) continue;
                if (returnType.typeKind() == TypeDescKind.TYPE_REFERENCE) {
                    if (returnType.signature().equals("error") || !returnType.getModule().isPresent() || PluginUtils.validateModuleId((ModuleSymbol)returnType.getModule().get())) continue;
                    context.reportDiagnostic(PluginUtils.getDiagnostic(PluginConstants.CompilationErrors.INVALID_RETURN_TYPE_ERROR_OR_NIL, DiagnosticSeverity.ERROR, (Location)functionDefinitionNode.functionSignature().location()));
                    return;
                }
                if (returnType.typeKind() == TypeDescKind.ERROR) continue;
                context.reportDiagnostic(PluginUtils.getDiagnostic(PluginConstants.CompilationErrors.INVALID_RETURN_TYPE_ERROR_OR_NIL, DiagnosticSeverity.ERROR, (Location)functionDefinitionNode.functionSignature().location()));
                return;
            }
        } else {
            context.reportDiagnostic(PluginUtils.getDiagnostic(PluginConstants.CompilationErrors.INVALID_RETURN_TYPE_ERROR_OR_NIL, DiagnosticSeverity.ERROR, (Location)functionDefinitionNode.functionSignature().location()));
        }
    }
}

