/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.AnnotationAttachmentSymbol;
import io.ballerina.compiler.api.symbols.AnnotationSymbol;
import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.FunctionTypeSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.ObjectTypeSymbol;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.flowmodelgenerator.core.model.AvailableNode;
import io.ballerina.flowmodelgenerator.core.model.Codedata;
import io.ballerina.flowmodelgenerator.core.model.FlowNode;
import io.ballerina.flowmodelgenerator.core.model.FormBuilder;
import io.ballerina.flowmodelgenerator.core.model.NodeBuilder;
import io.ballerina.flowmodelgenerator.core.model.NodeKind;
import io.ballerina.flowmodelgenerator.core.model.Property;
import io.ballerina.flowmodelgenerator.core.model.PropertyCodedata;
import io.ballerina.flowmodelgenerator.core.model.SourceBuilder;
import io.ballerina.flowmodelgenerator.core.utils.FlowNodeUtil;
import io.ballerina.modelgenerator.commons.CommonUtils;
import io.ballerina.modelgenerator.commons.FunctionData;
import io.ballerina.modelgenerator.commons.FunctionDataBuilder;
import io.ballerina.modelgenerator.commons.PackageUtil;
import io.ballerina.modelgenerator.commons.ParameterData;
import io.ballerina.projects.Document;
import io.ballerina.projects.Package;
import io.ballerina.projects.Project;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocumentChange;
import io.ballerina.tools.text.TextEdit;
import io.ballerina.tools.text.TextRange;
import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;

public class AgentsGenerator {
    public static final String MODEL = "ModelProvider";
    public static final String TOOL_ANNOTATION = "AgentTool";
    public static final String MEMORY = "Memory";
    public static final String TARGET_TYPE = "targetType";
    private final Gson gson = new Gson();
    private final SemanticModel semanticModel;
    private static final String BALLERINAX = "ballerinax";
    private static final String AI_AGENT = "ai";
    private static final String INIT = "init";
    private static final String AGENT_FILE = "agents.bal";
    public static final String AGENT = "Agent";
    private static final String BALLERINA_ORG = "ballerina";
    private static final String HTTP_MODULE = "http";
    private static final List<String> HTTP_REMOTE_METHOD_SKIP_LIST = List.of("get", "put", "post", "head", "delete", "patch", "options");

    public AgentsGenerator() {
        this.semanticModel = null;
    }

    public AgentsGenerator(SemanticModel semanticModel) {
        this.semanticModel = semanticModel;
    }

    public JsonArray getAllAgents(SemanticModel agentSymbol) {
        ArrayList<Codedata> agents = new ArrayList<Codedata>();
        for (Symbol symbol : agentSymbol.moduleSymbols()) {
            ClassSymbol classSymbol;
            if (symbol.kind() != SymbolKind.CLASS || !(classSymbol = (ClassSymbol)symbol).qualifiers().contains(Qualifier.CLIENT) || !classSymbol.getName().orElse("").equals(AGENT)) continue;
            Optional optModule = classSymbol.getModule();
            if (optModule.isEmpty()) {
                throw new IllegalStateException("Agent module id not found");
            }
            ModuleID id = ((ModuleSymbol)optModule.get()).id();
            agents.add(new Codedata.Builder<Object>(null).node(NodeKind.AGENT).org(id.orgName()).module(id.packageName()).version(id.version()).object(classSymbol.getName().orElse(AGENT)).symbol(INIT).build());
        }
        return this.gson.toJsonTree(agents).getAsJsonArray();
    }

    public JsonArray getAllModels(SemanticModel agentSymbol) {
        ArrayList<ClassSymbol> modelSymbols = new ArrayList<ClassSymbol>();
        block0: for (Symbol symbol : agentSymbol.moduleSymbols()) {
            ClassSymbol classSymbol;
            if (symbol.kind() != SymbolKind.CLASS || !(classSymbol = (ClassSymbol)symbol).qualifiers().contains(Qualifier.CLIENT)) continue;
            List inclusionsTypes = classSymbol.typeInclusions();
            for (TypeSymbol typeSymbol : inclusionsTypes) {
                if (!typeSymbol.getName().isPresent() || !((String)typeSymbol.getName().get()).equals(MODEL)) continue;
                modelSymbols.add(classSymbol);
                continue block0;
            }
        }
        ArrayList<Codedata> models = new ArrayList<Codedata>();
        for (ClassSymbol model : modelSymbols) {
            Optional optModule = model.getModule();
            if (optModule.isEmpty()) {
                throw new IllegalStateException("Agent module id not found");
            }
            ModuleID id = ((ModuleSymbol)optModule.get()).id();
            models.add(new Codedata.Builder<Object>(null).node(NodeKind.CLASS_INIT).org(id.orgName()).module(id.packageName()).version(id.version()).object(model.getName().orElse(MODEL)).symbol(INIT).build());
        }
        return this.gson.toJsonTree(models).getAsJsonArray();
    }

    public JsonArray getAllMemoryManagers(SemanticModel agentSymbol) {
        ArrayList<ClassSymbol> memoryManagerSymbols = new ArrayList<ClassSymbol>();
        block0: for (Symbol symbol : agentSymbol.moduleSymbols()) {
            if (symbol.kind() != SymbolKind.CLASS) continue;
            ClassSymbol classSymbol = (ClassSymbol)symbol;
            List inclusionsTypes = classSymbol.typeInclusions();
            for (TypeSymbol typeSymbol : inclusionsTypes) {
                if (!typeSymbol.getName().isPresent() || !((String)typeSymbol.getName().get()).equals(MEMORY)) continue;
                memoryManagerSymbols.add(classSymbol);
                continue block0;
            }
        }
        ArrayList<Codedata> models = new ArrayList<Codedata>();
        for (ClassSymbol model : memoryManagerSymbols) {
            Optional optModule = model.getModule();
            if (optModule.isEmpty()) {
                throw new IllegalStateException("Memory Manager module id not found");
            }
            ModuleID id = ((ModuleSymbol)optModule.get()).id();
            models.add(new Codedata.Builder<Object>(null).node(NodeKind.CLASS_INIT).org(id.orgName()).module(id.packageName()).version(id.version()).object(model.getName().orElse(MEMORY)).symbol(INIT).build());
        }
        return this.gson.toJsonTree(models).getAsJsonArray();
    }

    public JsonArray getModels() {
        List moduleSymbols = this.semanticModel.moduleSymbols();
        ArrayList<String> models = new ArrayList<String>();
        for (Symbol moduleSymbol : moduleSymbols) {
            VariableSymbol variableSymbol;
            TypeSymbol typeSymbol;
            if (moduleSymbol.kind() != SymbolKind.VARIABLE || (typeSymbol = CommonUtils.getRawType((TypeSymbol)(variableSymbol = (VariableSymbol)moduleSymbol).typeDescriptor())).kind() != SymbolKind.CLASS) continue;
            List typeInclusions = ((ClassSymbol)typeSymbol).typeInclusions();
            for (TypeSymbol typeInclusion : typeInclusions) {
                Optional optName = typeInclusion.getName();
                if (!optName.isPresent() || !((String)optName.get()).equals(MODEL)) continue;
                models.add(variableSymbol.getName().orElse(""));
            }
        }
        return this.gson.toJsonTree(models).getAsJsonArray();
    }

    public JsonArray getTools(SemanticModel semanticModel) {
        List moduleSymbols = semanticModel.moduleSymbols();
        ArrayList<String> functionNames = new ArrayList<String>();
        TypeSymbol anydata = semanticModel.types().ANYDATA;
        for (Symbol moduleSymbol : moduleSymbols) {
            Optional optReturnTypeSymbol;
            FunctionSymbol functionSymbol;
            if (moduleSymbol.kind() != SymbolKind.FUNCTION || !(functionSymbol = (FunctionSymbol)moduleSymbol).qualifiers().contains(Qualifier.ISOLATED)) continue;
            FunctionTypeSymbol functionTypeSymbol = functionSymbol.typeDescriptor();
            Optional optParams = functionTypeSymbol.params();
            if (optParams.isPresent()) {
                boolean isAnydataSubType = true;
                for (ParameterSymbol parameterSymbol : (List)optParams.get()) {
                    if (CommonUtils.subTypeOf((TypeSymbol)parameterSymbol.typeDescriptor(), (TypeSymbol)anydata)) continue;
                    isAnydataSubType = false;
                    break;
                }
                if (!isAnydataSubType) continue;
            }
            if ((optReturnTypeSymbol = functionTypeSymbol.returnTypeDescriptor()).isPresent() && !CommonUtils.subTypeOf((TypeSymbol)((TypeSymbol)optReturnTypeSymbol.get()), (TypeSymbol)anydata) || !this.isToolAnnotated(functionSymbol)) continue;
            functionNames.add(moduleSymbol.getName().orElse(""));
        }
        return this.gson.toJsonTree(functionNames).getAsJsonArray();
    }

    public JsonElement genTool(JsonElement node, String toolName, String connectionName, String description, Path filePath, WorkspaceManager workspaceManager) {
        FlowNode flowNode = (FlowNode)this.gson.fromJson(node, FlowNode.class);
        NodeKind nodeKind = flowNode.codedata().node();
        SourceBuilder sourceBuilder = new SourceBuilder(flowNode, workspaceManager, filePath);
        ArrayList<String> args = new ArrayList<String>();
        String path = flowNode.metadata().icon();
        if (nodeKind == NodeKind.FUNCTION_DEFINITION) {
            Optional<Property> optFuncName;
            boolean hasReturn;
            Object object;
            if (description != null && !description.isEmpty()) {
                sourceBuilder.token().descriptionDoc(description);
            }
            sourceBuilder.token().name("@ai:AgentTool").name(System.lineSeparator());
            sourceBuilder.token().name("@display {").name("label: \"\",").name("iconPath: \"").name(path == null ? "" : path).name("\"}").name(System.lineSeparator());
            sourceBuilder.token().keyword(SyntaxKind.ISOLATED_KEYWORD).keyword(SyntaxKind.FUNCTION_KEYWORD);
            sourceBuilder.token().name(toolName).keyword(SyntaxKind.OPEN_PAREN_TOKEN);
            Optional<Property> parameters = flowNode.getProperty("parameters");
            if (parameters.isPresent() && (object = parameters.get().value()) instanceof Map) {
                Map paramMap = (Map)object;
                ArrayList<CallSite> paramList = new ArrayList<CallSite>();
                for (Object obj : paramMap.values()) {
                    Property paramProperty = (Property)this.gson.fromJson(this.gson.toJsonTree(obj), Property.class);
                    Object object2 = paramProperty.value();
                    if (!(object2 instanceof Map)) continue;
                    Map paramData = (Map)object2;
                    Map paramProperties = (Map)this.gson.fromJson(this.gson.toJsonTree((Object)paramData), FormBuilder.NODE_PROPERTIES_TYPE);
                    String paramType = ((Property)paramProperties.get("type")).value().toString();
                    String paramName = ((Property)paramProperties.get("variable")).value().toString();
                    args.add(paramName);
                    paramList.add((CallSite)((Object)(paramType + " " + paramName)));
                }
                sourceBuilder.token().name(String.join((CharSequence)", ", paramList));
            }
            sourceBuilder.token().keyword(SyntaxKind.CLOSE_PAREN_TOKEN);
            Optional<Property> returnType = flowNode.getProperty("type");
            boolean bl = hasReturn = returnType.isPresent() && !returnType.get().value().toString().isEmpty();
            if (hasReturn) {
                sourceBuilder.token().keyword(SyntaxKind.RETURNS_KEYWORD).name(returnType.get().value().toString());
            }
            sourceBuilder.token().keyword(SyntaxKind.OPEN_BRACE_TOKEN);
            if (hasReturn) {
                sourceBuilder.token().name(returnType.get().value().toString()).whiteSpace().name("result").whiteSpace().keyword(SyntaxKind.EQUAL_TOKEN);
            }
            if ((optFuncName = flowNode.getProperty("functionName")).isEmpty()) {
                throw new IllegalStateException("Function name is not present");
            }
            sourceBuilder.token().name(optFuncName.get().value().toString()).keyword(SyntaxKind.OPEN_PAREN_TOKEN);
            sourceBuilder.token().name(String.join((CharSequence)", ", args)).keyword(SyntaxKind.CLOSE_PAREN_TOKEN).endOfStatement();
            if (hasReturn) {
                sourceBuilder.token().keyword(SyntaxKind.RETURN_KEYWORD).name("result").endOfStatement();
            }
            sourceBuilder.token().keyword(SyntaxKind.CLOSE_BRACE_TOKEN);
            sourceBuilder.textEdit().acceptImport();
            Map<Path, List<org.eclipse.lsp4j.TextEdit>> textEdits = sourceBuilder.build();
            ArrayList<org.eclipse.lsp4j.TextEdit> te = new ArrayList<org.eclipse.lsp4j.TextEdit>();
            Path p = this.addIsolateKeyword(optFuncName.get().value().toString().trim(), filePath, te, workspaceManager);
            if (p != null) {
                textEdits.put(p, te);
            }
            return this.gson.toJsonTree(textEdits);
        }
        if (nodeKind == NodeKind.REMOTE_ACTION_CALL) {
            boolean hasDescription = this.genDescription(description, flowNode, sourceBuilder);
            Map<String, Property> properties = flowNode.properties();
            LinkedHashSet keys = new LinkedHashSet(properties != null ? properties.keySet() : Set.of());
            HashSet<String> ignoredKeys = new HashSet<String>(List.of("variable", "type", TARGET_TYPE, "connection", "checkError"));
            keys.removeAll(ignoredKeys);
            ArrayList<CallSite> paramList = new ArrayList<CallSite>();
            for (String k : keys) {
                String string;
                PropertyCodedata codedata;
                Property property = properties.get(k);
                if (property == null) continue;
                Object key = k;
                if (k.startsWith("$")) {
                    key = "'" + k.substring(1);
                }
                if ((codedata = property.codedata()) != null && (string = codedata.kind()) != null && string.equals(ParameterData.Kind.DEFAULTABLE.name())) {
                    ignoredKeys.add((String)key);
                    continue;
                }
                if (hasDescription) {
                    sourceBuilder.token().parameterDoc((String)key, property.metadata().description());
                }
                String string2 = property.valueTypeConstraint().toString();
                paramList.add((CallSite)((Object)(string2 + " " + (String)key)));
            }
            Optional<Property> optReturnType = flowNode.getProperty("type");
            String returnType = "";
            if (optReturnType.isPresent()) {
                Property returnProperty = optReturnType.get();
                returnType = flowNode.getProperty(TARGET_TYPE).isPresent() ? "json" : returnProperty.value().toString();
                sourceBuilder.token().returnDoc(returnProperty.metadata().description());
            }
            sourceBuilder.token().name("@ai:AgentTool").name(System.lineSeparator());
            sourceBuilder.token().name("@display {").name("label: \"\",").name("iconPath: \"").name(path == null ? "" : path).name("\"}").name(System.lineSeparator());
            sourceBuilder.token().keyword(SyntaxKind.ISOLATED_KEYWORD).keyword(SyntaxKind.FUNCTION_KEYWORD);
            sourceBuilder.token().name(toolName).keyword(SyntaxKind.OPEN_PAREN_TOKEN);
            sourceBuilder.token().name(String.join((CharSequence)", ", paramList));
            sourceBuilder.token().keyword(SyntaxKind.CLOSE_PAREN_TOKEN);
            if (!returnType.isEmpty()) {
                sourceBuilder.token().keyword(SyntaxKind.RETURNS_KEYWORD).name(returnType);
                if (FlowNodeUtil.hasCheckKeyFlagSet(flowNode)) {
                    sourceBuilder.token().keyword(SyntaxKind.PIPE_TOKEN).keyword(SyntaxKind.ERROR_KEYWORD);
                }
            }
            sourceBuilder.token().keyword(SyntaxKind.OPEN_BRACE_TOKEN);
            if (!returnType.isEmpty()) {
                sourceBuilder.token().expressionWithType(returnType, flowNode.getProperty("variable").orElseThrow()).keyword(SyntaxKind.EQUAL_TOKEN);
            }
            if (FlowNodeUtil.hasCheckKeyFlagSet(flowNode)) {
                sourceBuilder.token().keyword(SyntaxKind.CHECK_KEYWORD);
            }
            ((SourceBuilder)sourceBuilder.token().name(connectionName).keyword(SyntaxKind.RIGHT_ARROW_TOKEN).name(flowNode.metadata().label()).stepOut()).functionParameters(flowNode, ignoredKeys);
            if (!returnType.isEmpty()) {
                sourceBuilder.token().keyword(SyntaxKind.RETURN_KEYWORD).name(flowNode.getProperty("variable").get().value().toString()).endOfStatement();
            }
            sourceBuilder.token().keyword(SyntaxKind.CLOSE_BRACE_TOKEN);
            sourceBuilder.textEdit().acceptImport();
            return this.gson.toJsonTree(sourceBuilder.build());
        }
        if (nodeKind == NodeKind.RESOURCE_ACTION_CALL) {
            String resourcePath;
            boolean hasDescription = this.genDescription(description, flowNode, sourceBuilder);
            Map<String, Property> properties = flowNode.properties();
            LinkedHashSet keys = new LinkedHashSet(properties != null ? properties.keySet() : Set.of());
            HashSet<String> ignoredKeys = new HashSet<String>(List.of("connection", "variable", "type", TARGET_TYPE, "resourcePath", "checkError"));
            keys.removeAll(ignoredKeys);
            ArrayList<CallSite> paramList = new ArrayList<CallSite>();
            HashSet<Object> pathParams = new HashSet<Object>();
            for (String k : keys) {
                PropertyCodedata propertyCodedata;
                Property property = properties.get(k);
                if (property == null) continue;
                Object key = k;
                if (k.startsWith("$")) {
                    key = "'" + k.substring(1);
                }
                if ((propertyCodedata = property.codedata()) != null) {
                    String kind = propertyCodedata.kind();
                    if (kind.equals(ParameterData.Kind.PATH_PARAM.name()) || kind.equals(ParameterData.Kind.PATH_REST_PARAM.name())) {
                        pathParams.add(key);
                    } else if (kind.equals(ParameterData.Kind.DEFAULTABLE.name())) {
                        ignoredKeys.add((String)key);
                        continue;
                    }
                }
                if (hasDescription) {
                    sourceBuilder.token().parameterDoc((String)key, property.metadata().description());
                }
                String paramType = property.valueTypeConstraint().toString();
                paramList.add((CallSite)((Object)(paramType + " " + (String)key)));
            }
            sourceBuilder.token().name("@ai:AgentTool").name(System.lineSeparator());
            sourceBuilder.token().name("@display {").name("label: \"\",").name("iconPath: \"").name(path == null ? "" : path).name("\"}").name(System.lineSeparator());
            sourceBuilder.token().keyword(SyntaxKind.ISOLATED_KEYWORD).keyword(SyntaxKind.FUNCTION_KEYWORD);
            sourceBuilder.token().name(toolName).keyword(SyntaxKind.OPEN_PAREN_TOKEN);
            sourceBuilder.token().name(String.join((CharSequence)", ", paramList));
            sourceBuilder.token().keyword(SyntaxKind.CLOSE_PAREN_TOKEN);
            Optional<Property> optReturnType = flowNode.getProperty("type");
            String returnType = "";
            if (optReturnType.isPresent()) {
                returnType = flowNode.getProperty(TARGET_TYPE).isPresent() ? "json" : optReturnType.get().value().toString();
            }
            if (!returnType.isEmpty()) {
                sourceBuilder.token().keyword(SyntaxKind.RETURNS_KEYWORD).name(returnType);
                if (FlowNodeUtil.hasCheckKeyFlagSet(flowNode)) {
                    sourceBuilder.token().keyword(SyntaxKind.PIPE_TOKEN).keyword(SyntaxKind.ERROR_KEYWORD);
                }
            }
            sourceBuilder.token().keyword(SyntaxKind.OPEN_BRACE_TOKEN);
            if (!returnType.isEmpty()) {
                sourceBuilder.token().expressionWithType(returnType, flowNode.getProperty("variable").orElseThrow()).keyword(SyntaxKind.EQUAL_TOKEN);
            }
            if (FlowNodeUtil.hasCheckKeyFlagSet(flowNode)) {
                sourceBuilder.token().keyword(SyntaxKind.CHECK_KEYWORD);
            }
            if ((resourcePath = flowNode.properties().get("resourcePath").codedata().originalName()).equals("/path/to/subdirectory")) {
                resourcePath = flowNode.properties().get("resourcePath").value().toString();
            }
            for (String string : pathParams) {
                PropertyCodedata propCodedata;
                Optional<Property> property = flowNode.getProperty(string);
                if (property.isEmpty() || (propCodedata = property.get().codedata()) == null || !propCodedata.kind().equals(ParameterData.Kind.PATH_REST_PARAM.name())) continue;
                String replacement = property.get().value().toString();
                resourcePath = resourcePath.replace("/path/to/resource", replacement);
            }
            ignoredKeys.addAll(pathParams);
            ((SourceBuilder)sourceBuilder.token().name(connectionName).keyword(SyntaxKind.RIGHT_ARROW_TOKEN).resourcePath(resourcePath).keyword(SyntaxKind.DOT_TOKEN).name(sourceBuilder.flowNode.codedata().symbol()).stepOut()).functionParameters(flowNode, ignoredKeys);
            if (!returnType.isEmpty()) {
                sourceBuilder.token().keyword(SyntaxKind.RETURN_KEYWORD).name(flowNode.getProperty("variable").get().value().toString()).endOfStatement();
            }
            sourceBuilder.token().keyword(SyntaxKind.CLOSE_BRACE_TOKEN);
            sourceBuilder.textEdit().acceptImport();
            return this.gson.toJsonTree(sourceBuilder.build());
        }
        throw new IllegalStateException("Unsupported node kind to generate tool");
    }

    private boolean isToolAnnotated(FunctionSymbol functionSymbol) {
        for (AnnotationAttachmentSymbol annotAttachment : functionSymbol.annotAttachments()) {
            Optional optName;
            ModuleID id;
            AnnotationSymbol annotationSymbol = annotAttachment.typeDescriptor();
            Optional optModule = annotationSymbol.getModule();
            if (optModule.isEmpty() || !(id = ((ModuleSymbol)optModule.get()).id()).orgName().equals(BALLERINAX) || !id.packageName().equals(AI_AGENT) || (optName = annotationSymbol.getName()).isEmpty() || !((String)optName.get()).equals(TOOL_ANNOTATION)) continue;
            return true;
        }
        return false;
    }

    private boolean genDescription(String description, FlowNode flowNode, SourceBuilder sourceBuilder) {
        boolean hasDescription;
        String desc = "";
        String flowNodeDesc = flowNode.metadata().description();
        if (!description.isEmpty()) {
            desc = description;
        } else if (flowNodeDesc != null && !flowNodeDesc.isEmpty()) {
            desc = flowNodeDesc;
        }
        boolean bl = hasDescription = !desc.isEmpty();
        if (hasDescription) {
            sourceBuilder.token().descriptionDoc(desc);
        }
        return hasDescription;
    }

    public JsonArray getActions(JsonElement node, Path filePath, Project project, WorkspaceManager workspaceManager) {
        FlowNode flowNode = (FlowNode)this.gson.fromJson(node, FlowNode.class);
        Document document = (Document)workspaceManager.document(filePath).orElseThrow();
        TextDocument textDocument = document.textDocument();
        SourceBuilder sourceBuilder = new SourceBuilder(flowNode, workspaceManager, filePath);
        Path connectionPath = workspaceManager.projectRoot(filePath).resolve("connections.bal");
        List<org.eclipse.lsp4j.TextEdit> connectionTextEdits = NodeBuilder.getNodeFromKind(flowNode.codedata().node()).toSource(sourceBuilder).get(connectionPath);
        TextEdit[] textEdits = new TextEdit[connectionTextEdits.size()];
        for (int i = 0; i < connectionTextEdits.size(); ++i) {
            TextEdit textEdit;
            org.eclipse.lsp4j.TextEdit connectionTextEdit = connectionTextEdits.get(i);
            Position start = connectionTextEdit.getRange().getStart();
            int startTextPosition = textDocument.textPositionFrom(LinePosition.from((int)start.getLine(), (int)start.getCharacter()));
            Position end = connectionTextEdit.getRange().getEnd();
            int endTextPosition = textDocument.textPositionFrom(LinePosition.from((int)end.getLine(), (int)end.getCharacter()));
            textEdits[i] = textEdit = TextEdit.from((TextRange)TextRange.from((int)startTextPosition, (int)(endTextPosition - startTextPosition)), (String)connectionTextEdit.getNewText());
        }
        TextDocument modifiedTextDoc = textDocument.apply(TextDocumentChange.from((TextEdit[])textEdits));
        Document modifiedDoc = project.duplicate().currentPackage().module(document.module().moduleId()).document(document.documentId()).modify().withContent(String.join((CharSequence)System.lineSeparator(), modifiedTextDoc.textLines())).apply();
        SemanticModel newSemanticModel = PackageUtil.getCompilation((Package)modifiedDoc.module().packageInstance()).getSemanticModel(modifiedDoc.module().moduleId());
        Optional<Property> property = flowNode.getProperty("variable");
        if (property.isEmpty()) {
            throw new IllegalStateException("Variable name is not present");
        }
        String variableName = property.get().value().toString();
        VariableSymbol variableSymbol = null;
        List moduleSymbols = newSemanticModel.moduleSymbols();
        for (Symbol moduleSymbol : moduleSymbols) {
            if (moduleSymbol.kind() != SymbolKind.VARIABLE || !moduleSymbol.getName().orElse("").equals(variableName)) continue;
            variableSymbol = (VariableSymbol)moduleSymbol;
        }
        ArrayList<AvailableNode> methods = new ArrayList<AvailableNode>();
        if (variableSymbol == null) {
            return this.gson.toJsonTree(methods).getAsJsonArray();
        }
        TypeReferenceTypeSymbol typeDescriptorSymbol = (TypeReferenceTypeSymbol)variableSymbol.typeDescriptor();
        ClassSymbol classSymbol = (ClassSymbol)typeDescriptorSymbol.typeDescriptor();
        if (!classSymbol.qualifiers().contains(Qualifier.CLIENT)) {
            return this.gson.toJsonTree(methods).getAsJsonArray();
        }
        String parentSymbolName = (String)variableSymbol.getName().orElseThrow();
        String className = (String)classSymbol.getName().orElseThrow();
        List methodFunctionsData = new FunctionDataBuilder().parentSymbol((ObjectTypeSymbol)classSymbol).buildChildNodes();
        for (FunctionData methodFunction : methodFunctionsData) {
            NodeBuilder nodeBuilder;
            Object label;
            boolean isHttpModule;
            String org = methodFunction.org();
            String packageName = methodFunction.packageName();
            String version = methodFunction.version();
            boolean bl = isHttpModule = org.equals(BALLERINA_ORG) && packageName.equals(HTTP_MODULE);
            if (methodFunction.kind() == FunctionData.Kind.RESOURCE) {
                if (isHttpModule && HTTP_REMOTE_METHOD_SKIP_LIST.contains(methodFunction.name())) continue;
                label = methodFunction.name() + (isHttpModule ? "" : methodFunction.resourcePath());
                nodeBuilder = NodeBuilder.getNodeFromKind(NodeKind.RESOURCE_ACTION_CALL);
            } else {
                label = methodFunction.name();
                nodeBuilder = switch (methodFunction.kind()) {
                    case FunctionData.Kind.REMOTE -> NodeBuilder.getNodeFromKind(NodeKind.REMOTE_ACTION_CALL);
                    case FunctionData.Kind.FUNCTION -> NodeBuilder.getNodeFromKind(NodeKind.METHOD_CALL);
                    default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(methodFunction.kind()));
                };
            }
            AvailableNode item = ((NodeBuilder)((NodeBuilder)nodeBuilder.metadata().label((String)label).icon(CommonUtils.generateIcon((String)org, (String)packageName, (String)version)).description(methodFunction.description()).stepOut()).codedata().org(org).module(packageName).object(className).symbol(methodFunction.name()).version(version).parentSymbol(parentSymbolName).resourcePath(methodFunction.resourcePath()).id(methodFunction.functionId()).stepOut()).buildAvailableNode();
            methods.add(item);
        }
        return this.gson.toJsonTree(methods).getAsJsonArray();
    }

    public JsonElement editTool(String toolName, String description, Path projectPath) {
        HashMap textEditsMap = new HashMap();
        ArrayList<org.eclipse.lsp4j.TextEdit> textEdits = new ArrayList<org.eclipse.lsp4j.TextEdit>();
        for (Symbol symbol : this.semanticModel.moduleSymbols()) {
            FunctionSymbol functionSymbol;
            if (symbol.kind() != SymbolKind.FUNCTION || !((String)(functionSymbol = (FunctionSymbol)symbol).getName().orElseThrow()).equals(toolName)) continue;
            for (AnnotationAttachmentSymbol annotAttachment : functionSymbol.annotAttachments()) {
                AnnotationSymbol annotationSymbol = annotAttachment.typeDescriptor();
                if (!((String)annotationSymbol.getName().orElseThrow()).equals(TOOL_ANNOTATION)) continue;
                Location location = (Location)annotAttachment.getLocation().orElseThrow();
                textEdits.add(new org.eclipse.lsp4j.TextEdit(CommonUtils.toRange((LineRange)location.lineRange()), "@ai:AgentTool {description: \"" + description + "\"}" + System.lineSeparator()));
                break;
            }
            textEditsMap.put(projectPath.resolve(((Location)functionSymbol.getLocation().orElseThrow()).lineRange().fileName()), textEdits);
            break;
        }
        return this.gson.toJsonTree(textEditsMap);
    }

    private Path addIsolateKeyword(String name, Path filePath, List<org.eclipse.lsp4j.TextEdit> textEdits, WorkspaceManager workspaceManager) {
        for (Symbol symbol : this.semanticModel.moduleSymbols()) {
            NonTerminalNode node;
            Document document;
            Optional optNode;
            Path functionFile;
            Optional optDocument;
            FunctionSymbol functionSymbol;
            if (symbol.kind() != SymbolKind.FUNCTION || !((String)(functionSymbol = (FunctionSymbol)symbol).getName().orElseThrow()).equals(name)) continue;
            Path parent = filePath.getParent();
            Location location = (Location)functionSymbol.getLocation().orElseThrow();
            LineRange lineRange = location.lineRange();
            if (parent == null || (optDocument = workspaceManager.document(functionFile = parent.resolve(lineRange.fileName()))).isEmpty() || (optNode = CommonUtil.findNode((Symbol)functionSymbol, (SyntaxTree)(document = (Document)optDocument.get()).syntaxTree())).isEmpty() || (node = (NonTerminalNode)optNode.get()).kind() != SyntaxKind.FUNCTION_DEFINITION) break;
            FunctionDefinitionNode functionDefinitionNode = (FunctionDefinitionNode)node;
            boolean isIsolated = false;
            for (Token token : functionDefinitionNode.qualifierList()) {
                if (!token.text().trim().equals("isolated")) continue;
                isIsolated = true;
            }
            if (isIsolated) break;
            LinePosition startLine = lineRange.startLine();
            int offset = startLine.offset() - SyntaxKind.FUNCTION_KEYWORD.stringValue().length() - 1;
            int line = startLine.line();
            Position position = new Position(line, offset);
            textEdits.add(new org.eclipse.lsp4j.TextEdit(new Range(position, position), "isolated "));
            return functionFile;
        }
        return null;
    }
}

