/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.ObjectTypeSymbol;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.flowmodelgenerator.core.LocalIndexCentral;
import io.ballerina.flowmodelgenerator.core.model.AvailableNode;
import io.ballerina.flowmodelgenerator.core.model.Category;
import io.ballerina.flowmodelgenerator.core.model.Codedata;
import io.ballerina.flowmodelgenerator.core.model.Item;
import io.ballerina.flowmodelgenerator.core.model.Metadata;
import io.ballerina.flowmodelgenerator.core.model.NodeBuilder;
import io.ballerina.flowmodelgenerator.core.model.NodeKind;
import io.ballerina.modelgenerator.commons.CommonUtils;
import io.ballerina.modelgenerator.commons.FunctionData;
import io.ballerina.modelgenerator.commons.FunctionDataBuilder;
import io.ballerina.modelgenerator.commons.ModuleInfo;
import io.ballerina.projects.Document;
import io.ballerina.projects.Package;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.TextRange;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;

public class AvailableNodesGenerator {
    private final Category.Builder rootBuilder = new Category.Builder(null).name(Category.Name.ROOT);
    private final SemanticModel semanticModel;
    private final Document document;
    private final Package pkg;
    private final Gson gson = new Gson();
    private static final String BALLERINA_ORG = "ballerina";
    private static final String HTTP_MODULE = "http";
    private static final List<String> HTTP_REMOTE_METHOD_SKIP_LIST = List.of("get", "put", "post", "head", "delete", "patch", "options");
    private static final String BALLERINAX = "ballerinax";
    public static final String AI_AGENT = "ai";

    public AvailableNodesGenerator(SemanticModel semanticModel, Document document, Package pkg) {
        this.semanticModel = semanticModel;
        this.document = document;
        this.pkg = pkg;
    }

    public JsonArray getAvailableNodes(LinePosition position) {
        ArrayList<Category> connections = new ArrayList<Category>();
        List symbols = this.semanticModel.visibleSymbols(this.document, position);
        for (Symbol symbol : symbols) {
            Optional<Category> connection2 = this.getConnection(symbol);
            if (connection2.isEmpty()) continue;
            connections.add(connection2.get());
        }
        connections.sort(Comparator.comparing(connection -> connection.metadata().label()));
        this.rootBuilder.stepIn(Category.Name.CONNECTIONS).items(new ArrayList<Item>(connections)).stepOut();
        ArrayList<Item> items = new ArrayList<Item>();
        items.addAll(this.getAvailableFlowNodes(position));
        items.addAll(LocalIndexCentral.getInstance().getFunctions());
        return this.gson.toJsonTree(items).getAsJsonArray();
    }

    private List<Item> getAvailableFlowNodes(LinePosition cursorPosition) {
        SyntaxKind kind;
        NonTerminalNode nonTerminalNode;
        int txtPos = this.document.textDocument().textPositionFrom(cursorPosition);
        TextRange range = TextRange.from((int)txtPos, (int)0);
        for (NonTerminalNode iterationNode = nonTerminalNode = ((ModulePartNode)this.document.syntaxTree().rootNode()).findNode(range); iterationNode != null; iterationNode = iterationNode.parent()) {
            kind = iterationNode.kind();
            switch (kind) {
                case WHILE_STATEMENT: 
                case FOREACH_STATEMENT: {
                    this.setAvailableNodesForIteratingBlock(nonTerminalNode, this.semanticModel);
                    return this.rootBuilder.build().items();
                }
            }
        }
        while (nonTerminalNode != null) {
            kind = nonTerminalNode.kind();
            switch (kind) {
                case IF_ELSE_STATEMENT: 
                case LOCK_STATEMENT: 
                case TRANSACTION_STATEMENT: 
                case MATCH_STATEMENT: 
                case DO_STATEMENT: 
                case ON_FAIL_CLAUSE: {
                    this.setAvailableDefaultNodes(nonTerminalNode, this.semanticModel);
                    return this.rootBuilder.build().items();
                }
            }
            nonTerminalNode = nonTerminalNode.parent();
        }
        this.setDefaultNodes();
        return this.rootBuilder.build().items();
    }

    private void setAvailableDefaultNodes(NonTerminalNode node, SemanticModel semanticModel) {
        this.setDefaultNodes();
        this.setStopNode(node);
    }

    private void setAvailableNodesForIteratingBlock(NonTerminalNode node, SemanticModel semanticModel) {
        this.setDefaultNodes();
        this.setStopNode(node);
        this.rootBuilder.stepIn(Category.Name.CONTROL).node(NodeKind.BREAK).node(NodeKind.CONTINUE).stepOut();
    }

    private void setDefaultNodes() {
        AvailableNode function = new AvailableNode(new Metadata.Builder<Object>(null).label("Call Function").description("Both project and utility functions").build(), new Codedata.Builder<Object>(null).node(NodeKind.FUNCTION).build(), true);
        AvailableNode npFunction = new AvailableNode(new Metadata.Builder<Object>(null).label("Call Natural Function").description("Call a natural programming function").icon("https://gist.github.com/user-attachments/assets/903c5c16-7d67-4af8-8113-ce7c59ccdaab").build(), new Codedata.Builder<Object>(null).node(NodeKind.NP_FUNCTION).build(), true);
        AvailableNode agentCall = new AvailableNode(new Metadata.Builder<Object>(null).label("Agent").description("Create new agent").build(), new Codedata.Builder<Object>(null).node(NodeKind.AGENT_CALL).org(BALLERINAX).module(AI_AGENT).symbol("run").object("Agent").build(), true);
        this.rootBuilder.stepIn(Category.Name.STATEMENT).node(NodeKind.VARIABLE).node(NodeKind.ASSIGN).node(function).node(NodeKind.DATA_MAPPER_CALL).node(npFunction).node(agentCall);
        this.rootBuilder.stepIn(Category.Name.CONTROL).node(NodeKind.IF).node(NodeKind.MATCH).node(NodeKind.WHILE).node(NodeKind.FOREACH).node(NodeKind.RETURN);
        this.rootBuilder.stepIn(Category.Name.ERROR_HANDLING).node(NodeKind.ERROR_HANDLER).node(NodeKind.FAIL).node(NodeKind.PANIC).stepOut().stepIn(Category.Name.CONCURRENCY).node(NodeKind.FORK).node(NodeKind.PARALLEL_FLOW).node(NodeKind.WAIT).node(NodeKind.LOCK).node(NodeKind.START).node(NodeKind.TRANSACTION).node(NodeKind.COMMIT).node(NodeKind.ROLLBACK).node(NodeKind.RETRY).stepOut();
    }

    private void setStopNode(NonTerminalNode node) {
        for (NonTerminalNode parent = node; parent != null; parent = parent.parent()) {
            if (!this.isStopNodeAvailable((Node)parent)) continue;
            this.rootBuilder.stepIn(Category.Name.CONTROL).node(NodeKind.STOP).stepOut();
        }
    }

    private boolean isStopNodeAvailable(Node node) {
        if (node.kind() != SyntaxKind.FUNCTION_DEFINITION && node.kind() != SyntaxKind.RESOURCE_ACCESSOR_DEFINITION && node.kind() != SyntaxKind.OBJECT_METHOD_DEFINITION) {
            return false;
        }
        Optional symbol = this.semanticModel.symbol(node);
        if (symbol.isEmpty()) {
            return false;
        }
        Optional typeSymbol = ((FunctionSymbol)symbol.get()).typeDescriptor().returnTypeDescriptor();
        return typeSymbol.isEmpty() || ((TypeSymbol)typeSymbol.get()).subtypeOf(this.semanticModel.types().NIL);
    }

    private Optional<Category> getConnection(Symbol symbol) {
        try {
            TypeReferenceTypeSymbol typeDescriptorSymbol;
            if (symbol instanceof VariableSymbol) {
                VariableSymbol variableSymbol = (VariableSymbol)symbol;
                typeDescriptorSymbol = (TypeReferenceTypeSymbol)variableSymbol.typeDescriptor();
            } else if (symbol instanceof ParameterSymbol) {
                ParameterSymbol parameterSymbol = (ParameterSymbol)symbol;
                typeDescriptorSymbol = (TypeReferenceTypeSymbol)parameterSymbol.typeDescriptor();
            } else {
                return Optional.empty();
            }
            ClassSymbol classSymbol = (ClassSymbol)typeDescriptorSymbol.typeDescriptor();
            if (!classSymbol.qualifiers().contains(Qualifier.CLIENT)) {
                return Optional.empty();
            }
            String parentSymbolName = (String)symbol.getName().orElseThrow();
            String className = (String)classSymbol.getName().orElseThrow();
            ModuleInfo moduleInfo = classSymbol.getModule().map(moduleSymbol -> ModuleInfo.from((ModuleID)moduleSymbol.id())).orElse(null);
            FunctionDataBuilder functionDataBuilder = new FunctionDataBuilder().parentSymbol((ObjectTypeSymbol)classSymbol).parentSymbolType(className).project(this.pkg.project()).moduleInfo(moduleInfo);
            List methodFunctionsData = functionDataBuilder.buildChildNodes();
            ArrayList<Item> methods = new ArrayList<Item>();
            for (FunctionData methodFunction : methodFunctionsData) {
                NodeBuilder nodeBuilder;
                Object label;
                boolean isHttpModule;
                String org = methodFunction.org();
                String packageName = methodFunction.packageName();
                String version = methodFunction.version();
                boolean bl = isHttpModule = org.equals(BALLERINA_ORG) && packageName.equals(HTTP_MODULE);
                if (methodFunction.kind() == FunctionData.Kind.RESOURCE) {
                    if (isHttpModule && HTTP_REMOTE_METHOD_SKIP_LIST.contains(methodFunction.name())) continue;
                    label = methodFunction.name() + (isHttpModule ? "" : methodFunction.resourcePath());
                    nodeBuilder = NodeBuilder.getNodeFromKind(NodeKind.RESOURCE_ACTION_CALL);
                } else {
                    label = methodFunction.name();
                    FunctionData.Kind kind = methodFunction.kind();
                    if (kind == FunctionData.Kind.REMOTE) {
                        nodeBuilder = NodeBuilder.getNodeFromKind(NodeKind.REMOTE_ACTION_CALL);
                    } else if (kind == FunctionData.Kind.FUNCTION) {
                        nodeBuilder = NodeBuilder.getNodeFromKind(NodeKind.METHOD_CALL);
                    } else {
                        throw new IllegalStateException("Unexpected value: " + String.valueOf(kind));
                    }
                }
                AvailableNode node = ((NodeBuilder)((NodeBuilder)nodeBuilder.metadata().label((String)label).icon(CommonUtils.generateIcon((String)org, (String)packageName, (String)version)).description(methodFunction.description()).stepOut()).codedata().org(org).module(functionDataBuilder.isLocal() ? moduleInfo.moduleName() : packageName).object(className).symbol(methodFunction.name()).version(version).parentSymbol(parentSymbolName).resourcePath(methodFunction.resourcePath()).stepOut()).buildAvailableNode();
                methods.add(node);
            }
            Metadata metadata = new Metadata.Builder<Object>(null).label(parentSymbolName).build();
            return Optional.of(new Category(metadata, methods));
        }
        catch (RuntimeException ignored) {
            return Optional.empty();
        }
    }
}

