/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.AnnotationAttachmentSymbol;
import io.ballerina.compiler.api.symbols.ClassFieldSymbol;
import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.Documentation;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.FunctionTypeSymbol;
import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.ObjectTypeSymbol;
import io.ballerina.compiler.api.symbols.ParameterKind;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.RecordFieldSymbol;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.api.values.ConstantValue;
import io.ballerina.compiler.syntax.tree.AssignmentStatementNode;
import io.ballerina.compiler.syntax.tree.BinaryExpressionNode;
import io.ballerina.compiler.syntax.tree.BlockStatementNode;
import io.ballerina.compiler.syntax.tree.BreakStatementNode;
import io.ballerina.compiler.syntax.tree.ByteArrayLiteralNode;
import io.ballerina.compiler.syntax.tree.CheckExpressionNode;
import io.ballerina.compiler.syntax.tree.ClientResourceAccessActionNode;
import io.ballerina.compiler.syntax.tree.CommentNode;
import io.ballerina.compiler.syntax.tree.CommitActionNode;
import io.ballerina.compiler.syntax.tree.CompoundAssignmentStatementNode;
import io.ballerina.compiler.syntax.tree.ComputedResourceAccessSegmentNode;
import io.ballerina.compiler.syntax.tree.ContinueStatementNode;
import io.ballerina.compiler.syntax.tree.DoStatementNode;
import io.ballerina.compiler.syntax.tree.ElseBlockNode;
import io.ballerina.compiler.syntax.tree.ExplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionStatementNode;
import io.ballerina.compiler.syntax.tree.FailStatementNode;
import io.ballerina.compiler.syntax.tree.FieldAccessExpressionNode;
import io.ballerina.compiler.syntax.tree.ForEachStatementNode;
import io.ballerina.compiler.syntax.tree.ForkStatementNode;
import io.ballerina.compiler.syntax.tree.FunctionArgumentNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyBlockNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyNode;
import io.ballerina.compiler.syntax.tree.FunctionCallExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.IfElseStatementNode;
import io.ballerina.compiler.syntax.tree.ImplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.ListConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.LocalTypeDefinitionStatementNode;
import io.ballerina.compiler.syntax.tree.LockStatementNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingFieldNode;
import io.ballerina.compiler.syntax.tree.MatchClauseNode;
import io.ballerina.compiler.syntax.tree.MatchGuardNode;
import io.ballerina.compiler.syntax.tree.MatchStatementNode;
import io.ballerina.compiler.syntax.tree.MethodCallExpressionNode;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.NamedArgumentNode;
import io.ballerina.compiler.syntax.tree.NamedWorkerDeclarationNode;
import io.ballerina.compiler.syntax.tree.NamedWorkerDeclarator;
import io.ballerina.compiler.syntax.tree.NewExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ObjectFieldNode;
import io.ballerina.compiler.syntax.tree.OnFailClauseNode;
import io.ballerina.compiler.syntax.tree.PanicStatementNode;
import io.ballerina.compiler.syntax.tree.ParenthesizedArgList;
import io.ballerina.compiler.syntax.tree.PositionalArgumentNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.QueryActionNode;
import io.ballerina.compiler.syntax.tree.RemoteMethodCallActionNode;
import io.ballerina.compiler.syntax.tree.RetryStatementNode;
import io.ballerina.compiler.syntax.tree.ReturnStatementNode;
import io.ballerina.compiler.syntax.tree.ReturnTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.RollbackStatementNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.StartActionNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.TemplateExpressionNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TransactionStatementNode;
import io.ballerina.compiler.syntax.tree.TypedBindingPatternNode;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.WaitActionNode;
import io.ballerina.compiler.syntax.tree.WaitFieldNode;
import io.ballerina.compiler.syntax.tree.WaitFieldsListNode;
import io.ballerina.compiler.syntax.tree.WhileStatementNode;
import io.ballerina.flowmodelgenerator.core.DiagnosticHandler;
import io.ballerina.flowmodelgenerator.core.TypesGenerator;
import io.ballerina.flowmodelgenerator.core.model.Branch;
import io.ballerina.flowmodelgenerator.core.model.FlowNode;
import io.ballerina.flowmodelgenerator.core.model.FormBuilder;
import io.ballerina.flowmodelgenerator.core.model.NodeBuilder;
import io.ballerina.flowmodelgenerator.core.model.NodeKind;
import io.ballerina.flowmodelgenerator.core.model.Property;
import io.ballerina.flowmodelgenerator.core.model.node.BinaryBuilder;
import io.ballerina.flowmodelgenerator.core.model.node.CallBuilder;
import io.ballerina.flowmodelgenerator.core.model.node.DataMapperBuilder;
import io.ballerina.flowmodelgenerator.core.model.node.FunctionCall;
import io.ballerina.flowmodelgenerator.core.model.node.JsonPayloadBuilder;
import io.ballerina.flowmodelgenerator.core.model.node.MethodCall;
import io.ballerina.flowmodelgenerator.core.model.node.NewConnectionBuilder;
import io.ballerina.flowmodelgenerator.core.model.node.RemoteActionCallBuilder;
import io.ballerina.flowmodelgenerator.core.model.node.ResourceActionCallBuilder;
import io.ballerina.flowmodelgenerator.core.model.node.XmlPayloadBuilder;
import io.ballerina.flowmodelgenerator.core.utils.FlowNodeUtil;
import io.ballerina.flowmodelgenerator.core.utils.ParamUtils;
import io.ballerina.modelgenerator.commons.CommonUtils;
import io.ballerina.modelgenerator.commons.FunctionData;
import io.ballerina.modelgenerator.commons.FunctionDataBuilder;
import io.ballerina.modelgenerator.commons.ModuleInfo;
import io.ballerina.modelgenerator.commons.ParameterData;
import io.ballerina.projects.Project;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import io.ballerina.tools.text.TextDocument;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Stack;
import java.util.stream.Collectors;
import org.ballerinalang.langserver.common.utils.CommonUtil;

class CodeAnalyzer
extends NodeVisitor {
    private final Project project;
    private final SemanticModel semanticModel;
    private final Map<String, LineRange> dataMappings;
    private final Map<String, LineRange> naturalFunctions;
    private final TextDocument textDocument;
    private final ModuleInfo moduleInfo;
    private final DiagnosticHandler diagnosticHandler;
    private final boolean forceAssign;
    private final String connectionScope;
    private NodeBuilder nodeBuilder;
    private final List<FlowNode> flowNodeList;
    private final Stack<NodeBuilder> flowNodeBuilderStack;
    private TypedBindingPatternNode typedBindingPatternNode;
    private static final String BALLERINAX = "ballerinax";
    private static final String AI_AGENT = "ai";

    public CodeAnalyzer(Project project, SemanticModel semanticModel, String connectionScope, Map<String, LineRange> dataMappings, Map<String, LineRange> naturalFunctions, TextDocument textDocument, ModuleInfo moduleInfo, boolean forceAssign) {
        this.project = project;
        this.semanticModel = semanticModel;
        this.dataMappings = dataMappings;
        this.naturalFunctions = naturalFunctions;
        this.connectionScope = connectionScope;
        this.textDocument = textDocument;
        this.moduleInfo = moduleInfo;
        this.forceAssign = forceAssign;
        this.flowNodeList = new ArrayList<FlowNode>();
        this.flowNodeBuilderStack = new Stack();
        this.diagnosticHandler = new DiagnosticHandler(semanticModel);
    }

    public void visit(FunctionDefinitionNode functionDefinitionNode) {
        Optional symbol = this.semanticModel.symbol((Node)functionDefinitionNode);
        if (symbol.isEmpty()) {
            return;
        }
        FunctionBodyNode functionBodyNode = functionDefinitionNode.functionBody();
        this.startNode(NodeKind.EVENT_START, (Node)functionDefinitionNode).codedata().lineRange(functionBodyNode.lineRange()).sourceCode(functionDefinitionNode.toSourceCode().strip());
        FunctionSignatureNode functionSignatureNode = functionDefinitionNode.functionSignature();
        List<String> parametersList = functionSignatureNode.parameters().stream().map(parameter -> parameter.toSourceCode().strip()).toList();
        if (!parametersList.isEmpty()) {
            this.nodeBuilder.metadata().addData("parameters", parametersList);
        }
        functionSignatureNode.returnTypeDesc().ifPresent(returnTypeDesc -> this.nodeBuilder.metadata().addData("return", returnTypeDesc.type().toSourceCode().strip()));
        this.endNode();
        functionBodyNode.accept((NodeVisitor)this);
    }

    public void visit(ObjectFieldNode objectFieldNode) {
        Optional optExpr = objectFieldNode.expression();
        if (optExpr.isPresent()) {
            ((ExpressionNode)optExpr.get()).accept((NodeVisitor)this);
            this.nodeBuilder.properties().type(objectFieldNode.typeName(), true).data((Node)objectFieldNode.fieldName(), false, new HashSet<String>());
            this.endNode((Node)objectFieldNode);
        }
    }

    public void visit(FunctionBodyBlockNode functionBodyBlockNode) {
        functionBodyBlockNode.namedWorkerDeclarator().ifPresent(namedWorkerDeclarator -> namedWorkerDeclarator.accept((NodeVisitor)this));
        for (Node statementOrComment : functionBodyBlockNode.statementsWithComments()) {
            statementOrComment.accept((NodeVisitor)this);
        }
    }

    public void visit(CommentNode commentNode) {
        Node node = commentNode.getCommentAttachedNode();
        LinePosition startPos = this.textDocument.linePositionFrom(node.textRangeWithMinutiae().startOffset());
        int offset = 0;
        if (!(node instanceof Token)) {
            offset = node.textRangeWithMinutiae().startOffset();
        }
        LinePosition endPos = this.textDocument.linePositionFrom(commentNode.getLastMinutiae().textRange().endOffset() + offset);
        LineRange commentRange = LineRange.from((String)node.lineRange().fileName(), (LinePosition)startPos, (LinePosition)endPos);
        CommentMetadata commentMetadata = new CommentMetadata(String.join((CharSequence)System.lineSeparator(), commentNode.getCommentLines()), commentRange);
        this.genCommentNode(commentMetadata);
    }

    public void visit(ReturnStatementNode returnStatementNode) {
        Optional optExpr = returnStatementNode.expression();
        if (optExpr.isEmpty()) {
            this.startNode(NodeKind.STOP, (Node)returnStatementNode);
        } else {
            ExpressionNode expr = (ExpressionNode)optExpr.get();
            ((NodeBuilder)this.startNode(NodeKind.RETURN, (Node)returnStatementNode).metadata().description(String.format("Value of '%s'", expr)).stepOut()).properties().expressionOrAction(expr, "Return value", false);
        }
        this.nodeBuilder.returning();
        this.endNode((Node)returnStatementNode);
    }

    public void visit(RemoteMethodCallActionNode remoteMethodCallActionNode) {
        Optional symbol = this.semanticModel.symbol((Node)remoteMethodCallActionNode);
        if (symbol.isEmpty() || ((Symbol)symbol.get()).kind() != SymbolKind.METHOD) {
            this.handleExpressionNode((NonTerminalNode)remoteMethodCallActionNode);
            return;
        }
        Optional<ClassSymbol> classSymbol = this.getClassSymbol(remoteMethodCallActionNode.expression());
        if (classSymbol.isEmpty()) {
            this.handleExpressionNode((NonTerminalNode)remoteMethodCallActionNode);
            return;
        }
        String functionName = remoteMethodCallActionNode.methodName().name().text();
        ExpressionNode expressionNode = remoteMethodCallActionNode.expression();
        MethodSymbol functionSymbol = (MethodSymbol)symbol.get();
        if (this.isAgentCall((Symbol)classSymbol.get())) {
            this.startNode(NodeKind.AGENT_CALL, (Node)expressionNode.parent());
            this.setFunctionProperties(functionName, expressionNode, remoteMethodCallActionNode, functionSymbol, (String)classSymbol.get().getName().orElseThrow());
            if (this.isClassField(expressionNode)) {
                ServiceDeclarationNode serviceDeclaration = this.getParentServiceDeclaration((NonTerminalNode)remoteMethodCallActionNode);
                for (Node member : serviceDeclaration.members()) {
                    FunctionDefinitionNode funcDef;
                    if (member.kind() != SyntaxKind.OBJECT_METHOD_DEFINITION || !(funcDef = (FunctionDefinitionNode)member).functionName().text().equals("init")) continue;
                    for (StatementNode statement : ((FunctionBodyBlockNode)funcDef.functionBody()).statements()) {
                        AssignmentStatementNode assignmentStmtNode;
                        if (statement.kind() != SyntaxKind.ASSIGNMENT_STATEMENT || !(assignmentStmtNode = (AssignmentStatementNode)statement).varRef().toSourceCode().trim().equals(expressionNode.toSourceCode())) continue;
                        ImplicitNewExpressionNode newExpressionNode = this.getNewExpr(assignmentStmtNode.expression());
                        this.genAgentData(newExpressionNode, classSymbol.get());
                    }
                }
            } else {
                for (Symbol moduleSymbol : this.semanticModel.moduleSymbols()) {
                    VariableSymbol variableSymbol;
                    if (moduleSymbol.kind() != SymbolKind.VARIABLE || !((String)(variableSymbol = (VariableSymbol)moduleSymbol).getName().orElseThrow()).equals(expressionNode.toSourceCode())) continue;
                    Optional optLocation = variableSymbol.getLocation();
                    if (optLocation.isEmpty()) {
                        throw new IllegalStateException("Location not found for the variable symbol: " + String.valueOf(variableSymbol));
                    }
                    NonTerminalNode parent = ((NonTerminalNode)CommonUtil.findNode((Symbol)variableSymbol, (SyntaxTree)CommonUtils.getDocument((Project)this.project, (Location)((Location)optLocation.get())).syntaxTree()).get()).parent().parent();
                    if (parent.kind() != SyntaxKind.MODULE_VAR_DECL) {
                        throw new IllegalStateException("Parent is not a module variable declaration: " + String.valueOf(parent));
                    }
                    ModuleVariableDeclarationNode moduleVariableDeclarationNode = (ModuleVariableDeclarationNode)parent;
                    Optional optInitializer = moduleVariableDeclarationNode.initializer();
                    if (optInitializer.isEmpty()) {
                        throw new IllegalStateException("Initializer not found for the module variable declaration: " + String.valueOf(moduleVariableDeclarationNode));
                    }
                    ImplicitNewExpressionNode newExpressionNode = this.getNewExpr((ExpressionNode)optInitializer.get());
                    this.genAgentData(newExpressionNode, classSymbol.get());
                    break;
                }
            }
        } else {
            this.startNode(NodeKind.REMOTE_ACTION_CALL, (Node)expressionNode.parent());
            this.setFunctionProperties(functionName, expressionNode, remoteMethodCallActionNode, functionSymbol, (String)classSymbol.get().getName().orElseThrow());
        }
    }

    private void genAgentData(ImplicitNewExpressionNode newExpressionNode, ClassSymbol classSymbol) {
        Optional argList = newExpressionNode.parenthesizedArgList();
        if (argList.isEmpty()) {
            throw new IllegalStateException("ParenthesizedArgList not found for the new expression: " + String.valueOf(newExpressionNode));
        }
        ExpressionNode toolsArg = null;
        ExpressionNode modelArg = null;
        ExpressionNode systemPromptArg = null;
        ExpressionNode memory = null;
        for (FunctionArgumentNode arg : ((ParenthesizedArgList)argList.get()).arguments()) {
            if (arg.kind() != SyntaxKind.NAMED_ARG) continue;
            NamedArgumentNode namedArgumentNode = (NamedArgumentNode)arg;
            if (namedArgumentNode.argumentName().name().text().equals("tools")) {
                toolsArg = namedArgumentNode.expression();
                continue;
            }
            if (namedArgumentNode.argumentName().name().text().equals("model")) {
                modelArg = namedArgumentNode.expression();
                continue;
            }
            if (namedArgumentNode.argumentName().name().text().equals("systemPrompt")) {
                systemPromptArg = namedArgumentNode.expression();
                continue;
            }
            if (!namedArgumentNode.argumentName().name().text().equals("memory")) continue;
            memory = namedArgumentNode.expression();
        }
        if (toolsArg == null) {
            throw new IllegalStateException("Tools argument not found for the new expression: " + String.valueOf(newExpressionNode));
        }
        if (modelArg == null) {
            throw new IllegalStateException("Model argument not found for the new expression: " + String.valueOf(newExpressionNode));
        }
        if (systemPromptArg == null) {
            throw new IllegalStateException("SystemPrompt argument not found for the new expression: " + String.valueOf(newExpressionNode));
        }
        if (toolsArg.kind() == SyntaxKind.LIST_CONSTRUCTOR) {
            ArrayList<ToolData> toolsData = new ArrayList<ToolData>();
            ListConstructorExpressionNode listCtrExprNode = (ListConstructorExpressionNode)toolsArg;
            for (Node node : listCtrExprNode.expressions()) {
                if (node.kind() != SyntaxKind.SIMPLE_NAME_REFERENCE) continue;
                SimpleNameReferenceNode simpleNameReferenceNode = (SimpleNameReferenceNode)node;
                String toolName = simpleNameReferenceNode.name().text();
                toolsData.add(new ToolData(toolName, this.getIcon(toolName), this.getToolDescription(toolName)));
            }
            this.nodeBuilder.metadata().addData("tools", toolsData);
        }
        if (systemPromptArg.kind() == SyntaxKind.MAPPING_CONSTRUCTOR) {
            MappingConstructorExpressionNode mappingCtrExprNode = (MappingConstructorExpressionNode)systemPromptArg;
            SeparatedNodeList fields = mappingCtrExprNode.fields();
            HashMap<String, String> agentData = new HashMap<String, String>();
            for (MappingFieldNode field : fields) {
                SyntaxKind kind = field.kind();
                if (kind != SyntaxKind.SPECIFIC_FIELD) continue;
                SpecificFieldNode specificFieldNode = (SpecificFieldNode)field;
                agentData.put(specificFieldNode.fieldName().toString().trim(), ((ExpressionNode)specificFieldNode.valueExpr().orElseThrow()).toSourceCode());
            }
            this.nodeBuilder.metadata().addData("agent", agentData);
        }
        if (memory == null) {
            String defaultMemoryManagerName = this.getDefaultMemoryManagerName(classSymbol);
            this.nodeBuilder.metadata().addData("memory", new MemoryManagerData(defaultMemoryManagerName, "10"));
        } else if (memory.kind() == SyntaxKind.EXPLICIT_NEW_EXPRESSION) {
            ExplicitNewExpressionNode newExpr = (ExplicitNewExpressionNode)memory;
            SeparatedNodeList arguments = newExpr.parenthesizedArgList().arguments();
            String size = "";
            if (arguments.size() == 1) {
                size = ((FunctionArgumentNode)arguments.get(0)).toSourceCode();
            }
            this.nodeBuilder.metadata().addData("memory", new MemoryManagerData(newExpr.typeDescriptor().toSourceCode(), size));
        }
        ModelData modelUrl = this.getModelIconUrl(modelArg);
        if (modelUrl != null) {
            this.nodeBuilder.metadata().addData("model", modelUrl);
        }
    }

    private boolean isClassField(ExpressionNode expr) {
        if (expr.kind() == SyntaxKind.FIELD_ACCESS) {
            return ((FieldAccessExpressionNode)expr).expression().toSourceCode().trim().equals("self");
        }
        return false;
    }

    private ServiceDeclarationNode getParentServiceDeclaration(NonTerminalNode node) {
        NonTerminalNode currentNode;
        for (currentNode = node; currentNode != null && currentNode.kind() != SyntaxKind.SERVICE_DECLARATION; currentNode = currentNode.parent()) {
        }
        if (currentNode == null) {
            throw new IllegalStateException("Service declaration not found");
        }
        return (ServiceDeclarationNode)currentNode;
    }

    private void setFunctionProperties(String functionName, ExpressionNode expressionNode, RemoteMethodCallActionNode remoteMethodCallActionNode, MethodSymbol functionSymbol, String objName) {
        FunctionDataBuilder functionDataBuilder = new FunctionDataBuilder().name(functionName).functionSymbol((FunctionSymbol)functionSymbol).semanticModel(this.semanticModel).userModuleInfo(this.moduleInfo);
        FunctionData functionData = functionDataBuilder.build();
        ((NodeBuilder)((NodeBuilder)this.nodeBuilder.symbolInfo((Symbol)functionSymbol).metadata().label(functionName).description(functionData.description()).stepOut()).codedata().nodeInfo((Node)remoteMethodCallActionNode).object(objName).symbol(functionName).stepOut()).properties().callConnection(expressionNode, "connection");
        this.processFunctionSymbol((NonTerminalNode)remoteMethodCallActionNode, (SeparatedNodeList<FunctionArgumentNode>)remoteMethodCallActionNode.arguments(), (FunctionSymbol)functionSymbol, functionData);
    }

    private String getDefaultMemoryManagerName(ClassSymbol classSymbol) {
        Optional initMethodSymbol = classSymbol.initMethod();
        if (initMethodSymbol.isEmpty()) {
            return "";
        }
        Optional optParams = ((MethodSymbol)initMethodSymbol.get()).typeDescriptor().params();
        if (optParams.isEmpty()) {
            return "";
        }
        for (ParameterSymbol param : (List)optParams.get()) {
            RecordFieldSymbol recordFieldSymbol;
            ParameterKind paramKind = param.paramKind();
            if (paramKind != ParameterKind.INCLUDED_RECORD) continue;
            TypeSymbol rawType = CommonUtils.getRawType((TypeSymbol)param.typeDescriptor());
            if (rawType.typeKind() != TypeDescKind.RECORD || (recordFieldSymbol = (RecordFieldSymbol)((RecordTypeSymbol)rawType).fieldDescriptors().get("memory")) == null) break;
            if (!recordFieldSymbol.hasDefaultValue()) continue;
            return "ai:MessageWindowChatMemory";
        }
        return "";
    }

    public void visit(ClientResourceAccessActionNode clientResourceAccessActionNode) {
        Optional symbol = this.semanticModel.symbol((Node)clientResourceAccessActionNode);
        if (symbol.isEmpty() || ((Symbol)symbol.get()).kind() != SymbolKind.METHOD && ((Symbol)symbol.get()).kind() != SymbolKind.RESOURCE_METHOD) {
            this.handleExpressionNode((NonTerminalNode)clientResourceAccessActionNode);
            return;
        }
        Optional<ClassSymbol> classSymbol = this.getClassSymbol(clientResourceAccessActionNode.expression());
        if (classSymbol.isEmpty()) {
            this.handleExpressionNode((NonTerminalNode)clientResourceAccessActionNode);
            return;
        }
        String functionName = clientResourceAccessActionNode.methodName().map(simpleNameReference -> simpleNameReference.name().text()).orElse("get");
        ExpressionNode expressionNode = clientResourceAccessActionNode.expression();
        SeparatedNodeList argumentNodes = clientResourceAccessActionNode.arguments().map(ParenthesizedArgList::arguments).orElse(null);
        MethodSymbol functionSymbol = (MethodSymbol)symbol.get();
        this.startNode(NodeKind.RESOURCE_ACTION_CALL, (Node)expressionNode.parent());
        SeparatedNodeList nodes = clientResourceAccessActionNode.resourceAccessPath();
        ParamUtils.ResourcePathTemplate resourcePathTemplate = ParamUtils.buildResourcePathTemplate(this.semanticModel, (FunctionSymbol)functionSymbol, this.semanticModel.types().ERROR);
        if (CommonUtils.isHttpModule((Symbol)functionSymbol)) {
            String resourcePath = nodes.stream().map(Node::toSourceCode).collect(Collectors.joining("/"));
            String fullPath = "/" + resourcePath;
            this.nodeBuilder.properties().resourcePath(fullPath, true);
        } else {
            this.nodeBuilder.properties().resourcePath(resourcePathTemplate.resourcePathTemplate(), false);
            int idx = 0;
            for (int i = 0; i < nodes.size(); ++i) {
                Node node = nodes.get(i);
                if (nodes.size() <= idx) break;
                if (!(node instanceof ComputedResourceAccessSegmentNode)) continue;
                ComputedResourceAccessSegmentNode computedResourceAccessSegmentNode = (ComputedResourceAccessSegmentNode)node;
                ExpressionNode expr = computedResourceAccessSegmentNode.expression();
                ParameterData paramResult = resourcePathTemplate.pathParams().get(idx);
                String unescapedParamName = ParamUtils.removeLeadingSingleQuote(paramResult.name());
                ((FormBuilder)((Property.Builder)((Property.Builder)this.nodeBuilder.properties().custom().metadata().label(unescapedParamName).description(paramResult.description()).stepOut()).codedata().kind(paramResult.kind().name()).originalName(paramResult.name()).stepOut()).value(expr.toSourceCode()).typeConstraint(paramResult.type()).typeMembers(paramResult.typeMembers()).type(Property.ValueType.EXPRESSION).editable().defaultable(paramResult.optional()).stepOut()).addProperty(unescapedParamName);
                ++idx;
            }
        }
        FunctionDataBuilder functionDataBuilder = new FunctionDataBuilder().name(functionName).functionSymbol((FunctionSymbol)functionSymbol).semanticModel(this.semanticModel).userModuleInfo(this.moduleInfo).resourcePath(resourcePathTemplate.resourcePathTemplate()).functionResultKind(FunctionData.Kind.RESOURCE);
        FunctionData functionData = functionDataBuilder.build();
        ((NodeBuilder)((NodeBuilder)this.nodeBuilder.symbolInfo((Symbol)functionSymbol).metadata().label(functionName).description(functionData.description()).stepOut()).codedata().nodeInfo((Node)clientResourceAccessActionNode).object(classSymbol.get().getName().orElse("")).symbol(functionName).resourcePath(resourcePathTemplate.resourcePathTemplate()).stepOut()).properties().callConnection(expressionNode, "connection").data((Node)this.typedBindingPatternNode, false, new HashSet<String>());
        this.processFunctionSymbol((NonTerminalNode)clientResourceAccessActionNode, (SeparatedNodeList<FunctionArgumentNode>)argumentNodes, (FunctionSymbol)functionSymbol, functionData);
    }

    private void addRemainingParamsToPropertyMap(Map<String, ParameterData> funcParamMap, boolean hasOnlyRestParams) {
        for (Map.Entry<String, ParameterData> entry : funcParamMap.entrySet()) {
            ParameterData paramResult = entry.getValue();
            if (paramResult.kind().equals((Object)ParameterData.Kind.PARAM_FOR_TYPE_INFER) || paramResult.kind().equals((Object)ParameterData.Kind.INCLUDED_RECORD)) continue;
            String unescapedParamName = ParamUtils.removeLeadingSingleQuote(paramResult.name());
            String label = paramResult.label();
            Property.Builder<FormBuilder<NodeBuilder>> customPropBuilder = this.nodeBuilder.properties().custom();
            ((Property.Builder)((Property.Builder)customPropBuilder.metadata().label(label == null || label.isEmpty() ? unescapedParamName : label).description(paramResult.description()).stepOut()).codedata().kind(paramResult.kind().name()).originalName(paramResult.name()).stepOut()).placeholder(paramResult.defaultValue()).typeConstraint(paramResult.type()).typeMembers(paramResult.typeMembers()).imports(paramResult.importStatements()).editable().defaultable(paramResult.optional());
            if (paramResult.kind() == ParameterData.Kind.INCLUDED_RECORD_REST) {
                if (hasOnlyRestParams) {
                    customPropBuilder.defaultable(false);
                }
                unescapedParamName = "additionalValues";
                customPropBuilder.type(Property.ValueType.MAPPING_EXPRESSION_SET);
            } else if (paramResult.kind() == ParameterData.Kind.REST_PARAMETER) {
                if (hasOnlyRestParams) {
                    customPropBuilder.defaultable(false);
                }
                customPropBuilder.type(Property.ValueType.EXPRESSION_SET);
            } else {
                customPropBuilder.type(Property.ValueType.EXPRESSION);
            }
            ((FormBuilder)customPropBuilder.stepOut()).addProperty(unescapedParamName);
        }
    }

    private void calculateFunctionArgs(Map<String, Node> namedArgValueMap, Queue<Node> positionalArgs, SeparatedNodeList<FunctionArgumentNode> argumentNodes) {
        if (argumentNodes != null) {
            for (FunctionArgumentNode argument : argumentNodes) {
                switch (argument.kind()) {
                    case NAMED_ARG: {
                        NamedArgumentNode namedArgument = (NamedArgumentNode)argument;
                        namedArgValueMap.put(namedArgument.argumentName().name().text(), (Node)namedArgument.expression());
                        break;
                    }
                    case POSITIONAL_ARG: {
                        positionalArgs.add((Node)((PositionalArgumentNode)argument).expression());
                        break;
                    }
                }
            }
        }
    }

    private void buildPropsFromFuncCallArgs(SeparatedNodeList<FunctionArgumentNode> argumentNodes, FunctionTypeSymbol functionTypeSymbol, Map<String, ParameterData> funcParamMap, Queue<Node> positionalArgs, Map<String, Node> namedArgValueMap) {
        boolean hasOnlyRestParams;
        if (argumentNodes == null) {
            List<ParameterData> functionParameters = funcParamMap.values().stream().toList();
            boolean hasOnlyRestParams2 = functionParameters.size() == 1;
            for (ParameterData paramResult : functionParameters) {
                ParameterData.Kind paramKind = paramResult.kind();
                if (paramKind.equals((Object)ParameterData.Kind.PATH_PARAM) || paramKind.equals((Object)ParameterData.Kind.PATH_REST_PARAM) || paramKind.equals((Object)ParameterData.Kind.PARAM_FOR_TYPE_INFER) || paramKind.equals((Object)ParameterData.Kind.INCLUDED_RECORD)) continue;
                String unescapedParamName = ParamUtils.removeLeadingSingleQuote(paramResult.name());
                String label = paramResult.label();
                Property.Builder<FormBuilder<NodeBuilder>> customPropBuilder = this.nodeBuilder.properties().custom();
                ((Property.Builder)((Property.Builder)customPropBuilder.metadata().label(label == null || label.isEmpty() ? unescapedParamName : label).description(paramResult.description()).stepOut()).codedata().kind(paramKind.name()).originalName(paramResult.name()).stepOut()).placeholder(paramResult.defaultValue()).typeConstraint(paramResult.type()).typeMembers(paramResult.typeMembers()).imports(paramResult.importStatements()).editable().defaultable(paramResult.optional());
                if (paramKind == ParameterData.Kind.INCLUDED_RECORD_REST) {
                    if (hasOnlyRestParams2) {
                        customPropBuilder.defaultable(false);
                    }
                    customPropBuilder.type(Property.ValueType.MAPPING_EXPRESSION_SET);
                } else if (paramKind == ParameterData.Kind.REST_PARAMETER) {
                    if (hasOnlyRestParams2) {
                        customPropBuilder.defaultable(false);
                    }
                    customPropBuilder.type(Property.ValueType.EXPRESSION_SET);
                } else if (paramResult.type() instanceof List) {
                    customPropBuilder.type(Property.ValueType.SINGLE_SELECT);
                } else {
                    customPropBuilder.type(Property.ValueType.EXPRESSION);
                }
                ((FormBuilder)customPropBuilder.stepOut()).addProperty(FlowNodeUtil.getPropertyKey(unescapedParamName));
            }
            return;
        }
        boolean bl = hasOnlyRestParams = funcParamMap.size() == 1;
        if (functionTypeSymbol.restParam().isPresent()) {
            ParameterSymbol restParamSymbol = (ParameterSymbol)functionTypeSymbol.restParam().get();
            Optional paramsOptional = functionTypeSymbol.params();
            if (paramsOptional.isPresent()) {
                int i;
                List paramsList = (List)paramsOptional.get();
                int paramCount = paramsList.size();
                int argCount = positionalArgs.size();
                ArrayList<String> restArgs = new ArrayList<String>();
                for (i = 0; i < paramsList.size(); ++i) {
                    ParameterSymbol parameterSymbol = (ParameterSymbol)paramsList.get(i);
                    String escapedParamName = (String)parameterSymbol.getName().get();
                    ParameterData paramResult = funcParamMap.get(escapedParamName);
                    if (paramResult == null) {
                        escapedParamName = CommonUtil.escapeReservedKeyword((String)((String)parameterSymbol.getName().get()));
                    }
                    paramResult = funcParamMap.get(escapedParamName);
                    Node paramValue = i < argCount ? positionalArgs.poll() : namedArgValueMap.get(paramResult.name());
                    funcParamMap.remove(parameterSymbol.getName().get());
                    Property.Builder<FormBuilder<NodeBuilder>> customPropBuilder = this.nodeBuilder.properties().custom();
                    String unescapedParamName = ParamUtils.removeLeadingSingleQuote(paramResult.name());
                    String value = null;
                    String selectedType = "";
                    if (paramValue != null) {
                        value = paramValue.toSourceCode();
                        Optional paramType = this.semanticModel.typeOf(paramValue);
                        if (paramType.isPresent()) {
                            if (((TypeSymbol)paramType.get()).getModule().isPresent()) {
                                ModuleID id = ((ModuleSymbol)((TypeSymbol)paramType.get()).getModule().get()).id();
                                selectedType = CommonUtils.getTypeSignature((TypeSymbol)((TypeSymbol)paramType.get()), (ModuleInfo)ModuleInfo.from((ModuleID)id));
                            } else {
                                selectedType = CommonUtils.getTypeSignature((TypeSymbol)((TypeSymbol)paramType.get()), null);
                            }
                        }
                    }
                    String label = paramResult.label();
                    ((FormBuilder)((Property.Builder)((Property.Builder)customPropBuilder.metadata().label(label == null || label.isEmpty() ? unescapedParamName : label).description(paramResult.description()).stepOut()).type(this.getPropertyTypeFromParam(parameterSymbol, paramResult)).typeConstraint(paramResult.type()).typeMembers(paramResult.typeMembers(), selectedType).imports(paramResult.importStatements()).value(value).placeholder(paramResult.defaultValue()).editable().defaultable(paramResult.optional()).codedata().kind(paramResult.kind().name()).originalName(paramResult.name()).stepOut()).stepOut()).addProperty(FlowNodeUtil.getPropertyKey(unescapedParamName));
                }
                for (i = paramCount; i < argCount; ++i) {
                    restArgs.add(Objects.requireNonNull(positionalArgs.poll()).toSourceCode());
                }
                Property.Builder<FormBuilder<NodeBuilder>> customPropBuilder = this.nodeBuilder.properties().custom();
                String escapedParamName = CommonUtil.escapeReservedKeyword((String)((String)restParamSymbol.getName().get()));
                ParameterData restParamResult = funcParamMap.get(escapedParamName);
                funcParamMap.remove(restParamSymbol.getName().get());
                String unescapedParamName = ParamUtils.removeLeadingSingleQuote(restParamResult.name());
                ((FormBuilder)((Property.Builder)((Property.Builder)customPropBuilder.metadata().label(unescapedParamName).description(restParamResult.description()).stepOut()).type(this.getPropertyTypeFromParam(restParamSymbol, restParamResult)).typeConstraint(restParamResult.type()).typeMembers(restParamResult.typeMembers()).imports(restParamResult.importStatements()).value(restArgs).placeholder(restParamResult.defaultValue()).editable().defaultable(!hasOnlyRestParams).codedata().kind(restParamResult.kind().name()).originalName(restParamResult.name()).stepOut()).stepOut()).addProperty(FlowNodeUtil.getPropertyKey(unescapedParamName));
            }
            this.addRemainingParamsToPropertyMap(funcParamMap, hasOnlyRestParams);
            return;
        }
        Optional paramsOptional = functionTypeSymbol.params();
        if (paramsOptional.isPresent()) {
            String label;
            Optional paramType;
            ModuleID id;
            String escapedParamName;
            List paramsList = (List)paramsOptional.get();
            int argCount = positionalArgs.size();
            ArrayList includedRecordRestArgs = new ArrayList();
            for (int i = 0; i < paramsList.size(); ++i) {
                String value;
                String unescapedParamName;
                Property.Builder<FormBuilder<NodeBuilder>> customPropBuilder;
                Node paramValue;
                ParameterSymbol parameterSymbol = (ParameterSymbol)paramsList.get(i);
                escapedParamName = (String)parameterSymbol.getName().get();
                ParameterData paramResult = funcParamMap.get(escapedParamName);
                if (paramResult == null) continue;
                paramResult = funcParamMap.get(escapedParamName);
                if (i < argCount) {
                    paramValue = positionalArgs.poll();
                } else {
                    paramValue = namedArgValueMap.get(paramResult.name());
                    namedArgValueMap.remove(paramResult.name());
                }
                if (paramResult.kind() == ParameterData.Kind.INCLUDED_RECORD) {
                    if (argumentNodes.size() > i && ((FunctionArgumentNode)argumentNodes.get(i)).kind() == SyntaxKind.NAMED_ARG) {
                        FunctionArgumentNode argNode = (FunctionArgumentNode)argumentNodes.get(i);
                        funcParamMap.remove(escapedParamName);
                        NamedArgumentNode namedArgumentNode = (NamedArgumentNode)argNode;
                        String argName = namedArgumentNode.argumentName().name().text();
                        if (argName.equals(paramResult.name())) {
                            paramResult = funcParamMap.get(escapedParamName);
                            customPropBuilder = this.nodeBuilder.properties().custom();
                            value = paramValue != null ? paramValue.toSourceCode() : null;
                            String unescapedParamName2 = ParamUtils.removeLeadingSingleQuote(paramResult.name());
                            paramType = this.semanticModel.typeOf(paramValue);
                            String selectedType = "";
                            if (paramType.isPresent()) {
                                if (((TypeSymbol)paramType.get()).getModule().isPresent()) {
                                    ModuleID id2 = ((ModuleSymbol)((TypeSymbol)paramType.get()).getModule().get()).id();
                                    selectedType = CommonUtils.getTypeSignature((TypeSymbol)((TypeSymbol)paramType.get()), (ModuleInfo)ModuleInfo.from((ModuleID)id2));
                                } else {
                                    selectedType = CommonUtils.getTypeSignature((TypeSymbol)((TypeSymbol)paramType.get()), null);
                                }
                            }
                            String label2 = paramResult.label();
                            ((FormBuilder)((Property.Builder)((Property.Builder)customPropBuilder.metadata().label(label2 == null || label2.isEmpty() ? unescapedParamName2 : label2).description(paramResult.description()).stepOut()).type(this.getPropertyTypeFromParam(parameterSymbol, paramResult)).typeConstraint(paramResult.type()).typeMembers(paramResult.typeMembers(), selectedType).imports(paramResult.importStatements()).value(value).placeholder(paramResult.defaultValue()).editable().defaultable(paramResult.optional()).codedata().kind(paramResult.kind().name()).originalName(paramResult.name()).stepOut()).stepOut()).addProperty(FlowNodeUtil.getPropertyKey(unescapedParamName2), paramValue);
                        } else if (funcParamMap.containsKey(argName)) {
                            paramResult = funcParamMap.get(argName);
                            funcParamMap.remove(argName);
                            customPropBuilder = this.nodeBuilder.properties().custom();
                            if (paramValue == null) {
                                paramValue = namedArgValueMap.get(argName);
                                namedArgValueMap.remove(argName);
                            }
                            value = null;
                            String selectedType = "";
                            if (paramValue != null) {
                                value = paramValue.toSourceCode();
                                paramType = this.semanticModel.typeOf(paramValue);
                                if (paramType.isPresent()) {
                                    if (((TypeSymbol)paramType.get()).getModule().isPresent()) {
                                        ModuleID id3 = ((ModuleSymbol)((TypeSymbol)paramType.get()).getModule().get()).id();
                                        selectedType = CommonUtils.getTypeSignature((TypeSymbol)((TypeSymbol)paramType.get()), (ModuleInfo)ModuleInfo.from((ModuleID)id3));
                                    } else {
                                        selectedType = CommonUtils.getTypeSignature((TypeSymbol)((TypeSymbol)paramType.get()), null);
                                    }
                                }
                            }
                            String unescapedParamName3 = ParamUtils.removeLeadingSingleQuote(paramResult.name());
                            String label3 = paramResult.label();
                            ((FormBuilder)((Property.Builder)((Property.Builder)customPropBuilder.metadata().label(label3 == null || label3.isEmpty() ? unescapedParamName3 : label3).description(paramResult.description()).stepOut()).type(this.getPropertyTypeFromParam(parameterSymbol, paramResult)).typeConstraint(paramResult.type()).typeMembers(paramResult.typeMembers(), selectedType).imports(paramResult.importStatements()).value(value).placeholder(paramResult.defaultValue()).editable().defaultable(paramResult.optional()).codedata().kind(paramResult.kind().name()).originalName(paramResult.name()).stepOut()).stepOut()).addProperty(FlowNodeUtil.getPropertyKey(unescapedParamName3), paramValue);
                        }
                    } else if (paramValue != null) {
                        customPropBuilder = this.nodeBuilder.properties().custom();
                        unescapedParamName = ParamUtils.removeLeadingSingleQuote(paramResult.name());
                        funcParamMap.remove(escapedParamName);
                        value = paramValue.toSourceCode();
                        Optional paramType2 = this.semanticModel.typeOf(paramValue);
                        String selectedType = "";
                        if (paramType2.isPresent()) {
                            if (((TypeSymbol)paramType2.get()).getModule().isPresent()) {
                                id = ((ModuleSymbol)((TypeSymbol)paramType2.get()).getModule().get()).id();
                                selectedType = CommonUtils.getTypeSignature((TypeSymbol)((TypeSymbol)paramType2.get()), (ModuleInfo)ModuleInfo.from((ModuleID)id));
                            } else {
                                selectedType = CommonUtils.getTypeSignature((TypeSymbol)((TypeSymbol)paramType2.get()), null);
                            }
                        }
                        String label4 = paramResult.label();
                        ((FormBuilder)((Property.Builder)((Property.Builder)customPropBuilder.metadata().label(label4 == null || label4.isEmpty() ? unescapedParamName : label4).description(paramResult.description()).stepOut()).type(this.getPropertyTypeFromParam(parameterSymbol, paramResult)).typeConstraint(paramResult.type()).typeMembers(paramResult.typeMembers(), selectedType).imports(paramResult.importStatements()).value(value).placeholder(paramResult.defaultValue()).editable().defaultable(paramResult.optional()).codedata().kind(paramResult.kind().name()).originalName(paramResult.name()).stepOut()).stepOut()).addProperty(FlowNodeUtil.getPropertyKey(unescapedParamName), paramValue);
                        return;
                    }
                }
                if (paramValue == null && paramResult.kind() == ParameterData.Kind.INCLUDED_RECORD) {
                    funcParamMap.remove(escapedParamName);
                    continue;
                }
                customPropBuilder = this.nodeBuilder.properties().custom();
                funcParamMap.remove(escapedParamName);
                unescapedParamName = ParamUtils.removeLeadingSingleQuote(paramResult.name());
                value = null;
                String selectedType = "";
                if (paramValue != null) {
                    value = paramValue.toSourceCode();
                    paramType = this.semanticModel.typeOf(paramValue);
                    if (paramType.isPresent()) {
                        if (((TypeSymbol)paramType.get()).getModule().isPresent()) {
                            id = ((ModuleSymbol)((TypeSymbol)paramType.get()).getModule().get()).id();
                            selectedType = CommonUtils.getTypeSignature((TypeSymbol)((TypeSymbol)paramType.get()), (ModuleInfo)ModuleInfo.from((ModuleID)id));
                        } else {
                            selectedType = CommonUtils.getTypeSignature((TypeSymbol)((TypeSymbol)paramType.get()), null);
                        }
                    }
                }
                label = paramResult.label();
                ((FormBuilder)((Property.Builder)((Property.Builder)customPropBuilder.metadata().label(label == null || label.isEmpty() ? unescapedParamName : label).description(paramResult.description()).stepOut()).type(this.getPropertyTypeFromParam(parameterSymbol, paramResult)).typeConstraint(paramResult.type()).typeMembers(paramResult.typeMembers(), selectedType).imports(paramResult.importStatements()).value(value).placeholder(paramResult.defaultValue()).editable().defaultable(paramResult.optional()).codedata().kind(paramResult.kind().name()).originalName(paramResult.name()).stepOut()).stepOut()).addProperty(FlowNodeUtil.getPropertyKey(unescapedParamName), paramValue);
            }
            for (Map.Entry<String, Node> entry : namedArgValueMap.entrySet()) {
                escapedParamName = CommonUtil.escapeReservedKeyword((String)entry.getKey());
                if (!funcParamMap.containsKey(escapedParamName)) {
                    LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                    map.put(entry.getKey(), entry.getValue().toSourceCode());
                    includedRecordRestArgs.add(map);
                    continue;
                }
                Property.Builder<FormBuilder<NodeBuilder>> customPropBuilder = this.nodeBuilder.properties().custom();
                ParameterData paramResult = funcParamMap.remove(escapedParamName);
                String unescapedParamName = ParamUtils.removeLeadingSingleQuote(paramResult.name());
                String value = null;
                String selectedType = "";
                Node paramValue = entry.getValue();
                if (paramValue != null) {
                    value = paramValue.toSourceCode();
                    paramType = this.semanticModel.typeOf(paramValue);
                    if (paramType.isPresent()) {
                        if (((TypeSymbol)paramType.get()).getModule().isPresent()) {
                            id = ((ModuleSymbol)((TypeSymbol)paramType.get()).getModule().get()).id();
                            selectedType = CommonUtils.getTypeSignature((TypeSymbol)((TypeSymbol)paramType.get()), (ModuleInfo)ModuleInfo.from((ModuleID)id));
                        } else {
                            selectedType = CommonUtils.getTypeSignature((TypeSymbol)((TypeSymbol)paramType.get()), null);
                        }
                    }
                }
                label = paramResult.label();
                ((FormBuilder)((Property.Builder)((Property.Builder)customPropBuilder.metadata().label(label == null || label.isEmpty() ? unescapedParamName : label).description(paramResult.description()).stepOut()).type(this.getPropertyTypeFromParam(null, paramResult)).typeConstraint(paramResult.type()).typeMembers(paramResult.typeMembers(), selectedType).imports(paramResult.importStatements()).value(value).placeholder(paramResult.defaultValue()).editable().defaultable(paramResult.optional()).codedata().kind(paramResult.kind().name()).originalName(paramResult.name()).stepOut()).stepOut()).addProperty(FlowNodeUtil.getPropertyKey(unescapedParamName), paramValue);
            }
            ParameterData includedRecordRest = funcParamMap.get("Additional Values");
            if (includedRecordRest != null) {
                funcParamMap.remove("Additional Values");
                Property.Builder<FormBuilder<NodeBuilder>> customPropBuilder = this.nodeBuilder.properties().custom();
                String unescapedParamName = ParamUtils.removeLeadingSingleQuote(includedRecordRest.name());
                ((FormBuilder)((Property.Builder)((Property.Builder)customPropBuilder.metadata().label(unescapedParamName).description(includedRecordRest.description()).stepOut()).type(this.getPropertyTypeFromParam(null, includedRecordRest)).typeConstraint(includedRecordRest.type()).typeMembers(includedRecordRest.typeMembers()).imports(includedRecordRest.importStatements()).value(includedRecordRestArgs).placeholder(includedRecordRest.defaultValue()).editable().defaultable(includedRecordRest.optional()).codedata().kind(includedRecordRest.kind().name()).originalName(includedRecordRest.name()).stepOut()).stepOut()).addProperty("additionalValues");
            }
            this.addRemainingParamsToPropertyMap(funcParamMap, hasOnlyRestParams);
        }
    }

    private void handleCheckFlag(NonTerminalNode node, FunctionTypeSymbol functionTypeSymbol) {
        SyntaxKind parentKind = node.parent().kind();
        if (parentKind == SyntaxKind.CHECK_ACTION || parentKind == SyntaxKind.CHECK_EXPRESSION) {
            this.nodeBuilder.properties().checkError(true);
        } else {
            functionTypeSymbol.returnTypeDescriptor().ifPresent(typeSymbol -> {
                if (CommonUtils.subTypeOf((TypeSymbol)typeSymbol, (TypeSymbol)this.semanticModel.types().ERROR) && CommonUtils.withinDoClause((NonTerminalNode)node)) {
                    this.nodeBuilder.properties().checkError(false);
                }
            });
        }
    }

    private Property.ValueType getPropertyTypeFromParam(ParameterSymbol paramSymbol, ParameterData paramData) {
        ParameterData.Kind kind = paramData.kind();
        if (kind == ParameterData.Kind.REST_PARAMETER) {
            return Property.ValueType.EXPRESSION_SET;
        }
        if (kind == ParameterData.Kind.INCLUDED_RECORD_REST) {
            return Property.ValueType.MAPPING_EXPRESSION_SET;
        }
        if (paramSymbol != null && this.isSubTypeOfRawTemplate(paramSymbol.typeDescriptor())) {
            return Property.ValueType.RAW_TEMPLATE;
        }
        if (paramData.type() instanceof List) {
            return Property.ValueType.SINGLE_SELECT;
        }
        return Property.ValueType.EXPRESSION;
    }

    public void visit(IfElseStatementNode ifElseStatementNode) {
        this.startNode(NodeKind.IF, (Node)ifElseStatementNode);
        this.addConditionalBranch(ifElseStatementNode.condition(), ifElseStatementNode.ifBody(), "Then");
        ifElseStatementNode.elseBody().ifPresent(this::analyzeElseBody);
        this.endNode((Node)ifElseStatementNode);
    }

    private void addConditionalBranch(ExpressionNode condition, BlockStatementNode body, String label) {
        Branch.Builder branchBuilder = (Branch.Builder)this.startBranch(label, NodeKind.CONDITIONAL, Branch.BranchKind.BLOCK, Branch.Repeatable.ONE_OR_MORE).properties().condition(condition).stepOut();
        this.analyzeBlock(body, branchBuilder);
        this.endBranch(branchBuilder, (Node)body);
    }

    private void analyzeElseBody(Node elseBody) {
        switch (elseBody.kind()) {
            case ELSE_BLOCK: {
                this.analyzeElseBody((Node)((ElseBlockNode)elseBody).elseBody());
                break;
            }
            case BLOCK_STATEMENT: {
                Branch.Builder branchBuilder = this.startBranch("Else", NodeKind.ELSE, Branch.BranchKind.BLOCK, Branch.Repeatable.ZERO_OR_ONE);
                this.analyzeBlock((BlockStatementNode)elseBody, branchBuilder);
                this.endBranch(branchBuilder, elseBody);
                break;
            }
            case IF_ELSE_STATEMENT: {
                IfElseStatementNode ifElseNode = (IfElseStatementNode)elseBody;
                this.addConditionalBranch(ifElseNode.condition(), ifElseNode.ifBody(), ifElseNode.condition().toSourceCode().strip());
                ifElseNode.elseBody().ifPresent(this::analyzeElseBody);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected else body kind: " + String.valueOf(elseBody.kind()));
            }
        }
    }

    public void visit(ImplicitNewExpressionNode implicitNewExpressionNode) {
        SeparatedNodeList argumentNodes = implicitNewExpressionNode.parenthesizedArgList().map(ParenthesizedArgList::arguments).orElse(null);
        this.checkForNewConnectionOrAgent((NewExpressionNode)implicitNewExpressionNode, (SeparatedNodeList<FunctionArgumentNode>)argumentNodes);
    }

    public void visit(ExplicitNewExpressionNode explicitNewExpressionNode) {
        SeparatedNodeList argumentNodes = explicitNewExpressionNode.parenthesizedArgList().arguments();
        this.checkForNewConnectionOrAgent((NewExpressionNode)explicitNewExpressionNode, (SeparatedNodeList<FunctionArgumentNode>)argumentNodes);
    }

    private void checkForNewConnectionOrAgent(NewExpressionNode newExpressionNode, SeparatedNodeList<FunctionArgumentNode> argumentNodes) {
        FunctionData functionData;
        Optional<ClassSymbol> optClassSymbol = this.getClassSymbol((ExpressionNode)newExpressionNode);
        if (optClassSymbol.isEmpty()) {
            return;
        }
        ClassSymbol classSymbol = optClassSymbol.get();
        if (this.isAgentCall((Symbol)classSymbol)) {
            this.startNode(NodeKind.AGENT, (Node)newExpressionNode);
        } else if (this.isAIModel(classSymbol)) {
            this.startNode(NodeKind.CLASS_INIT, (Node)newExpressionNode);
        } else if (classSymbol.qualifiers().contains(Qualifier.CLIENT)) {
            this.startNode(NodeKind.NEW_CONNECTION, (Node)newExpressionNode);
        } else {
            this.handleExpressionNode((NonTerminalNode)newExpressionNode);
            return;
        }
        Optional optMethodSymbol = classSymbol.initMethod();
        FunctionDataBuilder functionDataBuilder = new FunctionDataBuilder().parentSymbol((ObjectTypeSymbol)classSymbol).semanticModel(this.semanticModel).name("init").functionResultKind(FunctionData.Kind.CONNECTOR).userModuleInfo(this.moduleInfo);
        if (optMethodSymbol.isPresent()) {
            MethodSymbol methodSymbol = (MethodSymbol)optMethodSymbol.get();
            functionDataBuilder.functionSymbol((FunctionSymbol)methodSymbol);
            functionData = functionDataBuilder.build();
            this.processFunctionSymbol((NonTerminalNode)newExpressionNode, argumentNodes, (FunctionSymbol)methodSymbol, functionData);
        } else {
            functionData = functionDataBuilder.build();
        }
        String org = functionData.org();
        String packageName = functionData.packageName();
        String name = classSymbol.getName().orElse("");
        ((NodeBuilder)((NodeBuilder)this.nodeBuilder.metadata().label(packageName).description(functionData.description()).icon(CommonUtils.generateIcon((String)org, (String)packageName, (String)functionData.version())).stepOut()).codedata().org(org).module(packageName).object(name).symbol("init").stepOut()).properties().scope(this.connectionScope).checkError(true, "Terminate on error", false);
    }

    private Optional<ClassSymbol> getClassSymbol(ExpressionNode newExpressionNode) {
        Optional typeSymbol = CommonUtils.getTypeSymbol((SemanticModel)this.semanticModel, (Node)newExpressionNode).flatMap(symbol -> {
            if (symbol.typeKind() == TypeDescKind.UNION) {
                return ((UnionTypeSymbol)symbol).memberTypeDescriptors().stream().filter(tSymbol -> !tSymbol.subtypeOf(this.semanticModel.types().ERROR)).findFirst();
            }
            return Optional.of(symbol);
        });
        if (typeSymbol.isEmpty()) {
            return Optional.empty();
        }
        if (((TypeSymbol)typeSymbol.get()).typeKind() != TypeDescKind.TYPE_REFERENCE) {
            return Optional.empty();
        }
        Symbol defintionSymbol = ((TypeReferenceTypeSymbol)typeSymbol.get()).definition();
        if (defintionSymbol.kind() != SymbolKind.CLASS) {
            return Optional.empty();
        }
        return Optional.of((ClassSymbol)defintionSymbol);
    }

    public void visit(TemplateExpressionNode templateExpressionNode) {
        if (this.forceAssign) {
            return;
        }
        if (templateExpressionNode.kind() == SyntaxKind.XML_TEMPLATE_EXPRESSION) {
            ((NodeBuilder)this.startNode(NodeKind.XML_PAYLOAD, (Node)templateExpressionNode).metadata().description("Assign XML").stepOut()).properties().expression((ExpressionNode)templateExpressionNode);
        }
    }

    public void visit(ByteArrayLiteralNode byteArrayLiteralNode) {
        if (this.forceAssign) {
            return;
        }
        ((NodeBuilder)this.startNode(NodeKind.BINARY_DATA, (Node)byteArrayLiteralNode).metadata().stepOut()).properties().expression((ExpressionNode)byteArrayLiteralNode);
    }

    public void visit(VariableDeclarationNode variableDeclarationNode) {
        this.handleVariableNode((NonTerminalNode)variableDeclarationNode);
    }

    private void handleVariableNode(NonTerminalNode variableDeclarationNode) {
        Optional initializer;
        Optional finalKeyword = switch (variableDeclarationNode.kind()) {
            case SyntaxKind.LOCAL_VAR_DECL -> {
                VariableDeclarationNode localVariableDeclarationNode = (VariableDeclarationNode)variableDeclarationNode;
                initializer = localVariableDeclarationNode.initializer();
                this.typedBindingPatternNode = localVariableDeclarationNode.typedBindingPattern();
                yield localVariableDeclarationNode.finalKeyword();
            }
            case SyntaxKind.MODULE_VAR_DECL -> {
                ModuleVariableDeclarationNode moduleVariableDeclarationNode = (ModuleVariableDeclarationNode)variableDeclarationNode;
                initializer = moduleVariableDeclarationNode.initializer();
                this.typedBindingPatternNode = moduleVariableDeclarationNode.typedBindingPattern();
                yield Optional.empty();
            }
            default -> throw new IllegalStateException("Unexpected variable declaration kind: " + String.valueOf(variableDeclarationNode.kind()));
        };
        boolean implicit = false;
        if (initializer.isEmpty()) {
            implicit = true;
            ((NodeBuilder)this.startNode(NodeKind.VARIABLE, (Node)variableDeclarationNode).metadata().description("Assign a value to a variable").stepOut()).properties().expressionOrAction(null, "Initialize with value", true);
        } else {
            ExpressionNode initializerNode = (ExpressionNode)initializer.get();
            initializerNode.accept((NodeVisitor)this);
            if (this.isNodeUnidentified()) {
                implicit = true;
                ((NodeBuilder)this.startNode(NodeKind.VARIABLE, (Node)variableDeclarationNode).metadata().description("Assign a value to a variable").stepOut()).properties().expressionOrAction(initializerNode, "Initialize with value", true);
            }
        }
        if (this.nodeBuilder instanceof DataMapperBuilder) {
            this.nodeBuilder.properties().data((Node)this.typedBindingPatternNode, new HashSet<String>());
        } else if (this.nodeBuilder instanceof XmlPayloadBuilder) {
            this.nodeBuilder.properties().payload(this.typedBindingPatternNode, "xml");
        } else if (this.nodeBuilder instanceof JsonPayloadBuilder) {
            this.nodeBuilder.properties().payload(this.typedBindingPatternNode, "json");
        } else if (this.nodeBuilder instanceof BinaryBuilder) {
            this.nodeBuilder.properties().payload(this.typedBindingPatternNode, "byte[]");
        } else if (this.nodeBuilder instanceof NewConnectionBuilder) {
            this.nodeBuilder.properties().dataVariable(this.typedBindingPatternNode, "Connection Name", "Connection Type", false, new HashSet<String>());
        } else if (this.nodeBuilder instanceof RemoteActionCallBuilder || this.nodeBuilder instanceof ResourceActionCallBuilder || this.nodeBuilder instanceof FunctionCall || this.nodeBuilder instanceof MethodCall) {
            this.nodeBuilder.properties().dataVariable(this.typedBindingPatternNode, "Variable Name", "Variable Type", false, new HashSet<String>());
        } else {
            this.nodeBuilder.properties().dataVariable(this.typedBindingPatternNode, implicit, new HashSet<String>());
        }
        finalKeyword.ifPresent(token -> this.nodeBuilder.flag(4));
        this.endNode((Node)variableDeclarationNode);
        this.typedBindingPatternNode = null;
    }

    public void visit(ModuleVariableDeclarationNode moduleVariableDeclarationNode) {
        this.handleVariableNode((NonTerminalNode)moduleVariableDeclarationNode);
    }

    public void visit(AssignmentStatementNode assignmentStatementNode) {
        ExpressionNode expression = assignmentStatementNode.expression();
        expression.accept((NodeVisitor)this);
        if (this.isNodeUnidentified()) {
            ((NodeBuilder)this.startNode(NodeKind.ASSIGN, (Node)assignmentStatementNode).metadata().description("Assign a value to a variable").stepOut()).properties().expressionOrAction(expression, "Assign value", false);
            ((FormBuilder)((Property.Builder)this.nodeBuilder.properties().custom().metadata().label("Variable").description("Name of the variable/field").stepOut()).type(Property.ValueType.LV_EXPRESSION).value(CommonUtils.getVariableName((Node)assignmentStatementNode.varRef())).editable().stepOut()).addProperty("variable");
        }
        this.endNode((Node)assignmentStatementNode);
    }

    public void visit(CompoundAssignmentStatementNode compoundAssignmentStatementNode) {
        this.handleDefaultStatementNode((NonTerminalNode)compoundAssignmentStatementNode);
    }

    public void visit(BlockStatementNode blockStatementNode) {
        this.handleDefaultStatementNode((NonTerminalNode)blockStatementNode);
    }

    public void visit(QueryActionNode queryActionNode) {
        this.handleDefaultStatementNode((NonTerminalNode)queryActionNode);
    }

    public void visit(BreakStatementNode breakStatementNode) {
        this.startNode(NodeKind.BREAK, (Node)breakStatementNode);
        this.endNode((Node)breakStatementNode);
    }

    public void visit(FailStatementNode failStatementNode) {
        this.startNode(NodeKind.FAIL, (Node)failStatementNode).properties().expression(failStatementNode.expression(), "Fail value", false, TypesGenerator.TYPE_ERROR);
        this.endNode((Node)failStatementNode);
    }

    public void visit(ExpressionStatementNode expressionStatementNode) {
        expressionStatementNode.expression().accept((NodeVisitor)this);
        if (this.isNodeUnidentified()) {
            this.handleExpressionNode((NonTerminalNode)expressionStatementNode);
        }
        this.endNode((Node)expressionStatementNode);
    }

    public void visit(ContinueStatementNode continueStatementNode) {
        this.startNode(NodeKind.CONTINUE, (Node)continueStatementNode);
        this.endNode((Node)continueStatementNode);
    }

    public void visit(MethodCallExpressionNode methodCallExpressionNode) {
        Object t;
        Optional symbol = this.semanticModel.symbol((Node)methodCallExpressionNode);
        if (symbol.isEmpty() || !((t = symbol.get()) instanceof FunctionSymbol)) {
            this.handleExpressionNode((NonTerminalNode)methodCallExpressionNode);
            return;
        }
        FunctionSymbol functionSymbol = (FunctionSymbol)t;
        if (CommonUtils.isValueLangLibFunction((FunctionSymbol)functionSymbol)) {
            return;
        }
        Optional<ClassSymbol> classSymbol = this.getClassSymbol(methodCallExpressionNode.expression());
        if (classSymbol.isEmpty()) {
            this.handleExpressionNode((NonTerminalNode)methodCallExpressionNode);
            return;
        }
        ExpressionNode expressionNode = methodCallExpressionNode.expression();
        NameReferenceNode nameReferenceNode = methodCallExpressionNode.methodName();
        String functionName = CodeAnalyzer.getIdentifierName(nameReferenceNode);
        this.startNode(NodeKind.METHOD_CALL, (Node)methodCallExpressionNode.parent());
        if (CommonUtils.isDefaultPackage((Symbol)functionSymbol, (ModuleInfo)this.moduleInfo)) {
            functionSymbol.getLocation().flatMap(location -> CommonUtil.findNode((Symbol)functionSymbol, (SyntaxTree)CommonUtils.getDocument((Project)this.project, (Location)location).syntaxTree())).ifPresent(node -> this.nodeBuilder.properties().view(node.lineRange()));
        }
        FunctionDataBuilder functionDataBuilder = new FunctionDataBuilder().name(functionName).functionSymbol(functionSymbol).semanticModel(this.semanticModel).userModuleInfo(this.moduleInfo);
        FunctionData functionData = functionDataBuilder.build();
        ((NodeBuilder)this.nodeBuilder.symbolInfo((Symbol)functionSymbol).metadata().label(functionName).description(functionData.description()).stepOut()).codedata().symbol(functionName).object(classSymbol.get().getName().orElse(""));
        if (classSymbol.get().qualifiers().contains(Qualifier.CLIENT)) {
            this.nodeBuilder.properties().callConnection(expressionNode, "connection");
        } else {
            this.nodeBuilder.properties().callExpression(expressionNode, "connection");
        }
        this.processFunctionSymbol((NonTerminalNode)methodCallExpressionNode, (SeparatedNodeList<FunctionArgumentNode>)methodCallExpressionNode.arguments(), functionSymbol, functionData);
    }

    public void visit(FunctionCallExpressionNode functionCallExpressionNode) {
        Optional symbol = this.semanticModel.symbol((Node)functionCallExpressionNode);
        if (symbol.isEmpty() || ((Symbol)symbol.get()).kind() != SymbolKind.FUNCTION) {
            this.handleExpressionNode((NonTerminalNode)functionCallExpressionNode);
            return;
        }
        FunctionSymbol functionSymbol = (FunctionSymbol)symbol.get();
        NameReferenceNode nameReferenceNode = functionCallExpressionNode.functionName();
        String functionName = CodeAnalyzer.getIdentifierName(nameReferenceNode);
        if (this.dataMappings.containsKey(functionName)) {
            this.startNode(NodeKind.DATA_MAPPER_CALL, (Node)functionCallExpressionNode.parent());
        } else if (this.isAgentCall((Symbol)symbol.get())) {
            this.startNode(NodeKind.AGENT_CALL, (Node)functionCallExpressionNode.parent());
        } else if (this.naturalFunctions.containsKey(functionName)) {
            this.startNode(NodeKind.NP_FUNCTION_CALL, (Node)functionCallExpressionNode.parent());
        } else {
            this.startNode(NodeKind.FUNCTION_CALL, (Node)functionCallExpressionNode.parent());
        }
        if (CommonUtils.isDefaultPackage((Symbol)functionSymbol, (ModuleInfo)this.moduleInfo)) {
            functionSymbol.getLocation().flatMap(location -> CommonUtil.findNode((Symbol)functionSymbol, (SyntaxTree)CommonUtils.getDocument((Project)this.project, (Location)location).syntaxTree())).ifPresent(node -> this.nodeBuilder.properties().view(node.lineRange()));
        }
        FunctionDataBuilder functionDataBuilder = new FunctionDataBuilder().name(functionName).functionSymbol(functionSymbol).semanticModel(this.semanticModel).userModuleInfo(this.moduleInfo);
        FunctionData functionData = functionDataBuilder.build();
        this.processFunctionSymbol((NonTerminalNode)functionCallExpressionNode, (SeparatedNodeList<FunctionArgumentNode>)functionCallExpressionNode.arguments(), functionSymbol, functionData);
        ((NodeBuilder)this.nodeBuilder.symbolInfo((Symbol)functionSymbol).metadata().label(functionName).description(functionData.description()).stepOut()).codedata().symbol(functionName);
    }

    private void processFunctionSymbol(NonTerminalNode callNode, SeparatedNodeList<FunctionArgumentNode> arguments, FunctionSymbol functionSymbol, FunctionData functionData) {
        HashMap<String, Node> namedArgValueMap = new HashMap<String, Node>();
        LinkedList<Node> positionalArgs = new LinkedList<Node>();
        this.calculateFunctionArgs(namedArgValueMap, positionalArgs, arguments);
        LinkedHashMap<String, ParameterData> funcParamMap = new LinkedHashMap<String, ParameterData>();
        FunctionTypeSymbol functionTypeSymbol = functionSymbol.typeDescriptor();
        functionData.parameters().forEach((key, paramResult) -> {
            String inferredTypeName;
            if (paramResult.kind() == ParameterData.Kind.PATH_PARAM) {
                return;
            }
            if (paramResult.kind() != ParameterData.Kind.PARAM_FOR_TYPE_INFER) {
                funcParamMap.put((String)key, (ParameterData)paramResult);
                return;
            }
            String returnType = functionData.returnType();
            Node node = (Node)namedArgValueMap.get(key);
            if (node != null) {
                inferredTypeName = node.toSourceCode();
            } else if (this.typedBindingPatternNode == null) {
                inferredTypeName = paramResult.defaultValue();
            } else {
                Optional symbol = this.semanticModel.symbol((Node)this.typedBindingPatternNode);
                if (symbol.isEmpty() || ((Symbol)symbol.get()).kind() != SymbolKind.VARIABLE) {
                    return;
                }
                String variableType = CommonUtils.getTypeSignature((TypeSymbol)((VariableSymbol)symbol.get()).typeDescriptor(), (ModuleInfo)this.moduleInfo);
                inferredTypeName = CodeAnalyzer.deriveInferredType(variableType, returnType, key);
            }
            this.nodeBuilder.codedata().inferredReturnType(functionData.returnError() ? returnType : null);
            CallBuilder.buildInferredTypeProperty(this.nodeBuilder, paramResult, inferredTypeName);
        });
        this.buildPropsFromFuncCallArgs(arguments, functionTypeSymbol, funcParamMap, positionalArgs, namedArgValueMap);
        this.handleCheckFlag(callNode, functionTypeSymbol);
    }

    private static String deriveInferredType(String variableType, String returnType, String key) {
        int keyIndex = returnType.indexOf(key);
        if (keyIndex == -1) {
            return variableType;
        }
        String prefix = returnType.substring(0, keyIndex);
        String suffix = returnType.substring(keyIndex + key.length());
        if (variableType.startsWith(prefix) && variableType.endsWith(suffix)) {
            return variableType.substring(prefix.length(), variableType.length() - suffix.length());
        }
        return variableType;
    }

    private boolean isAgentCall(Symbol symbol) {
        boolean isAIModule;
        Optional optModule = symbol.getModule();
        if (optModule.isEmpty()) {
            return false;
        }
        ModuleID id = ((ModuleSymbol)optModule.get()).id();
        boolean bl = isAIModule = id.orgName().equals(BALLERINAX) && id.packageName().equals(AI_AGENT);
        if (!isAIModule) {
            return false;
        }
        return symbol.getName().isPresent() && ((String)symbol.getName().get()).equals("Agent");
    }

    private boolean isAIModel(ClassSymbol classSymbol) {
        boolean isAIModule;
        Optional optModule = classSymbol.getModule();
        if (optModule.isEmpty()) {
            return false;
        }
        ModuleID id = ((ModuleSymbol)optModule.get()).id();
        boolean bl = isAIModule = id.orgName().equals(BALLERINAX) && id.packageName().equals(AI_AGENT);
        if (!isAIModule) {
            return false;
        }
        for (TypeSymbol typeSymbol : classSymbol.typeInclusions()) {
            String name;
            Optional optName = typeSymbol.getName();
            if (!optName.isPresent() || !(name = (String)optName.get()).equals("ModelProvider") && !name.equals("MemoryManager")) continue;
            return true;
        }
        return false;
    }

    private ModelData getModelIconUrl(ExpressionNode expressionNode) {
        if (expressionNode.kind() == SyntaxKind.SIMPLE_NAME_REFERENCE) {
            Optional symbolName;
            Optional optSymbol = this.semanticModel.symbol((Node)expressionNode);
            if (optSymbol.isEmpty()) {
                return null;
            }
            Symbol symbol = (Symbol)optSymbol.get();
            if (symbol.kind() == SymbolKind.VARIABLE) {
                symbolName = ((VariableSymbol)symbol).typeDescriptor().getName();
            } else if (symbol.kind() == SymbolKind.CLASS_FIELD) {
                symbolName = ((ClassFieldSymbol)symbol).typeDescriptor().getName();
            } else {
                return null;
            }
            Optional optModule = symbol.getModule();
            if (optModule.isEmpty()) {
                return null;
            }
            ModuleID id = ((ModuleSymbol)optModule.get()).id();
            return new ModelData((String)((Symbol)optSymbol.get()).getName().orElseThrow(), CommonUtils.generateIcon((String)id.moduleName(), (String)id.packageName(), (String)id.version()), symbolName.orElse(""));
        }
        if (expressionNode.kind() == SyntaxKind.FIELD_ACCESS) {
            FieldAccessExpressionNode fieldAccessExpressionNode = (FieldAccessExpressionNode)expressionNode;
            return this.getModelIconUrl((ExpressionNode)fieldAccessExpressionNode.fieldName());
        }
        return null;
    }

    private static String getIdentifierName(NameReferenceNode nameReferenceNode) {
        return switch (nameReferenceNode.kind()) {
            case SyntaxKind.QUALIFIED_NAME_REFERENCE -> ((QualifiedNameReferenceNode)nameReferenceNode).identifier().text();
            case SyntaxKind.SIMPLE_NAME_REFERENCE -> ((SimpleNameReferenceNode)nameReferenceNode).name().text();
            default -> "";
        };
    }

    public void visit(WhileStatementNode whileStatementNode) {
        this.startNode(NodeKind.WHILE, (Node)whileStatementNode).properties().condition(whileStatementNode.condition());
        BlockStatementNode whileBody = whileStatementNode.whileBody();
        Branch.Builder branchBuilder = this.startBranch("Body", NodeKind.CONDITIONAL, Branch.BranchKind.BLOCK, Branch.Repeatable.ONE);
        this.analyzeBlock(whileBody, branchBuilder);
        this.endBranch(branchBuilder, (Node)whileBody);
        whileStatementNode.onFailClause().ifPresent(this::processOnFailClause);
        this.endNode((Node)whileStatementNode);
    }

    private void processOnFailClause(OnFailClauseNode onFailClauseNode) {
        Branch.Builder branchBuilder = this.startBranch("On Failure", NodeKind.ON_FAILURE, Branch.BranchKind.BLOCK, Branch.Repeatable.ZERO_OR_ONE);
        if (onFailClauseNode.typedBindingPattern().isPresent()) {
            branchBuilder.properties().ignore(false).onErrorVariable((TypedBindingPatternNode)onFailClauseNode.typedBindingPattern().get());
        }
        BlockStatementNode onFailClauseBlock = onFailClauseNode.blockStatement();
        this.analyzeBlock(onFailClauseBlock, branchBuilder);
        this.endBranch(branchBuilder, (Node)onFailClauseBlock);
    }

    public void visit(PanicStatementNode panicStatementNode) {
        this.startNode(NodeKind.PANIC, (Node)panicStatementNode).properties().expression(panicStatementNode.expression(), "Panic value", false, TypesGenerator.TYPE_ERROR);
        this.endNode((Node)panicStatementNode);
    }

    public void visit(LocalTypeDefinitionStatementNode localTypeDefinitionStatementNode) {
        this.handleDefaultStatementNode((NonTerminalNode)localTypeDefinitionStatementNode);
    }

    public void visit(StartActionNode startActionNode) {
        this.startNode(NodeKind.START, (Node)startActionNode).properties().expressionOrAction(startActionNode.expression(), "Call action or expression", false);
    }

    public void visit(LockStatementNode lockStatementNode) {
        this.startNode(NodeKind.LOCK, (Node)lockStatementNode);
        Branch.Builder branchBuilder = this.startBranch("Body", NodeKind.BODY, Branch.BranchKind.BLOCK, Branch.Repeatable.ONE);
        BlockStatementNode lockBody = lockStatementNode.blockStatement();
        this.analyzeBlock(lockBody, branchBuilder);
        this.endBranch(branchBuilder, (Node)lockBody);
        lockStatementNode.onFailClause().ifPresent(this::processOnFailClause);
        this.endNode((Node)lockStatementNode);
    }

    public void visit(ForkStatementNode forkStatementNode) {
        this.startNode(NodeKind.FORK, (Node)forkStatementNode);
        forkStatementNode.namedWorkerDeclarations().forEach(this::visit);
        this.endNode((Node)forkStatementNode);
    }

    public void visit(NamedWorkerDeclarator namedWorkerDeclarator) {
        namedWorkerDeclarator.workerInitStatements().forEach(statement -> statement.accept((NodeVisitor)this));
        this.startNode(NodeKind.PARALLEL_FLOW);
        NodeList workers = namedWorkerDeclarator.namedWorkerDeclarations();
        LineRange startLineRange = ((NamedWorkerDeclarationNode)workers.get(0)).lineRange();
        LinePosition endLine = ((NamedWorkerDeclarationNode)workers.get(workers.size() - 1)).lineRange().endLine();
        workers.forEach(this::visit);
        this.nodeBuilder.codedata().lineRange(LineRange.from((String)startLineRange.fileName(), (LinePosition)startLineRange.startLine(), (LinePosition)endLine));
        this.endNode();
    }

    public void visit(NamedWorkerDeclarationNode namedWorkerDeclarationNode) {
        String type;
        Branch.Builder workerBranchBuilder = this.startBranch(namedWorkerDeclarationNode.workerName().text(), NodeKind.WORKER, Branch.BranchKind.WORKER, Branch.Repeatable.ONE_OR_MORE);
        Optional returnTypeDesc = namedWorkerDeclarationNode.returnTypeDesc();
        if (returnTypeDesc.isPresent() && ((Node)returnTypeDesc.get()).kind() == SyntaxKind.RETURN_TYPE_DESCRIPTOR) {
            ReturnTypeDescriptorNode returnTypeDescriptorNode = (ReturnTypeDescriptorNode)returnTypeDesc.get();
            type = returnTypeDescriptorNode.type().toSourceCode().strip();
        } else {
            type = "";
        }
        workerBranchBuilder.properties().data((Node)namedWorkerDeclarationNode.workerName(), "Worker Name", "Name of the worker", "worker", false).returnType(type);
        this.analyzeBlock(namedWorkerDeclarationNode.workerBody(), workerBranchBuilder);
        this.endBranch(workerBranchBuilder, (Node)namedWorkerDeclarationNode);
    }

    public void visit(WaitActionNode waitActionNode) {
        this.startNode(NodeKind.WAIT, (Node)waitActionNode);
        boolean waitAll = false;
        Node waitFutureExpr = waitActionNode.waitFutureExpr();
        ArrayList<Node> nodes = new ArrayList<Node>();
        switch (waitFutureExpr.kind()) {
            case BINARY_EXPRESSION: {
                BinaryExpressionNode binaryExpressionNode = (BinaryExpressionNode)waitFutureExpr;
                Stack futuresStack = new Stack();
                futuresStack.push(binaryExpressionNode.rhsExpr());
                Node lhsNode = binaryExpressionNode.lhsExpr();
                while (lhsNode.kind() == SyntaxKind.BINARY_EXPRESSION) {
                    BinaryExpressionNode nestedBinary = (BinaryExpressionNode)lhsNode;
                    futuresStack.push(nestedBinary.rhsExpr());
                    lhsNode = nestedBinary.lhsExpr();
                }
                futuresStack.push(lhsNode);
                while (!futuresStack.isEmpty()) {
                    nodes.add((Node)futuresStack.pop());
                }
                break;
            }
            case WAIT_FIELDS_LIST: {
                WaitFieldsListNode waitFieldsListNode = (WaitFieldsListNode)waitFutureExpr;
                for (Node field : waitFieldsListNode.waitFields()) {
                    nodes.add(field);
                }
                waitAll = true;
                break;
            }
            default: {
                nodes.add(waitFutureExpr);
            }
        }
        this.nodeBuilder.properties().waitAll(waitAll).nestedProperty();
        int i = 1;
        for (Node n : nodes) {
            ExpressionNode expressionNode;
            SimpleNameReferenceNode waitField;
            if (n.kind() == SyntaxKind.WAIT_FIELD) {
                waitField = ((WaitFieldNode)n).fieldName();
                expressionNode = ((WaitFieldNode)n).waitFutureExpr();
            } else {
                waitField = null;
                expressionNode = (ExpressionNode)n;
            }
            this.nodeBuilder.properties().nestedProperty().waitField((Node)waitField).expression(expressionNode).endNestedProperty(Property.ValueType.FIXED_PROPERTY, "future" + i++, "Future", "The worker/async function to wait for");
        }
        this.nodeBuilder.properties().endNestedProperty(Property.ValueType.REPEATABLE_PROPERTY, "futures", "Futures", "The futures to wait for");
    }

    public void visit(TransactionStatementNode transactionStatementNode) {
        this.startNode(NodeKind.TRANSACTION, (Node)transactionStatementNode);
        Branch.Builder branchBuilder = this.startBranch("Body", NodeKind.BODY, Branch.BranchKind.BLOCK, Branch.Repeatable.ONE);
        BlockStatementNode blockStatementNode = transactionStatementNode.blockStatement();
        this.analyzeBlock(blockStatementNode, branchBuilder);
        this.endBranch(branchBuilder, (Node)blockStatementNode);
        transactionStatementNode.onFailClause().ifPresent(this::processOnFailClause);
        this.endNode((Node)transactionStatementNode);
    }

    public void visit(ForEachStatementNode forEachStatementNode) {
        this.startNode(NodeKind.FOREACH, (Node)forEachStatementNode).properties().dataVariable(forEachStatementNode.typedBindingPattern(), new HashSet<String>()).collection(forEachStatementNode.actionOrExpressionNode());
        Branch.Builder branchBuilder = this.startBranch("Body", NodeKind.BODY, Branch.BranchKind.BLOCK, Branch.Repeatable.ONE);
        BlockStatementNode blockStatementNode = forEachStatementNode.blockStatement();
        this.analyzeBlock(blockStatementNode, branchBuilder);
        this.endBranch(branchBuilder, (Node)blockStatementNode);
        forEachStatementNode.onFailClause().ifPresent(this::processOnFailClause);
        this.endNode((Node)forEachStatementNode);
    }

    public void visit(RollbackStatementNode rollbackStatementNode) {
        this.startNode(NodeKind.ROLLBACK, (Node)rollbackStatementNode);
        Optional optExpr = rollbackStatementNode.expression();
        if (optExpr.isPresent()) {
            ExpressionNode expr = (ExpressionNode)optExpr.get();
            expr.accept((NodeVisitor)this);
            this.nodeBuilder.properties().expression(expr, "Rollback transaction");
        }
        this.endNode((Node)rollbackStatementNode);
    }

    public void visit(RetryStatementNode retryStatementNode) {
        int retryCount = retryStatementNode.arguments().isEmpty() ? 3 : Integer.parseInt(retryStatementNode.arguments().map(arg -> (FunctionArgumentNode)arg.arguments().get(0)).get().toString());
        StatementNode statementNode = retryStatementNode.retryBody();
        if (statementNode.kind() == SyntaxKind.BLOCK_STATEMENT) {
            this.startNode(NodeKind.RETRY, (Node)retryStatementNode).properties().retryCount(retryCount);
            Branch.Builder branchBuilder = this.startBranch("Body", NodeKind.BODY, Branch.BranchKind.BLOCK, Branch.Repeatable.ONE);
            this.analyzeBlock((BlockStatementNode)statementNode, branchBuilder);
            this.endBranch(branchBuilder, (Node)statementNode);
            retryStatementNode.onFailClause().ifPresent(this::processOnFailClause);
            this.endNode((Node)retryStatementNode);
        } else {
            TransactionStatementNode transactionStatementNode = (TransactionStatementNode)statementNode;
            BlockStatementNode blockStatementNode = transactionStatementNode.blockStatement();
            this.startNode(NodeKind.TRANSACTION, (Node)retryStatementNode).properties().retryCount(retryCount);
            Branch.Builder branchBuilder = this.startBranch("Body", NodeKind.BODY, Branch.BranchKind.BLOCK, Branch.Repeatable.ONE);
            this.analyzeBlock(blockStatementNode, branchBuilder);
            this.endBranch(branchBuilder, (Node)blockStatementNode);
            transactionStatementNode.onFailClause().ifPresent(this::processOnFailClause);
            this.endNode((Node)retryStatementNode);
        }
    }

    public void visit(CommitActionNode commitActionNode) {
        this.startNode(NodeKind.COMMIT, (Node)commitActionNode);
        this.endNode();
    }

    public void visit(MatchStatementNode matchStatementNode) {
        this.startNode(NodeKind.MATCH, (Node)matchStatementNode).properties().condition(matchStatementNode.condition());
        NodeList matchClauseNodes = matchStatementNode.matchClauses();
        for (MatchClauseNode matchClauseNode : matchClauseNodes) {
            Optional matchGuardNode = matchClauseNode.matchGuard();
            Object label = matchClauseNode.matchPatterns().stream().map(node -> node.toSourceCode().strip()).collect(Collectors.joining("|"));
            if (matchGuardNode.isPresent()) {
                label = (String)label + " " + ((MatchGuardNode)matchGuardNode.get()).toSourceCode().strip();
            }
            Branch.Builder branchBuilder = (Branch.Builder)this.startBranch((String)label, NodeKind.CONDITIONAL, Branch.BranchKind.BLOCK, Branch.Repeatable.ONE_OR_MORE).properties().patterns((NodeList<Node>)matchClauseNode.matchPatterns()).stepOut();
            matchGuardNode.ifPresent(guard -> branchBuilder.properties().expression(guard.expression(), "guard", "Guard expression"));
            this.analyzeBlock(matchClauseNode.blockStatement(), branchBuilder);
            this.endBranch(branchBuilder, (Node)matchClauseNode.blockStatement());
        }
        matchStatementNode.onFailClause().ifPresent(this::processOnFailClause);
        this.endNode((Node)matchStatementNode);
    }

    public void visit(DoStatementNode doStatementNode) {
        Optional optOnFailClauseNode = doStatementNode.onFailClause();
        BlockStatementNode blockStatementNode = doStatementNode.blockStatement();
        if (optOnFailClauseNode.isEmpty()) {
            this.handleDefaultStatementNode((NonTerminalNode)doStatementNode);
            return;
        }
        this.startNode(NodeKind.ERROR_HANDLER, (Node)doStatementNode);
        Branch.Builder branchBuilder = this.startBranch("Body", NodeKind.BODY, Branch.BranchKind.BLOCK, Branch.Repeatable.ONE);
        this.analyzeBlock(blockStatementNode, branchBuilder);
        this.endBranch(branchBuilder, (Node)blockStatementNode);
        this.processOnFailClause((OnFailClauseNode)optOnFailClauseNode.get());
        this.endNode((Node)doStatementNode);
    }

    public void visit(CheckExpressionNode checkExpressionNode) {
        String checkText;
        checkExpressionNode.expression().accept((NodeVisitor)this);
        if (this.isNodeUnidentified()) {
            return;
        }
        switch (checkText = checkExpressionNode.checkKeyword().text()) {
            case "check": {
                this.nodeBuilder.flag(1);
                break;
            }
            case "checkpanic": {
                this.nodeBuilder.flag(2);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + checkText);
            }
        }
        this.nodeBuilder.codedata().nodeInfo((Node)checkExpressionNode);
    }

    public void visit(MappingConstructorExpressionNode mappingCtrExprNode) {
        this.handleConstructorExpressionNode((ExpressionNode)mappingCtrExprNode);
    }

    public void visit(ListConstructorExpressionNode listCtrExprNode) {
        this.handleConstructorExpressionNode((ExpressionNode)listCtrExprNode);
    }

    private void handleConstructorExpressionNode(ExpressionNode constructorExprNode) {
        NonTerminalNode parent = constructorExprNode.parent();
        SyntaxKind kind = parent.kind();
        if (kind != SyntaxKind.ASSIGNMENT_STATEMENT && kind != SyntaxKind.MODULE_VAR_DECL && kind != SyntaxKind.LOCAL_VAR_DECL) {
            return;
        }
        Optional parentSymbol = this.semanticModel.symbol((Node)parent);
        if (parentSymbol.isPresent() && CommonUtils.getRawType((TypeSymbol)((VariableSymbol)parentSymbol.get()).typeDescriptor()).typeKind() == TypeDescKind.JSON && !this.forceAssign) {
            ((NodeBuilder)this.startNode(NodeKind.JSON_PAYLOAD, (Node)constructorExprNode).metadata().description("Assign JSON").stepOut()).properties().expression(constructorExprNode);
        }
    }

    private void endNode(Node node) {
        this.nodeBuilder.codedata().nodeInfo(node);
        this.endNode();
    }

    private void endNode() {
        if (this.flowNodeBuilderStack.isEmpty()) {
            this.flowNodeList.add(this.buildNode());
        }
    }

    private NodeBuilder startNode(NodeKind kind) {
        this.nodeBuilder = NodeBuilder.getNodeFromKind(kind).semanticModel(this.semanticModel).defaultModuleName(this.moduleInfo);
        return this.nodeBuilder;
    }

    private NodeBuilder startNode(NodeKind kind, Node node) {
        this.nodeBuilder = NodeBuilder.getNodeFromKind(kind).semanticModel(this.semanticModel).diagnosticHandler(this.diagnosticHandler).defaultModuleName(this.moduleInfo);
        this.diagnosticHandler.handle(this.nodeBuilder, node instanceof ExpressionNode ? node.parent().lineRange() : node.lineRange(), false);
        return this.nodeBuilder;
    }

    private FlowNode buildNode() {
        FlowNode node = this.nodeBuilder.build();
        this.nodeBuilder = null;
        return node;
    }

    private Branch.Builder startBranch(String label, NodeKind node, Branch.BranchKind kind, Branch.Repeatable repeatable) {
        this.flowNodeBuilderStack.push(this.nodeBuilder);
        this.nodeBuilder = null;
        return ((Branch.Builder)new Branch.Builder().semanticModel(this.semanticModel).defaultModuleName(this.moduleInfo).diagnosticHandler(this.diagnosticHandler).codedata().node(node).stepOut()).label(label).kind(kind).repeatable(repeatable);
    }

    private void endBranch(Branch.Builder branchBuilder, Node node) {
        branchBuilder.codedata().nodeInfo(node);
        this.nodeBuilder = this.flowNodeBuilderStack.pop();
        this.nodeBuilder.branch(branchBuilder.build());
    }

    private boolean isNodeUnidentified() {
        return this.nodeBuilder == null;
    }

    private void handleDefaultStatementNode(NonTerminalNode statementNode) {
        this.handleExpressionNode(statementNode);
        this.endNode((Node)statementNode);
    }

    private void handleExpressionNode(NonTerminalNode statementNode) {
        if (this.typedBindingPatternNode != null) {
            return;
        }
        this.startNode(NodeKind.EXPRESSION, (Node)statementNode).properties().statement((Node)statementNode);
    }

    private void analyzeBlock(BlockStatementNode blockStatement, Branch.Builder branchBuilder) {
        for (Node statementOrComment : blockStatement.statementsWithComments()) {
            statementOrComment.accept((NodeVisitor)this);
            branchBuilder.node(this.buildNode());
        }
    }

    protected void visitSyntaxNode(Node node) {
    }

    private void genCommentNode(CommentMetadata comment) {
        ((NodeBuilder)this.startNode(NodeKind.COMMENT).metadata().description(comment.comment()).stepOut()).properties().comment(comment.comment());
        this.nodeBuilder.codedata().lineRange(comment.position).sourceCode(comment.comment());
        this.endNode();
    }

    private String getIcon(String name) {
        for (Symbol symbol : this.semanticModel.moduleSymbols()) {
            FunctionSymbol functionSymbol;
            if (symbol.kind() != SymbolKind.FUNCTION || !((String)(functionSymbol = (FunctionSymbol)symbol).getName().orElseThrow()).equals(name)) continue;
            for (AnnotationAttachmentSymbol annotAttachment : functionSymbol.annotAttachments()) {
                if (!((String)annotAttachment.typeDescriptor().getName().orElseThrow()).equals("display")) continue;
                Optional optAttachmentValue = annotAttachment.attachmentValue();
                if (optAttachmentValue.isEmpty()) {
                    throw new IllegalStateException("Annotation attachment value not found");
                }
                ConstantValue attachmentValue = (ConstantValue)optAttachmentValue.get();
                if (attachmentValue.valueType().typeKind() != TypeDescKind.RECORD) {
                    throw new IllegalStateException("Annotation attachment value is not a record");
                }
                HashMap valueMap = (HashMap)attachmentValue.value();
                if (valueMap.get("iconPath") == null) {
                    throw new IllegalStateException("Icon path not found in the annotation attachment value");
                }
                return valueMap.get("iconPath").toString();
            }
        }
        return "";
    }

    private String getToolDescription(String toolName) {
        for (Symbol symbol : this.semanticModel.moduleSymbols()) {
            Optional optDescription;
            FunctionSymbol functionSymbol;
            if (symbol.kind() != SymbolKind.FUNCTION || !((String)(functionSymbol = (FunctionSymbol)symbol).getName().orElseThrow()).equals(toolName)) continue;
            Optional optDoc = functionSymbol.documentation();
            if (optDoc.isEmpty() || (optDescription = ((Documentation)optDoc.get()).description()).isEmpty()) break;
            return (String)optDescription.get();
        }
        return "";
    }

    private ImplicitNewExpressionNode getNewExpr(ExpressionNode expressionNode) {
        ExpressionNode expr = expressionNode;
        if (expressionNode.kind() == SyntaxKind.CHECK_EXPRESSION) {
            expr = ((CheckExpressionNode)expr).expression();
        }
        if (expr.kind() == SyntaxKind.IMPLICIT_NEW_EXPRESSION) {
            return (ImplicitNewExpressionNode)expr;
        }
        throw new IllegalStateException("Implicit new expression not found");
    }

    private boolean isSubTypeOfRawTemplate(TypeSymbol typeSymbol) {
        TypeDefinitionSymbol rawTypeDefSymbol = (TypeDefinitionSymbol)this.semanticModel.types().getTypeByName("ballerina", "lang.object", "0.0.0", "RawTemplate").get();
        TypeSymbol rawTemplateTypeDesc = rawTypeDefSymbol.typeDescriptor();
        return typeSymbol.subtypeOf(rawTemplateTypeDesc);
    }

    public List<FlowNode> getFlowNodes() {
        return this.flowNodeList;
    }

    private record CommentMetadata(String comment, LineRange position) {
    }

    private record ToolData(String name, String path, String description) {
    }

    private record MemoryManagerData(String type, String size) {
    }

    private record ModelData(String name, String path, String type) {
    }
}

