/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.ballerina.compiler.syntax.tree.BlockStatementNode;
import io.ballerina.compiler.syntax.tree.ElseBlockNode;
import io.ballerina.compiler.syntax.tree.IfElseStatementNode;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ImportOrgNameNode;
import io.ballerina.compiler.syntax.tree.ImportPrefixNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.flowmodelgenerator.core.model.FlowNode;
import io.ballerina.flowmodelgenerator.core.model.node.NewConnectionBuilder;
import io.ballerina.modelgenerator.commons.CommonUtils;
import io.ballerina.projects.DiagnosticResult;
import io.ballerina.projects.Document;
import io.ballerina.projects.Project;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticProperty;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocumentChange;
import io.ballerina.tools.text.TextEdit;
import io.ballerina.tools.text.TextRange;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.util.diagnostic.DiagnosticErrorCode;

public class DeleteNodeHandler {
    private static final Gson gson = new Gson();
    private final FlowNode nodeToDelete;
    private final Path filePath;
    private static final String EXPECTED_PREFIX = "_";
    private static final String DRIVER_SUFFIX = ".driver";
    private static final Set<String> DB_DRIVERS = NewConnectionBuilder.CONNECTION_DRIVERS.stream().map(driver -> driver.substring(driver.lastIndexOf(47) + 1)).collect(Collectors.toSet());

    public DeleteNodeHandler(JsonElement nodeToDelete, Path filePath) {
        this.nodeToDelete = (FlowNode)new Gson().fromJson(nodeToDelete, FlowNode.class);
        this.filePath = filePath;
    }

    @Deprecated
    public JsonElement getTextEditsToDeletedNode(Document document, Project project) {
        LineRange lineRange = this.nodeToDelete.codedata().lineRange();
        return DeleteNodeHandler.getTextEditsToDeletedNode(lineRange, this.filePath, document, project);
    }

    public static JsonElement getTextEditsToDeletedNode(JsonElement node, Path filePath, Document document, Project project) {
        return DeleteNodeHandler.getTextEditsToDeletedNode(DeleteNodeHandler.getNodeLineRange(node), filePath, document, project);
    }

    private static JsonElement getTextEditsToDeletedNode(LineRange lineRange, Path filePath, Document document, Project project) {
        TextDocument textDocument = document.textDocument();
        int startTextPosition = textDocument.textPositionFrom(lineRange.startLine());
        int endTextPosition = textDocument.textPositionFrom(lineRange.endLine());
        TextEdit te = TextEdit.from((TextRange)TextRange.from((int)startTextPosition, (int)(endTextPosition - startTextPosition)), (String)"");
        TextDocument apply = textDocument.apply(TextDocumentChange.from((TextEdit[])List.of(te).toArray(new TextEdit[0])));
        Document modifiedDoc = project.duplicate().currentPackage().module(document.module().moduleId()).document(document.documentId()).modify().withContent(String.join((CharSequence)System.lineSeparator(), apply.textLines())).apply();
        ModulePartNode modulePartNode = (ModulePartNode)modifiedDoc.syntaxTree().rootNode();
        NodeList imports = modulePartNode.imports();
        ArrayList<org.eclipse.lsp4j.TextEdit> textEdits = new ArrayList<org.eclipse.lsp4j.TextEdit>();
        DiagnosticResult diagnostics = modifiedDoc.module().getCompilation().diagnostics();
        block0: for (Diagnostic diagnostic : diagnostics.diagnostics()) {
            String diagnosticProperty;
            DiagnosticInfo diagnosticInfo = diagnostic.diagnosticInfo();
            if (diagnostic.diagnosticInfo().severity() != DiagnosticSeverity.ERROR || !diagnosticInfo.code().equals(DiagnosticErrorCode.UNUSED_MODULE_PREFIX.diagnosticId())) continue;
            ImportDeclarationNode importNode = DeleteNodeHandler.getUnusedImport(diagnostic.location().lineRange(), (NodeList<ImportDeclarationNode>)imports);
            org.eclipse.lsp4j.TextEdit deleteImportTextEdit = new org.eclipse.lsp4j.TextEdit(CommonUtils.toRange((LineRange)importNode.lineRange()), "");
            textEdits.add(deleteImportTextEdit);
            List diagnosticProperties = diagnostic.properties();
            if (diagnosticProperties == null || diagnosticProperties.isEmpty() || !DB_DRIVERS.contains(diagnosticProperty = ((DiagnosticProperty)diagnosticProperties.getFirst()).value().toString())) continue;
            String expectedModuleName = diagnosticProperty + DRIVER_SUFFIX;
            for (ImportDeclarationNode importDeclarationNode : imports) {
                Optional orgName = importDeclarationNode.orgName();
                Optional prefix = importDeclarationNode.prefix();
                if (!prefix.isPresent() || !((ImportPrefixNode)prefix.get()).prefix().text().equals(EXPECTED_PREFIX) || !orgName.isPresent() || !((ImportOrgNameNode)orgName.get()).toString().equals("ballerinax/") || !importDeclarationNode.moduleName().stream().map(Token::text).collect(Collectors.joining(".")).equals(expectedModuleName)) continue;
                org.eclipse.lsp4j.TextEdit deleteDriverImportTextEdit = new org.eclipse.lsp4j.TextEdit(CommonUtils.toRange((LineRange)importDeclarationNode.lineRange()), "");
                textEdits.add(deleteDriverImportTextEdit);
                continue block0;
            }
        }
        LineRange nodeRangeToDelete = DeleteNodeHandler.checkElseToDelete(document, startTextPosition, endTextPosition);
        if (nodeRangeToDelete == null) {
            nodeRangeToDelete = lineRange;
        }
        org.eclipse.lsp4j.TextEdit textEdit = new org.eclipse.lsp4j.TextEdit(CommonUtils.toRange((LineRange)nodeRangeToDelete), "");
        textEdits.add(textEdit);
        HashMap<Path, ArrayList<org.eclipse.lsp4j.TextEdit>> textEditsMap = new HashMap<Path, ArrayList<org.eclipse.lsp4j.TextEdit>>();
        textEditsMap.put(filePath, textEdits);
        return gson.toJsonTree(textEditsMap);
    }

    private static LineRange getNodeLineRange(JsonElement node) {
        FlowNode nodeToDelete = (FlowNode)gson.fromJson(node, FlowNode.class);
        if (nodeToDelete.codedata() != null) {
            return nodeToDelete.codedata().lineRange();
        }
        JsonObject jsonObject = node.getAsJsonObject();
        LinePosition startLinePosition = LinePosition.from((int)jsonObject.get("startLine").getAsInt(), (int)jsonObject.get("startColumn").getAsInt());
        LinePosition endLinePosition = LinePosition.from((int)jsonObject.get("endLine").getAsInt(), (int)jsonObject.get("endColumn").getAsInt());
        return LineRange.from((String)jsonObject.get("filePath").getAsString(), (LinePosition)startLinePosition, (LinePosition)endLinePosition);
    }

    private static ImportDeclarationNode getUnusedImport(LineRange diagnosticLocation, NodeList<ImportDeclarationNode> imports) {
        for (ImportDeclarationNode importNode : imports) {
            if (!PositionUtil.isWithinLineRange((LineRange)diagnosticLocation, (LineRange)importNode.lineRange())) continue;
            return importNode;
        }
        throw new IllegalStateException("There should be an import node");
    }

    private static LineRange checkElseToDelete(Document document, int nodeStart, int nodeEnd) {
        BlockStatementNode blockStatementNode;
        ModulePartNode modulePartNode = (ModulePartNode)document.syntaxTree().rootNode();
        NonTerminalNode node = modulePartNode.findNode(TextRange.from((int)nodeStart, (int)(nodeEnd - nodeStart))).parent();
        if (node != null && node.kind() == SyntaxKind.BLOCK_STATEMENT && (blockStatementNode = (BlockStatementNode)node).statements().size() == 1) {
            IfElseStatementNode ifElseStmt;
            NonTerminalNode p;
            NonTerminalNode parent = node.parent();
            if (parent.kind() == SyntaxKind.ELSE_BLOCK) {
                return parent.lineRange();
            }
            if (parent.kind() == SyntaxKind.IF_ELSE_STATEMENT && (p = (ifElseStmt = (IfElseStatementNode)parent).parent()) != null && p.kind() == SyntaxKind.ELSE_BLOCK) {
                ElseBlockNode elseBlock = (ElseBlockNode)p;
                return LineRange.from((String)parent.lineRange().fileName(), (LinePosition)elseBlock.lineRange().startLine(), (LinePosition)ifElseStmt.ifBody().lineRange().endLine());
            }
        }
        return null;
    }
}

