/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core;

import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.projects.Document;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import io.ballerina.tools.text.TextRange;
import java.util.function.Predicate;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.eclipse.lsp4j.Position;

public class EnclosedNodeFinder {
    private final Document document;
    private final LinePosition position;
    private final boolean findClass;

    public EnclosedNodeFinder(Document document, LinePosition position, boolean findClass) {
        this.document = document;
        this.position = position;
        this.findClass = findClass;
    }

    public LineRange findEnclosedNode() {
        NonTerminalNode nonTerminalNode;
        ModulePartNode modulePartNode = (ModulePartNode)this.document.syntaxTree().rootNode();
        int positionOffset = PositionUtil.getPositionOffset((Position)PositionUtil.toPosition((LinePosition)this.position), (SyntaxTree)this.document.syntaxTree());
        TextRange textRange = TextRange.from((int)positionOffset, (int)1);
        Predicate<NonTerminalNode> nodeMatcher = this.findClass ? node -> !(node instanceof ClassDefinitionNode) && !(node instanceof ServiceDeclarationNode) : node -> !(node instanceof FunctionDefinitionNode);
        for (nonTerminalNode = modulePartNode.findNode(textRange); nonTerminalNode != null && nodeMatcher.test(nonTerminalNode); nonTerminalNode = nonTerminalNode.parent()) {
        }
        if (nonTerminalNode == null) {
            throw new RuntimeException("No enclosed node found");
        }
        return nonTerminalNode.lineRange();
    }
}

