/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ArrayTypeSymbol;
import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.EnumSymbol;
import io.ballerina.compiler.api.symbols.ErrorTypeSymbol;
import io.ballerina.compiler.api.symbols.FutureTypeSymbol;
import io.ballerina.compiler.api.symbols.IntersectionTypeSymbol;
import io.ballerina.compiler.api.symbols.MapTypeSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.ObjectTypeSymbol;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.ServiceDeclarationSymbol;
import io.ballerina.compiler.api.symbols.StreamTypeSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TableTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.flowmodelgenerator.core.model.Codedata;
import io.ballerina.flowmodelgenerator.core.model.TypeData;
import io.ballerina.flowmodelgenerator.core.utils.SourceCodeGenerator;
import io.ballerina.flowmodelgenerator.core.utils.TypeTransformer;
import io.ballerina.flowmodelgenerator.core.utils.TypeUtils;
import io.ballerina.modelgenerator.commons.CommonUtils;
import io.ballerina.modelgenerator.commons.ModuleInfo;
import io.ballerina.projects.Document;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleDescriptor;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

public class TypesManager {
    private static final Gson gson = new Gson();
    private final Module module;
    private final Document typeDocument;
    private static final List<SymbolKind> supportedSymbolKinds = List.of(SymbolKind.TYPE_DEFINITION, SymbolKind.ENUM, SymbolKind.CLASS, SymbolKind.TYPE);
    private static final List<SymbolKind> supportedGraphqlSymbolKinds = List.of(SymbolKind.TYPE_DEFINITION, SymbolKind.ENUM, SymbolKind.SERVICE_DECLARATION, SymbolKind.CLASS, SymbolKind.TYPE);

    public TypesManager(Document typeDocument) {
        this.typeDocument = typeDocument;
        this.module = typeDocument.module();
    }

    public JsonElement getAllTypes(SemanticModel semanticModel) {
        Map<String, Symbol> symbolMap = semanticModel.moduleSymbols().stream().filter(s -> supportedSymbolKinds.contains(s.kind())).collect(Collectors.toMap(symbol -> symbol.getName().orElse(""), symbol -> symbol));
        new HashMap<String, Symbol>(symbolMap).forEach((key, element) -> {
            if (element.kind() != SymbolKind.TYPE_DEFINITION) {
                return;
            }
            TypeSymbol typeSymbol = ((TypeDefinitionSymbol)element).typeDescriptor();
            this.addMemberTypes(typeSymbol, symbolMap);
        });
        List<Object> allTypes = symbolMap.values().stream().map(this::getTypeData).toList();
        return gson.toJsonTree(allTypes);
    }

    public JsonElement getGraphqlType(SemanticModel semanticModel, Document document, LinePosition linePosition) {
        NonTerminalNode node = CommonUtil.findNode((Range)CommonUtils.toRange((LinePosition)linePosition), (SyntaxTree)document.syntaxTree());
        Optional optSymbol = Optional.empty();
        if (SyntaxKind.ANNOTATION == node.kind() && node.parent().kind() == SyntaxKind.METADATA) {
            MetadataNode metadata = (MetadataNode)node.parent();
            NonTerminalNode parentNode = metadata.parent();
            if (SyntaxKind.SERVICE_DECLARATION == parentNode.kind()) {
                optSymbol = semanticModel.symbol((Node)parentNode);
            }
        } else {
            optSymbol = semanticModel.symbol(document, linePosition);
        }
        if (optSymbol.isEmpty() || !supportedGraphqlSymbolKinds.contains(((Symbol)optSymbol.get()).kind())) {
            return null;
        }
        Object type = this.getTypeData((Symbol)optSymbol.get());
        HashMap<String, Object> refs = new HashMap<String, Object>();
        if (((Symbol)optSymbol.get()).kind() == SymbolKind.SERVICE_DECLARATION) {
            this.addDependencyTypes((ServiceDeclarationSymbol)optSymbol.get(), refs);
        } else {
            TypeSymbol typeDescriptor = this.getTypeDescriptor((Symbol)optSymbol.get());
            if (typeDescriptor != null) {
                this.addDependencyTypes(typeDescriptor, refs);
            }
        }
        return gson.toJsonTree((Object)new TypeDataWithRefs(type, refs.values().stream().toList()));
    }

    public JsonElement getType(SemanticModel semanticModel, Document document, LinePosition linePosition) {
        Optional symbol = semanticModel.symbol(document, linePosition);
        if (symbol.isEmpty() || !supportedGraphqlSymbolKinds.contains(((Symbol)symbol.get()).kind())) {
            return null;
        }
        Object type = this.getTypeData((Symbol)symbol.get());
        HashMap<String, Object> refs = new HashMap<String, Object>();
        if (((Symbol)symbol.get()).kind() == SymbolKind.SERVICE_DECLARATION) {
            this.addDependencyTypes((ServiceDeclarationSymbol)symbol.get(), refs);
        } else {
            TypeSymbol typeDescriptor = this.getTypeDescriptor((Symbol)symbol.get());
            if (typeDescriptor != null) {
                this.addDependencyTypes(typeDescriptor, refs);
            }
        }
        return gson.toJsonTree((Object)new TypeDataWithRefs(type, refs.values().stream().toList()));
    }

    public TypeDataWithRefs getTypeDataWithRefs(TypeDefinitionSymbol typeDefSymbol) {
        Object type = this.getTypeData((Symbol)typeDefSymbol);
        HashMap<String, Object> refs = new HashMap<String, Object>();
        TypeSymbol typeDescriptor = this.getTypeDescriptor((Symbol)typeDefSymbol);
        if (typeDescriptor != null) {
            this.addDependencyTypes(typeDescriptor, refs);
        }
        return this.genTypeDataRefWithoutPosition(type, refs.values().stream().toList());
    }

    public JsonElement updateType(Path filePath, TypeData typeData) {
        ArrayList<TextEdit> textEdits = new ArrayList<TextEdit>();
        HashMap<Path, ArrayList<TextEdit>> textEditsMap = new HashMap<Path, ArrayList<TextEdit>>();
        textEditsMap.put(filePath, textEdits);
        SourceCodeGenerator sourceCodeGenerator = new SourceCodeGenerator();
        String codeSnippet = sourceCodeGenerator.generateCodeSnippetForType(typeData);
        SyntaxTree syntaxTree = this.typeDocument.syntaxTree();
        ModulePartNode rootNode = (ModulePartNode)syntaxTree.rootNode();
        LineRange lineRange = typeData.codedata().lineRange();
        if (lineRange == null) {
            textEdits.add(new TextEdit(CommonUtils.toRange((LinePosition)rootNode.lineRange().endLine()), codeSnippet));
        } else {
            NonTerminalNode node = CommonUtil.findNode((Range)CommonUtils.toRange((LineRange)lineRange), (SyntaxTree)syntaxTree);
            textEdits.add(new TextEdit(CommonUtils.toRange((LineRange)node.lineRange()), codeSnippet));
        }
        TypesManager.addImportsToTextEdits(sourceCodeGenerator.getImports(), rootNode, textEdits);
        return gson.toJsonTree(textEditsMap);
    }

    public JsonElement createMultipleTypes(Path filePath, List<TypeData> typeDataList) {
        HashMap<Path, ArrayList<TextEdit>> textEditsMap = new HashMap<Path, ArrayList<TextEdit>>();
        ArrayList<TextEdit> textEdits = new ArrayList<TextEdit>();
        textEditsMap.put(filePath, textEdits);
        SyntaxTree syntaxTree = this.typeDocument.syntaxTree();
        ModulePartNode rootNode = (ModulePartNode)syntaxTree.rootNode();
        ArrayList<String> codeSnippets = new ArrayList<String>();
        for (TypeData typeData : typeDataList) {
            SourceCodeGenerator sourceCodeGenerator = new SourceCodeGenerator();
            String codeSnippet = sourceCodeGenerator.generateCodeSnippetForType(typeData);
            codeSnippets.add(codeSnippet);
            TypesManager.addImportsToTextEdits(sourceCodeGenerator.getImports(), rootNode, textEdits);
        }
        textEdits.add(new TextEdit(CommonUtils.toRange((LinePosition)rootNode.lineRange().endLine()), String.join((CharSequence)System.lineSeparator(), codeSnippets)));
        return gson.toJsonTree(textEditsMap);
    }

    public JsonElement createGraphqlClassType(Path filePath, TypeData typeData) {
        ArrayList<TextEdit> textEdits = new ArrayList<TextEdit>();
        HashMap<Path, ArrayList<TextEdit>> textEditsMap = new HashMap<Path, ArrayList<TextEdit>>();
        textEditsMap.put(filePath, textEdits);
        SourceCodeGenerator sourceCodeGenerator = new SourceCodeGenerator();
        String codeSnippet = sourceCodeGenerator.generateGraphqlClassType(typeData);
        SyntaxTree syntaxTree = this.typeDocument.syntaxTree();
        ModulePartNode rootNode = (ModulePartNode)syntaxTree.rootNode();
        textEdits.add(new TextEdit(CommonUtils.toRange((LinePosition)rootNode.lineRange().endLine()), codeSnippet));
        TypesManager.addImportsToTextEdits(sourceCodeGenerator.getImports(), rootNode, textEdits);
        return gson.toJsonTree(textEditsMap);
    }

    private void addMemberTypes(TypeSymbol typeSymbol, Map<String, Symbol> symbolMap) {
        switch (typeSymbol.typeKind()) {
            case RECORD: {
                RecordTypeSymbol recordTypeSymbol = (RecordTypeSymbol)typeSymbol;
                List inclusions = recordTypeSymbol.typeInclusions();
                inclusions.forEach(inc -> this.addToMapIfForeignAndNotAdded(symbolMap, (TypeSymbol)inc));
                Optional restTypeDescriptor = recordTypeSymbol.restTypeDescriptor();
                if (restTypeDescriptor.isPresent()) {
                    TypeSymbol restType = (TypeSymbol)restTypeDescriptor.get();
                    this.addToMapIfForeignAndNotAdded(symbolMap, restType);
                }
                Map fieldSymbolMap = recordTypeSymbol.fieldDescriptors();
                fieldSymbolMap.forEach((key, field) -> {
                    TypeSymbol ts = field.typeDescriptor();
                    if (ts.typeKind() == TypeDescKind.ARRAY || ts.typeKind() == TypeDescKind.UNION) {
                        this.addMemberTypes(ts, symbolMap);
                    } else {
                        this.addToMapIfForeignAndNotAdded(symbolMap, ts);
                    }
                });
                break;
            }
            case UNION: {
                UnionTypeSymbol unionTypeSymbol = (UnionTypeSymbol)typeSymbol;
                List unionMembers = unionTypeSymbol.memberTypeDescriptors();
                unionMembers.forEach(member -> {
                    if (member.typeKind() == TypeDescKind.ARRAY) {
                        this.addMemberTypes((TypeSymbol)member, symbolMap);
                    } else {
                        this.addToMapIfForeignAndNotAdded(symbolMap, (TypeSymbol)member);
                    }
                });
                break;
            }
            case ARRAY: {
                ArrayTypeSymbol arrayTypeSymbol = (ArrayTypeSymbol)typeSymbol;
                TypeSymbol arrMemberTypeDesc = arrayTypeSymbol.memberTypeDescriptor();
                if (arrMemberTypeDesc.typeKind() == TypeDescKind.ARRAY || arrMemberTypeDesc.typeKind() == TypeDescKind.UNION) {
                    this.addMemberTypes(arrMemberTypeDesc, symbolMap);
                    break;
                }
                this.addToMapIfForeignAndNotAdded(symbolMap, arrMemberTypeDesc);
                break;
            }
        }
    }

    private Object getTypeData(Symbol symbol) {
        TypeTransformer typeTransformer = new TypeTransformer(this.module);
        return switch (symbol.kind()) {
            case SymbolKind.TYPE_DEFINITION -> typeTransformer.transform((TypeDefinitionSymbol)symbol);
            case SymbolKind.CLASS -> typeTransformer.transform((ClassSymbol)symbol);
            case SymbolKind.ENUM -> typeTransformer.transform((EnumSymbol)symbol);
            case SymbolKind.SERVICE_DECLARATION -> typeTransformer.transform((ServiceDeclarationSymbol)symbol);
            case SymbolKind.TYPE -> this.getTypeData(((TypeReferenceTypeSymbol)symbol).definition());
            default -> null;
        };
    }

    private TypeSymbol getTypeDescriptor(Symbol symbol) {
        return switch (symbol.kind()) {
            case SymbolKind.TYPE_DEFINITION -> ((TypeDefinitionSymbol)symbol).typeDescriptor();
            case SymbolKind.CLASS -> (ClassSymbol)symbol;
            default -> null;
        };
    }

    private void addToMapIfForeignAndNotAdded(Map<String, Symbol> foreignSymbols, TypeSymbol type) {
        if (type.typeKind() != TypeDescKind.TYPE_REFERENCE || type.getName().isEmpty() || type.getModule().isEmpty()) {
            return;
        }
        String name = (String)type.getName().get();
        ModuleInfo moduleInfo = ModuleInfo.from((ModuleDescriptor)this.module.descriptor());
        ModuleID typeModuleId = ((ModuleSymbol)type.getModule().get()).id();
        if (CommonUtils.isWithinPackage((Symbol)type, (ModuleInfo)moduleInfo) || CommonUtils.isPredefinedLangLib((String)typeModuleId.orgName(), (String)typeModuleId.packageName())) {
            return;
        }
        String typeName = TypeUtils.generateReferencedTypeId(type, moduleInfo);
        if (!foreignSymbols.containsKey(name)) {
            foreignSymbols.put(typeName, (Symbol)type);
        }
    }

    private void addDependencyTypes(ServiceDeclarationSymbol serviceDeclarationSymbol, Map<String, Object> references) {
        serviceDeclarationSymbol.fieldDescriptors().forEach((key, field) -> this.addDependencyTypes(field.typeDescriptor(), references));
        serviceDeclarationSymbol.methods().forEach((key, method) -> {
            method.typeDescriptor().params().ifPresent(params -> params.forEach(param -> this.addDependencyTypes(param.typeDescriptor(), references)));
            method.typeDescriptor().returnTypeDescriptor().ifPresent(returnType -> this.addDependencyTypes((TypeSymbol)returnType, references));
            method.typeDescriptor().restParam().ifPresent(restParam -> this.addDependencyTypes(restParam.typeDescriptor(), references));
        });
    }

    private void addDependencyTypes(TypeSymbol typeSymbol, Map<String, Object> references) {
        switch (typeSymbol.typeKind()) {
            case RECORD: {
                RecordTypeSymbol recordTypeSymbol = (RecordTypeSymbol)typeSymbol;
                recordTypeSymbol.typeInclusions().forEach(includedType -> this.addDependencyTypes((TypeSymbol)includedType, references));
                recordTypeSymbol.fieldDescriptors().forEach((key, field) -> this.addDependencyTypes(field.typeDescriptor(), references));
                if (!recordTypeSymbol.restTypeDescriptor().isPresent()) break;
                this.addDependencyTypes((TypeSymbol)recordTypeSymbol.restTypeDescriptor().get(), references);
                break;
            }
            case ARRAY: {
                this.addDependencyTypes(((ArrayTypeSymbol)typeSymbol).memberTypeDescriptor(), references);
                break;
            }
            case UNION: {
                ((UnionTypeSymbol)typeSymbol).userSpecifiedMemberTypes().forEach(memberType -> this.addDependencyTypes((TypeSymbol)memberType, references));
                break;
            }
            case ERROR: {
                ErrorTypeSymbol errorTypeSymbol = (ErrorTypeSymbol)typeSymbol;
                if (errorTypeSymbol.signature().equals("error")) {
                    return;
                }
                this.addDependencyTypes(errorTypeSymbol.detailTypeDescriptor(), references);
                break;
            }
            case FUTURE: {
                Optional typeParam = ((FutureTypeSymbol)typeSymbol).typeParameter();
                if (typeParam.isEmpty()) {
                    return;
                }
                this.addDependencyTypes((TypeSymbol)typeParam.get(), references);
                break;
            }
            case MAP: {
                TypeSymbol typeParam = ((MapTypeSymbol)typeSymbol).typeParam();
                this.addDependencyTypes(typeParam, references);
                break;
            }
            case STREAM: {
                TypeSymbol typeParam = ((StreamTypeSymbol)typeSymbol).typeParameter();
                this.addDependencyTypes(typeParam, references);
                break;
            }
            case INTERSECTION: {
                ((IntersectionTypeSymbol)typeSymbol).memberTypeDescriptors().forEach(memberTypes -> this.addDependencyTypes((TypeSymbol)memberTypes, references));
                break;
            }
            case TABLE: {
                TableTypeSymbol tableTypeSymbol = (TableTypeSymbol)typeSymbol;
                this.addDependencyTypes(tableTypeSymbol.rowTypeParameter(), references);
                if (!tableTypeSymbol.keyConstraintTypeParameter().isPresent()) break;
                this.addDependencyTypes((TypeSymbol)tableTypeSymbol.keyConstraintTypeParameter().get(), references);
                break;
            }
            case OBJECT: {
                ObjectTypeSymbol objectTypeSymbol = (ObjectTypeSymbol)typeSymbol;
                objectTypeSymbol.typeInclusions().forEach(includedType -> this.addDependencyTypes((TypeSymbol)includedType, references));
                objectTypeSymbol.fieldDescriptors().forEach((key, field) -> this.addDependencyTypes(field.typeDescriptor(), references));
                objectTypeSymbol.methods().forEach((key, method) -> {
                    method.typeDescriptor().params().ifPresent(params -> params.forEach(param -> this.addDependencyTypes(param.typeDescriptor(), references)));
                    method.typeDescriptor().returnTypeDescriptor().ifPresent(returnType -> this.addDependencyTypes((TypeSymbol)returnType, references));
                    method.typeDescriptor().restParam().ifPresent(restParam -> this.addDependencyTypes(restParam.typeDescriptor(), references));
                });
                break;
            }
            case FUNCTION: 
            case TUPLE: {
                break;
            }
            case TYPE_REFERENCE: {
                Symbol definition = ((TypeReferenceTypeSymbol)typeSymbol).definition();
                ModuleInfo moduleInfo = ModuleInfo.from((ModuleDescriptor)this.module.descriptor());
                String typeName = TypeUtils.generateReferencedTypeId(typeSymbol, moduleInfo);
                if (references.containsKey(typeName)) {
                    return;
                }
                references.putIfAbsent(typeName, this.getTypeData(definition));
                if (!CommonUtils.isWithinPackage((Symbol)definition, (ModuleInfo)moduleInfo)) break;
                this.addDependencyTypes(((TypeReferenceTypeSymbol)typeSymbol).typeDescriptor(), references);
                break;
            }
        }
    }

    private TypeDataWithRefs genTypeDataRefWithoutPosition(Object type, List<Object> refs) {
        ArrayList<Object> newRefs = new ArrayList<Object>();
        for (Object ref : refs) {
            if (ref instanceof TypeData) {
                newRefs.add(this.getTypeDataWithoutPosition((TypeData)ref));
                continue;
            }
            newRefs.add(ref);
        }
        if (type instanceof TypeData) {
            return new TypeDataWithRefs(this.getTypeDataWithoutPosition((TypeData)type), newRefs);
        }
        return new TypeDataWithRefs(type, newRefs);
    }

    private TypeData getTypeDataWithoutPosition(TypeData typeData) {
        Codedata codedata = typeData.codedata();
        Codedata newCodedata = this.getCodedataWithoutPosition(codedata);
        return new TypeData(typeData.name(), typeData.editable(), typeData.metadata(), newCodedata, typeData.properties(), typeData.members(), typeData.restMember(), typeData.includes(), typeData.functions(), typeData.annotations(), typeData.allowAdditionalFields());
    }

    private Codedata getCodedataWithoutPosition(Codedata codedata) {
        return new Codedata(codedata.node(), codedata.org(), codedata.module(), codedata.object(), codedata.symbol(), codedata.version(), null, codedata.sourceCode(), codedata.parentSymbol(), codedata.resourcePath(), codedata.id(), codedata.isNew(), codedata.isGenerated(), codedata.inferredReturnType());
    }

    private static void addImportsToTextEdits(Map<String, String> imports, ModulePartNode rootNode, List<TextEdit> textEdits) {
        TreeSet importStmts = new TreeSet();
        imports.values().forEach(moduleId -> {
            String moduleName;
            String[] importParts = moduleId.split("/");
            String orgName = importParts[0];
            if (!CommonUtils.importExists((ModulePartNode)rootNode, (String)orgName, (String)(moduleName = importParts[1].split(":")[0]))) {
                importStmts.add(TypesManager.getImportStmt(orgName, moduleName));
            }
        });
        if (!importStmts.isEmpty()) {
            String importsStmts = String.join((CharSequence)System.lineSeparator(), importStmts);
            textEdits.addFirst(new TextEdit(CommonUtils.toRange((LinePosition)rootNode.lineRange().startLine()), importsStmts));
        }
    }

    private static String getImportStmt(String org, String module) {
        return String.format("%nimport %s/%s;%n", org, module);
    }

    public record TypeDataWithRefs(Object type, List<Object> refs) {
    }
}

