/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.analyzers.function;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.DefaultableParameterNode;
import io.ballerina.compiler.syntax.tree.ExpressionFunctionBodyNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.MarkdownDocumentationLineNode;
import io.ballerina.compiler.syntax.tree.MarkdownDocumentationNode;
import io.ballerina.compiler.syntax.tree.MarkdownParameterDocumentationLineNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.NaturalExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.RestParameterNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.flowmodelgenerator.core.model.FormBuilder;
import io.ballerina.flowmodelgenerator.core.model.NodeBuilder;
import io.ballerina.flowmodelgenerator.core.model.NodeKind;
import io.ballerina.flowmodelgenerator.core.model.Property;
import io.ballerina.flowmodelgenerator.core.model.node.AutomationBuilder;
import io.ballerina.flowmodelgenerator.core.model.node.DataMapperDefinitionBuilder;
import io.ballerina.flowmodelgenerator.core.model.node.FunctionDefinitionBuilder;
import io.ballerina.flowmodelgenerator.core.model.node.NPFunctionDefinitionBuilder;
import io.ballerina.modelgenerator.commons.CommonUtils;
import io.ballerina.modelgenerator.commons.ModuleInfo;
import io.ballerina.modelgenerator.commons.ParameterData;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class ModuleNodeAnalyzer
extends NodeVisitor {
    private final ModuleInfo moduleInfo;
    private final SemanticModel semanticModel;
    private final Gson gson;
    private JsonElement node;

    public ModuleNodeAnalyzer(ModuleInfo moduleInfo, SemanticModel semanticModel) {
        this.moduleInfo = moduleInfo;
        this.semanticModel = semanticModel;
        this.gson = new Gson();
    }

    public Optional<JsonElement> findFunction(ModulePartNode rootNode, String functionName) {
        for (ModuleMemberDeclarationNode member : rootNode.members()) {
            FunctionDefinitionNode functionNode;
            if (member.kind() != SyntaxKind.FUNCTION_DEFINITION || !(functionNode = (FunctionDefinitionNode)member).functionName().text().equals(functionName)) continue;
            functionNode.accept((NodeVisitor)this);
            return Optional.of(this.node);
        }
        return Optional.empty();
    }

    public void visit(FunctionDefinitionNode functionDefinitionNode) {
        boolean isNpFunction = CommonUtils.isNaturalExpressionBodiedFunction((FunctionDefinitionNode)functionDefinitionNode);
        NodeKind nodeKind = isNpFunction ? NodeKind.NP_FUNCTION_DEFINITION : (functionDefinitionNode.functionBody().kind() == SyntaxKind.EXPRESSION_FUNCTION_BODY ? NodeKind.DATA_MAPPER_DEFINITION : (functionDefinitionNode.functionName().text().equals("main") ? NodeKind.AUTOMATION : NodeKind.FUNCTION_DEFINITION));
        NodeBuilder nodeBuilder = NodeBuilder.getNodeFromKind(nodeKind).defaultModuleName(this.moduleInfo);
        FunctionDocumentation documentation = this.getFunctionDocumentation(functionDefinitionNode);
        LineRange functionLineRange = functionDefinitionNode.lineRange();
        if (isNpFunction) {
            nodeBuilder.codedata().lineRange(functionLineRange);
        } else {
            nodeBuilder.codedata().lineRange(LineRange.from((String)functionLineRange.fileName(), (LinePosition)functionLineRange.startLine(), (LinePosition)functionDefinitionNode.functionBody().lineRange().startLine()));
        }
        String returnType = functionDefinitionNode.functionSignature().returnTypeDesc().map(type -> type.type().toSourceCode().strip()).orElse("");
        if (nodeKind != NodeKind.AUTOMATION) {
            nodeBuilder.properties().functionName(functionDefinitionNode.functionName());
        }
        switch (nodeKind) {
            case DATA_MAPPER_DEFINITION: {
                DataMapperDefinitionBuilder.setMandatoryProperties(nodeBuilder, returnType);
                break;
            }
            case AUTOMATION: {
                AutomationBuilder.sendMandatoryProperties(nodeBuilder);
                break;
            }
            case NP_FUNCTION_DEFINITION: {
                NPFunctionDefinitionBuilder.setMandatoryProperties(nodeBuilder, returnType);
                break;
            }
            default: {
                FunctionDefinitionBuilder.setMandatoryProperties(nodeBuilder, returnType, documentation == null ? "" : documentation.description(), documentation == null ? "" : documentation.returnDescription());
            }
        }
        boolean isModelParamAvailable = false;
        block19: for (ParameterNode parameter : functionDefinitionNode.functionSignature().parameters()) {
            String paramDesc;
            Optional paramName;
            Object paramType;
            switch (parameter.kind()) {
                case REQUIRED_PARAM: {
                    RequiredParameterNode reqParam = (RequiredParameterNode)parameter;
                    paramType = ModuleNodeAnalyzer.getNodeValue(reqParam.typeName());
                    paramName = reqParam.paramName();
                    break;
                }
                case DEFAULTABLE_PARAM: {
                    DefaultableParameterNode defParam = (DefaultableParameterNode)parameter;
                    paramType = ModuleNodeAnalyzer.getNodeValue(defParam.typeName());
                    paramName = defParam.paramName();
                    break;
                }
                case REST_PARAM: {
                    RestParameterNode restParam = (RestParameterNode)parameter;
                    paramType = ModuleNodeAnalyzer.getNodeValue(restParam.typeName()) + restParam.ellipsisToken().text();
                    paramName = restParam.paramName();
                    break;
                }
                default: {
                    continue block19;
                }
            }
            if (this.isNaturalFunctionModelProviderProperty(parameter)) {
                isModelParamAvailable = true;
                continue;
            }
            String paramNameText = paramName.map(Token::text).orElse("");
            Token paramToken = paramName.orElse(null);
            switch (nodeKind) {
                case AUTOMATION: {
                    AutomationBuilder.setProperty(nodeBuilder.properties(), (String)paramType, paramNameText, paramToken);
                    continue block19;
                }
                case DATA_MAPPER_DEFINITION: {
                    DataMapperDefinitionBuilder.setProperty(nodeBuilder.properties(), (String)paramType, paramNameText, paramToken);
                    continue block19;
                }
            }
            String paramDescription = "";
            if (documentation != null && (paramDesc = documentation.parameterDescriptions().get(paramNameText)) != null) {
                paramDescription = paramDesc;
            }
            FunctionDefinitionBuilder.setProperty(nodeBuilder.properties(), (String)paramType, paramNameText, paramDescription, paramToken);
        }
        switch (nodeKind) {
            case DATA_MAPPER_DEFINITION: {
                DataMapperDefinitionBuilder.setOptionalProperties(nodeBuilder);
                break;
            }
            case AUTOMATION: {
                AutomationBuilder.setOptionalProperties(nodeBuilder, !returnType.isEmpty());
                break;
            }
            case NP_FUNCTION_DEFINITION: {
                NPFunctionDefinitionBuilder.endOptionalProperties(nodeBuilder);
                ExpressionFunctionBodyNode expressionFunctionBodyNode = (ExpressionFunctionBodyNode)functionDefinitionNode.functionBody();
                this.processNaturalFunctionDefProperties(nodeBuilder, (NaturalExpressionNode)expressionFunctionBodyNode.expression(), isModelParamAvailable);
                break;
            }
            default: {
                FunctionDefinitionBuilder.setOptionalProperties(nodeBuilder);
            }
        }
        Optional optMetadata = functionDefinitionNode.metadata();
        if (optMetadata.isPresent()) {
            StringBuilder annot = new StringBuilder();
            NodeList annotations = ((MetadataNode)optMetadata.get()).annotations();
            for (AnnotationNode annotation : annotations) {
                annot.append(annotation.toSourceCode());
            }
            annot.append(System.lineSeparator());
            nodeBuilder.properties().annotations(annot.toString());
        }
        for (Token token : functionDefinitionNode.qualifierList()) {
            if (!token.text().equals("isolated")) continue;
            nodeBuilder.properties().isIsolated(true, true, false, false);
        }
        this.node = this.gson.toJsonTree((Object)nodeBuilder.build());
    }

    private void processNaturalFunctionDefProperties(NodeBuilder nodeBuilder, NaturalExpressionNode naturalExpression, boolean isModelParamEnabled) {
        Object promptContent;
        LineRange endingNodeLineRange;
        LineRange startingNodeLineRange;
        NodeList prompt = naturalExpression.prompt();
        if (prompt.isEmpty()) {
            startingNodeLineRange = naturalExpression.openBraceToken().lineRange();
            endingNodeLineRange = naturalExpression.closeBraceToken().lineRange();
            promptContent = System.lineSeparator() + System.lineSeparator();
        } else {
            startingNodeLineRange = prompt.get(0).lineRange();
            endingNodeLineRange = prompt.get(prompt.size() - 1).lineRange();
            promptContent = String.join((CharSequence)"", prompt.stream().map(Node::toSourceCode).toList());
        }
        LineRange promptLineRange = LineRange.from((String)startingNodeLineRange.fileName(), (LinePosition)startingNodeLineRange.startLine(), (LinePosition)endingNodeLineRange.endLine());
        ((FormBuilder)((Property.Builder)((Property.Builder)nodeBuilder.properties().custom().metadata().label("Prompt").description("Prompt for the function").stepOut()).codedata().kind(ParameterData.Kind.REQUIRED.name()).lineRange(promptLineRange).stepOut()).value(promptContent).editable().hidden().type(Property.ValueType.RAW_TEMPLATE).stepOut()).addProperty("prompt");
        if (isModelParamEnabled) {
            ((FormBuilder)((Property.Builder)((Property.Builder)nodeBuilder.properties().custom().metadata().label("Model").description("Model for the function").stepOut()).codedata().kind(ParameterData.Kind.REQUIRED.name()).stepOut()).typeConstraint("np:ModelProvider").editable().optional(true).advanced(true).hidden().type(Property.ValueType.EXPRESSION).stepOut()).addProperty("model");
        }
        ((FormBuilder)((Property.Builder)nodeBuilder.properties().custom().metadata().label("Enable model configuration").description("Allow specifying Large Language Model (LLM) choice").stepOut()).editable().value(isModelParamEnabled).optional(true).advanced(true).type(Property.ValueType.FLAG).stepOut()).addProperty("enableModelContext");
    }

    private static String getNodeValue(Node node) {
        return node.toSourceCode().strip();
    }

    public JsonElement getNode() {
        return this.node;
    }

    private boolean isNaturalFunctionModelProviderProperty(ParameterNode parameterNode) {
        Optional paramSymbol = this.semanticModel.symbol((Node)parameterNode);
        if (paramSymbol.isEmpty()) {
            return false;
        }
        TypeSymbol typeDesc = ((ParameterSymbol)paramSymbol.get()).typeDescriptor();
        return CommonUtils.isBallerinaNpModule((Symbol)typeDesc) && typeDesc.getName().isPresent() && "ModelProvider".equals(typeDesc.getName().get());
    }

    private FunctionDocumentation getFunctionDocumentation(FunctionDefinitionNode funcDefNode) {
        Optional optMetadata = funcDefNode.metadata();
        if (optMetadata.isEmpty()) {
            return null;
        }
        Optional optDocStr = ((MetadataNode)optMetadata.get()).documentationString();
        if (optDocStr.isEmpty() || ((Node)optDocStr.get()).kind() != SyntaxKind.MARKDOWN_DOCUMENTATION) {
            return null;
        }
        MarkdownDocumentationNode docNode = (MarkdownDocumentationNode)optDocStr.get();
        StringBuilder description = new StringBuilder();
        HashMap<String, String> params = new HashMap<String, String>();
        String returnDescription = "";
        for (Node documentationLine : docNode.documentationLines()) {
            MarkdownParameterDocumentationLineNode returnDocLine;
            NodeList nodes;
            if (documentationLine.kind() == SyntaxKind.MARKDOWN_DOCUMENTATION_LINE) {
                NodeList nodes2 = ((MarkdownDocumentationLineNode)documentationLine).documentElements();
                if (nodes2.size() != 1) continue;
                description.append(nodes2.get(0).toSourceCode());
                continue;
            }
            if (documentationLine.kind() == SyntaxKind.MARKDOWN_PARAMETER_DOCUMENTATION_LINE) {
                MarkdownParameterDocumentationLineNode docLine = (MarkdownParameterDocumentationLineNode)documentationLine;
                String param = docLine.parameterName().text().trim();
                NodeList nodes3 = docLine.documentElements();
                if (nodes3.isEmpty()) continue;
                params.put(param, nodes3.get(0).toSourceCode());
                continue;
            }
            if (documentationLine.kind() != SyntaxKind.MARKDOWN_RETURN_PARAMETER_DOCUMENTATION_LINE || (nodes = (returnDocLine = (MarkdownParameterDocumentationLineNode)documentationLine).documentElements()).isEmpty()) continue;
            returnDescription = nodes.get(0).toSourceCode();
        }
        return new FunctionDocumentation(description.toString(), params, returnDescription);
    }

    private record FunctionDocumentation(String description, Map<String, String> parameterDescriptions, String returnDescription) {
    }
}

