/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.converters.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Utils {
    private static final String UNICODE_REGEX = "\\\\(\\\\*)u\\{([a-fA-F0-9]+)\\}";
    public static final Pattern UNICODE_PATTERN = Pattern.compile("\\\\(\\\\*)u\\{([a-fA-F0-9]+)\\}");
    private static final Pattern UNESCAPED_SPECIAL_CHAR_SET = Pattern.compile("([$&+,:;=\\?@#\\\\|/'\\ \\[\\}\\]<\\>.\"^*{}~`()%!-])");

    public static String unescapeUnicodeCodepoints(String identifier) {
        Matcher matcher = UNICODE_PATTERN.matcher(identifier);
        StringBuilder buffer = new StringBuilder(identifier.length());
        while (matcher.find()) {
            String leadingSlashes = matcher.group(1);
            if (Utils.isEscapedNumericEscape(leadingSlashes)) continue;
            int codePoint = Integer.parseInt(matcher.group(2), 16);
            char[] chars = Character.toChars(codePoint);
            String ch = String.valueOf(chars);
            if (ch.equals("\\")) {
                matcher.appendReplacement(buffer, Matcher.quoteReplacement(leadingSlashes + "\\u005C"));
                continue;
            }
            matcher.appendReplacement(buffer, Matcher.quoteReplacement(leadingSlashes + ch));
        }
        matcher.appendTail(buffer);
        return String.valueOf(buffer);
    }

    public static String escapeSpecialCharacters(String identifier) {
        return UNESCAPED_SPECIAL_CHAR_SET.matcher(identifier).replaceAll("\\\\$1");
    }

    public static boolean isEscapedNumericEscape(String leadingSlashes) {
        return !Utils.isEven(leadingSlashes.length());
    }

    private static boolean isEven(int n) {
        return (n & 1) == 0;
    }
}

