/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.expressioneditor.services;

import io.ballerina.compiler.syntax.tree.BracedExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FieldAccessExpressionNode;
import io.ballerina.compiler.syntax.tree.IndexedExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeParser;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.flowmodelgenerator.core.expressioneditor.ExpressionEditorContext;
import io.ballerina.flowmodelgenerator.core.expressioneditor.services.DiagnosticsRequest;
import io.ballerina.modelgenerator.commons.CommonUtils;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.text.LineRange;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.ballerinalang.util.diagnostic.DiagnosticErrorCode;
import org.eclipse.lsp4j.Diagnostic;

public class LvExpressionDiagnosticRequest
extends DiagnosticsRequest {
    private static final String INVALID_LHS = "Invalid expression for a variable reference '%s'";
    private static final DiagnosticErrorCode INVALID_EXPRESSION_CODE = DiagnosticErrorCode.INVALID_EXPR_STATEMENT;
    private static final DiagnosticErrorCode UNDERSCORE_NOT_ALLOWED_CODE = DiagnosticErrorCode.UNDERSCORE_NOT_ALLOWED_AS_IDENTIFIER;

    public LvExpressionDiagnosticRequest(ExpressionEditorContext context) {
        super(context);
    }

    @Override
    protected Node getParsedNode(String text) {
        return NodeParser.parseExpression((String)text);
    }

    @Override
    protected Set<Diagnostic> getSyntaxDiagnostics(ExpressionEditorContext context) {
        Node parsedNode = this.getParsedNode(context.info().expression());
        if (parsedNode.hasDiagnostics()) {
            return StreamSupport.stream(parsedNode.diagnostics().spliterator(), true).map(CommonUtils::transformBallerinaDiagnostic).collect(Collectors.toSet());
        }
        if (this.isValidLVExpr((ExpressionNode)parsedNode)) {
            return Set.of();
        }
        String message = String.format(INVALID_LHS, context.info().expression());
        return Set.of(CommonUtils.createDiagnostic((String)message, (LineRange)context.getExpressionLineRange(), (DiagnosticErrorCode)INVALID_EXPRESSION_CODE));
    }

    private boolean isValidLVExpr(ExpressionNode expression) {
        return switch (expression.kind()) {
            case SyntaxKind.SIMPLE_NAME_REFERENCE, SyntaxKind.QUALIFIED_NAME_REFERENCE, SyntaxKind.LIST_BINDING_PATTERN, SyntaxKind.MAPPING_BINDING_PATTERN, SyntaxKind.ERROR_BINDING_PATTERN, SyntaxKind.WILDCARD_BINDING_PATTERN -> true;
            case SyntaxKind.FIELD_ACCESS -> this.isValidLVMemberExpr(((FieldAccessExpressionNode)expression).expression());
            case SyntaxKind.INDEXED_EXPRESSION -> this.isValidLVMemberExpr(((IndexedExpressionNode)expression).containerExpression());
            default -> expression.isMissing();
        };
    }

    private boolean isValidLVMemberExpr(ExpressionNode expression) {
        return switch (expression.kind()) {
            case SyntaxKind.SIMPLE_NAME_REFERENCE, SyntaxKind.QUALIFIED_NAME_REFERENCE -> true;
            case SyntaxKind.FIELD_ACCESS -> this.isValidLVMemberExpr(((FieldAccessExpressionNode)expression).expression());
            case SyntaxKind.INDEXED_EXPRESSION -> this.isValidLVMemberExpr(((IndexedExpressionNode)expression).containerExpression());
            case SyntaxKind.BRACED_EXPRESSION -> this.isValidLVMemberExpr(((BracedExpressionNode)expression).expression());
            default -> expression.isMissing();
        };
    }

    @Override
    protected Set<Diagnostic> getSemanticDiagnostics(ExpressionEditorContext context) {
        LineRange lineRange = context.generateStatement();
        Optional semanticModel = context.workspaceManager().semanticModel(context.filePath());
        return semanticModel.map(model -> model.diagnostics(lineRange).stream().filter(diagnostic -> diagnostic.diagnosticInfo().severity() == DiagnosticSeverity.ERROR && !UNDERSCORE_NOT_ALLOWED_CODE.diagnosticId().equals(diagnostic.diagnosticInfo().code())).map(CommonUtils::transformBallerinaDiagnostic).collect(Collectors.toSet())).orElseGet(Set::of);
    }
}

