/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.model;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.flowmodelgenerator.core.DiagnosticHandler;
import io.ballerina.flowmodelgenerator.core.model.Codedata;
import io.ballerina.flowmodelgenerator.core.model.FlowNode;
import io.ballerina.flowmodelgenerator.core.model.FormBuilder;
import io.ballerina.flowmodelgenerator.core.model.NodeKind;
import io.ballerina.flowmodelgenerator.core.model.Property;
import io.ballerina.modelgenerator.commons.ModuleInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.ballerinalang.langserver.common.utils.NameUtil;

public record Branch(String label, BranchKind kind, Codedata codedata, Repeatable repeatable, Map<String, Property> properties, List<FlowNode> children) {
    public static final String BODY_LABEL = "Body";
    public static final String ON_FAILURE_LABEL = "On Failure";
    public static final Branch DEFAULT_BODY_BRANCH = ((Builder)new Builder().label("Body").kind(BranchKind.BLOCK).repeatable(Repeatable.ONE).codedata().node(NodeKind.BODY).stepOut()).build();

    public static Branch getEmptyBranch(String label, NodeKind kind) {
        return ((Builder)new Builder().label(label).kind(BranchKind.BLOCK).repeatable(Repeatable.ZERO_OR_ONE).codedata().node(kind).stepOut()).build();
    }

    public static Branch getDefaultOnFailBranch(boolean value) {
        return ((Builder)((Builder)new Builder().label(ON_FAILURE_LABEL).kind(BranchKind.BLOCK).repeatable(Repeatable.ZERO_OR_ONE).codedata().node(NodeKind.ON_FAILURE).stepOut()).properties().ignore(value).onErrorVariable(null).stepOut()).build();
    }

    public static Branch getDefaultWorkerBranch(Set<String> names) {
        String workerName = NameUtil.generateTypeName((String)"worker", names);
        return ((Builder)((Builder)new Builder().label(workerName).kind(BranchKind.WORKER).repeatable(Repeatable.ONE_OR_MORE).codedata().node(NodeKind.WORKER).stepOut()).properties().returnType(null).data(null, "Worker Name", "Name of the worker", workerName, false).stepOut()).build();
    }

    public Optional<Property> getProperty(String key) {
        return Optional.ofNullable(this.properties).map(props -> (Property)props.get(key));
    }

    public static enum BranchKind {
        BLOCK,
        WORKER;

    }

    public static enum Repeatable {
        ONE_OR_MORE("1+"),
        ZERO_OR_ONE("0..1"),
        ONE("1"),
        ZERO_OR_MORE("0+");

        private final String value;

        private Repeatable(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static Repeatable fromValue(String value) {
            for (Repeatable repeatable : Repeatable.values()) {
                if (!repeatable.value.equals(value)) continue;
                return repeatable;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static class Builder {
        private String label;
        private BranchKind kind;
        private final List<FlowNode> children = new ArrayList<FlowNode>();
        private Repeatable repeatable;
        protected Codedata.Builder<Builder> codedataBuilder;
        protected FormBuilder<Builder> formBuilder;
        private SemanticModel semanticModel;
        private DiagnosticHandler diagnosticHandler;
        private ModuleInfo moduleInfo;

        public Builder semanticModel(SemanticModel semanticModel) {
            this.semanticModel = semanticModel;
            return this;
        }

        public Builder diagnosticHandler(DiagnosticHandler diagnosticHandler) {
            this.diagnosticHandler = diagnosticHandler;
            return this;
        }

        public Builder defaultModuleName(ModuleInfo moduleInfo) {
            this.moduleInfo = moduleInfo;
            return this;
        }

        public Builder label(String label) {
            this.label = label;
            return this;
        }

        public Builder kind(BranchKind kind) {
            this.kind = kind;
            return this;
        }

        public Builder node(FlowNode node) {
            this.children.add(node);
            return this;
        }

        public Builder nodes(List<FlowNode> nodes) {
            this.children.addAll(nodes);
            return this;
        }

        public Builder repeatable(Repeatable repeatable) {
            this.repeatable = repeatable;
            return this;
        }

        public FormBuilder<Builder> properties() {
            if (this.formBuilder == null) {
                this.formBuilder = new FormBuilder<Builder>(this.semanticModel, this.diagnosticHandler, this.moduleInfo, this);
            }
            return this.formBuilder;
        }

        public Codedata.Builder<Builder> codedata() {
            if (this.codedataBuilder == null) {
                this.codedataBuilder = new Codedata.Builder<Builder>(this);
            }
            return this.codedataBuilder;
        }

        public Branch build() {
            return new Branch(this.label, this.kind, this.codedataBuilder == null ? null : this.codedataBuilder.build(), this.repeatable, this.formBuilder == null ? null : this.formBuilder.build(), this.children);
        }
    }
}

