/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.model;

import com.google.gson.reflect.TypeToken;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ParameterKind;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.CheckExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionArgumentNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.NamedArgumentNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.PositionalArgumentNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypedBindingPatternNode;
import io.ballerina.flowmodelgenerator.core.DiagnosticHandler;
import io.ballerina.flowmodelgenerator.core.model.FacetedBuilder;
import io.ballerina.flowmodelgenerator.core.model.Property;
import io.ballerina.modelgenerator.commons.CommonUtils;
import io.ballerina.modelgenerator.commons.ModuleInfo;
import io.ballerina.tools.text.LineRange;
import java.lang.invoke.CallSite;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import org.ballerinalang.langserver.common.utils.NameUtil;

public class FormBuilder<T>
extends FacetedBuilder<T> {
    private Map<String, Property> nodeProperties = new LinkedHashMap<String, Property>();
    private final Stack<Map<String, Property>> nodePropertiesStack;
    private final SemanticModel semanticModel;
    private final DiagnosticHandler diagnosticHandler;
    protected Property.Builder<FormBuilder<T>> propertyBuilder = new Property.Builder<FormBuilder>(this);
    private final ModuleInfo moduleInfo;
    public static final Type NODE_PROPERTIES_TYPE = new TypeToken<Map<String, Property>>(){}.getType();

    public FormBuilder(SemanticModel semanticModel, DiagnosticHandler diagnosticHandler, ModuleInfo moduleInfo, T parentBuilder) {
        super(parentBuilder);
        this.nodePropertiesStack = new Stack();
        this.semanticModel = semanticModel;
        this.diagnosticHandler = diagnosticHandler;
        this.moduleInfo = moduleInfo;
    }

    public FormBuilder<T> data(Node node, Set<String> names) {
        return this.data(node, false, names);
    }

    public FormBuilder<T> data(Node node, boolean implicit, Set<String> names) {
        return this.data(node, implicit ? "Name" : "Variable Name", "Name of the variable", NameUtil.generateTypeName((String)"var", names), false);
    }

    public FormBuilder<T> data(Node node, boolean implicit, Set<String> names, boolean assignment) {
        return this.data(node, implicit ? "Name" : "Variable Name", "Name of the variable", NameUtil.generateTypeName((String)"var", names), assignment);
    }

    public FormBuilder<T> data(Node node, String label, String doc, String templateName, boolean assignment) {
        ((Property.Builder)this.propertyBuilder.metadata().label(label).description(doc).stepOut()).value(node == null ? templateName : CommonUtils.getVariableName((Node)node)).type(Property.ValueType.IDENTIFIER);
        if (node != null && !assignment) {
            this.propertyBuilder.codedata().lineRange(node.lineRange());
        } else {
            this.propertyBuilder.editable();
        }
        this.addProperty("variable", node);
        return this;
    }

    public FormBuilder<T> data(String typeSignature, Set<String> names, String label) {
        String varName = typeSignature.contains("targetType") ? NameUtil.generateTypeName((String)"var", names) : NameUtil.generateVariableName((String)typeSignature, names);
        ((Property.Builder)this.propertyBuilder.metadata().label(label).description("Name of the variable").stepOut()).value(varName).type(Property.ValueType.IDENTIFIER).editable();
        this.addProperty("variable");
        return this;
    }

    public FormBuilder<T> waitField(Node node) {
        ((Property.Builder)((Property.Builder)this.propertyBuilder.metadata().label("Variable Name").description("Name of the variable").stepOut()).codedata().dependentProperty("waitAll").stepOut()).value(node == null ? "" : node.toSourceCode().strip()).type(Property.ValueType.IDENTIFIER).editable();
        this.addProperty("variable", node);
        return this;
    }

    public FormBuilder<T> type(Node node, boolean editable) {
        return this.type(node, "Variable Type", editable);
    }

    public FormBuilder<T> type(Node node, String label, boolean editable) {
        String typeName = node == null ? "" : CommonUtils.getVariableName((Node)node);
        return this.type(typeName, label, editable, node == null ? null : node.lineRange());
    }

    public FormBuilder<T> type(String typeName, boolean editable, String importStatements) {
        return this.type(typeName, "Variable Type", editable, null, importStatements);
    }

    public FormBuilder<T> type(String typeName, String label, boolean editable, LineRange lineRange) {
        return this.type(typeName, label, editable, lineRange, null);
    }

    public FormBuilder<T> type(String typeName, String label, boolean editable, LineRange lineRange, String importStatements) {
        ((Property.Builder)((Property.Builder)this.propertyBuilder.metadata().label(label).description("Type of the variable").stepOut()).codedata().stepOut()).placeholder("var").value(typeName).imports(importStatements).type(Property.ValueType.TYPE).editable(editable);
        this.addProperty("type", lineRange);
        return this;
    }

    public FormBuilder<T> returnType(String value, String typeConstraint, boolean optional) {
        ((Property.Builder)this.propertyBuilder.metadata().label("Return Type").description("Type of the return value").stepOut()).value(value == null ? "" : value).type(Property.ValueType.TYPE).typeConstraint(typeConstraint).optional(optional).editable();
        this.addProperty("type");
        return this;
    }

    public FormBuilder<T> functionDescription(String value) {
        ((Property.Builder)this.propertyBuilder.metadata().label("Description").description("Description of the function").stepOut()).value(value == null ? "" : value).type(Property.ValueType.STRING).optional(true).editable();
        this.addProperty("functionNameDescription");
        return this;
    }

    public FormBuilder<T> returnDescription(String value) {
        ((Property.Builder)this.propertyBuilder.metadata().label("Description").description("Description of the return value").stepOut()).value(value == null ? "" : value).type(Property.ValueType.STRING).optional(true).editable();
        this.addProperty("typeDescription");
        return this;
    }

    public FormBuilder<T> returnType(String value) {
        return this.returnType(value, null, true);
    }

    public FormBuilder<T> dataVariable(TypedBindingPatternNode node, boolean implicit, Set<String> names) {
        return implicit ? this.dataVariable(node, "Name", "Type", true, names) : this.dataVariable(node, "Variable Name", "Variable Type", true, names);
    }

    public FormBuilder<T> dataVariable(TypedBindingPatternNode node, Set<String> names) {
        return this.dataVariable(node, false, names);
    }

    public FormBuilder<T> dataVariable(TypedBindingPatternNode node, String variableLabel, String typeDoc, boolean editable, Set<String> names) {
        this.data((Node)(node == null ? null : node.bindingPattern()), variableLabel, "Name of the variable", NameUtil.generateTypeName((String)"var", names), false);
        String typeName = node == null ? "" : CommonUtils.getTypeSymbol((SemanticModel)this.semanticModel, (Node)node).map(typeSymbol -> CommonUtils.getTypeSignature((SemanticModel)this.semanticModel, (TypeSymbol)typeSymbol, (boolean)true, (ModuleInfo)this.moduleInfo)).orElse(CommonUtils.getVariableName((Node)node));
        return this.type(typeName, typeDoc, editable, node == null ? null : node.typeDescriptor().lineRange());
    }

    public Property.Builder<FormBuilder<T>> custom() {
        return this.propertyBuilder;
    }

    public FormBuilder<T> payload(TypedBindingPatternNode node, String type) {
        this.data((Node)node, new HashSet<String>());
        ((Property.Builder)this.propertyBuilder.metadata().label("Variable Type").description("Type of the variable").stepOut()).type(Property.ValueType.TYPE).editable();
        if (node == null) {
            this.propertyBuilder.value(type);
        } else {
            Optional optTypeSymbol = CommonUtils.getTypeSymbol((SemanticModel)this.semanticModel, (Node)node);
            optTypeSymbol.ifPresent(typeSymbol -> this.propertyBuilder.value(CommonUtils.getTypeSignature((SemanticModel)this.semanticModel, (TypeSymbol)typeSymbol, (boolean)true, (ModuleInfo)this.moduleInfo)));
        }
        this.addProperty("type");
        return this;
    }

    public FormBuilder<T> defaultableName(String data) {
        ((Property.Builder)this.propertyBuilder.metadata().label("Variable Name").description("Name of the variable").stepOut()).value(data).type(Property.ValueType.IDENTIFIER).typeConstraint("Global").editable();
        this.addProperty("variable");
        return this;
    }

    public FormBuilder<T> patterns(NodeList<? extends Node> node) {
        ArrayList<Property> properties = new ArrayList<Property>();
        for (Node patternNode : node) {
            Property property = ((Property.Builder)this.propertyBuilder.metadata().label("Pattern").description("Binding pattern").stepOut()).value(patternNode.toSourceCode().strip()).type(Property.ValueType.EXPRESSION).editable().build();
            properties.add(property);
        }
        ((Property.Builder)this.propertyBuilder.metadata().label("Patterns").description("List of binding patterns").stepOut()).value(properties).type(Property.ValueType.SINGLE_SELECT).editable();
        this.addProperty("patterns");
        return this;
    }

    public FormBuilder<T> callConnection(ExpressionNode expressionNode, String key) {
        ((Property.Builder)this.propertyBuilder.metadata().label("Connection").description("Connection to use").stepOut()).type(Property.ValueType.EXPRESSION).value(expressionNode.toString());
        this.addProperty(key);
        return this;
    }

    public FormBuilder<T> callExpression(ExpressionNode expressionNode, String key) {
        ((Property.Builder)this.propertyBuilder.metadata().label("Object").description("The object which you want to call the method on").stepOut()).type(Property.ValueType.EXPRESSION).value(expressionNode.toString());
        this.addProperty(key);
        return this;
    }

    public FormBuilder<T> resourcePath(String path, boolean editable) {
        ((Property.Builder)this.propertyBuilder.metadata().label("Resource Path").description("Resource Path").stepOut()).type(Property.ValueType.EXPRESSION);
        if (editable) {
            ((Property.Builder)this.propertyBuilder.codedata().originalName("/path/to/subdirectory").stepOut()).value(path).editable();
        } else {
            ((Property.Builder)this.propertyBuilder.codedata().originalName(path).stepOut()).value(path.replaceAll("\\\\", ""));
        }
        this.addProperty("resourcePath");
        return this;
    }

    public FormBuilder<T> checkError(boolean checkError) {
        return this.checkError(checkError, "Trigger error flow", true);
    }

    public FormBuilder<T> checkError(boolean checkError, String doc, boolean editable) {
        ((Property.Builder)this.propertyBuilder.metadata().label("Check Error").description(doc).stepOut()).value(checkError).advanced(true).type(Property.ValueType.FLAG);
        if (editable) {
            this.propertyBuilder.editable();
        }
        this.addProperty("checkError");
        return this;
    }

    public FormBuilder<T> inputs(SeparatedNodeList<FunctionArgumentNode> arguments, List<ParameterSymbol> parameterSymbols) {
        HashMap<String, ExpressionNode> namedArgValueMap = new HashMap<String, ExpressionNode>();
        LinkedList<ExpressionNode> positionalArgs = new LinkedList<ExpressionNode>();
        if (arguments != null) {
            for (FunctionArgumentNode argument : arguments) {
                switch (argument.kind()) {
                    case NAMED_ARG: {
                        NamedArgumentNode namedArgument = (NamedArgumentNode)argument;
                        namedArgValueMap.put(namedArgument.argumentName().name().text(), namedArgument.expression());
                        break;
                    }
                    case POSITIONAL_ARG: {
                        positionalArgs.add(((PositionalArgumentNode)argument).expression());
                        break;
                    }
                }
            }
        }
        int numParams = parameterSymbols.size();
        int numPositionalArgs = positionalArgs.size();
        ArrayList<CallSite> inputs = new ArrayList<CallSite>();
        for (int i = 0; i < numParams; ++i) {
            ParameterSymbol parameterSymbol = parameterSymbols.get(i);
            Optional name = parameterSymbol.getName();
            if (name.isEmpty()) continue;
            String parameterName = (String)name.get();
            Node paramValue = i < numPositionalArgs ? (Node)positionalArgs.poll() : (Node)namedArgValueMap.get(parameterName);
            String type = CommonUtils.getTypeSignature((SemanticModel)this.semanticModel, (TypeSymbol)parameterSymbol.typeDescriptor(), (boolean)false, (ModuleInfo)this.moduleInfo);
            String variableName = CommonUtils.getVariableName((Node)paramValue);
            inputs.add((CallSite)((Object)(type + " " + variableName)));
        }
        ((Property.Builder)this.propertyBuilder.metadata().label("Inputs").description("Input variables of the data mapper function").stepOut()).type(Property.ValueType.MULTIPLE_SELECT).value(inputs).editable();
        this.addProperty("inputs");
        return this;
    }

    public FormBuilder<T> output(Node node) {
        ((Property.Builder)this.propertyBuilder.metadata().label("Output").description("Output of the data mapper function").stepOut()).type(Property.ValueType.SINGLE_SELECT).editable();
        Optional optTypeSymbol = CommonUtils.getTypeSymbol((SemanticModel)this.semanticModel, (Node)node);
        optTypeSymbol.ifPresent(typeSymbol -> this.propertyBuilder.value(CommonUtils.getTypeSignature((SemanticModel)this.semanticModel, (TypeSymbol)typeSymbol, (boolean)true, (ModuleInfo)this.moduleInfo)));
        this.addProperty("output", node);
        return this;
    }

    public FormBuilder<T> functionArguments(SeparatedNodeList<FunctionArgumentNode> arguments, List<ParameterSymbol> parameterSymbols, Map<String, String> documentationMap, boolean ignoreTargetType) {
        HashMap<String, ExpressionNode> namedArgValueMap = new HashMap<String, ExpressionNode>();
        LinkedList<ExpressionNode> positionalArgs = new LinkedList<ExpressionNode>();
        if (arguments != null) {
            for (FunctionArgumentNode argument : arguments) {
                switch (argument.kind()) {
                    case NAMED_ARG: {
                        NamedArgumentNode namedArgument = (NamedArgumentNode)argument;
                        namedArgValueMap.put(namedArgument.argumentName().name().text(), namedArgument.expression());
                        break;
                    }
                    case POSITIONAL_ARG: {
                        positionalArgs.add(((PositionalArgumentNode)argument).expression());
                        break;
                    }
                }
            }
        }
        int numParams = parameterSymbols.size();
        int numPositionalArgs = positionalArgs.size();
        for (int i = 0; i < numParams; ++i) {
            Optional name;
            ParameterSymbol parameterSymbol = parameterSymbols.get(i);
            if (ignoreTargetType && parameterSymbol.nameEquals("targetType") || (name = parameterSymbol.getName()).isEmpty()) continue;
            String parameterName = ((String)name.get()).startsWith("'") ? ((String)name.get()).substring(1) : (String)name.get();
            Node paramValue = i < numPositionalArgs ? (Node)positionalArgs.poll() : (Node)namedArgValueMap.get(parameterName);
            ((Property.Builder)this.propertyBuilder.metadata().label(parameterName).description(documentationMap.get(parameterName)).stepOut()).type(Property.ValueType.EXPRESSION).editable().defaultable(parameterSymbol.paramKind() == ParameterKind.DEFAULTABLE);
            if (paramValue != null) {
                this.propertyBuilder.value(paramValue.toSourceCode());
            }
            this.addProperty(parameterName, paramValue);
        }
        return this;
    }

    public FormBuilder<T> condition(ExpressionNode expressionNode) {
        ((Property.Builder)this.propertyBuilder.metadata().label("Condition").description("Boolean Condition").stepOut()).value(expressionNode == null ? "" : expressionNode.toSourceCode()).placeholder("true").type(Property.ValueType.EXPRESSION).editable();
        this.addProperty("condition", (Node)expressionNode);
        return this;
    }

    public FormBuilder<T> retryCount(int retryCount) {
        return this.retryCount(retryCount, false);
    }

    public FormBuilder<T> retryCount(int retryCount, boolean optional) {
        ((Property.Builder)this.propertyBuilder.metadata().label("Retry Count").description("Number of retries").stepOut()).value(String.valueOf(retryCount)).type(Property.ValueType.EXPRESSION).optional(optional).editable();
        this.addProperty("retryCount");
        return this;
    }

    public FormBuilder<T> expression(String expr, String expressionDoc) {
        return this.expression(expr, expressionDoc, false, null);
    }

    public FormBuilder<T> expression(String expr, String expressionDoc, boolean optional, String typeConstraint) {
        ((Property.Builder)this.propertyBuilder.metadata().label("Expression").description(expressionDoc).stepOut()).value(expr).type(Property.ValueType.EXPRESSION).typeConstraint(typeConstraint).optional(optional).editable();
        this.addProperty("expression");
        return this;
    }

    public FormBuilder<T> expression(ExpressionNode expressionNode, String expressionDoc) {
        ((Property.Builder)this.propertyBuilder.metadata().label("Expression").description(expressionDoc).stepOut()).value(expressionNode == null ? "" : expressionNode.toSourceCode()).type(Property.ValueType.EXPRESSION).editable();
        this.addProperty("expression", (Node)expressionNode);
        return this;
    }

    public FormBuilder<T> expression(ExpressionNode expressionNode, String expressionDoc, boolean optional, String typeConstraint) {
        ((Property.Builder)this.propertyBuilder.metadata().label("Expression").description(expressionDoc).stepOut()).value(expressionNode == null ? "" : expressionNode.toSourceCode()).type(Property.ValueType.EXPRESSION).typeConstraint(typeConstraint).optional(optional).editable();
        this.addProperty("expression", (Node)expressionNode);
        return this;
    }

    public FormBuilder<T> expression(ExpressionNode expressionNode, String key, String expressionDoc) {
        ((Property.Builder)this.propertyBuilder.metadata().label("Expression").description(expressionDoc).stepOut()).value(expressionNode == null ? "" : expressionNode.toSourceCode()).type(Property.ValueType.EXPRESSION).editable();
        this.addProperty(key, (Node)expressionNode);
        return this;
    }

    public FormBuilder<T> expressionOrAction(ExpressionNode expressionNode, String expressionDoc, boolean optional) {
        ((Property.Builder)this.propertyBuilder.metadata().label("Expression").description(expressionDoc).stepOut()).value(expressionNode == null ? "" : expressionNode.toSourceCode()).type(Property.ValueType.ACTION_OR_EXPRESSION).optional(optional).editable();
        this.addProperty("expression", (Node)expressionNode);
        return this;
    }

    public FormBuilder<T> expression(ExpressionNode expressionNode) {
        return this.expression(expressionNode, false);
    }

    public FormBuilder<T> expression(ExpressionNode expressionNode, boolean optional) {
        ((Property.Builder)this.propertyBuilder.metadata().label("Expression").description("Expression").stepOut()).editable().value(expressionNode == null ? "" : expressionNode.toString()).optional(optional).type(Property.ValueType.EXPRESSION);
        this.addProperty("expression", (Node)expressionNode);
        return this;
    }

    public FormBuilder<T> defaultableVariable(ExpressionNode expr) {
        ((Property.Builder)this.propertyBuilder.metadata().label("Default value").description("Default value for the config, if empty your need to provide a value at runtime").stepOut()).value(expr != null && expr.kind() != SyntaxKind.REQUIRED_EXPRESSION ? expr.toSourceCode() : "").type(Property.ValueType.EXPRESSION).optional(true).editable();
        this.addProperty("defaultable", (Node)expr);
        return this;
    }

    public FormBuilder<T> statement(Node node) {
        ((Property.Builder)this.propertyBuilder.metadata().label("Statement").description("Ballerina statement").stepOut()).value(node == null ? "" : node.toSourceCode().strip()).type(Property.ValueType.STRING).editable();
        this.addProperty("statement", node);
        return this;
    }

    public FormBuilder<T> ignore(boolean ignore) {
        ((Property.Builder)this.propertyBuilder.metadata().label("Ignore").description("Ignore the error value").stepOut()).value(String.valueOf(ignore)).type(Property.ValueType.EXPRESSION).editable();
        this.addProperty("ignore");
        return this;
    }

    public FormBuilder<T> comment(String comment) {
        ((Property.Builder)this.propertyBuilder.metadata().label("Comment").description("Comment to describe the flow").stepOut()).value(comment).type(Property.ValueType.STRING).editable();
        this.addProperty("comment");
        return this;
    }

    public FormBuilder<T> onErrorVariable(TypedBindingPatternNode typedBindingPatternNode) {
        ((Property.Builder)this.propertyBuilder.metadata().label("Error Variable").description("Name of the error variable").stepOut()).value(typedBindingPatternNode == null ? "" : typedBindingPatternNode.bindingPattern().toString()).placeholder("err").type(Property.ValueType.IDENTIFIER).editable();
        this.addProperty("errorVariable", (Node)(typedBindingPatternNode == null ? null : typedBindingPatternNode.bindingPattern()));
        if (typedBindingPatternNode == null) {
            this.propertyBuilder.value("");
        } else {
            CommonUtils.getTypeSymbol((SemanticModel)this.semanticModel, (Node)typedBindingPatternNode).ifPresent(typeSymbol -> this.propertyBuilder.value(CommonUtils.getTypeSignature((SemanticModel)this.semanticModel, (TypeSymbol)typeSymbol, (boolean)false, (ModuleInfo)this.moduleInfo)));
        }
        ((Property.Builder)this.propertyBuilder.metadata().label("Error Type").description("Type of the error").stepOut()).placeholder("error").editable().type(Property.ValueType.TYPE);
        this.addProperty("errorType");
        return this;
    }

    public FormBuilder<T> functionName(IdentifierToken identifierToken) {
        String functionName = identifierToken.text() == null ? "" : identifierToken.text();
        ((Property.Builder)this.propertyBuilder.metadata().label("Name").description("Name of the function").stepOut()).type(Property.ValueType.IDENTIFIER).typeConstraint("Global").value(functionName);
        if (!functionName.equals("main")) {
            this.propertyBuilder.codedata().lineRange(identifierToken.lineRange());
        }
        this.addProperty("functionName");
        return this;
    }

    public FormBuilder<T> annotations(String annotations) {
        ((Property.Builder)this.propertyBuilder.metadata().label("Annotations").description("Annotations of the function").stepOut()).type(Property.ValueType.IDENTIFIER).hidden().value(annotations);
        this.addProperty("annotations");
        return this;
    }

    public FormBuilder<T> functionNameTemplate(String templatePrefix, Set<String> visibleSymbols) {
        return this.functionNameTemplate(templatePrefix, visibleSymbols, "Name", "Name of the function");
    }

    public FormBuilder<T> functionNameTemplate(String templatePrefix, Set<String> visibleSymbols, String label, String description) {
        String generatedName = NameUtil.generateTypeName((String)templatePrefix, visibleSymbols);
        ((Property.Builder)this.propertyBuilder.metadata().label(label).description(description).stepOut()).value(generatedName).type(Property.ValueType.IDENTIFIER).typeConstraint("Global").editable();
        this.addProperty("functionName");
        return this;
    }

    public FormBuilder<T> scope(String scope) {
        ((Property.Builder)this.propertyBuilder.metadata().label("Connection Scope").description("Scope of the connection, Global or Local").stepOut()).type(Property.ValueType.ENUM).value(scope).advanced(true).editable();
        this.addProperty("scope");
        return this;
    }

    public FormBuilder<T> view(LineRange lineRange) {
        ((Property.Builder)this.propertyBuilder.metadata().label("View").description("Function definition location").stepOut()).value(lineRange).type(Property.ValueType.VIEW);
        this.addProperty("view");
        return this;
    }

    public FormBuilder<T> collection(Node expressionNode) {
        ((Property.Builder)this.propertyBuilder.metadata().label("Collection").description("Collection to iterate").stepOut()).editable().placeholder("[]").value(expressionNode == null ? "" : (expressionNode.kind() == SyntaxKind.CHECK_EXPRESSION ? ((CheckExpressionNode)expressionNode).expression().toString() : expressionNode.toString())).type(Property.ValueType.ACTION_OR_EXPRESSION);
        this.addProperty("collection", expressionNode);
        return this;
    }

    public FormBuilder<T> name(String value, boolean optional, boolean editable, boolean advanced) {
        ((Property.Builder)this.propertyBuilder.metadata().label("Type name").description("Unique name to identify the type").stepOut()).editable(editable).optional(optional).advanced(advanced).value(value).type(Property.ValueType.IDENTIFIER);
        this.addProperty("name");
        return this;
    }

    public FormBuilder<T> description(String value, boolean optional, boolean editable, boolean advanced) {
        ((Property.Builder)this.propertyBuilder.metadata().label("Type description").description("Detailed description about the type").stepOut()).editable(editable).optional(optional).advanced(advanced).value(value).type(Property.ValueType.STRING);
        this.addProperty("description");
        return this;
    }

    public FormBuilder<T> isArray(String value, boolean optional, boolean editable, boolean advanced) {
        ((Property.Builder)this.propertyBuilder.metadata().label("Is array type").description("Is this type an array or list value").stepOut()).editable(editable).optional(optional).advanced(advanced).value(value).type(Property.ValueType.FLAG);
        this.addProperty("isArray");
        return this;
    }

    public FormBuilder<T> arraySize(String value, boolean optional, boolean editable, boolean advanced) {
        ((Property.Builder)this.propertyBuilder.metadata().label("Size of the array").description("Array dimensions").stepOut()).editable(editable).optional(optional).advanced(advanced).value(value).type(Property.ValueType.STRING);
        this.addProperty("arraySize");
        return this;
    }

    public FormBuilder<T> qualifiers(List<String> value, boolean optional, boolean editable, boolean advanced) {
        ((Property.Builder)this.propertyBuilder.metadata().label("Type Qualifiers").description("Qualifiers of the type").stepOut()).editable(editable).optional(optional).advanced(advanced).value(value).type(Property.ValueType.MULTIPLE_SELECT);
        this.addProperty("qualifiers");
        return this;
    }

    public FormBuilder<T> isPublic(boolean value, boolean optional, boolean editable, boolean advanced) {
        ((Property.Builder)this.propertyBuilder.metadata().label("public").description("Is this public").stepOut()).editable(editable).optional(optional).advanced(advanced).value(String.valueOf(value)).type(Property.ValueType.FLAG).editable();
        this.addProperty("isPublic");
        return this;
    }

    public FormBuilder<T> isPrivate(boolean value, boolean optional, boolean editable, boolean advanced) {
        ((Property.Builder)this.propertyBuilder.metadata().label("private").description("Is this private").stepOut()).editable(editable).optional(optional).advanced(advanced).value(String.valueOf(value)).type(Property.ValueType.FLAG).editable();
        this.addProperty("isPrivate");
        return this;
    }

    public FormBuilder<T> isIsolated(boolean value, boolean optional, boolean editable, boolean advanced) {
        ((Property.Builder)this.propertyBuilder.metadata().label("isolated").description("Is this isolated").stepOut()).editable(editable).optional(optional).advanced(advanced).value(String.valueOf(value)).type(Property.ValueType.FLAG).editable();
        this.addProperty("isIsolated");
        return this;
    }

    public FormBuilder<T> isReadOnly(boolean value, boolean optional, boolean editable, boolean advanced) {
        ((Property.Builder)this.propertyBuilder.metadata().label("readonly").description("Is this readonly").stepOut()).editable(editable).optional(optional).advanced(advanced).value(String.valueOf(value)).type(Property.ValueType.FLAG).editable();
        this.addProperty("isReadOnly");
        return this;
    }

    public FormBuilder<T> isDistinct(boolean value, boolean optional, boolean editable, boolean advanced) {
        ((Property.Builder)this.propertyBuilder.metadata().label("distinct").description("Is this distinct").stepOut()).editable(editable).optional(optional).advanced(advanced).value(String.valueOf(value)).type(Property.ValueType.FLAG).editable();
        this.addProperty("isDistinct");
        return this;
    }

    public FormBuilder<T> networkQualifier(String value, boolean optional, boolean editable, boolean advanced) {
        ((Property.Builder)this.propertyBuilder.metadata().label("Network Qualifier").description("Network qualifier").stepOut()).editable(editable).optional(optional).advanced(advanced).value(value).typeConstraint(List.of("service", "client")).type(Property.ValueType.SINGLE_SELECT);
        this.addProperty("networkQualifier");
        return this;
    }

    public FormBuilder<T> waitAll(boolean value) {
        ((Property.Builder)this.propertyBuilder.metadata().label("Wait All").description("Wait for all tasks to complete").stepOut()).value(value).type(Property.ValueType.FLAG).editable();
        this.addProperty("waitAll");
        return this;
    }

    public FormBuilder<T> parameter(String type, String name, Token token, Property.ValueType valueType, Object typeConstraint) {
        this.nestedProperty();
        ((Property.Builder)this.propertyBuilder.metadata().label("Type").description("Type of the parameter").stepOut()).type(valueType).typeConstraint(typeConstraint).value(type).editable();
        this.addProperty("type");
        ((Property.Builder)this.propertyBuilder.metadata().label("Name").description("Name of the parameter").stepOut()).type(Property.ValueType.IDENTIFIER).editable().value(name);
        if (token == null) {
            this.propertyBuilder.editable();
        } else {
            this.propertyBuilder.codedata().lineRange(token.lineRange());
        }
        this.addProperty("variable");
        return this.endNestedProperty(Property.ValueType.FIXED_PROPERTY, name, "Parameter", "Function parameter");
    }

    public FormBuilder<T> parameterWithDescription(String type, String name, Token token, Property.ValueType valueType, Object typeConstraint, String description) {
        this.nestedProperty();
        ((Property.Builder)this.propertyBuilder.metadata().label("Type").description("Type of the parameter").stepOut()).type(valueType).typeConstraint(typeConstraint).value(type).editable();
        this.addProperty("type");
        ((Property.Builder)this.propertyBuilder.metadata().label("Name").description("Name of the parameter").stepOut()).type(Property.ValueType.IDENTIFIER).editable().value(name);
        if (token == null) {
            this.propertyBuilder.editable();
        } else {
            this.propertyBuilder.codedata().lineRange(token.lineRange());
        }
        this.addProperty("variable");
        ((Property.Builder)this.propertyBuilder.metadata().label("Description").description("Description of the parameter").stepOut()).type(Property.ValueType.STRING).value(description).optional(true).editable();
        this.addProperty("parameterDescription");
        return this.endNestedProperty(Property.ValueType.FIXED_PROPERTY, name, "Parameter", "Function parameter");
    }

    public FormBuilder<T> nestedProperty() {
        LinkedHashMap<String, Property> newProperties = new LinkedHashMap<String, Property>();
        this.nodePropertiesStack.push(this.nodeProperties);
        this.nodeProperties = newProperties;
        return this;
    }

    public FormBuilder<T> endNestedProperty(Property.ValueType valueType, String key, String label, String doc, Object typeConstraint, boolean optional, boolean advanced) {
        ((Property.Builder)this.propertyBuilder.metadata().label(label).description(doc).stepOut()).value(this.nodeProperties).typeConstraint(typeConstraint).type(valueType).optional(optional).advanced(advanced);
        if (!this.nodePropertiesStack.isEmpty()) {
            this.nodeProperties = this.nodePropertiesStack.pop();
        }
        this.addProperty(key);
        return this;
    }

    public FormBuilder<T> endNestedProperty(Property.ValueType valueType, String key, String label, String doc) {
        return this.endNestedProperty(valueType, key, label, doc, null, false, false);
    }

    public final void addProperty(String key, Node node) {
        if (node != null) {
            this.diagnosticHandler.handle(this.propertyBuilder, node.lineRange(), true);
        }
        Property property = this.propertyBuilder.build();
        this.nodeProperties.put(key, property);
    }

    public final void addProperty(String key) {
        this.addProperty(key, (Node)null);
    }

    public final void addProperty(String key, LineRange lineRange) {
        if (lineRange != null) {
            this.diagnosticHandler.handle(this.propertyBuilder, lineRange, true);
        }
        Property property = this.propertyBuilder.build();
        this.nodeProperties.put(key, property);
    }

    public Map<String, Property> build() {
        return this.nodeProperties;
    }
}

