/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.model;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.flowmodelgenerator.core.DiagnosticHandler;
import io.ballerina.flowmodelgenerator.core.model.FormBuilder;
import io.ballerina.flowmodelgenerator.core.model.Member;
import io.ballerina.flowmodelgenerator.core.model.Property;
import io.ballerina.modelgenerator.commons.ModuleInfo;
import java.util.List;
import java.util.Map;

public record Function(String accessor, List<String> qualifiers, List<Member> parameters, Member restParameter, FunctionKind kind, String name, String description, Object returnType, List<String> refs, Map<String, Property> properties, Map<String, String> imports) {

    public static enum FunctionKind {
        FUNCTION,
        RESOURCE,
        REMOTE;

    }

    public static class FunctionBuilder {
        private String accessor;
        private List<String> qualifiers;
        private List<Member> parameters;
        private Member restParameter;
        private FunctionKind kind;
        private String name;
        private String docs;
        private Object returnType;
        private List<String> refs;
        private FormBuilder<FunctionBuilder> formBuilder;
        private ModuleInfo moduleInfo;
        private SemanticModel semanticModel;
        private DiagnosticHandler diagnosticHandler;
        Map<String, String> imports;

        public FunctionBuilder semanticModel(SemanticModel semanticModel) {
            this.semanticModel = semanticModel;
            return this;
        }

        public FunctionBuilder diagnosticHandler(DiagnosticHandler diagnosticHandler) {
            this.diagnosticHandler = diagnosticHandler;
            return this;
        }

        public FunctionBuilder defaultModuleName(ModuleInfo moduleInfo) {
            this.moduleInfo = moduleInfo;
            return this;
        }

        public FunctionBuilder accessor(String accessor) {
            this.accessor = accessor;
            return this;
        }

        public FunctionBuilder qualifiers(List<String> qualifiers) {
            this.qualifiers = qualifiers;
            return this;
        }

        public FunctionBuilder parameters(List<Member> parameters) {
            this.parameters = parameters;
            return this;
        }

        public FunctionBuilder restParameter(Member restParameter) {
            this.restParameter = restParameter;
            return this;
        }

        public FunctionBuilder kind(FunctionKind kind) {
            this.kind = kind;
            return this;
        }

        public FunctionBuilder name(String name) {
            this.name = name;
            return this;
        }

        public FunctionBuilder docs(String docs) {
            this.docs = docs;
            return this;
        }

        public FunctionBuilder returnType(Object returnType) {
            this.returnType = returnType;
            return this;
        }

        public FunctionBuilder refs(List<String> refs) {
            this.refs = refs;
            return this;
        }

        public FunctionBuilder imports(Map<String, String> imports) {
            this.imports = imports;
            return this;
        }

        public FormBuilder<FunctionBuilder> properties() {
            if (this.formBuilder == null) {
                this.formBuilder = new FormBuilder<FunctionBuilder>(this.semanticModel, this.diagnosticHandler, this.moduleInfo, this);
            }
            return this.formBuilder;
        }

        public Function build() {
            return new Function(this.accessor, this.qualifiers, this.parameters, this.restParameter, this.kind, this.name, this.docs, this.returnType, this.refs, this.formBuilder == null ? null : this.formBuilder.build(), this.imports != null ? Map.copyOf(this.imports) : null);
        }
    }
}

