/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.model;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.flowmodelgenerator.core.DiagnosticHandler;
import io.ballerina.flowmodelgenerator.core.model.AvailableNode;
import io.ballerina.flowmodelgenerator.core.model.Branch;
import io.ballerina.flowmodelgenerator.core.model.Codedata;
import io.ballerina.flowmodelgenerator.core.model.Diagnostics;
import io.ballerina.flowmodelgenerator.core.model.FlowNode;
import io.ballerina.flowmodelgenerator.core.model.FormBuilder;
import io.ballerina.flowmodelgenerator.core.model.Metadata;
import io.ballerina.flowmodelgenerator.core.model.NodeKind;
import io.ballerina.flowmodelgenerator.core.model.SourceBuilder;
import io.ballerina.flowmodelgenerator.core.model.node.AgentBuilder;
import io.ballerina.flowmodelgenerator.core.model.node.AgentCallBuilder;
import io.ballerina.flowmodelgenerator.core.model.node.AssignBuilder;
import io.ballerina.flowmodelgenerator.core.model.node.AutomationBuilder;
import io.ballerina.flowmodelgenerator.core.model.node.BinaryBuilder;
import io.ballerina.flowmodelgenerator.core.model.node.BreakBuilder;
import io.ballerina.flowmodelgenerator.core.model.node.ClassInitBuilder;
import io.ballerina.flowmodelgenerator.core.model.node.CommentBuilder;
import io.ballerina.flowmodelgenerator.core.model.node.CommitBuilder;
import io.ballerina.flowmodelgenerator.core.model.node.ConfigVariableBuilder;
import io.ballerina.flowmodelgenerator.core.model.node.ContinueBuilder;
import io.ballerina.flowmodelgenerator.core.model.node.DataMapperBuilder;
import io.ballerina.flowmodelgenerator.core.model.node.DataMapperCallBuilder;
import io.ballerina.flowmodelgenerator.core.model.node.DataMapperDefinitionBuilder;
import io.ballerina.flowmodelgenerator.core.model.node.ErrorHandlerBuilder;
import io.ballerina.flowmodelgenerator.core.model.node.EventStartBuilder;
import io.ballerina.flowmodelgenerator.core.model.node.ExpressionBuilder;
import io.ballerina.flowmodelgenerator.core.model.node.FailBuilder;
import io.ballerina.flowmodelgenerator.core.model.node.ForeachBuilder;
import io.ballerina.flowmodelgenerator.core.model.node.ForkBuilder;
import io.ballerina.flowmodelgenerator.core.model.node.FunctionCall;
import io.ballerina.flowmodelgenerator.core.model.node.FunctionDefinitionBuilder;
import io.ballerina.flowmodelgenerator.core.model.node.IfBuilder;
import io.ballerina.flowmodelgenerator.core.model.node.JsonPayloadBuilder;
import io.ballerina.flowmodelgenerator.core.model.node.LockBuilder;
import io.ballerina.flowmodelgenerator.core.model.node.MatchBuilder;
import io.ballerina.flowmodelgenerator.core.model.node.MethodCall;
import io.ballerina.flowmodelgenerator.core.model.node.NPFunctionCall;
import io.ballerina.flowmodelgenerator.core.model.node.NPFunctionDefinitionBuilder;
import io.ballerina.flowmodelgenerator.core.model.node.NewConnectionBuilder;
import io.ballerina.flowmodelgenerator.core.model.node.PanicBuilder;
import io.ballerina.flowmodelgenerator.core.model.node.ParallelFlowBuilder;
import io.ballerina.flowmodelgenerator.core.model.node.RemoteActionCallBuilder;
import io.ballerina.flowmodelgenerator.core.model.node.ResourceActionCallBuilder;
import io.ballerina.flowmodelgenerator.core.model.node.RetryBuilder;
import io.ballerina.flowmodelgenerator.core.model.node.ReturnBuilder;
import io.ballerina.flowmodelgenerator.core.model.node.RollbackBuilder;
import io.ballerina.flowmodelgenerator.core.model.node.StartBuilder;
import io.ballerina.flowmodelgenerator.core.model.node.StopBuilder;
import io.ballerina.flowmodelgenerator.core.model.node.TransactionBuilder;
import io.ballerina.flowmodelgenerator.core.model.node.VariableBuilder;
import io.ballerina.flowmodelgenerator.core.model.node.WaitBuilder;
import io.ballerina.flowmodelgenerator.core.model.node.WhileBuilder;
import io.ballerina.flowmodelgenerator.core.model.node.XmlPayloadBuilder;
import io.ballerina.modelgenerator.commons.CommonUtils;
import io.ballerina.modelgenerator.commons.ModuleInfo;
import io.ballerina.projects.Document;
import io.ballerina.tools.text.LinePosition;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.ballerinalang.langserver.LSClientLogger;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;
import org.eclipse.lsp4j.TextEdit;

public abstract class NodeBuilder
implements DiagnosticHandler.DiagnosticCapable {
    protected List<Branch> branches = new ArrayList<Branch>();
    protected Metadata.Builder<NodeBuilder> metadataBuilder;
    protected Codedata.Builder<NodeBuilder> codedataBuilder;
    protected FormBuilder<NodeBuilder> formBuilder;
    protected Diagnostics.Builder<NodeBuilder> diagnosticBuilder;
    protected DiagnosticHandler diagnosticHandler;
    protected int flags = 0;
    protected boolean returning;
    protected SemanticModel semanticModel;
    protected ModuleInfo moduleInfo;
    private static final Map<NodeKind, Supplier<? extends NodeBuilder>> CONSTRUCTOR_MAP = new HashMap<NodeKind, Supplier<? extends NodeBuilder>>(){
        {
            this.put(NodeKind.IF, IfBuilder::new);
            this.put(NodeKind.RETURN, ReturnBuilder::new);
            this.put(NodeKind.EXPRESSION, ExpressionBuilder::new);
            this.put(NodeKind.ERROR_HANDLER, ErrorHandlerBuilder::new);
            this.put(NodeKind.WHILE, WhileBuilder::new);
            this.put(NodeKind.CONTINUE, ContinueBuilder::new);
            this.put(NodeKind.BREAK, BreakBuilder::new);
            this.put(NodeKind.PANIC, PanicBuilder::new);
            this.put(NodeKind.EVENT_START, EventStartBuilder::new);
            this.put(NodeKind.REMOTE_ACTION_CALL, RemoteActionCallBuilder::new);
            this.put(NodeKind.RESOURCE_ACTION_CALL, ResourceActionCallBuilder::new);
            this.put(NodeKind.NEW_CONNECTION, NewConnectionBuilder::new);
            this.put(NodeKind.START, StartBuilder::new);
            this.put(NodeKind.TRANSACTION, TransactionBuilder::new);
            this.put(NodeKind.RETRY, RetryBuilder::new);
            this.put(NodeKind.LOCK, LockBuilder::new);
            this.put(NodeKind.FAIL, FailBuilder::new);
            this.put(NodeKind.COMMIT, CommitBuilder::new);
            this.put(NodeKind.ROLLBACK, RollbackBuilder::new);
            this.put(NodeKind.XML_PAYLOAD, XmlPayloadBuilder::new);
            this.put(NodeKind.JSON_PAYLOAD, JsonPayloadBuilder::new);
            this.put(NodeKind.BINARY_DATA, BinaryBuilder::new);
            this.put(NodeKind.STOP, StopBuilder::new);
            this.put(NodeKind.FUNCTION_CALL, FunctionCall::new);
            this.put(NodeKind.NP_FUNCTION_CALL, NPFunctionCall::new);
            this.put(NodeKind.NP_FUNCTION_DEFINITION, NPFunctionDefinitionBuilder::new);
            this.put(NodeKind.METHOD_CALL, MethodCall::new);
            this.put(NodeKind.FOREACH, ForeachBuilder::new);
            this.put(NodeKind.DATA_MAPPER, DataMapperBuilder::new);
            this.put(NodeKind.DATA_MAPPER_DEFINITION, DataMapperDefinitionBuilder::new);
            this.put(NodeKind.FUNCTION_DEFINITION, FunctionDefinitionBuilder::new);
            this.put(NodeKind.AUTOMATION, AutomationBuilder::new);
            this.put(NodeKind.VARIABLE, VariableBuilder::new);
            this.put(NodeKind.ASSIGN, AssignBuilder::new);
            this.put(NodeKind.COMMENT, CommentBuilder::new);
            this.put(NodeKind.MATCH, MatchBuilder::new);
            this.put(NodeKind.CONFIG_VARIABLE, ConfigVariableBuilder::new);
            this.put(NodeKind.DATA_MAPPER_CALL, DataMapperCallBuilder::new);
            this.put(NodeKind.FORK, ForkBuilder::new);
            this.put(NodeKind.PARALLEL_FLOW, ParallelFlowBuilder::new);
            this.put(NodeKind.WAIT, WaitBuilder::new);
            this.put(NodeKind.AGENT, AgentBuilder::new);
            this.put(NodeKind.AGENT_CALL, AgentCallBuilder::new);
            this.put(NodeKind.CLASS_INIT, ClassInitBuilder::new);
        }
    };

    public static NodeBuilder getNodeFromKind(NodeKind kind) {
        return CONSTRUCTOR_MAP.getOrDefault((Object)kind, ExpressionBuilder::new).get();
    }

    public NodeBuilder setConstData() {
        this.setConcreteConstData();
        return this;
    }

    public abstract void setConcreteConstData();

    public NodeBuilder setTemplateData(TemplateContext context) {
        this.setConcreteTemplateData(context);
        this.codedata().isNew();
        return this;
    }

    public abstract void setConcreteTemplateData(TemplateContext var1);

    public abstract Map<Path, List<TextEdit>> toSource(SourceBuilder var1);

    public NodeBuilder semanticModel(SemanticModel semanticModel) {
        this.semanticModel = semanticModel;
        return this;
    }

    public NodeBuilder diagnosticHandler(DiagnosticHandler diagnosticHandler) {
        this.diagnosticHandler = diagnosticHandler;
        return this;
    }

    public NodeBuilder defaultModuleName(ModuleInfo moduleInfo) {
        this.moduleInfo = moduleInfo;
        return this;
    }

    public NodeBuilder returning() {
        this.returning = true;
        return this;
    }

    public NodeBuilder branch(Branch branch) {
        this.branches.add(branch);
        return this;
    }

    public NodeBuilder flag(int flag) {
        this.flags |= flag;
        return this;
    }

    public NodeBuilder symbolInfo(Symbol symbol) {
        Optional module = symbol.getModule();
        if (module.isEmpty()) {
            this.codedata().module(".").version("0.0.0");
            return this;
        }
        ModuleID moduleId = ((ModuleSymbol)module.get()).id();
        String orgName = moduleId.orgName();
        String packageName = moduleId.packageName();
        String versionName = moduleId.version();
        if (!CommonUtils.isDefaultPackage((String)orgName, (String)packageName, (ModuleInfo)this.moduleInfo)) {
            this.metadata().icon(CommonUtils.generateIcon((String)orgName, (String)packageName, (String)versionName));
        }
        this.codedata().org(orgName).module(packageName).version(versionName);
        return this;
    }

    public Metadata.Builder<NodeBuilder> metadata() {
        if (this.metadataBuilder == null) {
            this.metadataBuilder = new Metadata.Builder<NodeBuilder>(this);
        }
        return this.metadataBuilder;
    }

    public Codedata.Builder<NodeBuilder> codedata() {
        if (this.codedataBuilder == null) {
            this.codedataBuilder = new Codedata.Builder<NodeBuilder>(this);
        }
        return this.codedataBuilder;
    }

    public FormBuilder<NodeBuilder> properties() {
        if (this.formBuilder == null) {
            this.formBuilder = new FormBuilder<NodeBuilder>(this.semanticModel, this.diagnosticHandler, this.moduleInfo, this);
        }
        return this.formBuilder;
    }

    public Diagnostics.Builder<NodeBuilder> diagnostics() {
        if (this.diagnosticBuilder == null) {
            this.diagnosticBuilder = new Diagnostics.Builder<NodeBuilder>(this);
        }
        return this.diagnosticBuilder;
    }

    public FlowNode build() {
        this.setConstData();
        Codedata codedata = this.codedataBuilder == null ? null : this.codedataBuilder.build();
        return new FlowNode(String.valueOf(Objects.hash(codedata != null ? codedata.lineRange() : null)), this.metadataBuilder == null ? null : this.metadataBuilder.build(), codedata, this.returning, this.branches.isEmpty() ? null : this.branches, this.formBuilder == null ? null : this.formBuilder.build(), this.diagnosticBuilder == null ? null : this.diagnosticBuilder.build(), this.flags);
    }

    public AvailableNode buildAvailableNode() {
        this.setConcreteConstData();
        return new AvailableNode(this.metadataBuilder == null ? null : this.metadataBuilder.build(), this.codedataBuilder == null ? null : this.codedataBuilder.build(), true);
    }

    public record TemplateContext(WorkspaceManager workspaceManager, Path filePath, LinePosition position, Codedata codedata, LSClientLogger lsClientLogger) {
        public Set<String> getAllVisibleSymbolNames() {
            try {
                this.workspaceManager.loadProject(this.filePath);
                SemanticModel semanticModel = (SemanticModel)this.workspaceManager.semanticModel(this.filePath).orElseThrow();
                Document document = (Document)this.workspaceManager.document(this.filePath).orElseThrow();
                return semanticModel.visibleSymbols(document, this.position).parallelStream().filter(s -> s.getName().isPresent()).map(s -> (String)s.getName().get()).collect(Collectors.toSet());
            }
            catch (Throwable e) {
                return new HashSet<String>();
            }
        }
    }
}

