/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.model.node;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.flowmodelgenerator.core.model.Codedata;
import io.ballerina.flowmodelgenerator.core.model.FormBuilder;
import io.ballerina.flowmodelgenerator.core.model.NodeBuilder;
import io.ballerina.flowmodelgenerator.core.model.NodeKind;
import io.ballerina.flowmodelgenerator.core.model.Property;
import io.ballerina.flowmodelgenerator.core.utils.FlowNodeUtil;
import io.ballerina.flowmodelgenerator.core.utils.ParamUtils;
import io.ballerina.modelgenerator.commons.CommonUtils;
import io.ballerina.modelgenerator.commons.FunctionData;
import io.ballerina.modelgenerator.commons.FunctionDataBuilder;
import io.ballerina.modelgenerator.commons.ModuleInfo;
import io.ballerina.modelgenerator.commons.PackageUtil;
import io.ballerina.modelgenerator.commons.ParameterData;
import io.ballerina.projects.ModuleDescriptor;
import io.ballerina.projects.PackageDescriptor;
import io.ballerina.projects.Project;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.List;
import org.ballerinalang.langserver.commons.eventsync.exceptions.EventSyncException;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentException;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;

public abstract class CallBuilder
extends NodeBuilder {
    protected abstract NodeKind getFunctionNodeKind();

    protected abstract FunctionData.Kind getFunctionResultKind();

    @Override
    public void setConcreteConstData() {
        this.codedata().node(this.getFunctionNodeKind());
    }

    @Override
    public void setConcreteTemplateData(NodeBuilder.TemplateContext context) {
        boolean isLocalFunction;
        Codedata codedata = context.codedata();
        FunctionDataBuilder functionDataBuilder = new FunctionDataBuilder().name(codedata.symbol()).moduleInfo(new ModuleInfo(codedata.org(), codedata.module(), codedata.module(), codedata.version())).lsClientLogger(context.lsClientLogger()).functionResultKind(this.getFunctionResultKind()).userModuleInfo(this.moduleInfo);
        NodeKind functionNodeKind = this.getFunctionNodeKind();
        if (functionNodeKind != NodeKind.FUNCTION_CALL) {
            functionDataBuilder.parentSymbolType(codedata.object());
        }
        if (isLocalFunction = CallBuilder.isLocalFunction(context.workspaceManager(), context.filePath(), codedata)) {
            WorkspaceManager workspaceManager = context.workspaceManager();
            PackageUtil.loadProject((WorkspaceManager)context.workspaceManager(), (Path)context.filePath());
            context.workspaceManager().module(context.filePath()).map(module -> ModuleInfo.from((ModuleDescriptor)module.descriptor())).ifPresent(arg_0 -> ((FunctionDataBuilder)functionDataBuilder).userModuleInfo(arg_0));
            SemanticModel semanticModel = (SemanticModel)workspaceManager.semanticModel(context.filePath()).orElseThrow();
            functionDataBuilder.semanticModel(semanticModel);
        }
        FunctionData functionData = functionDataBuilder.build();
        this.metadata().label(functionData.name()).icon(CommonUtils.generateIcon((String)functionData.org(), (String)functionData.packageName(), (String)functionData.version())).description(functionData.description());
        this.codedata().node(functionNodeKind).org(codedata.org()).module(codedata.module()).object(codedata.object()).version(codedata.version()).symbol(codedata.symbol()).inferredReturnType(functionData.inferredReturnType() ? functionData.returnType() : null);
        if (functionNodeKind != NodeKind.FUNCTION_CALL && functionNodeKind != NodeKind.AGENT && functionNodeKind != NodeKind.CLASS_INIT) {
            ((FormBuilder)((Property.Builder)this.properties().custom().metadata().label("Connection").description("Connection to use").stepOut()).typeConstraint(isLocalFunction ? codedata.object() : CommonUtils.getClassType((String)codedata.module(), (String)codedata.object())).value(codedata.parentSymbol()).type(Property.ValueType.EXPRESSION).stepOut()).addProperty("connection");
        }
        this.setParameterProperties(functionData);
        if (CommonUtils.hasReturn((String)functionData.returnType())) {
            this.setReturnTypeProperties(functionData, context, "Variable Name");
        }
        if (functionData.returnError()) {
            this.properties().checkError(true);
        }
    }

    public static void buildInferredTypeProperty(NodeBuilder nodeBuilder, ParameterData paramData, String value) {
        String unescapedParamName = ParamUtils.removeLeadingSingleQuote(paramData.name());
        ((FormBuilder)((Property.Builder)((Property.Builder)nodeBuilder.properties().custom().metadata().label(unescapedParamName).description(paramData.description()).stepOut()).codedata().kind(paramData.kind().name()).originalName(paramData.name()).stepOut()).value(value).placeholder(paramData.defaultValue()).type(Property.ValueType.TYPE).typeConstraint(paramData.type()).imports(paramData.importStatements()).editable().stepOut()).addProperty(unescapedParamName);
    }

    protected void setParameterProperties(FunctionData function) {
        boolean hasOnlyRestParams = function.parameters().size() == 1;
        LinkedHashMap paramMap = new LinkedHashMap();
        function.parameters().forEach((key, paramData) -> {
            if (paramData.kind() != ParameterData.Kind.PARAM_FOR_TYPE_INFER) {
                paramMap.put(key, paramData);
                return;
            }
            CallBuilder.buildInferredTypeProperty(this, paramData, null);
        });
        for (ParameterData paramResult : paramMap.values()) {
            if (paramResult.kind().equals((Object)ParameterData.Kind.INCLUDED_RECORD)) continue;
            String unescapedParamName = ParamUtils.removeLeadingSingleQuote(paramResult.name());
            Property.Builder<FormBuilder<NodeBuilder>> customPropBuilder = this.properties().custom();
            String label = paramResult.label();
            ((Property.Builder)((Property.Builder)customPropBuilder.metadata().label(label == null || label.isEmpty() ? unescapedParamName : label).description(paramResult.description()).stepOut()).codedata().kind(paramResult.kind().name()).originalName(paramResult.name()).stepOut()).placeholder(paramResult.defaultValue()).typeConstraint(paramResult.type()).typeMembers(paramResult.typeMembers()).imports(paramResult.importStatements()).editable().defaultable(paramResult.optional());
            switch (paramResult.kind()) {
                case PARAM_FOR_TYPE_INFER: {
                    customPropBuilder.advanced(false);
                    customPropBuilder.optional(false);
                    customPropBuilder.type(Property.ValueType.TYPE);
                    break;
                }
                case INCLUDED_RECORD_REST: {
                    if (hasOnlyRestParams) {
                        customPropBuilder.defaultable(false);
                    }
                    unescapedParamName = "additionalValues";
                    customPropBuilder.type(Property.ValueType.MAPPING_EXPRESSION_SET);
                    break;
                }
                case REST_PARAMETER: {
                    if (hasOnlyRestParams) {
                        customPropBuilder.defaultable(false);
                    }
                    customPropBuilder.type(Property.ValueType.EXPRESSION_SET);
                    break;
                }
                default: {
                    if (paramResult.type() instanceof List) {
                        customPropBuilder.type(Property.ValueType.SINGLE_SELECT);
                        break;
                    }
                    customPropBuilder.type(Property.ValueType.EXPRESSION);
                }
            }
            ((FormBuilder)customPropBuilder.stepOut()).addProperty(FlowNodeUtil.getPropertyKey(unescapedParamName));
        }
    }

    protected void setReturnTypeProperties(FunctionData functionData, NodeBuilder.TemplateContext context, String label) {
        this.properties().type(functionData.returnType(), false, functionData.importStatements()).data(functionData.returnType(), context.getAllVisibleSymbolNames(), label);
    }

    protected void setExpressionProperty(Codedata codedata) {
        ((FormBuilder)((Property.Builder)this.properties().custom().metadata().label("Connection").description("Connection to use").stepOut()).typeConstraint(CommonUtils.getClassType((String)codedata.module(), (String)codedata.object())).value(codedata.parentSymbol()).type(Property.ValueType.EXPRESSION).stepOut()).addProperty("connection");
    }

    protected static boolean isLocalFunction(WorkspaceManager workspaceManager, Path filePath, Codedata codedata) {
        if (codedata.org() == null || codedata.module() == null) {
            return false;
        }
        try {
            Project project = workspaceManager.loadProject(filePath);
            PackageDescriptor descriptor = project.currentPackage().descriptor();
            String packageOrg = descriptor.org().value();
            String packageName = descriptor.name().value();
            return packageOrg.equals(codedata.org()) && packageName.equals(codedata.module());
        }
        catch (EventSyncException | WorkspaceDocumentException e) {
            return false;
        }
    }
}

