/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.model.node;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ArrayTypeSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.flowmodelgenerator.core.model.FormBuilder;
import io.ballerina.flowmodelgenerator.core.model.NodeBuilder;
import io.ballerina.flowmodelgenerator.core.model.NodeKind;
import io.ballerina.flowmodelgenerator.core.model.Property;
import io.ballerina.flowmodelgenerator.core.model.SourceBuilder;
import io.ballerina.modelgenerator.commons.CommonUtils;
import io.ballerina.projects.Document;
import io.ballerina.projects.Project;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.LineRange;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.ballerinalang.langserver.common.utils.NameUtil;
import org.ballerinalang.langserver.commons.eventsync.exceptions.EventSyncException;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentException;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;
import org.eclipse.lsp4j.TextEdit;

public class DataMapperBuilder
extends NodeBuilder {
    public static final String LABEL = "Data Mapper";
    public static final String DESCRIPTION = "Map data from multiple variables to a record type";
    public static final String FUNCTION_NAME_KEY = "functionName";
    public static final String FUNCTION_NAME_LABEL = "Data mapper name";
    public static final String FUNCTION_NAME_DOC = "Name of the data mapper function";
    public static final String INPUTS_KEY = "inputs";
    public static final String INPUTS_LABEL = "Inputs";
    public static final String INPUTS_DOC = "Input variables of the data mapper function";
    public static final String OUTPUT_KEY = "output";
    public static final String OUTPUT_LABEL = "Output";
    public static final String OUTPUT_DOC = "Output of the data mapper function";
    public static final String VIEW_KEY = "view";
    public static final String VIEW_LABEL = "View";
    public static final String VIEW_DOC = "Function definition location";

    @Override
    public void setConcreteConstData() {
        this.metadata().label(LABEL).description(DESCRIPTION);
        this.codedata().node(NodeKind.DATA_MAPPER);
    }

    @Override
    public void setConcreteTemplateData(NodeBuilder.TemplateContext context) {
        Document document;
        SemanticModel semanticModel;
        Set<String> allVisibleSymbolNames = context.getAllVisibleSymbolNames();
        ((FormBuilder)((Property.Builder)this.properties().custom().metadata().label(FUNCTION_NAME_LABEL).description(FUNCTION_NAME_DOC).stepOut()).type(Property.ValueType.IDENTIFIER).value(NameUtil.generateTypeName((String)"transform", allVisibleSymbolNames)).editable().stepOut()).addProperty(FUNCTION_NAME_KEY);
        WorkspaceManager workspaceManager = context.workspaceManager();
        try {
            workspaceManager.loadProject(context.filePath());
            semanticModel = (SemanticModel)workspaceManager.semanticModel(context.filePath()).orElseThrow();
            document = (Document)workspaceManager.document(context.filePath()).orElseThrow();
        }
        catch (EventSyncException | WorkspaceDocumentException e) {
            throw new RuntimeException(e);
        }
        TreeSet<String> visibleTypes = new TreeSet<String>();
        for (Symbol symbol : semanticModel.visibleSymbols(document, context.position())) {
            if (symbol.kind() != SymbolKind.TYPE_DEFINITION) continue;
            this.addDataMappingCapableTypes(visibleTypes, symbol, ((TypeDefinitionSymbol)symbol).typeDescriptor());
        }
        ((FormBuilder)((Property.Builder)this.properties().custom().metadata().label(INPUTS_LABEL).description(INPUTS_DOC).stepOut()).type(Property.ValueType.MULTIPLE_SELECT).value("").typeConstraint(new ArrayList<String>(visibleTypes)).optional(false).editable().stepOut()).addProperty(INPUTS_KEY);
        ((FormBuilder)((Property.Builder)this.properties().custom().metadata().label(OUTPUT_LABEL).description(OUTPUT_DOC).stepOut()).type(Property.ValueType.SINGLE_SELECT).value("").typeConstraint(new ArrayList<String>(visibleTypes)).optional(false).editable().stepOut()).addProperty(OUTPUT_KEY);
    }

    private void addDataMappingCapableTypes(Set<String> types, Symbol parentSymbol, TypeSymbol typeSymbol) {
        TypeSymbol rawType = CommonUtils.getRawType((TypeSymbol)typeSymbol);
        switch (rawType.typeKind()) {
            case ARRAY: {
                this.addDataMappingCapableTypes(types, parentSymbol, ((ArrayTypeSymbol)rawType).memberTypeDescriptor());
                break;
            }
            case RECORD: {
                Optional moduleName = parentSymbol.getModule().flatMap(Symbol::getName);
                if (moduleName.isPresent() && ((String)moduleName.get()).equals("lang.annotations")) break;
                parentSymbol.getName().ifPresent(types::add);
                break;
            }
            case NIL: 
            case BOOLEAN: 
            case INT: 
            case FLOAT: 
            case DECIMAL: 
            case BYTE: 
            case STRING: 
            case JSON: {
                parentSymbol.getName().ifPresent(types::add);
                break;
            }
        }
    }

    private Optional<LineRange> getTransformFunctionLocation(SourceBuilder sourceBuilder, String functionNameString) {
        Project project;
        try {
            project = sourceBuilder.workspaceManager.loadProject(sourceBuilder.filePath);
        }
        catch (EventSyncException | WorkspaceDocumentException e) {
            return Optional.empty();
        }
        Optional semanticModel = sourceBuilder.workspaceManager.semanticModel(sourceBuilder.filePath);
        Optional location = semanticModel.flatMap(model -> model.moduleSymbols().parallelStream().filter(symbol -> symbol.kind() == SymbolKind.FUNCTION && symbol.nameEquals(functionNameString)).findAny().flatMap(Symbol::getLocation));
        if (location.isEmpty()) {
            return Optional.empty();
        }
        Document document = CommonUtils.getDocument((Project)project, (Location)((Location)location.get()));
        ModulePartNode node = (ModulePartNode)document.syntaxTree().rootNode();
        if (node.kind() != SyntaxKind.MODULE_PART) {
            return Optional.empty();
        }
        return ((Stream)node.members().stream().parallel()).filter(member -> member.kind() == SyntaxKind.FUNCTION_DEFINITION && ((FunctionDefinitionNode)member).functionName().text().strip().equals(functionNameString)).findAny().map(Node::lineRange);
    }

    @Override
    public Map<Path, List<TextEdit>> toSource(SourceBuilder sourceBuilder) {
        Optional<Property> output;
        Optional<Property> functionName = sourceBuilder.flowNode.getProperty(FUNCTION_NAME_KEY);
        if (functionName.isEmpty()) {
            throw new IllegalStateException("Function name must be defined for a data mapper node");
        }
        String functionNameString = functionName.get().value().toString();
        Optional<Property> inputs = sourceBuilder.flowNode.getProperty(INPUTS_KEY);
        if (inputs.isEmpty()) {
            throw new IllegalStateException("Inputs must be defined for a data mapper node");
        }
        ArrayList<String> inputArray = new ArrayList<String>();
        if (inputs.get().value() instanceof List) {
            for (Object input : (List)inputs.get().value()) {
                inputArray.add(input.toString());
            }
        }
        if ((output = sourceBuilder.flowNode.getProperty(OUTPUT_KEY)).isEmpty()) {
            throw new IllegalStateException("Output must be defined for a data mapper node");
        }
        String bodyText = sourceBuilder.getExpressionBodyText(output.get().value().toString(), null).orElse("");
        sourceBuilder.token().keyword(SyntaxKind.FUNCTION_KEYWORD).name(functionNameString).keyword(SyntaxKind.OPEN_PAREN_TOKEN).name(String.join((CharSequence)", ", inputArray)).keyword(SyntaxKind.CLOSE_PAREN_TOKEN).keyword(SyntaxKind.RETURNS_KEYWORD).name(output.get().value().toString()).keyword(SyntaxKind.RIGHT_DOUBLE_ARROW_TOKEN).openBrace().name(bodyText).closeBrace().endOfStatement();
        this.getTransformFunctionLocation(sourceBuilder, functionNameString).ifPresentOrElse(lineRange -> sourceBuilder.textEdit(), () -> sourceBuilder.textEdit());
        return sourceBuilder.build();
    }
}

