/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.model.node;

import com.google.gson.Gson;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.flowmodelgenerator.core.model.FormBuilder;
import io.ballerina.flowmodelgenerator.core.model.NodeBuilder;
import io.ballerina.flowmodelgenerator.core.model.NodeKind;
import io.ballerina.flowmodelgenerator.core.model.Property;
import io.ballerina.flowmodelgenerator.core.model.SourceBuilder;
import io.ballerina.tools.text.LineRange;
import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.model.types.TypeKind;
import org.eclipse.lsp4j.TextEdit;

public class DataMapperDefinitionBuilder
extends NodeBuilder {
    public static final String LABEL = "Data Mapper";
    public static final String DESCRIPTION = "Define a data mapper";
    public static final String DATA_MAPPER_NAME_LABEL = "Data Mapper Name";
    public static final String DATA_MAPPER_NAME_DOC = "Name of the data mapper";
    public static final String PARAMETERS_LABEL = "Inputs";
    public static final String PARAMETERS_DOC = "Input variables of the data mapper function";
    private static final Gson gson = new Gson();
    public static final String RETURN_TYPE = TypeKind.JSON.typeName();
    public static final String PARAMETER_TYPE = TypeKind.JSON.typeName();

    @Override
    public void setConcreteConstData() {
        this.metadata().label(LABEL).description(DESCRIPTION);
        this.codedata().node(NodeKind.DATA_MAPPER_DEFINITION);
    }

    public static Property getParameterSchema() {
        return ParameterSchemaHolder.PARAMETER_SCHEMA;
    }

    @Override
    public void setConcreteTemplateData(NodeBuilder.TemplateContext context) {
        this.properties().functionNameTemplate("transform", context.getAllVisibleSymbolNames(), DATA_MAPPER_NAME_LABEL, DATA_MAPPER_NAME_DOC);
        DataMapperDefinitionBuilder.setMandatoryProperties(this, null);
        DataMapperDefinitionBuilder.setOptionalProperties(this);
    }

    public static void setMandatoryProperties(NodeBuilder nodeBuilder, String returnType) {
        nodeBuilder.properties().returnType(returnType, RETURN_TYPE, false).nestedProperty();
    }

    public static void setProperty(FormBuilder<?> formBuilder, String type, String name, Token token) {
        formBuilder.parameter(type, name, token, Property.ValueType.TYPE, PARAMETER_TYPE);
    }

    public static void setOptionalProperties(NodeBuilder nodeBuilder) {
        nodeBuilder.properties().endNestedProperty(Property.ValueType.REPEATABLE_PROPERTY, "parameters", PARAMETERS_LABEL, PARAMETERS_DOC, DataMapperDefinitionBuilder.getParameterSchema(), false, false);
    }

    @Override
    public Map<Path, List<TextEdit>> toSource(SourceBuilder sourceBuilder) {
        Object object;
        sourceBuilder.token().keyword(SyntaxKind.FUNCTION_KEYWORD);
        Optional<Property> property = sourceBuilder.getProperty("functionName");
        if (property.isEmpty()) {
            throw new IllegalStateException("Data mapper name is not present");
        }
        sourceBuilder.token().name(property.get().value().toString()).keyword(SyntaxKind.OPEN_PAREN_TOKEN);
        Optional<Property> parameters = sourceBuilder.getProperty("parameters");
        if (parameters.isPresent() && (object = parameters.get().value()) instanceof Map) {
            Map paramMap = (Map)object;
            ArrayList<CallSite> paramList = new ArrayList<CallSite>();
            for (Object obj : paramMap.values()) {
                Property paramProperty = (Property)gson.fromJson(gson.toJsonTree(obj), Property.class);
                Object object2 = paramProperty.value();
                if (!(object2 instanceof Map)) continue;
                Map paramData = (Map)object2;
                Map paramProperties = (Map)gson.fromJson(gson.toJsonTree((Object)paramData), FormBuilder.NODE_PROPERTIES_TYPE);
                String paramType = ((Property)paramProperties.get("type")).value().toString();
                String paramName = ((Property)paramProperties.get("variable")).value().toString();
                paramList.add((CallSite)((Object)(paramType + " " + paramName)));
            }
            sourceBuilder.token().name(String.join((CharSequence)", ", paramList));
        }
        sourceBuilder.token().keyword(SyntaxKind.CLOSE_PAREN_TOKEN);
        Optional<Property> returnType = sourceBuilder.getProperty("type");
        if (returnType.isEmpty() || returnType.get().value().toString().isEmpty()) {
            throw new IllegalStateException("The data mapper should have an output");
        }
        String returnTypeString = returnType.get().value().toString();
        sourceBuilder.token().keyword(SyntaxKind.RETURNS_KEYWORD).name(returnTypeString);
        LineRange lineRange = sourceBuilder.flowNode.codedata().lineRange();
        if (lineRange == null) {
            Optional<String> returnBody = sourceBuilder.getExpressionBodyText(returnTypeString, returnType.get().imports());
            if (returnBody.isEmpty()) {
                throw new IllegalStateException("Failed to produce the data mapper output");
            }
            ((SourceBuilder)sourceBuilder.token().keyword(SyntaxKind.RIGHT_DOUBLE_ARROW_TOKEN).name(returnBody.get()).endOfStatement().stepOut()).textEdit(SourceBuilder.SourceKind.DECLARATION);
        } else {
            ((SourceBuilder)sourceBuilder.token().skipFormatting().stepOut()).textEdit();
        }
        return sourceBuilder.build();
    }

    private static class ParameterSchemaHolder {
        private static final Property PARAMETER_SCHEMA = ParameterSchemaHolder.initParameterSchema();

        private ParameterSchemaHolder() {
        }

        private static Property initParameterSchema() {
            FormBuilder<Object> formBuilder = new FormBuilder<Object>(null, null, null, null);
            DataMapperDefinitionBuilder.setProperty(formBuilder, "", "", null);
            Map<String, Property> nodeProperties = formBuilder.build();
            return nodeProperties.get("");
        }
    }
}

