/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.model.node;

import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.flowmodelgenerator.core.model.Branch;
import io.ballerina.flowmodelgenerator.core.model.NodeBuilder;
import io.ballerina.flowmodelgenerator.core.model.NodeKind;
import io.ballerina.flowmodelgenerator.core.model.Property;
import io.ballerina.flowmodelgenerator.core.model.SourceBuilder;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.lsp4j.TextEdit;

public class ForeachBuilder
extends NodeBuilder {
    public static final String LABEL = "Foreach";
    public static final String DESCRIPTION = "Iterate over a block of code.";

    @Override
    public void setConcreteConstData() {
        this.metadata().label(LABEL).description(DESCRIPTION);
        this.codedata().node(NodeKind.FOREACH);
    }

    @Override
    public Map<Path, List<TextEdit>> toSource(SourceBuilder sourceBuilder) {
        ((SourceBuilder)sourceBuilder.token().keyword(SyntaxKind.FOREACH_KEYWORD).stepOut()).typedBindingPattern().token().keyword(SyntaxKind.IN_KEYWORD);
        Optional<Property> exprProperty = sourceBuilder.getProperty("collection");
        exprProperty.ifPresent(property -> sourceBuilder.token().expression((Property)property));
        Optional<Branch> body = sourceBuilder.flowNode.getBranch("Body");
        body.ifPresent(branch -> sourceBuilder.body(branch.children()));
        return sourceBuilder.onFailure().textEdit().build();
    }

    @Override
    public void setConcreteTemplateData(NodeBuilder.TemplateContext context) {
        this.properties().dataVariable(null, context.getAllVisibleSymbolNames()).collection(null);
        this.branches = List.of(Branch.DEFAULT_BODY_BRANCH, Branch.getDefaultOnFailBranch(true));
    }
}

