/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.model.node;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.flowmodelgenerator.core.model.Codedata;
import io.ballerina.flowmodelgenerator.core.model.FormBuilder;
import io.ballerina.flowmodelgenerator.core.model.NodeBuilder;
import io.ballerina.flowmodelgenerator.core.model.NodeKind;
import io.ballerina.flowmodelgenerator.core.model.Property;
import io.ballerina.flowmodelgenerator.core.model.node.FunctionCall;
import io.ballerina.flowmodelgenerator.core.utils.ParamUtils;
import io.ballerina.modelgenerator.commons.CommonUtils;
import io.ballerina.modelgenerator.commons.FunctionData;
import io.ballerina.modelgenerator.commons.FunctionDataBuilder;
import io.ballerina.modelgenerator.commons.ModuleInfo;
import io.ballerina.modelgenerator.commons.PackageUtil;
import io.ballerina.modelgenerator.commons.ParameterData;
import io.ballerina.projects.ModuleDescriptor;
import java.nio.file.Path;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;

public class NPFunctionCall
extends FunctionCall {
    public static final String LABEL = "Call Natural Function";
    public static final String DESCRIPTION = "Call a natural programming function";

    @Override
    protected NodeKind getFunctionNodeKind() {
        return NodeKind.NP_FUNCTION_CALL;
    }

    @Override
    protected FunctionData.Kind getFunctionResultKind() {
        return super.getFunctionResultKind();
    }

    @Override
    protected void setParameterProperties(FunctionData function) {
        boolean hasOnlyRestParams = function.parameters().size() == 1;
        for (ParameterData paramResult : function.parameters().values()) {
            if (paramResult.kind().equals((Object)ParameterData.Kind.PARAM_FOR_TYPE_INFER) || paramResult.kind().equals((Object)ParameterData.Kind.INCLUDED_RECORD) || NPFunctionCall.isPromptParam(paramResult)) continue;
            String unescapedParamName = ParamUtils.removeLeadingSingleQuote(paramResult.name());
            Property.Builder<FormBuilder<NodeBuilder>> customPropBuilder = this.properties().custom();
            ((Property.Builder)((Property.Builder)customPropBuilder.metadata().label(unescapedParamName).description(paramResult.description()).stepOut()).codedata().kind(paramResult.kind().name()).originalName(paramResult.name()).stepOut()).placeholder(paramResult.defaultValue()).typeConstraint(paramResult.type()).imports(paramResult.importStatements()).editable().defaultable(paramResult.optional());
            switch (paramResult.kind()) {
                case INCLUDED_RECORD_REST: {
                    if (hasOnlyRestParams) {
                        customPropBuilder.defaultable(false);
                    }
                    unescapedParamName = "additionalValues";
                    customPropBuilder.type(Property.ValueType.MAPPING_EXPRESSION_SET);
                    break;
                }
                case REST_PARAMETER: {
                    if (hasOnlyRestParams) {
                        customPropBuilder.defaultable(false);
                    }
                    customPropBuilder.type(Property.ValueType.EXPRESSION_SET);
                    break;
                }
                default: {
                    customPropBuilder.type(Property.ValueType.EXPRESSION);
                }
            }
            ((FormBuilder)customPropBuilder.stepOut()).addProperty(unescapedParamName);
        }
    }

    @Override
    public void setConcreteTemplateData(NodeBuilder.TemplateContext context) {
        Codedata codedata = context.codedata();
        FunctionDataBuilder functionDataBuilder = new FunctionDataBuilder().name(codedata.symbol()).moduleInfo(new ModuleInfo(codedata.org(), codedata.module(), codedata.module(), codedata.version())).functionResultKind(this.getFunctionResultKind()).userModuleInfo(this.moduleInfo);
        boolean isLocalFunction = NPFunctionCall.isLocalFunction(context.workspaceManager(), context.filePath(), codedata);
        if (isLocalFunction) {
            WorkspaceManager workspaceManager = context.workspaceManager();
            PackageUtil.loadProject((WorkspaceManager)context.workspaceManager(), (Path)context.filePath());
            context.workspaceManager().module(context.filePath()).map(module -> ModuleInfo.from((ModuleDescriptor)module.descriptor())).ifPresent(arg_0 -> ((FunctionDataBuilder)functionDataBuilder).userModuleInfo(arg_0));
            SemanticModel semanticModel = (SemanticModel)workspaceManager.semanticModel(context.filePath()).orElseThrow();
            functionDataBuilder.semanticModel(semanticModel);
        }
        FunctionData functionData = functionDataBuilder.build();
        this.metadata().label(functionData.name()).description(functionData.description());
        this.codedata().id(functionData.functionId()).node(this.getFunctionNodeKind()).org(codedata.org()).module(codedata.module()).object(codedata.object()).version(codedata.version()).symbol(codedata.symbol());
        this.setParameterProperties(functionData);
        String returnTypeName = functionData.returnType();
        if (CommonUtils.hasReturn((String)functionData.returnType())) {
            this.properties().type(returnTypeName, functionData.inferredReturnType(), functionData.importStatements()).data(returnTypeName, context.getAllVisibleSymbolNames(), "Variable Name");
        }
        if (functionData.returnError()) {
            this.properties().checkError(true);
        }
    }

    public static boolean isPromptParam(ParameterData parameterData) {
        return parameterData.name().equals("prompt") && parameterData.type().equals("np:Prompt");
    }
}

