/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.model.node;

import com.google.gson.Gson;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.flowmodelgenerator.core.model.FormBuilder;
import io.ballerina.flowmodelgenerator.core.model.NodeBuilder;
import io.ballerina.flowmodelgenerator.core.model.NodeKind;
import io.ballerina.flowmodelgenerator.core.model.Property;
import io.ballerina.flowmodelgenerator.core.model.SourceBuilder;
import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.lsp4j.TextEdit;

public class WaitBuilder
extends NodeBuilder {
    public static final String LABEL = "Wait";
    public static final String DESCRIPTION = "Wait for a set of futures to complete";
    public static final String WAIT_ALL_KEY = "waitAll";
    public static final String WAIT_ALL_LABEL = "Wait All";
    public static final String WAIT_ALL_DOC = "Wait for all tasks to complete";
    public static final String FUTURES_KEY = "futures";
    public static final String FUTURES_LABEL = "Futures";
    public static final String FUTURES_DOC = "The futures to wait for";
    public static final String FUTURE_KEY = "future";
    public static final String FUTURE_LABEL = "Future";
    public static final String FUTURE_DOC = "The worker/async function to wait for";
    private static final Gson gson = new Gson();

    @Override
    public void setConcreteConstData() {
        this.metadata().label(LABEL).description(DESCRIPTION);
        this.codedata().node(NodeKind.WAIT);
    }

    @Override
    public void setConcreteTemplateData(NodeBuilder.TemplateContext context) {
        this.properties().dataVariable(null, context.getAllVisibleSymbolNames()).waitAll(false).nestedProperty().nestedProperty().waitField(null).expression(null).endNestedProperty(Property.ValueType.FIXED_PROPERTY, "future1", FUTURE_LABEL, FUTURE_DOC).endNestedProperty(Property.ValueType.REPEATABLE_PROPERTY, FUTURES_KEY, FUTURES_LABEL, FUTURES_DOC);
    }

    @Override
    public Map<Path, List<TextEdit>> toSource(SourceBuilder sourceBuilder) {
        Object object;
        Optional<Property> futures;
        boolean waitAll;
        sourceBuilder.newVariable();
        sourceBuilder.token().keyword(SyntaxKind.WAIT_KEYWORD);
        boolean bl = waitAll = sourceBuilder.flowNode.properties().containsKey(WAIT_ALL_KEY) && sourceBuilder.flowNode.properties().get(WAIT_ALL_KEY).value().equals(true);
        if (waitAll) {
            sourceBuilder.token().keyword(SyntaxKind.OPEN_BRACE_TOKEN);
        }
        if ((futures = sourceBuilder.getProperty(FUTURES_KEY)).isEmpty() || !((object = futures.get().value()) instanceof Map)) {
            throw new IllegalStateException("Wait node does not have futures to wait for");
        }
        Map futureMap = (Map)object;
        ArrayList<CallSite> expressions = new ArrayList<CallSite>();
        for (Object obj : futureMap.values()) {
            Property futureProperty = (Property)gson.fromJson(gson.toJsonTree(obj), Property.class);
            Object object2 = futureProperty.value();
            if (!(object2 instanceof Map)) continue;
            Map futureChildMap = (Map)object2;
            Map futureChildProperties = (Map)gson.fromJson(gson.toJsonTree((Object)futureChildMap), FormBuilder.NODE_PROPERTIES_TYPE);
            Property variableProperty = (Property)futureChildProperties.get("variable");
            Object waitField = waitAll && variableProperty != null && !variableProperty.value().toString().isEmpty() ? String.valueOf(variableProperty.value()) + ":" : "";
            Property expressionProperty = (Property)futureChildProperties.get("expression");
            if (expressionProperty == null) continue;
            expressions.add((CallSite)((Object)((String)waitField + expressionProperty.value().toString())));
        }
        String delimiter = waitAll ? "," : "|";
        sourceBuilder.token().name(String.join((CharSequence)delimiter, expressions));
        if (waitAll) {
            sourceBuilder.token().keyword(SyntaxKind.CLOSE_BRACE_TOKEN);
        }
        return ((SourceBuilder)sourceBuilder.token().endOfStatement().stepOut()).textEdit().build();
    }
}

