/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.search;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.symbols.AnnotationAttachmentSymbol;
import io.ballerina.compiler.api.symbols.AnnotationSymbol;
import io.ballerina.compiler.api.symbols.Documentation;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.flowmodelgenerator.core.model.AvailableNode;
import io.ballerina.flowmodelgenerator.core.model.Category;
import io.ballerina.flowmodelgenerator.core.model.Codedata;
import io.ballerina.flowmodelgenerator.core.model.Item;
import io.ballerina.flowmodelgenerator.core.model.Metadata;
import io.ballerina.flowmodelgenerator.core.model.NodeKind;
import io.ballerina.flowmodelgenerator.core.search.SearchCommand;
import io.ballerina.modelgenerator.commons.CommonUtils;
import io.ballerina.modelgenerator.commons.PackageUtil;
import io.ballerina.modelgenerator.commons.SearchResult;
import io.ballerina.projects.Document;
import io.ballerina.projects.Package;
import io.ballerina.projects.Project;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.LineRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.langserver.common.utils.PositionUtil;

class FunctionSearchCommand
extends SearchCommand {
    public static final String TOOL_ANNOTATION = "Tool";
    private static final String BALLERINAX = "ballerinax";
    private static final String AI_AGENT = "ai";
    private static final Map<String, List<String>> POPULAR_BALLERINA_FUNCTIONS = Map.of("log", List.of("printInfo", "printDebug", "printError", "printWarn"), "time", List.of("utcNow", "utcFromString"), "io", List.of("print", "println", "fileWriteString", "fileWriteJson", "fileReadString", "fileReadJson"));
    private static final String FETCH_KEY = "functions";
    private final List<String> moduleNames;
    private final Document functionsDoc;

    public FunctionSearchCommand(Project project, LineRange position, Map<String, String> queryMap, Document functionsDoc) {
        super(project, position, queryMap);
        Package currentPackage = project.currentPackage();
        PackageUtil.getCompilation((Package)currentPackage);
        this.moduleNames = currentPackage.getDefaultModule().moduleDependencies().stream().map(moduleDependency -> moduleDependency.descriptor().name().packageName().value()).toList();
        this.functionsDoc = functionsDoc;
    }

    @Override
    protected List<Item> defaultView() {
        this.buildProjectNodes();
        ArrayList<SearchResult> searchResults = new ArrayList<SearchResult>();
        if (!this.moduleNames.isEmpty()) {
            searchResults.addAll(this.dbManager.searchFunctionsByPackages(this.moduleNames, List.of(), this.limit, this.offset));
        }
        searchResults.addAll(this.defaultViewHolder.get(this).getOrDefault(FETCH_KEY, List.of()));
        this.buildLibraryNodes(searchResults);
        return this.rootBuilder.build().items();
    }

    @Override
    protected List<Item> search() {
        this.buildProjectNodes();
        List functionSearchList = this.dbManager.searchFunctions(this.query, this.limit, this.offset);
        this.buildLibraryNodes(functionSearchList);
        return this.rootBuilder.build().items();
    }

    @Override
    protected Map<String, List<SearchResult>> fetchPopularItems() {
        ArrayList<String> packageNames = new ArrayList<String>(POPULAR_BALLERINA_FUNCTIONS.keySet());
        List functionNames = POPULAR_BALLERINA_FUNCTIONS.values().stream().flatMap(Collection::stream).toList();
        return Map.of(FETCH_KEY, this.dbManager.searchFunctionsByPackages(packageNames, functionNames, this.limit, this.offset));
    }

    private void buildProjectNodes() {
        Package currentPackage = this.project.currentPackage();
        List<Symbol> functionSymbols = PackageUtil.getCompilation((Package)currentPackage).getSemanticModel(currentPackage.getDefaultModule().moduleId()).moduleSymbols().stream().filter(symbol -> symbol.kind().equals((Object)SymbolKind.FUNCTION) && !symbol.nameEquals("main")).toList();
        Category.Builder projectBuilder = this.rootBuilder.stepIn(Category.Name.CURRENT_INTEGRATION);
        Category.Builder agentToolsBuilder = this.rootBuilder.stepIn(Category.Name.AGENT_TOOLS);
        ArrayList<Item> availableNodes = new ArrayList<Item>();
        ArrayList<Item> availableTools = new ArrayList<Item>();
        for (Symbol symbol2 : functionSymbols) {
            FunctionSymbol functionSymbol = (FunctionSymbol)symbol2;
            if (this.functionsDoc != null && CommonUtils.isNaturalExpressionBodiedFunction((SyntaxTree)this.functionsDoc.syntaxTree(), (FunctionSymbol)functionSymbol)) continue;
            boolean isDataMappedFunction = false;
            Optional location = symbol2.getLocation();
            if (location.isPresent()) {
                isDataMappedFunction = ((Location)location.get()).lineRange().fileName().equals("data_mappings.bal");
                LineRange fnLineRange = ((Location)location.get()).lineRange();
                if (fnLineRange.fileName().equals(this.position.fileName()) && PositionUtil.isWithinLineRange((LineRange)fnLineRange, (LineRange)this.position)) continue;
            }
            if (symbol2.getName().isEmpty() || !this.query.isEmpty() && !((String)symbol2.getName().get()).toLowerCase(Locale.ROOT).contains(this.query.toLowerCase(Locale.ROOT))) continue;
            boolean isAgentTool = this.isAgentTool(functionSymbol);
            boolean isIsolatedFunction = functionSymbol.qualifiers().contains(Qualifier.ISOLATED);
            Metadata metadata = new Metadata.Builder<Object>(null).label((String)symbol2.getName().get()).description(functionSymbol.documentation().flatMap(Documentation::description).orElse(null)).addData("isDataMappedFunction", isDataMappedFunction).addData("isAgentTool", isAgentTool).addData("isIsolatedFunction", isIsolatedFunction).build();
            Codedata.Builder<Object> codedataBuilder = new Codedata.Builder<Object>(null).node(NodeKind.FUNCTION_CALL).symbol((String)symbol2.getName().get());
            Optional moduleSymbol = functionSymbol.getModule();
            if (moduleSymbol.isPresent()) {
                ModuleID id = ((ModuleSymbol)moduleSymbol.get()).id();
                codedataBuilder.org(id.orgName()).module(id.packageName()).version(id.version());
            }
            if (isAgentTool) {
                availableTools.add(new AvailableNode(metadata, codedataBuilder.build(), true));
                continue;
            }
            availableNodes.add(new AvailableNode(metadata, codedataBuilder.build(), true));
        }
        projectBuilder.items(availableNodes);
        agentToolsBuilder.items(availableTools);
    }

    private void buildLibraryNodes(List<SearchResult> functionSearchList) {
        Category.Builder importedFnBuilder = this.rootBuilder.stepIn(Category.Name.IMPORTED_FUNCTIONS);
        Category.Builder availableFnBuilder = this.rootBuilder.stepIn(Category.Name.AVAILABLE_FUNCTIONS);
        for (SearchResult searchResult : functionSearchList) {
            SearchResult.Package packageInfo = searchResult.packageInfo();
            String icon = CommonUtils.generateIcon((String)packageInfo.org(), (String)packageInfo.name(), (String)packageInfo.version());
            Metadata metadata = new Metadata.Builder<Object>(null).label(searchResult.name()).description(searchResult.description()).icon(icon).build();
            Codedata codedata = new Codedata.Builder<Object>(null).node(NodeKind.FUNCTION_CALL).org(packageInfo.org()).module(packageInfo.name()).symbol(searchResult.name()).version(packageInfo.version()).build();
            Category.Builder builder = this.moduleNames.contains(packageInfo.name()) ? importedFnBuilder : availableFnBuilder;
            if (builder == null) continue;
            builder.stepIn(packageInfo.name(), "", List.of()).node(new AvailableNode(metadata, codedata, true));
        }
    }

    private boolean isAgentTool(FunctionSymbol functionSymbol) {
        for (AnnotationAttachmentSymbol annotAttachment : functionSymbol.annotAttachments()) {
            Optional optName;
            ModuleID id;
            AnnotationSymbol annotationSymbol = annotAttachment.typeDescriptor();
            Optional optModule = annotationSymbol.getModule();
            if (optModule.isEmpty() || !(id = ((ModuleSymbol)optModule.get()).id()).orgName().equals(BALLERINAX) || !id.packageName().equals(AI_AGENT) || (optName = annotationSymbol.getName()).isEmpty() || !((String)optName.get()).equals(TOOL_ANNOTATION)) continue;
            return true;
        }
        return false;
    }
}

