/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.search;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.symbols.Documentation;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.flowmodelgenerator.core.model.AvailableNode;
import io.ballerina.flowmodelgenerator.core.model.Category;
import io.ballerina.flowmodelgenerator.core.model.Codedata;
import io.ballerina.flowmodelgenerator.core.model.Item;
import io.ballerina.flowmodelgenerator.core.model.Metadata;
import io.ballerina.flowmodelgenerator.core.model.NodeKind;
import io.ballerina.flowmodelgenerator.core.search.SearchCommand;
import io.ballerina.modelgenerator.commons.CommonUtils;
import io.ballerina.modelgenerator.commons.PackageUtil;
import io.ballerina.modelgenerator.commons.SearchResult;
import io.ballerina.projects.Document;
import io.ballerina.projects.Package;
import io.ballerina.projects.Project;
import io.ballerina.tools.text.LineRange;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;

class NPFunctionSearchCommand
extends SearchCommand {
    private final Document functionsDoc;

    public NPFunctionSearchCommand(Project project, LineRange position, Map<String, String> queryMap, Document functionsDoc) {
        super(project, position, queryMap);
        this.functionsDoc = functionsDoc;
    }

    @Override
    protected List<Item> defaultView() {
        this.buildProjectNodes();
        return this.rootBuilder.build().items();
    }

    @Override
    protected List<Item> search() {
        this.buildProjectNodes();
        return this.rootBuilder.build().items();
    }

    @Override
    protected Map<String, List<SearchResult>> fetchPopularItems() {
        return Map.of();
    }

    private void buildProjectNodes() {
        Package currentPackage = this.project.currentPackage();
        List<Symbol> functionSymbols = PackageUtil.getCompilation((Package)currentPackage).getSemanticModel(currentPackage.getDefaultModule().moduleId()).moduleSymbols().stream().filter(symbol -> symbol.kind().equals((Object)SymbolKind.FUNCTION)).toList();
        Category.Builder projectBuilder = this.rootBuilder.stepIn(Category.Name.CURRENT_INTEGRATION);
        ArrayList<Item> availableNodes = new ArrayList<Item>();
        for (Symbol symbol2 : functionSymbols) {
            FunctionSymbol functionSymbol = (FunctionSymbol)symbol2;
            if (this.functionsDoc == null || !CommonUtils.isNaturalExpressionBodiedFunction((SyntaxTree)this.functionsDoc.syntaxTree(), (FunctionSymbol)functionSymbol) || symbol2.getName().isEmpty() || !this.query.isEmpty() && !((String)symbol2.getName().get()).toLowerCase(Locale.ROOT).contains(this.query.toLowerCase(Locale.ROOT))) continue;
            Metadata metadata = new Metadata.Builder<Object>(null).label((String)symbol2.getName().get()).icon("https://gist.github.com/user-attachments/assets/903c5c16-7d67-4af8-8113-ce7c59ccdaab").description(functionSymbol.documentation().flatMap(Documentation::description).orElse(null)).build();
            Codedata.Builder<Object> codedataBuilder = new Codedata.Builder<Object>(null).node(NodeKind.NP_FUNCTION_CALL).symbol((String)symbol2.getName().get());
            Optional moduleSymbol = functionSymbol.getModule();
            if (moduleSymbol.isPresent()) {
                ModuleID id = ((ModuleSymbol)moduleSymbol.get()).id();
                codedataBuilder.org(id.orgName()).module(id.packageName()).version(id.version());
            }
            availableNodes.add(new AvailableNode(metadata, codedataBuilder.build(), true));
        }
        projectBuilder.items(availableNodes);
    }
}

