/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.search;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import io.ballerina.flowmodelgenerator.core.model.Category;
import io.ballerina.flowmodelgenerator.core.model.Item;
import io.ballerina.flowmodelgenerator.core.search.ConnectorSearchCommand;
import io.ballerina.flowmodelgenerator.core.search.DefaultViewHolder;
import io.ballerina.flowmodelgenerator.core.search.FunctionSearchCommand;
import io.ballerina.flowmodelgenerator.core.search.NPFunctionSearchCommand;
import io.ballerina.flowmodelgenerator.core.search.TypeSearchCommand;
import io.ballerina.modelgenerator.commons.SearchDatabaseManager;
import io.ballerina.modelgenerator.commons.SearchResult;
import io.ballerina.projects.Document;
import io.ballerina.projects.Project;
import io.ballerina.tools.text.LineRange;
import java.util.List;
import java.util.Map;

public abstract class SearchCommand {
    protected final Category.Builder rootBuilder = new Category.Builder(null);
    protected final Project project;
    protected final LineRange position;
    protected final String query;
    protected final int limit;
    protected final int offset;
    final SearchDatabaseManager dbManager;
    final DefaultViewHolder defaultViewHolder;
    protected static final String DATA_MAPPER_FILE_NAME = "data_mappings.bal";
    private static final Gson GSON = new Gson();
    private static final int DEFAULT_LIMIT = 20;
    private static final int DEFAULT_OFFSET = 0;

    public static SearchCommand from(Kind kind, Project module, LineRange position, Map<String, String> queryMap, Document functionsDoc) {
        return switch (kind.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> new FunctionSearchCommand(module, position, queryMap, functionsDoc);
            case 1 -> new ConnectorSearchCommand(module, position, queryMap);
            case 3 -> new NPFunctionSearchCommand(module, position, queryMap, functionsDoc);
            case 2 -> new TypeSearchCommand(module, position, queryMap);
        };
    }

    public SearchCommand(Project project, LineRange position, Map<String, String> queryMap) {
        this.project = project;
        this.position = position;
        this.dbManager = SearchDatabaseManager.getInstance();
        this.defaultViewHolder = DefaultViewHolder.getInstance();
        if (queryMap == null) {
            this.query = "";
            this.limit = 20;
            this.offset = 0;
        } else {
            this.query = queryMap.getOrDefault("q", "");
            this.limit = SearchCommand.parseIntParam(queryMap.get("limit"), 20);
            this.offset = SearchCommand.parseIntParam(queryMap.get("offset"), 0);
        }
    }

    protected abstract List<Item> defaultView();

    protected abstract List<Item> search();

    protected abstract Map<String, List<SearchResult>> fetchPopularItems();

    public JsonArray execute() {
        List<Item> items = this.query.isEmpty() ? this.defaultView() : this.search();
        return GSON.toJsonTree(items).getAsJsonArray();
    }

    private static int parseIntParam(String value, int defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static enum Kind {
        FUNCTION,
        CONNECTOR,
        TYPE,
        NP_FUNCTION;

    }
}

