/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.utils;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.Documentation;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.PathParameterSymbol;
import io.ballerina.compiler.api.symbols.ResourceMethodSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.resourcepath.PathSegmentList;
import io.ballerina.compiler.api.symbols.resourcepath.ResourcePath;
import io.ballerina.modelgenerator.commons.CommonUtils;
import io.ballerina.modelgenerator.commons.DefaultValueGeneratorUtil;
import io.ballerina.modelgenerator.commons.ParameterData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ParamUtils {
    public static final String REST_RESOURCE_PATH = "/path/to/subdirectory";
    public static final String REST_PARAM_PATH = "/path/to/resource";
    public static final String REST_RESOURCE_PATH_LABEL = "Remaining Resource Path";

    public static ResourcePathTemplate buildResourcePathTemplate(SemanticModel semanticModel, FunctionSymbol functionSymbol, TypeSymbol errorTypeSymbol) {
        Map documentationMap = functionSymbol.documentation().map(Documentation::parameterMap).orElse(Map.of());
        StringBuilder pathBuilder = new StringBuilder();
        ResourceMethodSymbol resourceMethodSymbol = (ResourceMethodSymbol)functionSymbol;
        ResourcePath resourcePath = resourceMethodSymbol.resourcePath();
        ArrayList<ParameterData> pathParams = new ArrayList<ParameterData>();
        switch (resourcePath.kind()) {
            case PATH_SEGMENT_LIST: {
                PathSegmentList pathSegmentList = (PathSegmentList)resourcePath;
                for (Symbol pathSegment : pathSegmentList.list()) {
                    pathBuilder.append("/");
                    if (pathSegment instanceof PathParameterSymbol) {
                        PathParameterSymbol pathParameterSymbol = (PathParameterSymbol)pathSegment;
                        String defaultValue = DefaultValueGeneratorUtil.getDefaultValueForType((TypeSymbol)pathParameterSymbol.typeDescriptor());
                        String type = CommonUtils.getTypeSignature((SemanticModel)semanticModel, (TypeSymbol)pathParameterSymbol.typeDescriptor(), (boolean)true);
                        String paramName = pathParameterSymbol.getName().orElse("");
                        String paramDescription = (String)documentationMap.get(paramName);
                        pathBuilder.append("[").append(paramName).append("]");
                        pathParams.add(ParameterData.from((String)paramName, (String)type, (ParameterData.Kind)ParameterData.Kind.PATH_PARAM, (String)defaultValue, (String)paramDescription, (boolean)false));
                        continue;
                    }
                    pathBuilder.append(pathSegment.getName().orElse(""));
                }
                ((PathSegmentList)resourcePath).pathRestParameter().ifPresent(pathRestParameter -> pathParams.add(ParameterData.from((String)REST_RESOURCE_PATH_LABEL, (String)"string", (ParameterData.Kind)ParameterData.Kind.PATH_REST_PARAM, (String)REST_PARAM_PATH, (String)REST_RESOURCE_PATH_LABEL, (boolean)false)));
                break;
            }
            case PATH_REST_PARAM: {
                pathBuilder.append(REST_RESOURCE_PATH);
                break;
            }
            case DOT_RESOURCE_PATH: {
                pathBuilder.append("/");
            }
        }
        return new ResourcePathTemplate(pathBuilder.toString(), pathParams);
    }

    public static String removeLeadingSingleQuote(String input) {
        if (input != null && input.startsWith("'")) {
            return input.substring(1);
        }
        return input;
    }

    public record ResourcePathTemplate(String resourcePathTemplate, List<ParameterData> pathParams) {
    }

    public record ParamForTypeInfer(String paramName, String defaultValue, String type) {
    }
}

