/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.email.client;

import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.email.util.CommonUtil;
import io.ballerina.stdlib.email.util.EmailConstants;
import io.ballerina.stdlib.email.util.SmtpUtil;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmtpClient {
    private static final Logger log = LoggerFactory.getLogger(SmtpClient.class);

    private SmtpClient() {
    }

    public static Object initClientEndpoint(BObject clientEndpoint, BString host, final BString username, final BString password, BMap<BString, Object> config) {
        Properties properties = SmtpClient.getPropertiesFromConfig(host.getValue(), config, true);
        Session session = Session.getInstance((Properties)properties, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(username.getValue(), password.getValue());
            }
        });
        clientEndpoint.addNativeData("session", (Object)session);
        clientEndpoint.addNativeData(EmailConstants.PROPS_USERNAME.getValue(), (Object)username.getValue());
        return null;
    }

    public static Object initNoAuthSmtpClientEndpoint(BObject clientEndpoint, BString host, BMap<BString, Object> config) {
        Properties properties = SmtpClient.getPropertiesFromConfig(host.getValue(), config, false);
        Session session = Session.getInstance((Properties)properties);
        clientEndpoint.addNativeData("session", (Object)session);
        return null;
    }

    public static Object sendMessage(BObject clientConnector, BMap<BString, Object> message) {
        try {
            Session session = (Session)clientConnector.getNativeData("session");
            String username = (String)clientConnector.getNativeData(EmailConstants.PROPS_USERNAME.getValue());
            Transport.send((Message)SmtpUtil.generateMessage(session, username, message));
            return null;
        }
        catch (BError e) {
            return e;
        }
        catch (SendFailedException e) {
            String invalidAddresses = Arrays.stream(e.getInvalidAddresses()).map(Address::toString).collect(Collectors.joining(","));
            return CommonUtil.getBallerinaError("Error", "Error while sending the message to SMTP server : " + e.getMessage() + " " + invalidAddresses);
        }
        catch (IOException | MessagingException e) {
            log.debug("Error while sending the message to SMTP server : ", e);
            return CommonUtil.getBallerinaError("Error", e.getMessage());
        }
    }

    private static Properties getPropertiesFromConfig(String host, BMap<BString, Object> config, boolean requireAuth) {
        if (config.isEmpty()) {
            throw CommonUtil.getBallerinaError("Error", "SmtpConfiguration should not be empty.");
        }
        try {
            return SmtpUtil.getProperties(config, host, requireAuth);
        }
        catch (IOException | GeneralSecurityException e) {
            log.debug("Error while initializing SMTP properties : ", (Throwable)e);
            throw CommonUtil.getBallerinaError("Error", e.getMessage());
        }
    }
}

