/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.email.server;

import io.ballerina.runtime.api.Runtime;
import io.ballerina.runtime.api.concurrent.StrandMetadata;
import io.ballerina.runtime.api.types.ObjectType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.stdlib.email.server.EmailEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailListener {
    private static final Logger log = LoggerFactory.getLogger(EmailListener.class);
    private final Runtime runtime;
    private Map<String, BObject> registeredServices = new HashMap<String, BObject>();

    public EmailListener(Runtime runtime) {
        this.runtime = runtime;
    }

    public boolean onMessage(EmailEvent emailEvent) {
        Thread.startVirtualThread(() -> {
            Object email = emailEvent.getEmailObject();
            if (this.runtime != null) {
                Set<Map.Entry<String, BObject>> services = this.registeredServices.entrySet();
                for (Map.Entry<String, BObject> service : services) {
                    this.callMethod(service.getValue(), "onMessage", email);
                }
            } else {
                log.error("Runtime should not be null.");
            }
        });
        return true;
    }

    public void onError(Object error) {
        Thread.startVirtualThread(() -> {
            log.error(((BError)error).getMessage());
            if (this.runtime != null) {
                Set<Map.Entry<String, BObject>> services = this.registeredServices.entrySet();
                for (Map.Entry<String, BObject> service : services) {
                    this.callMethod(service.getValue(), "onError", error);
                }
            } else {
                log.error("Runtime should not be null.");
            }
        });
    }

    public void onClose(Object error) {
        Thread.startVirtualThread(() -> {
            if (error != null) {
                log.error(((BError)error).getMessage());
            }
            if (this.runtime != null) {
                Set<Map.Entry<String, BObject>> services = this.registeredServices.entrySet();
                for (Map.Entry<String, BObject> service : services) {
                    this.callMethod(service.getValue(), "onClose", error);
                }
            } else {
                log.error("Runtime should not be null.");
            }
        });
    }

    protected void addService(BObject service) {
        ObjectType serviceType;
        if (service != null && (serviceType = (ObjectType)TypeUtils.getReferredType((Type)TypeUtils.getType((Object)service))) != null && serviceType.getName() != null) {
            this.registeredServices.put(serviceType.getName(), service);
        }
    }

    private void callMethod(BObject service, String methodName, Object args) {
        ObjectType serviceType = (ObjectType)TypeUtils.getReferredType((Type)TypeUtils.getType((Object)service));
        boolean isConcurrentSafe = serviceType.isIsolated() && serviceType.isIsolated(methodName);
        this.runtime.callMethod(service, methodName, new StrandMetadata(isConcurrentSafe, null), new Object[]{args});
    }
}

