/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.data.csvdata.compiler;

import io.ballerina.tools.diagnostics.DiagnosticSeverity;

public enum CsvDataDiagnosticCodes {
    DUPLICATE_FIELD("CSV_ERROR_1", "invalid field: duplicate field found", DiagnosticSeverity.ERROR),
    UNSUPPORTED_TYPE("CSV_ERROR_2", "unsupported type: type is not supported", DiagnosticSeverity.ERROR),
    UNSUPPORTED_FIELD_TYPE("CSV_ERROR_3", "Unsupported type in the field: Only basic types are supported for fields, and other types are not allowed.", DiagnosticSeverity.ERROR),
    UNSUPPORTED_TUPLE_MEMBER_TYPE("CSV_ERROR_4", "Unsupported type in the tuple member: Tuple members can only be basic types, other types are not supported.", DiagnosticSeverity.ERROR),
    IGNORE_OUTPUT_HEADERS_FOR_RECORD_ARRAY("CSV_ERROR_5", "The option 'outputWithHeaders' will be not allowed since the expected type is a subtype record array.", DiagnosticSeverity.ERROR),
    IGNORE_HEADERS_ORDER_FOR_RECORD_ARRAY("CSV_ERROR_5", "The option 'headerOrder' will be not allowed since the expected type is a subtype record array.", DiagnosticSeverity.ERROR),
    IGNORE_CUSTOM_HEADERS_PARAMETER_WHEN_HEADER_PRESENT("CSV_ERROR_6", "The option 'customHeadersIfHeadersAbsent' will be not allowed since the header is present.", DiagnosticSeverity.ERROR),
    CUSTOM_HEADERS_SHOULD_BE_PROVIDED("CSV_ERROR_7", "customHeaders parameter should be provided since the headerRows larger than 1.", DiagnosticSeverity.ERROR);

    private final String code;
    private final String message;
    private final DiagnosticSeverity severity;

    private CsvDataDiagnosticCodes(String code, String message, DiagnosticSeverity severity) {
        this.code = code;
        this.message = message;
        this.severity = severity;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public DiagnosticSeverity getSeverity() {
        return this.severity;
    }
}

