/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.data.jsonpath;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.JsonPathException;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JsonProvider;
import io.ballerina.lib.data.jsonpath.BJsonProvider;
import io.ballerina.lib.data.jsonpath.Utils;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BObject;

public class BJsonPath {
    public static final Configuration BJSON_CONFIGURATION = Configuration.builder().jsonProvider((JsonProvider)new BJsonProvider()).build();

    public static Object readJson(Object json, BObject query) {
        try {
            return JsonPath.using((Configuration)BJSON_CONFIGURATION).parse(json).read(Utils.convertRawTemplateToString(query), new Predicate[0]);
        }
        catch (PathNotFoundException e) {
            BError cause = Utils.createError(e.getMessage());
            return Utils.createError(Utils.getCannotExecuteQueryErrorMessage(StringUtils.fromString((String)Utils.convertRawTemplateToString(query))), cause);
        }
        catch (JsonPathException | IllegalArgumentException e) {
            return Utils.createError(e.getMessage());
        }
    }
}

