/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.data.jsonpath;

import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.JsonPathException;
import com.jayway.jsonpath.spi.json.AbstractJsonProvider;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.JsonUtils;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BDecimal;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class BJsonProvider
extends AbstractJsonProvider {
    public Object parse(String json) throws InvalidJsonException {
        return JsonUtils.parse((String)json);
    }

    public Object parse(byte[] json) throws InvalidJsonException {
        return super.parse(json);
    }

    public Object parse(InputStream jsonStream, String charset) throws InvalidJsonException {
        return JsonUtils.parse((InputStream)jsonStream, (String)charset);
    }

    public String toJson(Object obj) {
        return StringUtils.getJsonString((Object)obj);
    }

    public Object createArray() {
        return ValueCreator.createArrayValue((ArrayType)PredefinedTypes.TYPE_JSON_ARRAY);
    }

    public Object createMap() {
        return ValueCreator.createMapValue();
    }

    public boolean isArray(Object obj) {
        return obj instanceof BArray;
    }

    public Object getArrayIndex(Object obj, int idx) {
        return this.toJsonArray(obj).get((long)idx);
    }

    public void setArrayIndex(Object array, int index, Object newValue) {
        if (!this.isArray(array)) {
            throw new UnsupportedOperationException();
        }
        BArray arrayNode = this.toJsonArray(array);
        if (index == arrayNode.size()) {
            arrayNode.append(this.createJsonElement(newValue));
        } else {
            arrayNode.add((long)index, this.createJsonElement(newValue));
        }
    }

    public Object getMapValue(Object obj, String key) {
        if (!this.isMap(obj)) {
            throw new UnsupportedOperationException();
        }
        BMap jsonObject = this.toJsonObject(obj);
        if (!jsonObject.containsKey((Object)StringUtils.fromString((String)key))) {
            return UNDEFINED;
        }
        return this.unwrap(jsonObject.get((Object)StringUtils.fromString((String)key)));
    }

    public void setProperty(Object obj, Object key, Object value) {
        if (this.isMap(obj)) {
            this.toJsonObject(obj).put((Object)key.toString(), this.createJsonElement(value));
        } else {
            BArray array;
            long index = key != null ? (key instanceof Integer ? (long)((Integer)key).intValue() : (long)Integer.parseInt(key.toString())) : (long)array.size();
            if (index == (long)(array = this.toJsonArray(obj)).size()) {
                array.append(this.createJsonElement(value));
            } else {
                array.add(index, this.createJsonElement(value));
            }
        }
    }

    public void removeProperty(Object obj, Object key) {
        if (this.isMap(obj)) {
            this.toJsonObject(obj).remove((Object)key.toString());
        } else {
            BArray array = this.toJsonArray(obj);
            int index = key instanceof Integer ? (Integer)key : Integer.parseInt(key.toString());
            array.shift((long)index);
        }
    }

    public boolean isMap(Object obj) {
        return obj instanceof BMap;
    }

    public Collection<String> getPropertyKeys(Object obj) {
        return Arrays.stream(this.toJsonObject(obj).getKeys()).map(Object::toString).collect(Collectors.toList());
    }

    public int length(Object obj) {
        if (this.isArray(obj)) {
            return this.toJsonArray(obj).size();
        }
        if (this.isMap(obj)) {
            return this.toJsonObject(obj).entrySet().size();
        }
        if (this.isJsonPrimitive(obj)) {
            return obj.toString().length();
        }
        throw new JsonPathException("length operation cannot be applied to " + (obj != null ? obj.getClass().getName() : "null"));
    }

    public Iterable<?> toIterable(Object obj) {
        BArray arr = this.toJsonArray(obj);
        ArrayList<Object> values = new ArrayList<Object>(arr.size());
        for (int i = 0; i < arr.size(); ++i) {
            values.add(this.unwrap(arr.get((long)i)));
        }
        return values;
    }

    public Object unwrap(Object obj) {
        Object targetType;
        if (obj == null) {
            return null;
        }
        if (this.isMap(obj)) {
            targetType = PredefinedTypes.TYPE_JSON;
        } else if (this.isArray(obj)) {
            targetType = PredefinedTypes.TYPE_JSON_ARRAY;
        } else if (obj instanceof BString) {
            targetType = PredefinedTypes.TYPE_STRING;
        } else if (obj instanceof BDecimal) {
            targetType = PredefinedTypes.TYPE_FLOAT;
        } else if (obj instanceof String) {
            targetType = PredefinedTypes.TYPE_STRING;
        } else if (obj instanceof Boolean) {
            targetType = PredefinedTypes.TYPE_BOOLEAN;
        } else if (obj instanceof Long) {
            targetType = PredefinedTypes.TYPE_INT;
        } else if (obj instanceof Integer) {
            obj = ((Integer)obj).longValue();
            targetType = PredefinedTypes.TYPE_INT;
        } else {
            targetType = obj instanceof BigDecimal ? PredefinedTypes.TYPE_JSON_DECIMAL : (obj instanceof Double ? PredefinedTypes.TYPE_JSON_FLOAT : PredefinedTypes.TYPE_ANY);
        }
        Object jsonValue = JsonUtils.convertJSON((Object)obj, (Type)targetType);
        if (jsonValue instanceof BString) {
            return StringUtils.getStringValue((Object)jsonValue);
        }
        if (jsonValue instanceof BDecimal) {
            return ((BDecimal)jsonValue).decimalValue();
        }
        return jsonValue;
    }

    private boolean isJsonPrimitive(Object obj) {
        return obj == null || obj instanceof Long || obj instanceof Integer || obj instanceof BDecimal || obj instanceof Double || obj instanceof BString || obj instanceof String || obj instanceof Boolean;
    }

    private Object createJsonElement(Object o) {
        if (o instanceof String) {
            return JsonUtils.convertToJson((Object)StringUtils.fromString((String)((String)o)));
        }
        if (o instanceof List) {
            BArray jsonArray = (BArray)this.createArray();
            for (Object element : (List)o) {
                jsonArray.append(this.createJsonElement(element));
            }
            return JsonUtils.convertToJson((Object)jsonArray);
        }
        return JsonUtils.convertToJson((Object)o);
    }

    private BArray toJsonArray(Object o) {
        return (BArray)o;
    }

    private BMap toJsonObject(Object o) {
        return (BMap)o;
    }
}

