/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.designmodelgenerator.extension;

import io.ballerina.artifactsgenerator.ArtifactGenerationDebouncer;
import io.ballerina.artifactsgenerator.ArtifactsGenerator;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.designmodelgenerator.extension.response.ArtifactsParams;
import java.nio.file.Path;
import java.util.Optional;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.ballerinalang.langserver.commons.LanguageServerContext;
import org.ballerinalang.langserver.commons.client.ExtendedLanguageClient;
import org.ballerinalang.langserver.commons.eventsync.EventKind;
import org.ballerinalang.langserver.commons.eventsync.spi.EventSubscriber;

public class PublishArtifactsSubscriber
implements EventSubscriber {
    public static final String NAME = "Publish artifacts subscriber";
    private static final String EXPR_URI = "expr";
    private static final String LOAD_PROJECT = "loadProject";

    public EventKind eventKind() {
        return EventKind.PROJECT_UPDATE;
    }

    public void onEvent(ExtendedLanguageClient client, DocumentServiceContext context, LanguageServerContext serverContext) {
        if (context.fileUri().startsWith(EXPR_URI) || LOAD_PROJECT.equals(context.operation().getName())) {
            return;
        }
        Optional syntaxTree = context.currentSyntaxTree();
        Optional semanticModel = context.currentSemanticModel();
        if (syntaxTree.isEmpty() || semanticModel.isEmpty()) {
            return;
        }
        Path projectPath = context.workspace().projectRoot(context.filePath());
        ArtifactGenerationDebouncer.getInstance().debounce(context.fileUri(), () -> {
            ArtifactsParams artifactsParams = new ArtifactsParams();
            artifactsParams.setUri(projectPath.toUri().toString());
            artifactsParams.setArtifacts(ArtifactsGenerator.artifactChanges((String)projectPath.toString(), (SyntaxTree)((SyntaxTree)syntaxTree.get()), (SemanticModel)((SemanticModel)semanticModel.get())));
            client.publishArtifacts((Object)artifactsParams);
        });
    }

    public String getName() {
        return NAME;
    }
}

